/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.param.ItmTagPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmTagSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmTagSwitchParam;
import com.elitesland.yst.supportdomain.item.service.ItmTagService;
import com.elitesland.yst.supportdomain.item.vo.ItmTagPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagTreeVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/itm/tag"})
@Api(value="\u6807\u7b7e", tags={"\u6807\u7b7e"})
public class ItmTagController {
    private final ItmTagService itmTagService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u5206\u9875\u6570\u636e")
    public ApiResult<PagingVO<ItmTagPagingVO>> searchPaging(@RequestBody ItmTagPagingParam param) {
        return ApiResult.ok(this.itmTagService.searchPaging(param));
    }

    @GetMapping(value={"/tree"})
    @ApiOperation(value="\u83b7\u53d6\u5b8c\u6574\u6811\u5f62\u7ed3\u6784")
    public ApiResult<List<ItmTagTreeVO>> tagTree() {
        return ApiResult.ok(this.itmTagService.tagTree());
    }

    @GetMapping(value={"/sub/{pid}"})
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7ID\u83b7\u53d6\u5b50\u5217\u8868(\u975e\u6811\u5f62\u7ed3\u6784)")
    public ApiResult<List<ItmTagTreeVO>> findSubTagByPid(@PathVariable Long pid) {
        return ApiResult.ok(this.itmTagService.querySubTagByPid(pid));
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u6839\u636e\u6807\u7b7eID\u83b7\u53d6\u6807\u7b7e\u8be6\u60c5")
    public ApiResult<ItmTagVO> findTagDetailsVoById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.itmTagService.queryTagDetailsVoById(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u6807\u7b7e")
    public ApiResult<String> saveOrUpdate(@RequestBody ItmTagSaveParam param) {
        return ApiResult.ok((Object)this.itmTagService.saveOrUpdateTag(param).toString());
    }

    @PostMapping(value={"/switch"})
    @ApiOperation(value="\u6279\u91cf\u542f\u7528/\u7981\u7528\u6807\u7b7e")
    public ApiResult<Object> switchStatusByIds(@RequestBody ItmTagSwitchParam param) {
        this.itmTagService.switchTagStatusByIds(param.getIds(), param.getStatus());
        return ApiResult.ok();
    }

    @PostMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u6839\u636e\u6807\u7b7eID\u5220\u9664\u6807\u7b7e\u6216\u6807\u7b7e\u7ec4")
    public ApiResult<Object> deleteById(@PathVariable Long id) {
        this.itmTagService.softDeleteTagById(id);
        return ApiResult.ok();
    }

    public ItmTagController(ItmTagService itmTagService) {
        this.itmTagService = itmTagService;
    }
}

