/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class BomQtyConvert
implements Converter<Integer> {
    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public Integer convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        CellDataTypeEnum type = cellData.getType();
        if (type.equals((Object)CellDataTypeEnum.NUMBER)) {
            String numberStr = cellData.getNumberValue().toString();
            return this.getInteger(cellData, contentProperty, numberStr);
        }
        if (type.equals((Object)CellDataTypeEnum.STRING)) {
            String stringValue = cellData.getStringValue();
            return this.getInteger(cellData, contentProperty, stringValue);
        }
        throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u6570\u91cf\u89e3\u6790\u5f02\u5e38");
    }

    private Integer getInteger(ReadCellData<?> cellData, ExcelContentProperty contentProperty, String stringValue) {
        if (!stringValue.matches("^[-+]?[\\d]*$")) {
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u8bf7\u586b\u5199\u6b63\u786e\u6570\u636e");
        }
        try {
            return Integer.valueOf(stringValue);
        }
        catch (Exception e) {
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u6570\u91cf\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public WriteCellData<String> convertToExcelData(Integer value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}

