/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class GrossMarginConvert
implements Converter<String> {
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);

    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public String convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        CellDataTypeEnum type = cellData.getType();
        if (type.equals((Object)CellDataTypeEnum.NUMBER)) {
            BigDecimal numberValue = cellData.getNumberValue();
            if (numberValue.compareTo(BigDecimal.ZERO) >= 0 && numberValue.compareTo(DIVISOR) < 1) {
                return String.valueOf(numberValue.divide(DIVISOR, 2, RoundingMode.HALF_UP));
            }
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u6bdb\u5229\u63a7\u5236\u7387\u6570\u636e\u5f02\u5e38,\u8bf7\u8f93\u51650-100\u7684\u6570\u636e");
        }
        if (type.equals((Object)CellDataTypeEnum.STRING)) {
            BigDecimal numberValue;
            String stringValue = cellData.getStringValue();
            try {
                numberValue = new BigDecimal(stringValue);
            }
            catch (Exception e) {
                throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u201c" + stringValue + "\u201d\u6bdb\u5229\u63a7\u5236\u7387\u6570\u636e\u5f02\u5e38");
            }
            if (numberValue.compareTo(BigDecimal.ZERO) >= 0 && numberValue.compareTo(DIVISOR) < 1) {
                return String.valueOf(numberValue.divide(DIVISOR, 2, RoundingMode.HALF_UP));
            }
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u6bdb\u5229\u63a7\u5236\u7387\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8f93\u51650-100\u7684\u6570\u636e");
        }
        throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u6bdb\u5229\u63a7\u5236\u7387\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u6570\u636e");
    }

    public WriteCellData<String> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}

