/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmBrandDTO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmBrandExcelConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBrandUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmBrandListener
extends AnalysisEventListener<ItmBrandUploadExcel> {
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ItmBrandListener.class);
    private static final String ENABLE = "ENABLE";
    private static final String BRAND_INITIAL = "\u54c1\u724c\u9996\u5b57\u6bcd";
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmBrandRepo itmBrandRepo;
    private final List<String> brandNameList;
    private final List<String> brandCodeList;
    private final ErrorInfo errorInfo;
    private final List<ItmBrandUploadExcel> itmBrandUploadExcels = new ArrayList<ItmBrandUploadExcel>();

    public ItmBrandListener(ErrorInfo errorInfo, List<ItmBrandDTO> itmBrandDTOS, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmBrandRepo itmBrandRepo) {
        this.errorInfo = errorInfo;
        this.brandNameList = itmBrandDTOS.stream().map(ItmBrandDTO::getBrandName).collect(Collectors.toList());
        this.brandCodeList = itmBrandDTOS.stream().map(ItmBrandDTO::getBrandCode).collect(Collectors.toList());
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmBrandRepo = itmBrandRepo;
    }

    public void invoke(ItmBrandUploadExcel data, AnalysisContext context) {
        List<String> urlList;
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        String brandName = data.getBrandName();
        if (StringUtils.isBlank((CharSequence)brandName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u724c\u540d\u79f0", "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (this.brandNameList.contains(brandName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u724c\u540d\u79f0", "\u54c1\u724c\u540d\u79f0\u91cd\u590d"));
        } else {
            this.brandNameList.add(brandName);
        }
        String brandInitial = data.getBrandInitial();
        if (StringUtils.isBlank((CharSequence)brandInitial)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, BRAND_INITIAL, "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (!brandInitial.matches("[a-zA-Z0-9]$")) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, BRAND_INITIAL, "\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u636e\uff1a\u4e00\u4f4d\u6570\u5b57\u6216\u5b57\u6bcd"));
        }
        String url = data.getUrl();
        if (StringUtils.isNotBlank((CharSequence)url) && !(urlList = Arrays.asList(url.split("="))).get(urlList.size() - 1).matches("[0-9]+$")) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1logo", "url\u683c\u5f0f\u9519\u8bef"));
        }
        if (!this.errorInfo.hasError()) {
            this.itmBrandUploadExcels.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    private void doSave() {
        if (CollectionUtils.isEmpty(this.itmBrandUploadExcels)) {
            return;
        }
        this.itmBrandUploadExcels.forEach(brand -> {
            String brandCode = this.sysNumberGeneratorWrapper.generate("BRAND_NO");
            if (this.brandCodeList.contains(brandCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u53d1\u53f7\u5668\u5f02\u5e38\uff0c\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
            }
            this.brandCodeList.add(brandCode);
            brand.setBrandCode(brandCode);
            brand.setStatus(ENABLE);
            if (StringUtils.isNotBlank((CharSequence)brand.getUrl())) {
                List<String> urlAndFileCode = Arrays.asList(brand.getUrl().split("="));
                brand.setFileCode(urlAndFileCode.get(urlAndFileCode.size() - 1));
            }
        });
        this.itmBrandRepo.saveAll(ItmBrandExcelConvert.INSTANCE.excelToDO(this.itmBrandUploadExcels));
    }
}

