/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBomDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemBomUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBomRepo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemBomListener
extends AnalysisEventListener<ItmItemBomUploadExcel> {
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1}\u5217\u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ItmItemBomListener.class);
    private static final Integer ZERO = 0;
    private final ErrorInfo errorInfo;
    private final List<String> itemCodes;
    private final List<String> accessoriesCodes;
    private final List<String> uniqueCodes;
    private final List<ItmItemDTO> itemInfo;
    private final ItmItemBomRepo itmItemBomRepo;
    private final List<ItmItemBomUploadExcel> itmItemBomUploadExcels = new ArrayList<ItmItemBomUploadExcel>();

    public ItmItemBomListener(ErrorInfo errorInfo, List<ItmItemDTO> itemCodes, List<ItmItemDTO> accessoriesCodes, List<String> uniqueCodes, ItmItemBomRepo itmItemBomRepo) {
        this.errorInfo = errorInfo;
        this.itemCodes = itemCodes.stream().map(ItmItemDTO::getItemCode).collect(Collectors.toList());
        this.accessoriesCodes = accessoriesCodes.stream().map(ItmItemDTO::getItemCode).collect(Collectors.toList());
        this.uniqueCodes = uniqueCodes;
        this.itemInfo = itemCodes;
        this.itmItemBomRepo = itmItemBomRepo;
    }

    public void invoke(ItmItemBomUploadExcel data, AnalysisContext context) {
        String uniqueCode;
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        boolean itemCodeFlag = true;
        String itemCode = data.getItemCode();
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            itemCodeFlag = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7f16\u7801", "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (!this.itemCodes.contains(itemCode)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u5546\u54c1\u7f16\u7801"));
        }
        boolean accessoriesCodeFlag = true;
        String accessoriesCode = data.getAccessoriesCode();
        if (StringUtils.isBlank((CharSequence)accessoriesCode)) {
            accessoriesCodeFlag = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u914d\u4ef6\u7f16\u7801", "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (!this.accessoriesCodes.contains(accessoriesCode)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u914d\u4ef6\u7f16\u7801", "\u914d\u4ef6\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u914d\u4ef6\u7f16\u7801"));
        }
        Integer qty = data.getQty();
        if (qty == null) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6570\u91cf", "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (qty.compareTo(ZERO) < 0) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6570\u91cf", "\u5fc5\u987b\u5927\u4e8e0"));
        }
        if (itemCodeFlag && accessoriesCodeFlag && this.uniqueCodes.contains(uniqueCode = itemCode + "-" + accessoriesCode)) {
            this.uniqueCodes.add(uniqueCode);
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6574\u884c", "\u5bfc\u5165\u91cd\u590d\u6570\u636e"));
        }
        if (!this.errorInfo.hasError()) {
            this.itmItemBomUploadExcels.add(data);
        }
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    private void doSave() {
        ArrayList pItmItemBomDOS = new ArrayList();
        ArrayList cItmItemBomDOS = new ArrayList();
        HashSet itemCodeSet = new HashSet();
        this.itmItemBomUploadExcels.forEach(itemBom -> {
            itemCodeSet.add(itemBom.getItemCode());
            itemCodeSet.add(itemBom.getAccessoriesCode());
        });
        List<ItmItemDTO> itemBomInfo = this.itemInfo.stream().filter(item -> itemCodeSet.contains(item.getItemCode())).collect(Collectors.toList());
        this.itmItemBomUploadExcels.forEach(itmItemBom -> {
            String itemCode = itmItemBom.getItemCode();
            String accessoriesCode = itmItemBom.getAccessoriesCode();
            itemBomInfo.forEach(itemBom -> {
                if (itemCode.equals(itemBom.getItemCode())) {
                    itmItemBom.setItemCode(itemBom.getId().toString());
                }
                if (accessoriesCode.equals(itemBom.getItemCode())) {
                    itmItemBom.setAccessoriesCode(itemBom.getId().toString());
                }
            });
        });
        Map<String, List<ItmItemBomUploadExcel>> resultMap = this.itmItemBomUploadExcels.stream().collect(Collectors.groupingBy(ItmItemBomUploadExcel::getItemCode));
        Set<String> pInfo = resultMap.keySet();
        itemBomInfo.forEach(itemBom -> pInfo.forEach(info -> {
            ItmItemBomDO itmItemBomDO = new ItmItemBomDO();
            if (info.equals(itemBom.getId().toString())) {
                itmItemBomDO.setItemId(itemBom.getId());
                itmItemBomDO.setPid(0L);
                pItmItemBomDOS.add(itmItemBomDO);
            }
        }));
        this.itmItemBomRepo.saveAll(pItmItemBomDOS);
        pItmItemBomDOS.forEach(pItmItemBom -> {
            String pItemId = pItmItemBom.getItemId().toString();
            Long pid = pItmItemBom.getId();
            List itmItemBomUploadExcels = (List)resultMap.get(pItemId);
            itmItemBomUploadExcels.forEach(itmItem -> {
                ItmItemBomDO itmItemBomDO = new ItmItemBomDO();
                itmItemBomDO.setPid(pid);
                itmItemBomDO.setItemId(Long.valueOf(itmItem.getAccessoriesCode()));
                itmItemBomDO.setQty(itmItem.getQty());
                cItmItemBomDOS.add(itmItemBomDO);
            });
        });
        this.itmItemBomRepo.saveAll(cItmItemBomDOS);
    }
}

