/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.TableColumnExtEnum;
import com.elitesland.yst.supportdomain.common.entity.TableColumnExtDO;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepo;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemCateDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.pri.param.PriCatePriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemCateListener
extends AnalysisEventListener<ItmItemCateUploadExcel> {
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final String REGEX = "\\d{2}$";
    private final ErrorInfo errorInfo;
    private final Map<String, String> tagNameCodeMap;
    private final Map<String, ItmItemCateDTO> cateCodeDtoMap;
    private final Map<Long, List<ItmItemCateDTO>> catePidMap;
    private final Map<Long, Set<String>> catePidNameMap;
    private final Map<String, String> finTypeUdc;
    private final Map<String, String> qualifyTypeUdc;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmCateContrParaRepo itmCateContrParaRepo;
    private final TableColumnExtRepo tableColumnExtRepo;
    private final PriMainPriceService priMainPriceService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ItmItemCateListener.class);
    private final Map<String, String> newCateCodeNameMap = new HashMap<String, String>();
    private final List<ItmItemCateUploadExcel> excelData = new ArrayList<ItmItemCateUploadExcel>();
    private static final Long ROOT_PID = 0L;
    private static final String ROOT_CODE = "0";
    private static final String TRUE_FLAG = "1";
    private static final String FALSE_FLAG = "0";
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);

    public ItmItemCateListener(ErrorInfo errorInfo, List<ItmTagDTO> tagDtos, List<ItmItemCateDTO> cateDtos, Map<String, String> finTypeUdc, Map<String, String> qualifyTypeUdc, ItmItemCateRepo itmItemCateRepo, ItmCateContrParaRepo itmCateContrParaRepo, TableColumnExtRepo tableColumnExtRepo, PriMainPriceService priMainPriceService) {
        this.errorInfo = errorInfo;
        this.tagNameCodeMap = tagDtos.stream().collect(Collectors.toMap(ItmTagDTO::getTagName, ItmTagDTO::getTagCode));
        this.cateCodeDtoMap = cateDtos.stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateCode, t -> t));
        this.catePidMap = cateDtos.stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid));
        this.catePidNameMap = this.catePidMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ItmItemCateDTO::getItemCateName).collect(Collectors.toSet())));
        this.finTypeUdc = finTypeUdc;
        this.qualifyTypeUdc = qualifyTypeUdc;
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmCateContrParaRepo = itmCateContrParaRepo;
        this.tableColumnExtRepo = tableColumnExtRepo;
        this.priMainPriceService = priMainPriceService;
    }

    public void invoke(ItmItemCateUploadExcel data, AnalysisContext context) {
        String qualifyType;
        String snFlag;
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        String cateBigCode = data.getItemCateBigCode();
        boolean hasBigCode = true;
        boolean isNewBigCode = false;
        if (StringUtils.isBlank((CharSequence)cateBigCode)) {
            hasBigCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (this.cateCodeDtoMap.containsKey(cateBigCode)) {
            ItmItemCateDTO cateDto = this.cateCodeDtoMap.get(cateBigCode);
            if (cateDto.getPid() == null || ROOT_PID.equals(cateDto.getPid())) {
                data.setCateBigId(cateDto.getId());
                data.setCateBigName(cateDto.getItemCateName());
            } else {
                hasBigCode = false;
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6240\u586b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4f46\u4e0d\u662f\u4e00\u7ea7\u54c1\u7c7b\uff0c\u5df2\u5b58\u5728\u54c1\u7c7b\u7684\u540d\u79f0\uff1a" + cateDto.getItemCateName()));
            }
        } else if (cateBigCode.matches(REGEX)) {
            isNewBigCode = true;
            data.setFullCateBigCode(cateBigCode);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
        }
        String cateBigName = data.getItemCateBigName();
        if (StringUtils.isBlank((CharSequence)cateBigName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (hasBigCode) {
            if (isNewBigCode) {
                if (!this.newCateCodeNameMap.containsKey(cateBigCode)) {
                    if (this.catePidNameMap.getOrDefault(0L, Collections.emptySet()).contains(cateBigName)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                    }
                    this.newCateCodeNameMap.put(cateBigCode, cateBigName);
                }
            } else if (!cateBigName.equals(data.getCateBigName())) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u5339\u914d\u5230\u76f8\u540c\u7f16\u53f7\u7684\u54c1\u7c7b\uff0c\u4f46\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
            }
        }
        boolean hasMidCode = true;
        boolean isNewMidCode = false;
        String shortCateMidCode = data.getItemCateMidCode();
        String cateMidCode = cateBigCode + "-" + shortCateMidCode;
        if (StringUtils.isBlank((CharSequence)shortCateMidCode)) {
            hasMidCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (hasBigCode && hasMidCode) {
            if (this.cateCodeDtoMap.containsKey(cateMidCode)) {
                ItmItemCateDTO cateDto = this.cateCodeDtoMap.get(cateMidCode);
                if (isNewBigCode) {
                    hasMidCode = false;
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u5982\u679c\u4e00\u7ea7\u54c1\u7c7b\u4e3a\u65b0\u5efa\uff0c\u5219\u4e8c\u7ea7\u54c1\u7c7b\u5fc5\u987b\u4e3a\u65b0\u5efa\u54c1\u7c7b"));
                } else if (cateDto.getPid().equals(data.getCateBigId())) {
                    data.setCateMidId(cateDto.getId());
                    data.setCateMidName(cateDto.getItemCateName());
                } else {
                    hasMidCode = false;
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6307\u5b9a\u7684\u4e8c\u7ea7\u54c1\u7c7b\u5df2\u7ecf\u5c5e\u4e8e\u5176\u5b83\u4e00\u7ea7\u54c1\u7c7b\uff0c\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
                }
            } else if (shortCateMidCode.matches(REGEX)) {
                isNewMidCode = true;
                data.setFullCateMidCode(cateMidCode);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
            }
            String cateMidName = data.getItemCateMidName();
            if (StringUtils.isBlank((CharSequence)cateMidName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (hasMidCode) {
                if (isNewMidCode) {
                    if (!this.newCateCodeNameMap.containsKey(cateMidCode)) {
                        if (data.getCateBigId() != null && this.catePidNameMap.getOrDefault(data.getCateBigId(), Collections.emptySet()).contains(cateMidName)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                        }
                        this.newCateCodeNameMap.put(cateMidCode, cateMidName);
                    }
                } else if (!cateMidName.equals(data.getCateMidName())) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u4e0d\u6b63\u786e\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateMidName()));
                }
            }
        }
        boolean hasSmallCode = true;
        String shortCateSmallCode = data.getItemCateSmallCode();
        String cateSmallCode = cateMidCode + "-" + shortCateSmallCode;
        if (StringUtils.isBlank((CharSequence)shortCateSmallCode)) {
            hasSmallCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (shortCateSmallCode.matches(REGEX)) {
            data.setFullCateSmallCode(cateSmallCode);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
        }
        if (hasBigCode && hasMidCode && hasSmallCode) {
            boolean isNewSmallCode = true;
            if (this.cateCodeDtoMap.containsKey(cateSmallCode)) {
                isNewSmallCode = false;
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u5df2\u5b58\u5728"));
            }
            if (isNewSmallCode) {
                String cateSmallName = data.getItemCateSmallName();
                if (StringUtils.isBlank((CharSequence)cateSmallName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
                } else if (this.newCateCodeNameMap.containsKey(cateSmallCode)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u91cd\u590d\uff0c\u91cd\u590d\u54c1\u7c7b\u7f16\u7801\uff1a" + shortCateSmallCode));
                } else {
                    if (data.getCateMidId() != null && this.catePidNameMap.getOrDefault(data.getCateMidId(), Collections.emptySet()).contains(cateSmallCode)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u76f8\u540c\u7236\u7c7b\u4e0b\uff0c\u54c1\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728"));
                    }
                    this.newCateCodeNameMap.put(cateSmallCode, cateSmallName);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)(snFlag = data.getSnFlag()))) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else if (!TRUE_FLAG.equals(snFlag) && !"0".equals(snFlag)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u53ea\u80fd\u586b 0 \u6216\u8005 1"));
        }
        String lotFlag = data.getLotFlag();
        if (StringUtils.isBlank((CharSequence)lotFlag)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else if (!TRUE_FLAG.equals(lotFlag) && !"0".equals(lotFlag)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u53ea\u80fd\u586b 0 \u6216\u8005 1"));
        }
        String finTypeName = data.getFinType();
        if (StringUtils.isBlank((CharSequence)finTypeName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d22\u52a1\u5206\u7c7b", "\u6570\u636e\u5fc5\u586b"));
        } else if (!this.finTypeUdc.containsKey(finTypeName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d22\u52a1\u5206\u7c7b", "\u4e0d\u6b63\u786e\u7684\u8d22\u52a1\u5206\u7c7b\uff1a" + finTypeName));
        } else {
            data.setFinTypeCode(this.finTypeUdc.get(finTypeName));
        }
        String grossMarginBStr = data.getGrossMarginB();
        if (StringUtils.isBlank((CharSequence)grossMarginBStr)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5fc5\u586b"));
        } else {
            try {
                BigDecimal grossMarginB = new BigDecimal(grossMarginBStr);
                if (grossMarginB.compareTo(BigDecimal.ZERO) >= 0 && grossMarginB.compareTo(DIVISOR) < 1) {
                    data.setGrossMarginBDecimal(grossMarginB.divide(DIVISOR, 2, RoundingMode.HALF_UP));
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u5927\u5c0f\u533a\u95f4\u5e94\u4e3a0-100"));
                }
            }
            catch (NumberFormatException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57"));
            }
        }
        String grossMarginCStr = data.getGrossMarginC();
        if (StringUtils.isBlank((CharSequence)grossMarginCStr)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5fc5\u586b"));
        } else {
            try {
                BigDecimal grossMarginC = new BigDecimal(grossMarginCStr);
                if (grossMarginC.compareTo(BigDecimal.ZERO) >= 0 && grossMarginC.compareTo(DIVISOR) < 1) {
                    data.setGrossMarginCDecimal(grossMarginC.divide(DIVISOR, 2, RoundingMode.HALF_UP));
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u5927\u5c0f\u533a\u95f4\u5e94\u4e3a0-100"));
                }
            }
            catch (NumberFormatException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57"));
            }
        }
        String tagName = data.getTagSaveParams();
        if (StringUtils.isNotBlank((CharSequence)tagName)) {
            List tagNames = Arrays.stream(tagName.split("(;)|(\uff1b)")).distinct().collect(Collectors.toList());
            StringBuilder errorType = new StringBuilder();
            ArrayList<String> tagCodes = new ArrayList<String>();
            for (String tag : tagNames) {
                if (this.tagNameCodeMap.containsKey(tag)) {
                    tagCodes.add(this.tagNameCodeMap.get(tag));
                    continue;
                }
                errorType.append(tag).append(" ");
            }
            if (errorType.length() > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6807\u7b7e\u7ef4\u62a4", "\u4e0d\u6b63\u786e\u7684\u6807\u7b7e\u540d\u79f0\uff1a" + errorType));
            } else {
                data.setTagCodes(tagCodes);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(qualifyType = data.getQualifyTypes()))) {
            List qualifyTypes = Arrays.stream(qualifyType.split("(;)|(\uff1b)")).distinct().collect(Collectors.toList());
            StringBuilder errorType = new StringBuilder();
            ArrayList<String> qualifyTypeCodes = new ArrayList<String>();
            for (String type : qualifyTypes) {
                if (this.qualifyTypeUdc.containsKey(type)) {
                    qualifyTypeCodes.add(this.qualifyTypeUdc.get(type));
                    continue;
                }
                errorType.append(type).append(" ");
            }
            if (errorType.length() > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8bc1\u7167\u7ef4\u62a4", "\u4e0d\u6b63\u786e\u7684\u8bc1\u7167\u7c7b\u578b\uff1a" + errorType));
            } else {
                data.setQualifyTypeCodes(qualifyTypeCodes);
            }
        }
        if (!this.errorInfo.hasError()) {
            this.excelData.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    private void doSave() {
        if (CollectionUtils.isEmpty(this.excelData)) {
            return;
        }
        HashMap pCodeDoGroupMap = new HashMap();
        HashMap<String, ItmItemCateDO> codeDoMap = new HashMap<String, ItmItemCateDO>();
        ArrayList<ItmItemCateDO> bigCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmItemCateDO> midCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmItemCateDO> smallCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmCateContrParaDO> itmCateContrParaDos = new ArrayList<ItmCateContrParaDO>();
        ArrayList<PriCatePriceSaveRowParam> priCatePriceSaveParams = new ArrayList<PriCatePriceSaveRowParam>();
        ArrayList<TableColumnExtDO> tagExtDos = new ArrayList<TableColumnExtDO>();
        ArrayList<TableColumnExtDO> qualifyTypeExtDos = new ArrayList<TableColumnExtDO>();
        LocalDate now = LocalDate.now();
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u4fdd\u5b58\u6570\u636e");
        for (ItmItemCateUploadExcel excelDatum : this.excelData) {
            TableColumnExtDO tableColumnExtDO;
            int sortNo;
            String fullCateMidCode;
            String fullCateBigCode = excelDatum.getFullCateBigCode();
            if (StringUtils.isNotBlank((CharSequence)fullCateBigCode) && !codeDoMap.containsKey(fullCateBigCode)) {
                ItmItemCateDO bigCateDo = new ItmItemCateDO();
                bigCateDo.setItemCateCode(fullCateBigCode);
                bigCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateBigCode));
                bigCateDo.setGrade(1);
                bigCateDo.setItemCateIsBasic(0);
                bigCateDo.setStatus("ENABLE");
                bigCateDo.setPid(0L);
                if (pCodeDoGroupMap.containsKey("0")) {
                    ((List)pCodeDoGroupMap.get("0")).add(bigCateDo);
                } else {
                    ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                    dos.add(bigCateDo);
                    pCodeDoGroupMap.put("0", dos);
                }
                codeDoMap.put(fullCateBigCode, bigCateDo);
                bigCateDos.add(bigCateDo);
            }
            if (StringUtils.isNotBlank((CharSequence)(fullCateMidCode = excelDatum.getFullCateMidCode())) && !codeDoMap.containsKey(fullCateMidCode)) {
                ItmItemCateDO midCateDo = new ItmItemCateDO();
                midCateDo.setItemCateCode(fullCateMidCode);
                midCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateMidCode));
                midCateDo.setGrade(2);
                midCateDo.setItemCateIsBasic(0);
                midCateDo.setStatus("ENABLE");
                if (excelDatum.getCateBigId() != null) {
                    midCateDo.setPid(excelDatum.getCateBigId());
                } else {
                    String pCode = excelDatum.getFullCateBigCode();
                    if (pCodeDoGroupMap.containsKey(pCode)) {
                        ((List)pCodeDoGroupMap.get(pCode)).add(midCateDo);
                    } else {
                        ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                        dos.add(midCateDo);
                        pCodeDoGroupMap.put(pCode, dos);
                    }
                }
                codeDoMap.put(fullCateMidCode, midCateDo);
                midCateDos.add(midCateDo);
            }
            String fullCateSmallCode = excelDatum.getFullCateSmallCode();
            ItmItemCateDO smallCateDo = new ItmItemCateDO();
            smallCateDo.setItemCateCode(fullCateSmallCode);
            smallCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateSmallCode));
            smallCateDo.setGrade(3);
            smallCateDo.setItemCateIsBasic(1);
            smallCateDo.setStatus("ENABLE");
            if (excelDatum.getCateMidId() != null) {
                smallCateDo.setPid(excelDatum.getCateMidId());
            } else {
                String pCode = excelDatum.getFullCateMidCode();
                if (pCodeDoGroupMap.containsKey(pCode)) {
                    ((List)pCodeDoGroupMap.get(pCode)).add(smallCateDo);
                } else {
                    ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                    dos.add(smallCateDo);
                    pCodeDoGroupMap.put(pCode, dos);
                }
            }
            codeDoMap.put(fullCateSmallCode, smallCateDo);
            smallCateDos.add(smallCateDo);
            ItmCateContrParaDO snFlagDo = new ItmCateContrParaDO();
            snFlagDo.setItemCateCode(fullCateSmallCode);
            snFlagDo.setControlParamCode(ItmCateControlParamEnum.SN_FLAG.getCode());
            snFlagDo.setControlParamValue(excelDatum.getSnFlag());
            itmCateContrParaDos.add(snFlagDo);
            ItmCateContrParaDO lotFlagDo = new ItmCateContrParaDO();
            lotFlagDo.setItemCateCode(fullCateSmallCode);
            lotFlagDo.setControlParamCode(ItmCateControlParamEnum.LOT_FLAG.getCode());
            lotFlagDo.setControlParamValue(excelDatum.getLotFlag());
            itmCateContrParaDos.add(lotFlagDo);
            ItmCateContrParaDO finTypeDo = new ItmCateContrParaDO();
            finTypeDo.setItemCateCode(fullCateSmallCode);
            finTypeDo.setControlParamCode(ItmCateControlParamEnum.FIN_TYPE.getCode());
            finTypeDo.setControlParamValue(excelDatum.getFinTypeCode());
            itmCateContrParaDos.add(finTypeDo);
            PriCatePriceSaveRowParam priCatePriceSaveParam = new PriCatePriceSaveRowParam();
            priCatePriceSaveParam.setItemCateCode(fullCateSmallCode);
            priCatePriceSaveParam.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
            priCatePriceSaveParam.setValidFrom(LocalDateTime.of(now, LocalTime.MIN));
            priCatePriceSaveParam.setValidTo(LocalDateTime.of(now.plusYears(30L), LocalTime.MIN));
            priCatePriceSaveParam.setPrice4(excelDatum.getGrossMarginBDecimal());
            priCatePriceSaveParam.setPrice5(excelDatum.getGrossMarginCDecimal());
            priCatePriceSaveParams.add(priCatePriceSaveParam);
            if (CollectionUtils.isNotEmpty(excelDatum.getTagCodes())) {
                sortNo = 1;
                for (String tagCode : excelDatum.getTagCodes()) {
                    tableColumnExtDO = new TableColumnExtDO();
                    tableColumnExtDO.setTableName(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName());
                    tableColumnExtDO.setColumnName(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName());
                    tableColumnExtDO.setRowCode(fullCateSmallCode);
                    tableColumnExtDO.setColumnValue(tagCode);
                    tableColumnExtDO.setSortNo(sortNo++);
                    tagExtDos.add(tableColumnExtDO);
                }
            }
            if (!CollectionUtils.isNotEmpty(excelDatum.getQualifyTypeCodes())) continue;
            sortNo = 1;
            for (String qualifyType : excelDatum.getQualifyTypeCodes()) {
                tableColumnExtDO = new TableColumnExtDO();
                tableColumnExtDO.setTableName(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName());
                tableColumnExtDO.setColumnName(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName());
                tableColumnExtDO.setRowCode(fullCateSmallCode);
                tableColumnExtDO.setColumnValue(qualifyType);
                tableColumnExtDO.setSortNo(sortNo++);
                qualifyTypeExtDos.add(tableColumnExtDO);
            }
        }
        LOGGER.info("\u6784\u5efa\u5b8c\u6210");
        this.itmItemCateRepo.saveAll(bigCateDos);
        bigCateDos.forEach(big -> ((List)pCodeDoGroupMap.get(big.getItemCateCode())).forEach(mid -> mid.setPid(big.getId())));
        this.itmItemCateRepo.saveAll(midCateDos);
        midCateDos.forEach(mid -> ((List)pCodeDoGroupMap.get(mid.getItemCateCode())).forEach(small -> small.setPid(mid.getId())));
        this.itmItemCateRepo.saveAll(smallCateDos);
        this.itmCateContrParaRepo.saveAll(itmCateContrParaDos);
        this.priMainPriceService.priCatePriceSave(priCatePriceSaveParams);
        if (CollectionUtils.isNotEmpty(tagExtDos)) {
            this.tableColumnExtRepo.saveAll(tagExtDos);
        }
        if (CollectionUtils.isNotEmpty(qualifyTypeExtDos)) {
            this.tableColumnExtRepo.saveAll(qualifyTypeExtDos);
        }
    }
}

