/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropDO;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropValueDO;
import com.elitesland.yst.supportdomain.item.entity.ItmPropDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCatePropUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmBrandListener;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmPropRepo;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.service.ItmPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmPropVO;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemCatePropListener
extends AnalysisEventListener<ItmItemCatePropUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemCatePropListener.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ItmBrandListener.class);
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private final ErrorInfo errorInfo;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmPropService itmPropService;
    private final ItmCatePropService itmCatePropService;
    private final ItmCatePropRepo itmCatePropRepo;
    private final ItmCatePropValueRepo itmCatePropValueRepo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmPropRepo itmPropRepo;
    private final Map<Long, Map<String, ItmItemCateDTO>> itemCatePidMap;
    private final List<ItmPropVO> itmPropList;
    private final List<String> itmPropNameList;
    private final List<String> itmPropCodeList;
    private final List<ItmPropDO> itmPropDos = new ArrayList<ItmPropDO>();
    private final Map<String, List<String>> smallCateNameMap = new HashMap<String, List<String>>();
    private final Map<Integer, ItmCatePropDO> itmCatePropDOMap = new HashMap<Integer, ItmCatePropDO>();
    private final Map<Integer, List<ItmCatePropValueDO>> itmCatePropValueMap = new HashMap<Integer, List<ItmCatePropValueDO>>();

    public ItmItemCatePropListener(ErrorInfo errorInfo, ItmItemCateRepoProc itmItemCateRepoProc, ItmPropService itmPropService, ItmCatePropService itmCatePropService, ItmCatePropRepo itmCatePropRepo, ItmCatePropValueRepo itmCatePropValueRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmPropRepo itmPropRepo) {
        this.itmCatePropService = itmCatePropService;
        this.errorInfo = errorInfo;
        this.itmPropService = itmPropService;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCatePropRepo = itmCatePropRepo;
        this.itmCatePropValueRepo = itmCatePropValueRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmPropRepo = itmPropRepo;
        this.itemCatePidMap = itmItemCateRepoProc.findAllDto().stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateName, t -> t, (t1, t2) -> t1))));
        this.itmPropList = itmPropService.findPropList(null);
        this.itmPropNameList = itmPropService.findPropList(null).stream().map(ItmPropVO::getCatePropName).collect(Collectors.toList());
        this.itmPropCodeList = itmPropService.findPropList(null).stream().map(ItmPropVO::getCatePropCode).collect(Collectors.toList());
    }

    public void invoke(ItmItemCatePropUploadExcel data, AnalysisContext context) {
        Map<String, ItmItemCateDTO> cateNameMap;
        int rowId = context.readRowHolder().getRowIndex() + 1;
        ItmCatePropDO itmCatePropDO = new ItmCatePropDO();
        String bigCateName = data.getBigCateName();
        Long bigCateId = null;
        if (StringUtils.isBlank((CharSequence)bigCateName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
        } else {
            Map<String, ItmItemCateDTO> bigCateNameMap = this.itemCatePidMap.get(0L);
            if (bigCateNameMap.containsKey(bigCateName)) {
                bigCateId = bigCateNameMap.get(bigCateName).getId();
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + bigCateName + "\u4e0d\u5b58\u5728"));
            }
        }
        String midCateName = data.getMidCateName();
        Long midCateId = null;
        if (StringUtils.isBlank((CharSequence)midCateName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
        } else if (null != bigCateId) {
            Map<String, ItmItemCateDTO> midCateNameMap = this.itemCatePidMap.get(bigCateId);
            if (midCateNameMap.containsKey(midCateName)) {
                midCateId = midCateNameMap.get(midCateName).getId();
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + midCateName + "\u4e0d\u5b58\u5728"));
            }
        }
        String smallCateName = data.getSmallCateName();
        String smallCateCode = null;
        if (StringUtils.isBlank((CharSequence)smallCateName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
        } else if (null != midCateId && (cateNameMap = this.itemCatePidMap.get(midCateId)).containsKey(smallCateName)) {
            smallCateCode = cateNameMap.get(smallCateName).getItemCateCode();
            itmCatePropDO.setItemCateCode(smallCateCode);
        }
        String catePropName = data.getCatePropName();
        List<String> smallCatePropName = null;
        smallCatePropName = CollectionUtils.isNotEmpty((Collection)this.smallCateNameMap.get(smallCateCode)) ? this.smallCateNameMap.get(smallCateCode) : this.itmCatePropService.getPropsByItemCateCode(smallCateCode).stream().map(ItmCatePropVO::getCatePropName).collect(Collectors.toList());
        if (smallCatePropName.contains(catePropName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u540d\u79f0", "\u5c0f\u7c7b\uff1a" + smallCateName + " \u7684\u54c1\u7c7b\u5c5e\u6027\uff1a" + catePropName + " \u91cd\u590d"));
        } else {
            smallCatePropName.add(catePropName);
            this.smallCateNameMap.put(smallCateCode, smallCatePropName);
            itmCatePropDO.setCatePropName(catePropName);
            if (!this.itmPropNameList.contains(catePropName)) {
                ItmPropDO itmPropDO = new ItmPropDO();
                itmPropDO.setCatePropName(catePropName);
                this.itmPropDos.add(itmPropDO);
                this.itmPropNameList.add(catePropName);
            }
        }
        Boolean isSaleProp = null;
        String catePropType = data.getCatePropType();
        if (StringUtils.isBlank((CharSequence)catePropType)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u7c7b\u578b", "\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (ItmUdcEnum.ITM_CATE_PROP_TYPE_DESC_PROP.getValDesc().equals(catePropType)) {
            isSaleProp = false;
            itmCatePropDO.setCatePropType(ItmUdcEnum.ITM_CATE_PROP_TYPE_DESC_PROP.getUdcVal());
        } else if (ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getValDesc().equals(catePropType)) {
            isSaleProp = true;
            itmCatePropDO.setCatePropType(ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getUdcVal());
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u7c7b\u578b", "\u4e0d\u5b58\u5728\u7684\u5c5e\u6027\u7c7b\u578b\uff1a" + catePropType + ";\u8bf7\u586b\u5199\u9500\u552e\u5c5e\u6027\u6216\u8005\u63cf\u8ff0\u5c5e\u6027"));
        }
        String isMust = data.getIsMust();
        String isHand = data.getIsHand();
        boolean isHandFlag = false;
        if (null != isSaleProp && !isSaleProp.booleanValue()) {
            if (StringUtils.isBlank((CharSequence)isMust)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u5fc5\u586b", "\u63cf\u8ff0\u5c5e\u6027-\u662f\u5426\u5fc5\u586b\u9879\uff0c\u5fc5\u586b"));
            } else if (isMust.matches("[01]$")) {
                itmCatePropDO.setIsMust(Integer.valueOf(isMust));
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u5fc5\u586b", "\u8bf7\u586b\u51990\u62161"));
            }
            if (StringUtils.isBlank((CharSequence)isHand)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f55\u5165\u65b9\u5f0f", "\u63cf\u8ff0\u5c5e\u6027-\u5f55\u5165\u65b9\u5f0f\u9879\uff0c\u5fc5\u586b"));
            } else if (isMust.matches("[01]$")) {
                Integer isHandInteger = Integer.valueOf(isHand);
                itmCatePropDO.setIsHand(isHandInteger);
                if (isHandInteger.equals(ZERO)) {
                    isHandFlag = true;
                }
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f55\u5165\u65b9\u5f0f", "\u8bf7\u586b\u51990\u62161"));
            }
            if (isHandFlag) {
                String isBox = data.getIsBox();
                if (StringUtils.isBlank((CharSequence)isBox)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5355\u9009/\u590d\u9009", "\u63cf\u8ff0\u5c5e\u6027-\u5355\u9009\u590d\u9009 \u5728\u5f55\u5165\u65b9\u5f0f\u4e3a\u5217\u8868\u9009\u62e9\u65f6\uff0c\u5fc5\u586b"));
                } else if (isBox.matches("[01]$")) {
                    itmCatePropDO.setIsBox(Integer.valueOf(isBox));
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5355\u9009/\u590d\u9009", "\u8bf7\u586b\u51990\u62161"));
                }
                String propValueName = data.getPropValueName();
                if (StringUtils.isNotBlank((CharSequence)propValueName)) {
                    List<String> propValueNameList = Arrays.asList(propValueName.split("(;)|(\uff1b)"));
                    if (CollectionUtils.isNotEmpty(propValueNameList) && !this.errorInfo.hasError()) {
                        ArrayList itmCatePropValueSaveParams = new ArrayList();
                        propValueNameList.forEach(value -> {
                            ItmCatePropValueDO itmCatePropValueSaveParam = new ItmCatePropValueDO();
                            itmCatePropValueSaveParam.setPropValueName((String)value);
                            itmCatePropValueSaveParams.add(itmCatePropValueSaveParam);
                        });
                        this.itmCatePropValueMap.put(rowId, itmCatePropValueSaveParams);
                    }
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u503c", "\u63cf\u8ff0\u5c5e\u6027-\u5f55\u5165\u65b9\u5f0f\u4e3a\u5217\u8868\u9009\u62e9\u65f6\uff0c\u5c5e\u6027\u503c\u5fc5\u586b"));
                }
            } else {
                itmCatePropDO.setIsBox(ZERO);
            }
        }
        if (!this.errorInfo.hasError()) {
            this.itmCatePropDOMap.put(rowId, itmCatePropDO);
        }
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    private void doSave() {
        if (CollectionUtils.isNotEmpty(this.itmPropDos)) {
            this.itmPropDos.forEach(itmProp -> {
                String prop_no = this.sysNumberGeneratorWrapper.generate("PROP_NO");
                if (this.itmPropCodeList.contains(prop_no)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u5f02\u5e38\uff0c\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
                }
                this.itmPropCodeList.add(prop_no);
                itmProp.setCatePropCode(prop_no);
                itmProp.setDeleteFlag(0);
            });
            this.itmPropRepo.saveAll(this.itmPropDos);
        }
        this.itmCatePropDOMap.values().forEach(cateProp -> {
            cateProp.setCreateTime(LocalDateTime.now());
            if (ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getUdcVal().equals(cateProp.getCatePropType())) {
                cateProp.setIsMust(ZERO);
                cateProp.setIsHand(ONE);
                cateProp.setIsBox(ZERO);
            }
            this.itmPropDos.forEach(prop -> {
                if (prop.getCatePropName().equals(cateProp.getCatePropName())) {
                    cateProp.setCatePropCode(prop.getCatePropCode());
                }
            });
            if (StringUtils.isBlank((CharSequence)cateProp.getCatePropCode())) {
                this.itmPropList.forEach(prop -> {
                    if (prop.getCatePropName().equals(cateProp.getCatePropName())) {
                        cateProp.setCatePropCode(prop.getCatePropCode());
                    }
                });
            }
        });
        this.itmCatePropRepo.saveAll(this.itmCatePropDOMap.values());
        this.itmCatePropValueMap.forEach((rowId, itmCatePropValue) -> {
            Long id = this.itmCatePropDOMap.get(rowId).getId();
            itmCatePropValue.forEach(value -> {
                value.setCatePropId(id);
                value.setCreateTime(LocalDateTime.now());
            });
        });
        if (MapUtils.isNotEmpty(this.itmCatePropValueMap)) {
            List catePropValueResults = this.itmCatePropValueMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.itmCatePropValueRepo.saveAll(catePropValueResults);
        }
    }
}

