/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepo;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemCateDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateXinUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemCateXinListener
extends AnalysisEventListener<ItmItemCateXinUploadExcel> {
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final String REGEX = "\\d{2}$";
    private final ErrorInfo errorInfo;
    private final Map<String, ItmItemCateDTO> cateCodeDtoMap;
    private final Map<Long, List<ItmItemCateDTO>> catePidMap;
    private final Map<Long, Set<String>> catePidNameMap;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmCateContrParaRepo itmCateContrParaRepo;
    private final TableColumnExtRepo tableColumnExtRepo;
    private final PriMainPriceService priMainPriceService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ItmItemCateXinListener.class);
    private final Map<String, String> newCateCodeNameMap = new HashMap<String, String>();
    private final List<ItmItemCateXinUploadExcel> excelData = new ArrayList<ItmItemCateXinUploadExcel>();
    private static final Long ROOT_PID = 0L;
    private static final String ROOT_CODE = "0";
    private static final String TRUE_FLAG = "1";
    private static final String FALSE_FLAG = "0";
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);

    public ItmItemCateXinListener(ErrorInfo errorInfo, List<ItmItemCateDTO> cateDtos, ItmItemCateRepo itmItemCateRepo, ItmCateContrParaRepo itmCateContrParaRepo, TableColumnExtRepo tableColumnExtRepo, PriMainPriceService priMainPriceService) {
        this.errorInfo = errorInfo;
        this.cateCodeDtoMap = cateDtos.stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateCode, t -> t));
        this.catePidMap = cateDtos.stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid));
        this.catePidNameMap = this.catePidMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ItmItemCateDTO::getItemCateName).collect(Collectors.toSet())));
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmCateContrParaRepo = itmCateContrParaRepo;
        this.tableColumnExtRepo = tableColumnExtRepo;
        this.priMainPriceService = priMainPriceService;
    }

    public void invoke(ItmItemCateXinUploadExcel data, AnalysisContext context) {
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        String cateBigCode = data.getItemCateBigCode();
        boolean hasBigCode = true;
        boolean isNewBigCode = false;
        if (StringUtils.isBlank((CharSequence)cateBigCode)) {
            hasBigCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (this.cateCodeDtoMap.containsKey(cateBigCode)) {
            ItmItemCateDTO cateDto = this.cateCodeDtoMap.get(cateBigCode);
            if (cateDto.getPid() == null || ROOT_PID.equals(cateDto.getPid())) {
                data.setCateBigId(cateDto.getId());
                data.setCateBigName(cateDto.getItemCateName());
            } else {
                hasBigCode = false;
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6240\u586b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4f46\u4e0d\u662f\u4e00\u7ea7\u54c1\u7c7b\uff0c\u5df2\u5b58\u5728\u54c1\u7c7b\u7684\u540d\u79f0\uff1a" + cateDto.getItemCateName()));
            }
        } else {
            isNewBigCode = true;
            data.setFullCateBigCode(cateBigCode);
        }
        String cateBigName = data.getItemCateBigName();
        if (StringUtils.isBlank((CharSequence)cateBigName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (hasBigCode) {
            if (isNewBigCode) {
                if (!this.newCateCodeNameMap.containsKey(cateBigCode)) {
                    if (this.catePidNameMap.getOrDefault(0L, Collections.emptySet()).contains(cateBigName)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                    }
                    this.newCateCodeNameMap.put(cateBigCode, cateBigName);
                }
            } else if (!cateBigName.equals(data.getCateBigName())) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u5339\u914d\u5230\u76f8\u540c\u7f16\u53f7\u7684\u54c1\u7c7b\uff0c\u4f46\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
            }
        }
        boolean hasMidCode = true;
        boolean isNewMidCode = false;
        String shortCateMidCode = data.getItemCateMidCode();
        String cateMidCode = cateBigCode + "-" + shortCateMidCode;
        if (StringUtils.isBlank((CharSequence)shortCateMidCode)) {
            hasMidCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (hasBigCode && hasMidCode) {
            if (this.cateCodeDtoMap.containsKey(cateMidCode)) {
                ItmItemCateDTO cateDto = this.cateCodeDtoMap.get(cateMidCode);
                if (isNewBigCode) {
                    hasMidCode = false;
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u5982\u679c\u4e00\u7ea7\u54c1\u7c7b\u4e3a\u65b0\u5efa\uff0c\u5219\u4e8c\u7ea7\u54c1\u7c7b\u5fc5\u987b\u4e3a\u65b0\u5efa\u54c1\u7c7b"));
                } else if (cateDto.getPid().equals(data.getCateBigId())) {
                    data.setCateMidId(cateDto.getId());
                    data.setCateMidName(cateDto.getItemCateName());
                } else {
                    hasMidCode = false;
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6307\u5b9a\u7684\u4e8c\u7ea7\u54c1\u7c7b\u5df2\u7ecf\u5c5e\u4e8e\u5176\u5b83\u4e00\u7ea7\u54c1\u7c7b\uff0c\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
                }
            } else {
                isNewMidCode = true;
                data.setFullCateMidCode(cateMidCode);
            }
            String cateMidName = data.getItemCateMidName();
            if (StringUtils.isBlank((CharSequence)cateMidName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (hasMidCode) {
                if (isNewMidCode) {
                    if (!this.newCateCodeNameMap.containsKey(cateMidCode)) {
                        if (data.getCateBigId() != null && this.catePidNameMap.getOrDefault(data.getCateBigId(), Collections.emptySet()).contains(cateMidName)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                        }
                        this.newCateCodeNameMap.put(cateMidCode, cateMidName);
                    }
                } else if (!cateMidName.equals(data.getCateMidName())) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u4e0d\u6b63\u786e\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateMidName()));
                }
            }
        }
        boolean hasSmallCode = true;
        String shortCateSmallCode = data.getItemCateSmallCode();
        String cateSmallCode = cateMidCode + "-" + shortCateSmallCode;
        if (StringUtils.isBlank((CharSequence)shortCateSmallCode)) {
            hasSmallCode = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            data.setFullCateSmallCode(cateSmallCode);
        }
        if (hasBigCode && hasMidCode && hasSmallCode) {
            boolean isNewSmallCode = true;
            if (this.cateCodeDtoMap.containsKey(cateSmallCode)) {
                isNewSmallCode = false;
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u5df2\u5b58\u5728"));
            }
            if (isNewSmallCode) {
                String cateSmallName = data.getItemCateSmallName();
                if (StringUtils.isBlank((CharSequence)cateSmallName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
                } else if (this.newCateCodeNameMap.containsKey(cateSmallCode)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u91cd\u590d\uff0c\u91cd\u590d\u54c1\u7c7b\u7f16\u7801\uff1a" + shortCateSmallCode));
                } else {
                    if (data.getCateMidId() != null && this.catePidNameMap.getOrDefault(data.getCateMidId(), Collections.emptySet()).contains(cateSmallCode)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u76f8\u540c\u7236\u7c7b\u4e0b\uff0c\u54c1\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728"));
                    }
                    this.newCateCodeNameMap.put(cateSmallCode, cateSmallName);
                }
            }
        }
        if (!this.errorInfo.hasError()) {
            this.excelData.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    private void doSave() {
        if (CollectionUtils.isEmpty(this.excelData)) {
            return;
        }
        HashMap pCodeDoGroupMap = new HashMap();
        HashMap<String, ItmItemCateDO> codeDoMap = new HashMap<String, ItmItemCateDO>();
        ArrayList<ItmItemCateDO> bigCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmItemCateDO> midCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmItemCateDO> smallCateDos = new ArrayList<ItmItemCateDO>();
        ArrayList<ItmCateContrParaDO> itmCateContrParaDos = new ArrayList<ItmCateContrParaDO>();
        LocalDate now = LocalDate.now();
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u4fdd\u5b58\u6570\u636e");
        for (ItmItemCateXinUploadExcel excelDatum : this.excelData) {
            String fullCateMidCode;
            String fullCateBigCode = excelDatum.getFullCateBigCode();
            if (StringUtils.isNotBlank((CharSequence)fullCateBigCode) && !codeDoMap.containsKey(fullCateBigCode)) {
                ItmItemCateDO bigCateDo = new ItmItemCateDO();
                bigCateDo.setItemCateCode(fullCateBigCode);
                bigCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateBigCode));
                bigCateDo.setGrade(1);
                bigCateDo.setItemCateIsBasic(0);
                bigCateDo.setStatus("ENABLE");
                bigCateDo.setPid(0L);
                if (pCodeDoGroupMap.containsKey("0")) {
                    ((List)pCodeDoGroupMap.get("0")).add(bigCateDo);
                } else {
                    ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                    dos.add(bigCateDo);
                    pCodeDoGroupMap.put("0", dos);
                }
                codeDoMap.put(fullCateBigCode, bigCateDo);
                bigCateDos.add(bigCateDo);
            }
            if (StringUtils.isNotBlank((CharSequence)(fullCateMidCode = excelDatum.getFullCateMidCode())) && !codeDoMap.containsKey(fullCateMidCode)) {
                ItmItemCateDO midCateDo = new ItmItemCateDO();
                midCateDo.setItemCateCode(fullCateMidCode);
                midCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateMidCode));
                midCateDo.setGrade(2);
                midCateDo.setItemCateIsBasic(0);
                midCateDo.setStatus("ENABLE");
                if (excelDatum.getCateBigId() != null) {
                    midCateDo.setPid(excelDatum.getCateBigId());
                } else {
                    String pCode = excelDatum.getFullCateBigCode();
                    if (pCodeDoGroupMap.containsKey(pCode)) {
                        ((List)pCodeDoGroupMap.get(pCode)).add(midCateDo);
                    } else {
                        ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                        dos.add(midCateDo);
                        pCodeDoGroupMap.put(pCode, dos);
                    }
                }
                codeDoMap.put(fullCateMidCode, midCateDo);
                midCateDos.add(midCateDo);
            }
            String fullCateSmallCode = excelDatum.getFullCateSmallCode();
            ItmItemCateDO smallCateDo = new ItmItemCateDO();
            smallCateDo.setItemCateCode(fullCateSmallCode);
            smallCateDo.setItemCateName(this.newCateCodeNameMap.get(fullCateSmallCode));
            smallCateDo.setGrade(3);
            smallCateDo.setItemCateIsBasic(1);
            smallCateDo.setStatus("ENABLE");
            if (excelDatum.getCateMidId() != null) {
                smallCateDo.setPid(excelDatum.getCateMidId());
            } else {
                String pCode = excelDatum.getFullCateMidCode();
                if (pCodeDoGroupMap.containsKey(pCode)) {
                    ((List)pCodeDoGroupMap.get(pCode)).add(smallCateDo);
                } else {
                    ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                    dos.add(smallCateDo);
                    pCodeDoGroupMap.put(pCode, dos);
                }
            }
            codeDoMap.put(fullCateSmallCode, smallCateDo);
            smallCateDos.add(smallCateDo);
            ItmCateContrParaDO snFlagDo = new ItmCateContrParaDO();
            snFlagDo.setItemCateCode(fullCateSmallCode);
            snFlagDo.setControlParamCode(ItmCateControlParamEnum.SN_FLAG.getCode());
            snFlagDo.setControlParamValue(excelDatum.getSnFlag());
            itmCateContrParaDos.add(snFlagDo);
            ItmCateContrParaDO lotFlagDo = new ItmCateContrParaDO();
            lotFlagDo.setItemCateCode(fullCateSmallCode);
            lotFlagDo.setControlParamCode(ItmCateControlParamEnum.LOT_FLAG.getCode());
            lotFlagDo.setControlParamValue(excelDatum.getLotFlag());
            itmCateContrParaDos.add(lotFlagDo);
            ItmCateContrParaDO finTypeDo = new ItmCateContrParaDO();
            finTypeDo.setItemCateCode(fullCateSmallCode);
            finTypeDo.setControlParamCode(ItmCateControlParamEnum.FIN_TYPE.getCode());
            finTypeDo.setControlParamValue(excelDatum.getFinTypeCode());
            itmCateContrParaDos.add(finTypeDo);
        }
        LOGGER.info("\u6784\u5efa\u5b8c\u6210");
        this.itmItemCateRepo.saveAll(bigCateDos);
        bigCateDos.forEach(big -> ((List)pCodeDoGroupMap.get(big.getItemCateCode())).forEach(mid -> mid.setPid(big.getId())));
        this.itmItemCateRepo.saveAll(midCateDos);
        midCateDos.forEach(mid -> ((List)pCodeDoGroupMap.get(mid.getItemCateCode())).forEach(small -> small.setPid(mid.getId())));
        this.itmItemCateRepo.saveAll(smallCateDos);
        this.itmCateContrParaRepo.saveAll(itmCateContrParaDos);
    }
}

