/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.provider.IdGeneratorProvider;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.dto.PurSuppBaseDTO;
import com.elitesland.yst.provider.PurSuppProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmBrandDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemUomConvDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemPropDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmItemConvUomConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmCateDescProp;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemAttr;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemUomConvRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.org.dto.OrgOuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgOuService;
import com.elitesland.yst.supportdomain.pri.param.PriItemPriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.GuaranteeConvUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemListener
extends AnalysisEventListener<ItmItemUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemListener.class);
    private static final String ERROR_TEMPLATE = "Sheet: \u5546\u54c1\u4e3b\u6863\u8d44\u6599, \u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final int ATTR_1_INDEX = 1;
    private static final int ATTR_2_INDEX = 2;
    private static final int ATTR_3_INDEX = 3;
    private static final String TRUE_FLAG = "1";
    private static final String FALSE_FLAG = "0";
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);
    private static final String CNY = "CNY";
    private static final String SPU_NO = "SPU_NO";
    private static final String SKU_NO = "SKU_NO";
    private static final String SKU_BAR_CODE = "SKU_BAR_CODE";
    private static final int STRING_BIG_LENGTH = 255;
    private static final int ZERO = 0;
    private final ErrorInfo errorInfo;
    private final Map<String, String> itemTypeUdc;
    private final Map<String, String> itemType2Udc;
    private final Map<String, String> timeUnitUdc;
    private final Map<String, String> returnExchangePolicyUdc;
    private final Map<String, String> weightUnitUdc;
    private final Map<String, String> volumeUnitUdc;
    private final Map<String, String> allocTypeUdc;
    private final Map<String, String> uomUdc;
    private final Map<String, String> brandNameCodeMap;
    private final Map<String, OrgOuDTO> ouDTOMap;
    private final PurSuppProvider purSuppProvider;
    private final ComTaxRateRpcService comTaxRateRpcService;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemPropRepo itmItemPropRepo;
    private final PriMainPriceService priMainPriceService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final IdGeneratorProvider snowflake;
    private final ItmItemUomConvRepo itmItemUomConvRepo;
    private final OrgBuRepo orgBuRepo;
    private final List<String> itemCodeList;
    private final Map<String, Map<Integer, ItmCateDescProp>> cateDescPropMap;
    private final Map<String, Map<Integer, ItmItemAttr>> itemCateAttrMap;
    private final Map<String, List<ItmCateDescProp>> notFillPropMap;
    private final Map<Long, Map<String, ItmItemCateDTO>> itemCatePidMap;
    private final Map<String, Map<Integer, ItmItemDO>> spuMap = new HashMap<String, Map<Integer, ItmItemDO>>();
    private final Map<String, Boolean> isSingleSkuMap = new HashMap<String, Boolean>();
    private final Map<String, String> buCurrCodeMap = new HashMap<String, String>();
    private final Map<Integer, ItmItemDO> dataMap = new HashMap<Integer, ItmItemDO>();
    private final Map<Integer, PriItemPriceSaveRowParam> priceMap = new HashMap<Integer, PriItemPriceSaveRowParam>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<Integer, ItmItemUomConvDTO> itmItemUomConvMap = new HashMap<Integer, ItmItemUomConvDTO>();
    private final Map<Integer, List<ItmItemPropDO>> itmItemDescPropDOMap = new HashMap<Integer, List<ItmItemPropDO>>();
    private final Map<String, List<String>> itmSkuNameMap = new HashMap<String, List<String>>();

    public ItmItemListener(UdcService sysUdcService, Map<String, Map<Integer, ItmCateDescProp>> cateDescPropMap, Map<String, Map<Integer, ItmItemAttr>> itemCateAttrMap, Map<String, List<ItmCateDescProp>> notFillPropMap, ItmItemCateRepoProc itmItemCateRepoProc, ItmBrandRepoProc itmBrandRepoProc, OrgOuService orgOuService, PurSuppProvider purSuppProvider, ComTaxRateRpcService comTaxRateRpcService, ItmItemRepo itmItemRepo, ItmItemPropRepo itmItemPropRepo, PriMainPriceService priMainPriceService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, IdGeneratorProvider snowflake, ItmItemUomConvRepo itmItemUomConvRepo, ItmItemService itmItemService, OrgBuRepo orgBuRepo) {
        this.errorInfo = new ErrorInfo();
        this.itemTypeUdc = sysUdcService.getCodeMap("ITM", "ITEM_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.itemType2Udc = sysUdcService.getCodeMap("ITM", "ITEM_TYPE2").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.timeUnitUdc = sysUdcService.getCodeMap("COM", "TIME_UNIT").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.returnExchangePolicyUdc = sysUdcService.getCodeMap("ITM", "RETURN_EXCHANGE_POLICY").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.weightUnitUdc = sysUdcService.getCodeMap("COM", "WEIGHT_UNIT").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.volumeUnitUdc = sysUdcService.getCodeMap("COM", "VOLUME_UNIT").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.allocTypeUdc = sysUdcService.getCodeMap("ITM", "ALLOC_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.uomUdc = sysUdcService.getCodeMap("COM", "UOM").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.cateDescPropMap = cateDescPropMap;
        this.itemCateAttrMap = itemCateAttrMap;
        this.notFillPropMap = notFillPropMap;
        this.itemCatePidMap = itmItemCateRepoProc.findAllDto().stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateName, t -> t, (t1, t2) -> t1))));
        this.brandNameCodeMap = itmBrandRepoProc.findAllBrandDto().stream().collect(Collectors.toMap(ItmBrandDTO::getBrandName, ItmBrandDTO::getBrandCode, (t1, t2) -> t1));
        this.ouDTOMap = orgOuService.findAllOuDto().stream().collect(Collectors.toMap(OrgOuDTO::getBuCode, t -> t, (t1, t2) -> t1));
        this.purSuppProvider = purSuppProvider;
        this.comTaxRateRpcService = comTaxRateRpcService;
        this.itmItemRepo = itmItemRepo;
        this.itmItemPropRepo = itmItemPropRepo;
        this.priMainPriceService = priMainPriceService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.snowflake = snowflake;
        this.itmItemUomConvRepo = itmItemUomConvRepo;
        this.orgBuRepo = orgBuRepo;
        this.itemCodeList = itmItemService.findAllItemDto(null).stream().map(ItmItemDTO::getItemCode).collect(Collectors.toList());
    }

    public void invoke(ItmItemUploadExcel data, AnalysisContext context) {
        String suppCode;
        String itemCateCode;
        String spuName;
        boolean isSuppCodeCorrect;
        boolean isItemCateCodeCorrect;
        boolean isSpuNameCorrect;
        StringBuilder uniqueKey;
        ItmItemDO itmItemDO;
        int rowId;
        block31: {
            rowId = context.readSheetHolder().getRowIndex() + 1;
            itmItemDO = new ItmItemDO();
            uniqueKey = new StringBuilder();
            isSpuNameCorrect = false;
            isItemCateCodeCorrect = false;
            isSuppCodeCorrect = false;
            spuName = data.getSpuName();
            if (StringUtils.isBlank((CharSequence)spuName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else if (spuName.length() > 255) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u540d\u79f0", "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26"));
            } else {
                itmItemDO.setSpuName(spuName);
                isSpuNameCorrect = true;
                uniqueKey.append(spuName);
            }
            String cateBigName = data.getCateBigName();
            Long cateBigId = null;
            if (StringUtils.isBlank((CharSequence)cateBigName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else {
                Map<String, ItmItemCateDTO> cateNameMap = this.itemCatePidMap.get(0L);
                if (cateNameMap.containsKey(cateBigName)) {
                    cateBigId = cateNameMap.get(cateBigName).getId();
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + cateBigName + "\u4e0d\u5b58\u5728"));
                }
            }
            String cateMidName = data.getCateMidName();
            Long cateMidId = null;
            if (StringUtils.isBlank((CharSequence)cateMidName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else if (cateBigId != null) {
                Map<String, ItmItemCateDTO> cateNameMap = this.itemCatePidMap.get(cateBigId);
                if (cateNameMap.containsKey(cateMidName)) {
                    cateMidId = cateNameMap.get(cateMidName).getId();
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + cateMidName + "\u4e0d\u5b58\u5728"));
                }
            }
            String cateSmallName = data.getCateSmallName();
            itemCateCode = null;
            if (StringUtils.isBlank((CharSequence)cateSmallName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else if (cateMidId != null) {
                Map<String, ItmItemCateDTO> cateNameMap = this.itemCatePidMap.get(cateMidId);
                if (cateNameMap.containsKey(cateSmallName)) {
                    itemCateCode = cateNameMap.get(cateSmallName).getItemCateCode();
                    itmItemDO.setItemCateCode(itemCateCode);
                    isItemCateCodeCorrect = true;
                    uniqueKey.append("_").append(itemCateCode);
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + cateSmallName + "\u4e0d\u5b58\u5728"));
                }
            }
            suppCode = data.getSuppCode();
            if (StringUtils.isBlank((CharSequence)suppCode)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4f9b\u5e94\u5546\u7f16\u53f7", "\u6570\u636e\u5fc5\u586b"));
            } else {
                try {
                    ApiResult apiResult = this.purSuppProvider.findBySuppCode(suppCode);
                    if (apiResult.isSuccess()) {
                        PurSuppBaseDTO supp = (PurSuppBaseDTO)apiResult.getData();
                        if (supp == null) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4f9b\u5e94\u5546\u7f16\u53f7", "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728"));
                        } else {
                            itmItemDO.setSuppId(supp.getId());
                            itmItemDO.setSuppCode(supp.getSuppCode());
                            itmItemDO.setSuppName(supp.getSuppName());
                            isSuppCodeCorrect = true;
                            uniqueKey.append("_").append(suppCode);
                        }
                        break block31;
                    }
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u5bfc\u5165\u5f02\u5e38\uff1a" + apiResult.getMsg());
                }
                catch (RuntimeException e) {
                    log.error(e.toString());
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u5bfc\u5165\u5f02\u5e38\uff0c\u4f9b\u5e94\u5546Dubbo\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
                }
            }
        }
        boolean isCorrectUniqueKey = false;
        boolean alreadyCheckedSpu = false;
        if (isSpuNameCorrect && isItemCateCodeCorrect && isSuppCodeCorrect) {
            isCorrectUniqueKey = true;
            if (this.itmItemRepo.existsBySpuNameAndSuppCodeAndItemCateCode(spuName, suppCode, itemCateCode)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u91cd\u590d", "\u5df2\u5b58\u5728 \u5546\u54c1\u540d\u79f0\uff0c\u54c1\u7c7b\uff0c\u4f9b\u5e94\u5546 \u90fd\u4e00\u6837\u7684\u5546\u54c1"));
            }
            alreadyCheckedSpu = this.spuMap.containsKey(uniqueKey.toString());
        }
        if (!isCorrectUniqueKey || !alreadyCheckedSpu) {
            this.checkSpuInfo(data, rowId, itmItemDO, itemCateCode);
            if (isCorrectUniqueKey) {
                this.spuMap.put(uniqueKey.toString(), Collections.singletonMap(rowId, itmItemDO));
                this.isSingleSkuMap.put(uniqueKey.toString(), true);
            }
        } else {
            ItmItemDO checkedSpu = new ArrayList<ItmItemDO>(this.spuMap.get(uniqueKey.toString()).values()).get(0);
            itmItemDO.setSpuName(checkedSpu.getSpuName());
            itmItemDO.setItemCateCode(checkedSpu.getItemCateCode());
            itmItemDO.setSuppId(checkedSpu.getSuppId());
            itmItemDO.setSuppCode(checkedSpu.getSuppCode());
            itmItemDO.setSuppName(checkedSpu.getSuppName());
            itmItemDO.setItemSource(checkedSpu.getItemSource());
            itmItemDO.setItemType(checkedSpu.getItemType());
            itmItemDO.setItemType2(checkedSpu.getItemType2());
            itmItemDO.setBrand(checkedSpu.getBrand());
            itmItemDO.setSpec(checkedSpu.getSpec());
            itmItemDO.setSalepurcFlag(checkedSpu.getSalepurcFlag());
            itmItemDO.setSnFlag(checkedSpu.getSnFlag());
            itmItemDO.setLotFlag(checkedSpu.getLotFlag());
            itmItemDO.setGuaranteePeriod(checkedSpu.getGuaranteePeriod());
            itmItemDO.setGuaranteePeriodUnit(checkedSpu.getGuaranteePeriodUnit());
            itmItemDO.setGuaranteeDays(checkedSpu.getGuaranteeDays());
            itmItemDO.setStoreCondition(checkedSpu.getStoreCondition());
            itmItemDO.setAllocType(checkedSpu.getAllocType());
            itmItemDO.setTaxType(checkedSpu.getTaxType());
            itmItemDO.setTaxRateNo(checkedSpu.getTaxRateNo());
            itmItemDO.setTaxRateNo2(checkedSpu.getTaxRateNo2());
            itmItemDO.setTaxRateTariff(checkedSpu.getTaxRateTariff());
            itmItemDO.setInstallFlag(checkedSpu.getInstallFlag());
            itmItemDO.setReturnExchangeFlag(checkedSpu.getReturnExchangeFlag());
            itmItemDO.setReturnExchangePolicy(checkedSpu.getReturnExchangePolicy());
            itmItemDO.setWarrantyFlag(checkedSpu.getWarrantyFlag());
            itmItemDO.setWarrantyPeriod(checkedSpu.getWarrantyPeriod());
            itmItemDO.setWarrantyPeriodUnit(checkedSpu.getWarrantyPeriodUnit());
            this.isSingleSkuMap.put(uniqueKey.toString(), false);
        }
        this.checkSkuInfo(data, rowId, itmItemDO, uniqueKey, spuName, itemCateCode, alreadyCheckedSpu);
        if (!this.errorInfo.hasError()) {
            this.dataMap.put(rowId, itmItemDO);
        }
    }

    private void checkSpuInfo(ItmItemUploadExcel data, int rowId, ItmItemDO itmItemDO, String smallCateCode) {
        String warrantyFlagStr;
        String returnExchangeFlagStr;
        String installFlagStr;
        String taxRateTariffStr;
        String allocTypeName;
        String storeCondition;
        String salepurcFlagStr;
        String itemSource = data.getItemSource();
        if (StringUtils.isBlank((CharSequence)itemSource)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u6765\u6e90\u7ec4\u7ec7\u7f16\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.ouDTOMap.containsKey(itemSource)) {
            if (!this.buCurrCodeMap.containsKey(itemSource)) {
                String currCode = this.ouDTOMap.get(itemSource).getCurrCode();
                this.buCurrCodeMap.put(itemSource, currCode == null ? CNY : currCode);
            }
            itmItemDO.setItemSource(itemSource);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u6765\u6e90\u7ec4\u7ec7\u7f16\u53f7", "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u53f8\u7c7b\u578b\u7684\u7ec4\u7ec7"));
        }
        String itemType2Name = data.getItemType2Name();
        if (StringUtils.isBlank((CharSequence)itemType2Name)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7269\u6599\u7c7b\u578b", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.itemType2Udc.containsKey(itemType2Name)) {
            itmItemDO.setItemType2(this.itemType2Udc.get(itemType2Name));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7269\u6599\u7c7b\u578b", "\u7269\u6599\u7c7b\u578b\uff1a" + itemType2Name + " \u4e0d\u5b58\u5728"));
        }
        String itemTypeName = data.getItemTypeName();
        if (StringUtils.isBlank((CharSequence)itemTypeName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7c7b\u578b", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.itemTypeUdc.containsKey(itemTypeName)) {
            itmItemDO.setItemType(this.itemTypeUdc.get(itemTypeName));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7c7b\u578b", "\u5546\u54c1\u7c7b\u578b\uff1a" + itemTypeName + " \u4e0d\u5b58\u5728"));
        }
        String brandName = data.getBrandName();
        if (StringUtils.isBlank((CharSequence)brandName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u54c1\u724c", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.brandNameCodeMap.containsKey(brandName)) {
            itmItemDO.setBrand(this.brandNameCodeMap.get(brandName));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u54c1\u724c", "\u5546\u54c1\u54c1\u724c\uff1a" + brandName + " \u4e0d\u5b58\u5728"));
        }
        String spec = data.getSpec();
        if (StringUtils.isNotBlank((CharSequence)spec)) {
            itmItemDO.setSpec(spec);
        }
        if (StringUtils.isBlank((CharSequence)(salepurcFlagStr = data.getSalepurcFlagStr()))) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u81ea\u91c7\u5546\u54c1", "\u6570\u636e\u5fc5\u586b"));
        } else if (TRUE_FLAG.equals(salepurcFlagStr)) {
            itmItemDO.setSalepurcFlag(true);
        } else if (FALSE_FLAG.equals(salepurcFlagStr)) {
            itmItemDO.setSalepurcFlag(false);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u81ea\u91c7\u5546\u54c1", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
        }
        String snFlagStr = data.getSnFlagStr();
        if (StringUtils.isBlank((CharSequence)snFlagStr)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else if (TRUE_FLAG.equals(snFlagStr)) {
            itmItemDO.setSnFlag(true);
        } else if (FALSE_FLAG.equals(snFlagStr)) {
            itmItemDO.setSnFlag(false);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
        }
        String lotFlagStr = data.getLotFlagStr();
        if (StringUtils.isBlank((CharSequence)lotFlagStr)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else if (TRUE_FLAG.equals(lotFlagStr)) {
            itmItemDO.setLotFlag(true);
        } else if (FALSE_FLAG.equals(lotFlagStr)) {
            itmItemDO.setLotFlag(false);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
        }
        Integer guaranteePeriod = data.getGuaranteePeriod();
        if (guaranteePeriod != null) {
            if (guaranteePeriod <= 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u8d28\u671f", "\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
            }
            String guaranteePeriodUnitName = data.getGuaranteePeriodUnitName();
            String guaranteePeriodUnit = null;
            if (StringUtils.isBlank((CharSequence)guaranteePeriodUnitName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u8d28\u671f\u5355\u4f4d", "\u5982\u679c\u586b\u4e86\u4fdd\u8d28\u671f\uff0c\u5219\u4fdd\u8d28\u671f\u5355\u4f4d\u5fc5\u586b"));
            } else if (this.timeUnitUdc.containsKey(guaranteePeriodUnitName)) {
                guaranteePeriodUnit = this.timeUnitUdc.get(guaranteePeriodUnitName);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u8d28\u671f\u5355\u4f4d", "\u4fdd\u8d28\u671f\u5355\u4f4d\uff1a" + guaranteePeriodUnitName + " \u4e0d\u5b58\u5728"));
            }
            if (!this.errorInfo.hasError() && guaranteePeriodUnit != null) {
                itmItemDO.setGuaranteePeriod(guaranteePeriod);
                itmItemDO.setGuaranteePeriodUnit(guaranteePeriodUnit);
                itmItemDO.setGuaranteeDays(GuaranteeConvUtil.convertToDays(guaranteePeriod, guaranteePeriodUnit));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(storeCondition = data.getStoreCondition()))) {
            itmItemDO.setStoreCondition(storeCondition);
        }
        if (StringUtils.isBlank((CharSequence)(allocTypeName = data.getAllocTypeName()))) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u914d\u8d27\u6a21\u5f0f", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.allocTypeUdc.containsKey(allocTypeName)) {
            itmItemDO.setAllocType(this.allocTypeUdc.get(allocTypeName));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u914d\u8d27\u6a21\u5f0f", "\u914d\u8d27\u6a21\u5f0f\uff1a" + allocTypeName + " \u4e0d\u5b58\u5728"));
        }
        String taxType = data.getTaxType();
        if (StringUtils.isBlank((CharSequence)taxType)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7a0e\u6536\u5206\u7c7b\u7801", "\u6570\u636e\u5fc5\u586b"));
        } else {
            itmItemDO.setTaxType(taxType);
        }
        String taxRateNo = data.getTaxRateNo();
        boolean hasTaxRateNo = true;
        String taxRateNo2 = data.getTaxRateNo2();
        boolean hasTaxRateNo2 = true;
        ArrayList<String> taxRateNos = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)taxRateNo)) {
            hasTaxRateNo = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8fdb\u9879\u7a0e\u7387\u7f16\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else {
            taxRateNos.add(taxRateNo);
        }
        if (StringUtils.isBlank((CharSequence)taxRateNo2)) {
            hasTaxRateNo = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u9879\u7a0e\u7387\u7f16\u53f7", "\u6570\u636e\u5fc5\u586b"));
        } else {
            taxRateNos.add(taxRateNo2);
        }
        if (CollectionUtils.isNotEmpty(taxRateNos)) {
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxRateNos.stream().distinct().collect(Collectors.toList()));
            List taxDto = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam).stream().map(ComTaxRateRpcDTO::getTaxRateNo).collect(Collectors.toList());
            if (hasTaxRateNo && taxDto.contains(taxRateNo)) {
                itmItemDO.setTaxRateNo(taxRateNo);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8fdb\u9879\u7a0e\u7387\u7f16\u53f7", "\u8fdb\u9879\u7a0e\u7387\u7f16\u53f7\uff1a" + taxRateNo + " \u4e0d\u5b58\u5728"));
            }
            if (hasTaxRateNo2 && taxDto.contains(taxRateNo2)) {
                itmItemDO.setTaxRateNo2(taxRateNo2);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u9879\u7a0e\u7387\u7f16\u53f7", "\u9500\u9879\u7a0e\u7387\u7f16\u53f7\uff1a" + taxRateNo + " \u4e0d\u5b58\u5728"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(taxRateTariffStr = data.getTaxRateTariffStr()))) {
            try {
                BigDecimal taxRateTariff = new BigDecimal(taxRateTariffStr);
                if (BigDecimal.ZERO.compareTo(taxRateTariff) <= 0 && DIVISOR.compareTo(taxRateTariff) > 0) {
                    itmItemDO.setTaxRateTariff(taxRateTariff.divide(DIVISOR, 2, RoundingMode.HALF_UP));
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5173\u7a0e\u7a0e\u7387", "\u5173\u7a0e\u7a0e\u7387 \u5fc5\u987b \u5927\u4e8e\u7b49\u4e8e0\uff0c\u5c0f\u4e8e100"));
                }
            }
            catch (NumberFormatException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5173\u7a0e\u7a0e\u7387", "\u5173\u7a0e\u7a0e\u7387\u6570\u503c\u8f6c\u6362\u5f02\u5e38\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(installFlagStr = data.getInstallFlagStr()))) {
            if (TRUE_FLAG.equals(installFlagStr)) {
                itmItemDO.setInstallFlag(true);
            } else if (FALSE_FLAG.equals(installFlagStr)) {
                itmItemDO.setInstallFlag(false);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u9700\u8981\u5b89\u88c5", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(returnExchangeFlagStr = data.getReturnExchangeFlagStr()))) {
            if (TRUE_FLAG.equals(returnExchangeFlagStr)) {
                String returnExchangePolicyName = data.getReturnExchangePolicyName();
                if (StringUtils.isBlank((CharSequence)returnExchangePolicyName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9000\u6362\u8d27\u627f\u8bfa", "\u5982\u679c\u9700\u8981\u9000\u6362\u8d27\uff0c\u5219\u6570\u636e\u5fc5\u586b"));
                } else if (this.returnExchangePolicyUdc.containsKey(returnExchangePolicyName)) {
                    itmItemDO.setReturnExchangeFlag(true);
                    itmItemDO.setReturnExchangePolicy(this.returnExchangePolicyUdc.get(returnExchangePolicyName));
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9000\u6362\u8d27\u627f\u8bfa", "\u9000\u6362\u8d27\u627f\u8bfa\uff1a" + returnExchangePolicyName + " \u4e0d\u5b58\u5728"));
                }
            } else if (FALSE_FLAG.equals(returnExchangeFlagStr)) {
                itmItemDO.setReturnExchangeFlag(false);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u9000\u6362\u8d27", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(warrantyFlagStr = data.getWarrantyFlagStr()))) {
            if (TRUE_FLAG.equals(warrantyFlagStr)) {
                Integer warrantyPeriod = data.getWarrantyPeriod();
                if (warrantyPeriod == null) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u4fee\u65f6\u957f", "\u5982\u679c\u9700\u8981\u4fdd\u4fee\uff0c\u5219\u6570\u636e\u5fc5\u586b"));
                }
                String warrantyPeriodUnitName = data.getWarrantyPeriodUnitName();
                String warrantyPeriodUnit = null;
                if (StringUtils.isBlank((CharSequence)warrantyPeriodUnitName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u4fee\u65f6\u957f\u5355\u4f4d", "\u5982\u679c\u9700\u8981\u4fdd\u4fee\uff0c\u5219\u6570\u636e\u5fc5\u586b"));
                } else if (this.timeUnitUdc.containsKey(warrantyPeriodUnitName)) {
                    warrantyPeriodUnit = this.timeUnitUdc.get(warrantyPeriodUnitName);
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fdd\u4fee\u65f6\u957f\u5355\u4f4d", "\u4fdd\u4fee\u65f6\u957f\u5355\u4f4d\uff1a" + warrantyPeriodUnitName + " \u4e0d\u5b58\u5728"));
                }
                if (warrantyPeriod != null && warrantyPeriodUnit != null) {
                    itmItemDO.setWarrantyFlag(true);
                    itmItemDO.setWarrantyPeriod(warrantyPeriod);
                    itmItemDO.setWarrantyPeriodUnit(warrantyPeriodUnit);
                }
            } else if (FALSE_FLAG.equals(warrantyFlagStr)) {
                itmItemDO.setWarrantyFlag(false);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u4fdd\u4fee", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)smallCateCode)) {
            String itemPropValue1 = data.getItemPropValue1();
            String itemPropValue2 = data.getItemPropValue2();
            String itemPropValue3 = data.getItemPropValue3();
            String itemPropValue4 = data.getItemPropValue4();
            String itemPropValue5 = data.getItemPropValue5();
            String itemPropValue6 = data.getItemPropValue6();
            String itemPropValue7 = data.getItemPropValue7();
            String itemPropValue8 = data.getItemPropValue8();
            String itemPropValue9 = data.getItemPropValue9();
            String itemPropValue10 = data.getItemPropValue10();
            String itemPropValue11 = data.getItemPropValue11();
            String itemPropValue12 = data.getItemPropValue12();
            String itemPropValue13 = data.getItemPropValue13();
            String itemPropValue14 = data.getItemPropValue14();
            String itemPropValue15 = data.getItemPropValue15();
            List<String> itemPropValues = Arrays.asList(itemPropValue1, itemPropValue2, itemPropValue3, itemPropValue4, itemPropValue5, itemPropValue6, itemPropValue7, itemPropValue8, itemPropValue9, itemPropValue10, itemPropValue11, itemPropValue12, itemPropValue13, itemPropValue14, itemPropValue15);
            Map<Integer, ItmCateDescProp> itmCateDescPropMap = this.cateDescPropMap.get(smallCateCode);
            long valuesNonNollSize = itemPropValues.stream().filter(Objects::nonNull).count();
            boolean isCateDescPropMapBlank = MapUtils.isEmpty(itmCateDescPropMap);
            if (isCateDescPropMapBlank) {
                if (0L != valuesNonNollSize) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u63cf\u8ff0\u5c5e\u6027", "\u63cf\u8ff0\u5c5e\u6027\u540d\u79f0\u5168\u90e8\u672a\u586b\uff0c\u63cf\u8ff0\u5c5e\u6027\u503c\u4e0d\u80fd\u586b\u5199"));
                }
            } else {
                for (int i = 0; i < itemPropValues.size(); ++i) {
                    String excelPropValue = itemPropValues.get(i);
                    boolean isValueBlank = StringUtils.isBlank((CharSequence)excelPropValue);
                    int colId2 = i + 1;
                    ItmCateDescProp descProp2 = itmCateDescPropMap.get(colId2);
                    boolean isNameBlank = Objects.isNull(descProp2);
                    if (!isValueBlank && isNameBlank) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u63cf\u8ff0\u5c5e\u6027" + colId2, "\u63cf\u8ff0\u5c5e\u6027\u540d\u79f0\u672a\u586b\uff0c\u63cf\u8ff0\u5c5e\u6027\u503c\u4e0d\u80fd\u586b\u5199"));
                        continue;
                    }
                    if (isNameBlank) continue;
                    if (descProp2.isMust() && isValueBlank) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u63cf\u8ff0\u5c5e\u6027" + colId2, " \u4e3a\u5fc5\u586b\u63cf\u8ff0\u5c5e\u6027\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
                        continue;
                    }
                    if (isValueBlank || descProp2.isHand()) continue;
                    List<String> excelValues = Arrays.stream(excelPropValue.split("(;)|(\uff1b)")).distinct().collect(Collectors.toList());
                    List<String> propValues = descProp2.getPropValues();
                    excelValues.forEach(value -> {
                        if (!propValues.contains(value)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u63cf\u8ff0\u5c5e\u6027" + colId2, "\u5c5e\u6027\u503c\u4e0d\u5b58\u5728\u63cf\u8ff0\u5c5e\u6027-" + descProp2.getName() + "\u7684\u5c5e\u6027\u5217\u8868" + propValues + "\u4e2d"));
                        }
                    });
                    if (descProp2.isBox() || excelValues.size() <= 1) continue;
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u63cf\u8ff0\u5c5e\u6027" + colId2, "\u4e3a\u5355\u9009\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u5355\u4e2a\u5c5e\u6027"));
                }
                if (!this.errorInfo.hasError()) {
                    ArrayList itmItemPropDOs = new ArrayList();
                    itmCateDescPropMap.forEach((colId, descProp) -> {
                        ItmItemPropDO itmItemPropDO = new ItmItemPropDO();
                        itmItemPropDO.setCatePropCode(descProp.getCode());
                        itmItemPropDO.setCatePropName(descProp.getName());
                        itmItemPropDO.setCatePropType(ItmUdcEnum.CATE_PROP_TYPE_DESC_PROP.getUdcVal());
                        String excelValue = (String)itemPropValues.get(colId - 1);
                        if (StringUtils.isNotBlank((CharSequence)excelValue)) {
                            itmItemPropDO.setPropValue(Arrays.stream(excelValue.split("(;)|(\uff1b)")).distinct().collect(Collectors.joining(",")));
                        }
                        itmItemPropDOs.add(itmItemPropDO);
                    });
                    List<ItmCateDescProp> notFillDescPropsMap = this.notFillPropMap.get(smallCateCode);
                    if (CollectionUtils.isNotEmpty(notFillDescPropsMap)) {
                        notFillDescPropsMap.forEach(cateDescProp -> {
                            ItmItemPropDO itmItemPropDO = new ItmItemPropDO();
                            itmItemPropDO.setCatePropCode(cateDescProp.getCode());
                            itmItemPropDO.setCatePropName(cateDescProp.getName());
                            itmItemPropDO.setCatePropType(ItmUdcEnum.CATE_PROP_TYPE_DESC_PROP.getUdcVal());
                            itmItemPropDOs.add(itmItemPropDO);
                        });
                    }
                    this.itmItemDescPropDOMap.put(rowId, itmItemPropDOs);
                }
            }
        }
    }

    private void checkSkuInfo(ItmItemUploadExcel data, int rowId, ItmItemDO itmItemDO, StringBuilder uniqueKey, String spuName, String itemCateCode, boolean alreadyCheckedSpu) {
        BigDecimal volume;
        BigDecimal grossWeight;
        String packageSpec;
        String distributionFlagXStr;
        BigDecimal price2;
        BigDecimal price3;
        BigDecimal price1;
        String suppItemCode;
        String barCode;
        if (StringUtils.isNotBlank((CharSequence)itemCateCode)) {
            String itemAttr1 = data.getItemAttr1();
            String itemAttr2 = data.getItemAttr2();
            String itemAttr3 = data.getItemAttr3();
            ArrayList<ItmItemAttr> itemAttrs = new ArrayList<ItmItemAttr>();
            String skuName = data.getSkuName();
            if (this.itemCateAttrMap.containsKey(itemCateCode)) {
                Map<Integer, ItmItemAttr> cateAttrMap = this.itemCateAttrMap.get(itemCateCode);
                for (Map.Entry<Integer, ItmItemAttr> entry : cateAttrMap.entrySet()) {
                    Integer key = entry.getKey();
                    ItmItemAttr itemAttr = entry.getValue();
                    if (key.equals(1)) {
                        if (StringUtils.isBlank((CharSequence)itemAttr1)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u60271", "\u5728 \u54c1\u7c7b\u5bf9\u5e94\u5c5e\u6027\u540dsheet \u4e2d\u8fdb\u884c\u914d\u7f6e\u8fc7\u7684\u9500\u552e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a"));
                            continue;
                        }
                        itemAttr.setValue(itemAttr1);
                        itemAttrs.add(itemAttr);
                        continue;
                    }
                    if (key.equals(2)) {
                        if (StringUtils.isBlank((CharSequence)itemAttr2)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u60272", "\u5728 \u54c1\u7c7b\u5bf9\u5e94\u5c5e\u6027\u540dsheet \u4e2d\u8fdb\u884c\u914d\u7f6e\u8fc7\u7684\u9500\u552e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a"));
                            continue;
                        }
                        itemAttr.setValue(itemAttr2);
                        itemAttrs.add(itemAttr);
                        continue;
                    }
                    if (!key.equals(3)) continue;
                    if (StringUtils.isBlank((CharSequence)itemAttr3)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u60273", "\u5728 \u54c1\u7c7b\u5bf9\u5e94\u5c5e\u6027\u540dsheet \u4e2d\u8fdb\u884c\u914d\u7f6e\u8fc7\u7684\u9500\u552e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a"));
                        continue;
                    }
                    itemAttr.setValue(itemAttr3);
                    itemAttrs.add(itemAttr);
                }
                if (MapUtils.isNotEmpty(cateAttrMap)) {
                    if (StringUtils.isBlank((CharSequence)skuName)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "sku\u540d\u79f0", "\u5728\u9500\u552e\u5c5e\u6027\u586b\u5199\u7684\u60c5\u51b5\u4e0b\uff0c\u5fc5\u586b"));
                    } else if (CollectionUtils.isNotEmpty((Collection)this.itmSkuNameMap.get(uniqueKey.toString()))) {
                        List<String> skuNameList = this.itmSkuNameMap.get(uniqueKey.toString());
                        if (skuNameList.contains(skuName)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "sku\u540d\u79f0" + skuName, "\u91cd\u590d"));
                        } else {
                            skuNameList.add(skuName);
                            this.itmSkuNameMap.put(uniqueKey.toString(), skuNameList);
                        }
                    } else {
                        ArrayList<String> newSkuNames = new ArrayList<String>();
                        newSkuNames.add(skuName);
                        this.itmSkuNameMap.put(uniqueKey.toString(), newSkuNames);
                    }
                }
            } else {
                if (alreadyCheckedSpu) {
                    Integer exRowId = new ArrayList<Integer>(this.spuMap.get(uniqueKey.toString()).keySet()).get(0);
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u6027", "\u5982\u679c\u5f53\u524d\u5546\u54c1\u6ca1\u6709\u5b9a\u4e49\u9500\u552e\u5c5e\u6027\uff0c\u5219\u6574\u4e2aExcel\u4e2d\u5fc5\u987b\u552f\u4e00\uff0c\u5f53\u524d\u5546\u54c1\u4e0e\u7b2c " + exRowId + " \u884c\u5546\u54c1\u91cd\u590d"));
                }
                if (StringUtils.isNotBlank((CharSequence)itemAttr1) || StringUtils.isNotBlank((CharSequence)itemAttr2) || StringUtils.isNotBlank((CharSequence)itemAttr3)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u6027", "\u9500\u552e\u5c5e\u6027\u6ca1\u6709\u5728 \u54c1\u7c7b\u5bf9\u5e94\u5c5e\u6027\u540dsheet \u4e2d\u8fdb\u884c\u914d\u7f6e"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)skuName)) {
                itmItemDO.setItemName(skuName);
            } else {
                itmItemDO.setItemName(spuName);
            }
            try {
                itmItemDO.setItemAttr(this.objectMapper.writeValueAsString(itemAttrs));
            }
            catch (JsonProcessingException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u5c5e\u6027", "JSON \u8f6c\u6362\u5f02\u5e38"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(barCode = data.getBarCode()))) {
            itmItemDO.setBarCode(barCode);
        } else {
            itmItemDO.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
        }
        String outerCode = data.getOuterCode();
        if (StringUtils.isNotBlank((CharSequence)outerCode)) {
            itmItemDO.setOuterCode(outerCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(suppItemCode = data.getSuppItemCode()))) {
            itmItemDO.setSuppItemCode(suppItemCode);
        }
        boolean needSavePrice = false;
        BigDecimal price8 = data.getPrice8();
        if (price8 != null) {
            if (BigDecimal.ZERO.compareTo(price8) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91c7\u8d2d\u4ef7", "\u91c7\u8d2d\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            } else {
                needSavePrice = true;
            }
        }
        if ((price1 = data.getPrice1()) != null) {
            if (BigDecimal.ZERO.compareTo(price1) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5e02\u573a\u4ef7", "\u5e02\u573a\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            } else {
                needSavePrice = true;
            }
        }
        if ((price3 = data.getPrice3()) != null) {
            if (BigDecimal.ZERO.compareTo(price3) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u96f6\u552e\u4ef7", "C\u7aef\u96f6\u552e\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            } else {
                needSavePrice = true;
            }
        }
        if ((price2 = data.getPrice2()) != null) {
            if (BigDecimal.ZERO.compareTo(price2) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6307\u5bfc\u4ef7", "B\u7aef\u6307\u5bfc\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            } else {
                needSavePrice = true;
            }
        }
        String price4Str = data.getPrice4Str();
        BigDecimal price4 = null;
        if (StringUtils.isNotBlank((CharSequence)price4Str)) {
            try {
                price4 = new BigDecimal(price4Str);
                if (BigDecimal.ZERO.compareTo(price4) <= 0 && DIVISOR.compareTo(price4) > 0) {
                    price4 = price4.divide(DIVISOR, 2, RoundingMode.HALF_UP);
                    needSavePrice = true;
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387 \u5fc5\u987b \u5927\u4e8e\u7b49\u4e8e0\uff0c\u5c0f\u4e8e100"));
                }
            }
            catch (NumberFormatException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387\u6570\u503c\u8f6c\u6362\u5f02\u5e38\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
            }
        }
        String price5Str = data.getPrice5Str();
        BigDecimal price5 = null;
        if (StringUtils.isNotBlank((CharSequence)price5Str)) {
            try {
                price5 = new BigDecimal(price5Str);
                if (BigDecimal.ZERO.compareTo(price5) <= 0 && DIVISOR.compareTo(price5) > 0) {
                    price5 = price5.divide(DIVISOR, 2, RoundingMode.HALF_UP);
                    needSavePrice = true;
                } else {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387 \u5fc5\u987b \u5927\u4e8e\u7b49\u4e8e0\uff0c\u5c0f\u4e8e100"));
                }
            }
            catch (NumberFormatException e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387\u6570\u503c\u8f6c\u6362\u5f02\u5e38\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
            }
        }
        if (needSavePrice) {
            PriItemPriceSaveRowParam priItemPriceSaveRowParam = new PriItemPriceSaveRowParam();
            priItemPriceSaveRowParam.setPrice1(price1);
            priItemPriceSaveRowParam.setPrice2(price2);
            priItemPriceSaveRowParam.setPrice3(price3);
            priItemPriceSaveRowParam.setPrice4(price4);
            priItemPriceSaveRowParam.setPrice5(price5);
            priItemPriceSaveRowParam.setPrice8(price8);
            this.priceMap.put(rowId, priItemPriceSaveRowParam);
        }
        boolean saleUomFlag = true;
        String saleUomName = data.getSaleUomName();
        if (StringUtils.isBlank((CharSequence)saleUomName)) {
            saleUomFlag = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u8ba1\u91cf\u5355\u4f4d", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.uomUdc.containsKey(saleUomName)) {
            itmItemDO.setSaleUom(this.uomUdc.get(saleUomName));
            itmItemDO.setUom(this.uomUdc.get(saleUomName));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u9500\u552e\u8ba1\u91cf\u5355\u4f4d", "\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\uff1a" + saleUomName + " \u4e0d\u5b58\u5728"));
        }
        boolean purcUomFlag = true;
        String purcUomName = data.getPurcUomName();
        if (StringUtils.isBlank((CharSequence)purcUomName)) {
            purcUomFlag = false;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91c7\u8d2d\u8ba1\u91cf\u5355\u4f4d", "\u6570\u636e\u5fc5\u586b"));
        } else if (this.uomUdc.containsKey(purcUomName)) {
            itmItemDO.setPurcUom(this.uomUdc.get(purcUomName));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91c7\u8d2d\u8ba1\u91cf\u5355\u4f4d", "\u91c7\u8d2d\u8ba1\u91cf\u5355\u4f4d\uff1a" + purcUomName + " \u4e0d\u5b58\u5728"));
        }
        ItmItemUomConvDTO itmItemUomConvDTO = new ItmItemUomConvDTO();
        itmItemUomConvDTO.setFromUom(this.uomUdc.get(purcUomName));
        itmItemUomConvDTO.setToUom(this.uomUdc.get(saleUomName));
        if (saleUomFlag && purcUomFlag && !saleUomName.equals(purcUomName)) {
            String ratio = data.getRatio();
            if (StringUtils.isBlank((CharSequence)ratio)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8f6c\u6362\u7cfb\u6570", "\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\u4e0e\u91c7\u8d2d\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\u65f6\uff0c\u8f6c\u6362\u7cfb\u6570\u5fc5\u586b"));
            } else {
                this.itmItemUomConvMap.put(rowId, this.judgmentRatio(data, rowId, itmItemUomConvDTO, false));
            }
        } else {
            this.itmItemUomConvMap.put(rowId, this.judgmentRatio(data, rowId, itmItemUomConvDTO, true));
        }
        String memberdiscFlagXStr = data.getMemberdiscFlagXStr();
        if (StringUtils.isNotBlank((CharSequence)memberdiscFlagXStr)) {
            if (TRUE_FLAG.equals(memberdiscFlagXStr)) {
                itmItemDO.setMemberdiscFlagX(true);
            } else if (FALSE_FLAG.equals(memberdiscFlagXStr)) {
                itmItemDO.setMemberdiscFlagX(false);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u4eab\u53d7\u4f1a\u5458\u6298\u6263", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(distributionFlagXStr = data.getDistributionFlagXStr()))) {
            if (TRUE_FLAG.equals(distributionFlagXStr)) {
                itmItemDO.setDistributionFlagX(true);
            } else if (FALSE_FLAG.equals(distributionFlagXStr)) {
                itmItemDO.setDistributionFlagX(false);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u5206\u9500", "\u53ea\u80fd\u586b 1 \u6216\u8005 0"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(packageSpec = data.getPackageSpec()))) {
            itmItemDO.setPackageSpec(packageSpec);
        }
        if ((grossWeight = data.getGrossWeight()) != null) {
            if (BigDecimal.ZERO.compareTo(grossWeight) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6bdb\u91cd", "\u6bdb\u91cd\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
            } else {
                itmItemDO.setGrossWeight(grossWeight);
            }
            String weightUnitName = data.getWeightUnitName();
            if (StringUtils.isBlank((CharSequence)weightUnitName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91cd\u91cf\u5355\u4f4d", "\u5982\u679c\u586b\u4e86\u91cd\u91cf\uff0c\u5219\u91cd\u91cf\u5355\u4f4d\u5fc5\u586b"));
            } else if (this.weightUnitUdc.containsKey(weightUnitName)) {
                itmItemDO.setWeightUnit(this.weightUnitUdc.get(weightUnitName));
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91cd\u91cf\u5355\u4f4d", "\u91cd\u91cf\u5355\u4f4d\uff1a" + weightUnitName + " \u4e0d\u5b58\u5728"));
            }
        }
        if ((volume = data.getVolume()) != null) {
            if (BigDecimal.ZERO.compareTo(volume) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4f53\u79ef", "\u4f53\u79ef\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
            } else {
                itmItemDO.setVolume(volume);
            }
            String volumeUnitName = data.getVolumeUnitName();
            if (StringUtils.isBlank((CharSequence)volumeUnitName)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4f53\u79ef\u5355\u4f4d", "\u5982\u679c\u586b\u4e86\u4f53\u79ef\uff0c\u5219\u4f53\u79ef\u5355\u4f4d\u5fc5\u586b"));
            } else if (this.volumeUnitUdc.containsKey(volumeUnitName)) {
                itmItemDO.setVolumeUnit(this.volumeUnitUdc.get(volumeUnitName));
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4f53\u79ef\u5355\u4f4d", "\u4f53\u79ef\u5355\u4f4d\uff1a" + volumeUnitName + " \u4e0d\u5b58\u5728"));
            }
        }
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (!(exception instanceof ExcelDataConvertException)) {
            if (exception instanceof BusinessException) {
                throw exception;
            }
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "Excel\u89e3\u6790\u5f02\u5e38: " + exception.getCause().getMessage());
        }
        log.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
        ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
        String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1 + "\u5217", excelDataConvertException.getCause().getMessage());
        log.error(logStr);
        this.errorInfo.log(logStr);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    private void doSave() {
        HashMap spuIdMap = new HashMap(16);
        HashMap spuNameMap = new HashMap(16);
        ArrayList itemPropDos = new ArrayList();
        this.dataMap.values().forEach(item -> {
            String spuCode;
            Long spuId;
            item.setCreateTime(LocalDateTime.now());
            String uniqueKey = item.getSpuName() + "_" + item.getItemCateCode() + "_" + item.getSuppCode();
            if (spuNameMap.containsKey(uniqueKey)) {
                spuId = (Long)spuIdMap.get(uniqueKey);
                spuCode = (String)spuNameMap.get(uniqueKey);
            } else {
                Collection<ItmItemAttr> attrs;
                spuId = this.snowflake.nextId();
                spuCode = this.sysNumberGeneratorWrapper.generate(SPU_NO);
                if (this.itemCodeList.contains(spuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u5f02\u5e38\uff0cspu\u7684itemCode\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
                }
                this.itemCodeList.add(spuCode);
                spuIdMap.put(uniqueKey, spuId);
                spuNameMap.put(uniqueKey, spuCode);
                if (this.itemCateAttrMap.containsKey(item.getItemCateCode()) && CollectionUtils.isNotEmpty(attrs = this.itemCateAttrMap.get(item.getItemCateCode()).values())) {
                    for (ItmItemAttr attr : attrs) {
                        ItmItemPropDO itemPropDO = new ItmItemPropDO();
                        itemPropDO.setItemId(spuId);
                        itemPropDO.setCatePropCode(attr.getCode());
                        itemPropDO.setCatePropName(attr.getName());
                        itemPropDO.setCatePropType(ItmUdcEnum.CATE_PROP_TYPE_SALE_PROP.getUdcVal());
                        itemPropDos.add(itemPropDO);
                    }
                }
            }
            item.setSpuId(spuId);
            item.setSpuCode(spuCode);
            if (this.isSingleSkuMap.get(uniqueKey).booleanValue()) {
                item.setItemCode(spuCode);
            } else {
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, spuCode);
                if (this.itemCodeList.contains(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u5f02\u5e38\uff0csku\u7684itemCode\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
                }
                this.itemCodeList.add(skuCode);
                item.setItemCode(skuCode);
            }
            item.setItemStatus(ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal());
            Optional<OrgBuDO> itemBuCode = this.orgBuRepo.findByBuCode(item.getItemSource());
            if (itemBuCode.isPresent()) {
                Long ouId = itemBuCode.get().getOuId();
                item.setSecOuId(ouId);
                GeneralUserDetails user = SecurityUtil.getUser();
                if (user != null && user.getSecurityOrgUserEmpBuDTO() != null && user.getSecurityOrgUserEmpBuDTO().getEmpId() != null) {
                    item.setSecUserId(user.getSecurityOrgUserEmpBuDTO().getEmpId());
                }
            }
        });
        if (MapUtils.isNotEmpty(this.itmItemDescPropDOMap)) {
            this.itmItemDescPropDOMap.forEach((rowId, descProps) -> {
                ItmItemDO itmItemDO = this.dataMap.get(rowId);
                descProps.forEach(descProp -> descProp.setItemId(itmItemDO.getSpuId()));
                itemPropDos.addAll(descProps);
            });
        }
        this.itmItemRepo.saveAll(this.dataMap.values());
        this.itmItemPropRepo.saveAll(itemPropDos);
        if (MapUtils.isNotEmpty(this.priceMap)) {
            this.priceMap.forEach((rowId, priceSaveRowParam) -> {
                ItmItemDO item = this.dataMap.get(rowId);
                priceSaveRowParam.setItemId(item.getId());
                priceSaveRowParam.setItemCode(item.getItemCode());
                priceSaveRowParam.setUom(item.getUom());
                priceSaveRowParam.setBuCode(item.getItemSource());
                priceSaveRowParam.setCurrCode(this.buCurrCodeMap.get(item.getItemSource()));
            });
            this.priMainPriceService.priMainPriceSave(new ArrayList<PriItemPriceSaveRowParam>(this.priceMap.values()), Collections.emptyList(), ComUdcEnum.COM_INACTIVE.getUdcVal());
        }
        this.itmItemUomConvMap.forEach((rowId, itmItemUomConv) -> {
            ItmItemDO item = this.dataMap.get(rowId);
            itmItemUomConv.setItemId(item.getId());
            this.itmItemUomConvRepo.save(ItmItemConvUomConvert.INSTANCE.dtoToDo((ItmItemUomConvDTO)itmItemUomConv));
        });
    }

    private ItmItemUomConvDTO judgmentRatio(ItmItemUploadExcel data, int rowId, ItmItemUomConvDTO itmItemUomConvDTO, Boolean flag) {
        String ratio = data.getRatio();
        if (StringUtils.isBlank((CharSequence)ratio) && flag.booleanValue()) {
            return itmItemUomConvDTO;
        }
        BigDecimal ratioBigDecimal = null;
        try {
            ratioBigDecimal = new BigDecimal(ratio);
            itmItemUomConvDTO.setRatio(ratioBigDecimal);
        }
        catch (Exception e) {
            ratioBigDecimal = null;
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8f6c\u6362\u7cfb\u6570", "\u8f6c\u6362\u7cfb\u6570\u8f6c\u6362\u683c\u5f0f\u5931\u8d25"));
        }
        if (ratioBigDecimal != null) {
            if (BigDecimal.ZERO.compareTo(ratioBigDecimal) >= 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8f6c\u6362\u7cfb\u6570", "\u8f6c\u6362\u7cfb\u6570\u5fc5\u987b\u5927\u4e8e0"));
            } else {
                itmItemUomConvDTO.setRevertRatio(BigDecimal.ZERO.divide(ratioBigDecimal, 2, RoundingMode.HALF_UP));
            }
        }
        return itmItemUomConvDTO;
    }
}

