/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.dto.ItmCatePropDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmCateDescProp;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemAttr;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemPreUploadExcel;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropValueVO;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItmItemPreListener
extends AnalysisEventListener<ItmItemPreUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemPreListener.class);
    private static final String ERROR_TEMPLATE = "Sheet: \u54c1\u7c7b\u5bf9\u5e94\u5c5e\u6027\u540d, \u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;
    private final ErrorInfo errorInfo = new ErrorInfo();
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmCatePropValueRepoProc itmCatePropValueRepoProc;
    private final Map<String, Map<Integer, ItmItemAttr>> cateAttrMap;
    private final Map<String, Map<Integer, ItmCateDescProp>> cateDescPropMap;
    private final Map<String, List<ItmCateDescProp>> notFillPropMap;

    public ItmItemPreListener(ItmItemCateRepo itmItemCateRepo, ItmItemCateRepoProc itmItemCateRepoProc, ItmCatePropRepoProc itmCatePropRepoProc, ItmCatePropValueRepoProc itmCatePropValueRepoProc, Map<String, Map<Integer, ItmItemAttr>> cateAttrMap, Map<String, Map<Integer, ItmCateDescProp>> cateDescPropMap, Map<String, List<ItmCateDescProp>> notFillPropMap) {
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.cateAttrMap = cateAttrMap;
        this.cateDescPropMap = cateDescPropMap;
        this.itmCatePropValueRepoProc = itmCatePropValueRepoProc;
        this.notFillPropMap = notFillPropMap;
    }

    public void invoke(ItmItemPreUploadExcel data, AnalysisContext context) {
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        String cateBigName = data.getCateBigName();
        Long cateBigId = null;
        if (StringUtils.isBlank((CharSequence)cateBigName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (this.itmItemCateRepo.existsByItemCateNameAndPid(cateBigName, 0L)) {
            ItmItemCateDTO cateDto = this.itmItemCateRepoProc.findByPidAndCateName(0L, cateBigName);
            cateBigId = cateDto.getId();
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u4e00\u7ea7\u54c1\u7c7b\u4e0d\u5b58\u5728"));
        }
        String cateMidName = data.getCateMidName();
        Long cateMidId = null;
        if (StringUtils.isBlank((CharSequence)cateMidName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (cateBigId != null) {
            if (this.itmItemCateRepo.existsByItemCateNameAndPid(cateMidName, cateBigId)) {
                ItmItemCateDTO cateDto = this.itmItemCateRepoProc.findByPidAndCateName(cateBigId, cateMidName);
                cateMidId = cateDto.getId();
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u4e8c\u7ea7\u54c1\u7c7b\u4e0d\u5b58\u5728"));
            }
        }
        String cateSmallName = data.getCateSmallName();
        ItmItemCateDTO itemCate = null;
        if (StringUtils.isBlank((CharSequence)cateSmallName)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (cateMidId != null) {
            if (this.itmItemCateRepo.existsByItemCateNameAndPid(cateSmallName, cateMidId)) {
                itemCate = this.itmItemCateRepoProc.findByPidAndCateName(cateMidId, cateSmallName);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u4e09\u7ea7\u54c1\u7c7b\u4e0d\u5b58\u5728"));
            }
        }
        if (itemCate != null) {
            String itemCateCode = itemCate.getItemCateCode();
            if (this.cateAttrMap.containsKey(itemCateCode)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b", "\u5df2\u5728Excel\u4e2d\u5f53\u524d\u884c\u4e4b\u524d\u914d\u7f6e\u8fc7\u7684\u54c1\u7c7b"));
            } else {
                List<ItmCatePropDTO> cateProps = this.itmCatePropRepoProc.findPropDtoByItemCateCode(itemCateCode);
                List<ItmCatePropDTO> descProps = cateProps.stream().filter(prop -> ItmUdcEnum.CATE_PROP_TYPE_DESC_PROP.getUdcVal().equals(prop.getCatePropType())).collect(Collectors.toList());
                this.checkAndRecordDescProps(data, rowId, itemCateCode, descProps);
                List<ItmCatePropDTO> saleProps = cateProps.stream().filter(prop -> ItmUdcEnum.CATE_PROP_TYPE_SALE_PROP.getUdcVal().equals(prop.getCatePropType())).collect(Collectors.toList());
                this.checkAndRecordSaleProps(data, rowId, itemCateCode, saleProps);
            }
        }
    }

    private void checkAndRecordDescProps(ItmItemPreUploadExcel data, int rowId, String itemCateCode, List<ItmCatePropDTO> descProps) {
        String itemProp15;
        String itemProp14;
        String itemProp13;
        String itemProp12;
        String itemProp11;
        String itemProp10;
        String itemProp9;
        String itemProp8;
        String itemProp7;
        String itemProp6;
        String itemProp5;
        String itemProp4;
        String itemProp3;
        String itemProp2;
        String itemProp1 = data.getItemProp1();
        List<String> itemPropList = Arrays.asList(itemProp1, itemProp2 = data.getItemProp2(), itemProp3 = data.getItemProp3(), itemProp4 = data.getItemProp4(), itemProp5 = data.getItemProp5(), itemProp6 = data.getItemProp6(), itemProp7 = data.getItemProp7(), itemProp8 = data.getItemProp8(), itemProp9 = data.getItemProp9(), itemProp10 = data.getItemProp10(), itemProp11 = data.getItemProp11(), itemProp12 = data.getItemProp12(), itemProp13 = data.getItemProp13(), itemProp14 = data.getItemProp14(), itemProp15 = data.getItemProp15());
        if (CollectionUtils.isNotEmpty(itemPropList) && itemPropList.stream().anyMatch(StringUtils::isNotBlank)) {
            if (CollectionUtils.isEmpty(descProps)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027", "\u6307\u5b9a\u7684\u54c1\u7c7b\u6ca1\u6709\u63cf\u8ff0\u5c5e\u6027"));
            } else {
                List<String> mustHavePropNames = descProps.stream().filter(prop -> ONE.equals(prop.getIsMust())).map(ItmCatePropDTO::getCatePropName).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(mustHavePropNames)) {
                    mustHavePropNames.forEach(mustPropName -> {
                        if (!itemPropList.contains(mustPropName)) {
                            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027", "\u672a\u914d\u7f6e\u5fc5\u586b\u7684\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027\uff1a" + mustPropName));
                        }
                    });
                }
            }
            if (this.hasDuplicateProp(itemPropList)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027", "\u6709\u91cd\u590d\u586b\u5199\u63cf\u8ff0\u5c5e\u6027"));
            }
            Map<String, ItmCatePropDTO> descPropMap = descProps.stream().collect(Collectors.toMap(ItmCatePropDTO::getCatePropName, t -> t));
            List<String> descPropNames = itemPropList.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
            descPropNames.forEach(descPropName -> {
                if (!descPropMap.containsKey(descPropName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027", "\u6307\u5b9a\u54c1\u7c7b\u4e0d\u5b58\u5728\u63cf\u8ff0\u5c5e\u6027\uff1a" + descPropName));
                }
            });
            if (!this.errorInfo.hasError()) {
                Set<Long> isListIds = descProps.stream().map(ItmCatePropDTO::getId).collect(Collectors.toSet());
                Map<Long, List<ItmCatePropValueVO>> propValueMap = this.itmCatePropValueRepoProc.findValuesByCateIds(isListIds).stream().collect(Collectors.groupingBy(ItmCatePropValueVO::getCatePropId));
                this.recordDescProps(itemCateCode, itemPropList, descPropMap, propValueMap);
            }
        }
    }

    private void recordDescProps(String itemCateCode, List<String> excelPropNameList, Map<String, ItmCatePropDTO> descPropMap, Map<Long, List<ItmCatePropValueVO>> propValueMap) {
        HashMap<Integer, ItmCateDescProp> indexMap = new HashMap<Integer, ItmCateDescProp>(21);
        for (int i = 0; i < excelPropNameList.size(); ++i) {
            List<ItmCatePropValueVO> itmCatePropValues;
            String excelDescPropName = excelPropNameList.get(i);
            if (!StringUtils.isNotBlank((CharSequence)excelDescPropName)) continue;
            ItmCatePropDTO descProp2 = descPropMap.remove(excelDescPropName);
            ItmCateDescProp cateProp = new ItmCateDescProp();
            cateProp.setCode(descProp2.getCatePropCode());
            cateProp.setName(descProp2.getCatePropName());
            cateProp.setBox(descProp2.getIsBox() != null && ONE.equals(descProp2.getIsBox()));
            cateProp.setHand(descProp2.getIsHand() != null && ONE.equals(descProp2.getIsHand()));
            cateProp.setMust(descProp2.getIsMust() != null && ONE.equals(descProp2.getIsMust()));
            if (propValueMap.containsKey(descProp2.getId()) && CollectionUtils.isNotEmpty(itmCatePropValues = propValueMap.get(descProp2.getId()))) {
                cateProp.setPropValues(itmCatePropValues.stream().map(ItmCatePropValueVO::getPropValueName).collect(Collectors.toList()));
            }
            indexMap.put(i + 1, cateProp);
        }
        if (MapUtils.isNotEmpty(descPropMap)) {
            List noFillDescProps = descPropMap.values().stream().map(descProp -> {
                ItmCateDescProp cateProp = new ItmCateDescProp();
                cateProp.setCode(descProp.getCatePropCode());
                cateProp.setName(descProp.getCatePropName());
                return cateProp;
            }).collect(Collectors.toList());
            this.notFillPropMap.put(itemCateCode, noFillDescProps);
        }
        this.cateDescPropMap.put(itemCateCode, indexMap);
    }

    private void checkAndRecordSaleProps(ItmItemPreUploadExcel data, int rowId, String itemCateCode, List<ItmCatePropDTO> saleProps) {
        String itemAttr1 = data.getItemAttr1();
        String itemAttr2 = data.getItemAttr2();
        String itemAttr3 = data.getItemAttr3();
        if (StringUtils.isNotBlank((CharSequence)itemAttr1) || StringUtils.isNotBlank((CharSequence)itemAttr2) || StringUtils.isNotBlank((CharSequence)itemAttr3)) {
            if (CollectionUtils.isEmpty(saleProps)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u9500\u552e\u5c5e\u6027", "\u6307\u5b9a\u7684\u54c1\u7c7b\u6ca1\u6709\u9500\u552e\u5c5e\u6027"));
            } else {
                List<String> attrList = Arrays.asList(itemAttr1, itemAttr2, itemAttr3);
                if (this.hasDuplicateProp(attrList)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u9500\u552e\u5c5e\u6027", "\u6709\u91cd\u590d\u586b\u5199\u9500\u552e\u5c5e\u6027"));
                }
                Map<String, ItmCatePropDTO> salePropMap = saleProps.stream().collect(Collectors.toMap(ItmCatePropDTO::getCatePropName, t -> t));
                List<String> salePropNames = attrList.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
                salePropNames.forEach(salePropName -> {
                    if (!salePropMap.containsKey(salePropName)) {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u9500\u552e\u5c5e\u6027", "\u6307\u5b9a\u54c1\u7c7b\u4e0d\u5b58\u5728\u9500\u552e\u5c5e\u6027\uff1a" + salePropName));
                    }
                });
                if (!this.errorInfo.hasError()) {
                    this.recordSaleProps(itemCateCode, attrList, salePropMap);
                }
            }
        }
    }

    private void recordSaleProps(String itemCateCode, List<String> attrList, Map<String, ItmCatePropDTO> salePropMap) {
        HashMap<Integer, ItmItemAttr> indexMap = new HashMap<Integer, ItmItemAttr>(5);
        for (int i = 0; i < attrList.size(); ++i) {
            String itemAttrName = attrList.get(i);
            if (!StringUtils.isNotBlank((CharSequence)itemAttrName)) continue;
            ItmCatePropDTO prop = salePropMap.get(itemAttrName);
            ItmItemAttr itemAttr = new ItmItemAttr();
            itemAttr.setCode(prop.getCatePropCode());
            itemAttr.setName(prop.getCatePropName());
            indexMap.put(i + 1, itemAttr);
        }
        this.cateAttrMap.put(itemCateCode, indexMap);
    }

    private boolean hasDuplicateProp(List<String> propList) {
        long distinctSize;
        long notNullSize = propList.stream().filter(Objects::nonNull).count();
        return notNullSize != (distinctSize = propList.stream().filter(Objects::nonNull).distinct().count());
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            log.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            log.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
    }
}

