/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.repo;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmCatePropDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemPropDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemUomConvDO;
import com.elitesland.yst.supportdomain.item.excel.param.ItmItemExportParam;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescNameVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescPropVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItmItemExportVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.pri.entity.QPriMainPriceRowDO;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemExportRepoProc {
    private static final String DESC_PROP = "DESC_PROP";
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
    private final QItmItemUomConvDO itemUomConv = QItmItemUomConvDO.itmItemUomConvDO;
    private final QItmItemPropDO itmItemProp = QItmItemPropDO.itmItemPropDO;
    private final QItmCatePropDO itmCateProp = QItmCatePropDO.itmCatePropDO;
    private final QPriMainPriceRowDO priMainPriceRowDO = QPriMainPriceRowDO.priMainPriceRowDO;

    public PagingVO<ItmItemExportVO> findItemExportData(ItmItemExportParam param, List<String> brandCodes) {
        List collect;
        String likeStr;
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemExportVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.spuCode, this.itmItem.itemAttr, this.itmItem.spuId, this.itmItem.itemSource, this.itmItem.spuName, this.itmItem.itemType2, this.itmItem.itemType, this.itmItem.outerCode, this.itmItem.itemCateCode, this.itmItem.brand, this.itmItem.suppName, this.itmItem.spec, this.itmItem.salepurcFlag, this.itmItem.aftersalesServiceFlagx, this.itmItem.snFlag, this.itmItem.lotFlag, this.itmItem.guaranteePeriod, this.itmItem.guaranteePeriodUnit, this.itmItem.storeCondition, this.itmItem.allocType, this.itmItem.taxType, this.itmItem.taxRateNo, this.itmItem.taxRateNo2, this.itmItem.taxRateTariff, this.itmItem.installFlag, this.itmItem.returnExchangeFlag, this.itmItem.returnExchangePolicy, this.itmItem.warrantyFlag, this.itmItem.warrantyPeriod, this.itmItem.warrantyPeriodUnit, this.itmItem.itemName.as("skuName"), this.itmItem.barCode, this.itmItem.ouCode, this.itmItem.suppItemCode, this.itmItem.saleUom, this.itmItem.purcUom, this.itmItem.memberdiscFlagX, this.itmItem.distributionFlagX, this.itmItem.packageSpec, this.itmItem.grossWeight, this.itmItem.weightUnit, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItem.itemStatus2, this.itmItem.createTime})).from((EntityPath)this.itmItem);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)param.getSpuCode())) {
            likeStr = "%" + param.getSpuCode() + "%";
            predicates.add(this.itmItem.spuCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSpuName())) {
            likeStr = "%" + param.getSpuName() + "%";
            predicates.add(this.itmItem.spuName.like(likeStr).or((Predicate)this.itmItem.spuAbbr.like(likeStr)));
        }
        if (CollectionUtils.isNotEmpty(brandCodes) && CollectionUtils.isNotEmpty(collect = brandCodes.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.itmItem.brand.in(collect));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemStatus())) {
            predicates.add(this.itmItem.itemStatus.eq((Object)param.getItemStatus()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (param.getSnFlag() != null) {
            predicates.add(this.itmItem.snFlag.eq(param.getSnFlag()));
        }
        if (param.getLotFlag() != null) {
            predicates.add(this.itmItem.lotFlag.eq(param.getLotFlag()));
        }
        if (param.getGuaranteeFlag() != null) {
            predicates.add(this.itmItem.guaranteeFlag.eq(param.getGuaranteeFlag()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itmItem.itemSource.eq((Object)param.getItemSource()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppCode())) {
            predicates.add(this.itmItem.suppCode.eq((Object)param.getSuppCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getAllocType())) {
            predicates.add(this.itmItem.allocType.eq((Object)param.getAllocType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOuterCode())) {
            predicates.add(this.itmItem.outerCode.eq((Object)param.getOuterCode()));
        }
        if (null != param.getAftersalesServiceFlagx()) {
            predicates.add(this.itmItem.aftersalesServiceFlagx.eq(param.getAftersalesServiceFlagx()));
        }
        if (null != param.getInstallFlag()) {
            predicates.add(this.itmItem.installFlag.eq(param.getInstallFlag()));
        }
        if (null != param.getWarrantyFlag()) {
            predicates.add(this.itmItem.warrantyFlag.eq(param.getWarrantyFlag()));
        }
        if (null != param.getCat()) {
            predicates.add(this.itmItem.cat.eq((Object)param.getCat()));
        }
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.itmItem.getMetadata()));
        predicates.add(this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        query.orderBy(this.itmItem.createTime.desc());
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmItemUomConvVO> findItmItemUomByItemId(List<Long> itemId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemUomConvVO.class, (Expression[])new Expression[]{this.itemUomConv.itemId, this.itemUomConv.fromUom, this.itemUomConv.toUom, this.itemUomConv.ratio})).from((EntityPath)this.itemUomConv)).where((Predicate)this.itemUomConv.itemId.in(itemId))).fetch();
    }

    public List<ItemCateDescPropVO> getItemDescProp(List<Long> spuIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItemCateDescPropVO.class, (Expression[])new Expression[]{this.itmItemProp.itemId, this.itmItemProp.catePropCode, this.itmItemProp.catePropName, this.itmItemProp.propValue})).from((EntityPath)this.itmItemProp)).where((Predicate)this.itmItemProp.itemId.in(spuIds))).orderBy(new OrderSpecifier[]{this.itmItemProp.itemId.desc(), this.itmItemProp.catePropCode.desc()})).fetch();
    }

    public List<ItemCateDescNameVO> getItemDescPropNameList(List<String> itemCateCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItemCateDescNameVO.class, (Expression[])new Expression[]{this.itmCateProp.itemCateCode, this.itmCateProp.catePropCode, this.itmCateProp.catePropName})).from((EntityPath)this.itmCateProp)).where((Predicate)this.itmCateProp.itemCateCode.in(itemCateCodes).and((Predicate)this.itmCateProp.catePropType.eq((Object)DESC_PROP)))).orderBy(this.itmCateProp.catePropCode.desc())).fetch();
    }

    public List<PriItemPricePagingVO> searchMainPrice(List<String> itemCodes, boolean statusBool) {
        LocalDateTime nowTime = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        BooleanExpression predicate = this.priMainPriceRowDO.itemCode.in(itemCodes);
        predicate = statusBool ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.priMainPriceRowDO.validFrom.loe((Comparable)nowTime).and((Predicate)this.priMainPriceRowDO.validTo.goe((Comparable)nowTime))) : predicate;
        return ((JPAQuery)this.selectItemPrice().where((Predicate)predicate)).fetch();
    }

    private JPAQuery<PriItemPricePagingVO> selectItemPrice() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PriItemPricePagingVO.class, (Expression[])new Expression[]{this.priMainPriceRowDO.id, this.priMainPriceRowDO.itemCode, this.itmItem.itemName, this.itmItem.uom, this.priMainPriceRowDO.currCode, this.priMainPriceRowDO.price1, this.priMainPriceRowDO.price2, this.priMainPriceRowDO.price3, this.priMainPriceRowDO.price4, this.priMainPriceRowDO.price5, this.priMainPriceRowDO.price6, this.priMainPriceRowDO.price7, this.priMainPriceRowDO.price8, this.priMainPriceRowDO.validFrom, this.priMainPriceRowDO.validTo, this.itmItem.taxRateNo2})).from((EntityPath)this.priMainPriceRowDO)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.priMainPriceRowDO.itemCode.eq((Expression)this.itmItem.itemCode).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))));
    }

    public ItmItemExportRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

