/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.dto.ItmItemBomDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemBomUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemBomListener;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemBomExcelService;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBomRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBomRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@UnicomTag(value="GENERAL")
public class ItmItemBomExcelServiceImpl
implements ItmItemBomExcelService {
    private final ItmItemService itmItemService;
    private final ItmItemBomRepoProc itmItemBomRepoProc;
    private final ItmItemBomRepo itmItemBomRepo;
    private static final String ACCESSORIESTYPE = "20";
    private static final Long ZERO = 0L;

    @Override
    public void uploadExcel(MultipartFile file) {
        ExcelReader reader;
        ErrorInfo errorInfo = new ErrorInfo();
        List<ItmItemDTO> itemCodes = this.itmItemService.findAllItemDto(null);
        List<ItmItemDTO> accessoriesCodes = this.itmItemService.findAllItemDto(ACCESSORIESTYPE);
        List<ItmItemBomDTO> bomDTOs = this.itmItemBomRepoProc.findAllBomDto();
        List childrenBom = bomDTOs.stream().filter(bom -> !ZERO.equals(bom.getPid())).collect(Collectors.toList());
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        bomDTOs.stream().filter(bom -> ZERO.equals(bom.getPid())).forEach(bom -> uniqueCodes.addAll(this.unique(bom.getId(), bom.getItemCode(), childrenBom)));
        try {
            reader = EasyExcel.read((InputStream)file.getInputStream()).build();
        }
        catch (Exception e) {
            throw new BusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25");
        }
        ReadSheet sheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(ItmItemBomUploadExcel.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)new ItmItemBomListener(errorInfo, itemCodes, accessoriesCodes, uniqueCodes, this.itmItemBomRepo))).build();
        reader.read(new ReadSheet[]{sheet});
    }

    private List<String> unique(Long id, String pItemCode, List<ItmItemBomDTO> bomDTOs) {
        ArrayList<String> result = new ArrayList<String>();
        bomDTOs.stream().filter(bom -> id.equals(bom.getPid())).forEach(bom -> result.add(pItemCode + "-" + bom.getItemCode()));
        return result;
    }

    public ItmItemBomExcelServiceImpl(ItmItemService itmItemService, ItmItemBomRepoProc itmItemBomRepoProc, ItmItemBomRepo itmItemBomRepo) {
        this.itmItemService = itmItemService;
        this.itmItemBomRepoProc = itmItemBomRepoProc;
        this.itmItemBomRepo = itmItemBomRepo;
    }
}

