/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.service.impl;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplyDCateExportVO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmItemBusinessExcelConvert;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmItemExportConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBusinessExportEntity;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemBusinessSystemExport;
import com.elitesland.yst.supportdomain.item.excel.repo.ItmItemExportRepoProc;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemBusinessExcelService;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescPropVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateSalePropVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessPagingParam;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepoProc;
import com.elitesland.yst.supportdomain.item.vo.ItmExportDescPropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportSalePropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.ItmExportUtil;
import com.elitesland.yst.system.service.SysUdcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ItmItemBusinessExcelServiceImpl
implements ItmItemBusinessExcelService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemBusinessExcelServiceImpl.class);
    private final ItmItemBusinessRepoProc itmItemBusinessRepoProc;
    private final ItmItemExportRepoProc itmItemExportRepoProc;
    private final ItmExportUtil itmExportUtil;
    private final OrgBuService orgBuService;
    private final ItmItemPropRepoProc itmItemPropRepoProc;
    private final ItmBrandRepoProc itmBrandRepoProc;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    private final SysUdcService sysUdcService;
    private final TaskExecutor taskExecutor;

    @Override
    public PagingVO<ItmItemBusinessSystemExport> getBusinessExportData(ItmItemBusinessPagingParam param) {
        String brand = param.getBrandName();
        List<String> brandCodes = this.itmBrandRepoProc.findBrandCodeByBuName(brand);
        Map itemType2CodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE2");
        Map itemTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE");
        Map allocTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ALLOC_TYPE");
        Map returnExchangePolicyCodeMap = this.sysUdcService.getCodeMap("ITM", "RETURN_EXCHANGE_POLICY");
        Map uomCodeMap = this.sysUdcService.getCodeMap("COM", "UOM");
        Map weightUnitCodeMap = this.sysUdcService.getCodeMap("COM", "WEIGHT_UNIT");
        Map volumeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "VOLUME_UNIT");
        Map timeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "TIME_UNIT");
        PagingVO<ItmBusinessExportEntity> itemDataPageVo = this.itmItemBusinessRepoProc.getExportItemSkuData(param, brandCodes);
        List itemData = itemDataPageVo.getRecords();
        CompletableFuture<Map> itemUomConvMapThread = CompletableFuture.supplyAsync(() -> this.itmItemExportRepoProc.findItmItemUomByItemId(itemData.stream().map(ItmBusinessExportEntity::getId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(ItmItemUomConvVO::getItemId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(HashMap::new, (m, v) -> m.put(v.getFromUom() + "-" + v.getToUom(), v.getRatio()), Map::putAll))), (Executor)this.taskExecutor);
        CompletableFuture<Map> cateNameThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemCateCodeList = itemData.stream().map(ItmBusinessExportEntity::getItemCateCode).collect(Collectors.toList());
            return this.itmExportUtil.allItemCateNameFill(itemCateCodeList);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> buMapThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemSources = itemData.stream().map(ItmBusinessExportEntity::getItemSource).collect(Collectors.toList());
            List purcCode = itemData.stream().map(ItmBusinessExportEntity::getBuCode).collect(Collectors.toList());
            itemSources.addAll(purcCode);
            OrgBuDtoParam buParam = OrgBuDtoParam.builder().buCodes(itemSources).build();
            return this.orgBuService.findBuDtoByParam(buParam).stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t, (t1, t2) -> t1));
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> descPropThread = CompletableFuture.supplyAsync(() -> this.itmItemPropRepoProc.getItemDescProp(itemData.stream().map(ItmBusinessExportEntity::getSpuId).distinct().collect(Collectors.toList())).stream().collect(Collectors.groupingBy(ItemCateDescPropVO::getItemId)), (Executor)this.taskExecutor);
        CompletableFuture<Map> itemPriceMapThread = CompletableFuture.supplyAsync(() -> {
            List<PriItemPricePagingVO> activeItemPrice = this.itmItemExportRepoProc.searchMainPrice(itemData.stream().map(ItmBusinessExportEntity::getItemCode).collect(Collectors.toList()), true);
            return activeItemPrice.stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
        }, (Executor)this.taskExecutor);
        Set taxRateNoSet = itemData.stream().map(ItmBusinessExportEntity::getTaxRateNo).collect(Collectors.toSet());
        Set taxRateNo2Set = itemData.stream().map(ItmBusinessExportEntity::getTaxRateNo2).collect(Collectors.toSet());
        taxRateNoSet.addAll(taxRateNo2Set);
        ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
        taxParam.setTaxRateNos(new ArrayList(taxRateNoSet));
        Map<String, Double> taxRateMap = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam).stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, ComTaxRateRpcDTO::getTaxRateValue));
        Map itemUomConvMap = itemUomConvMapThread.join();
        Map buMap = buMapThread.join();
        Map descPropMap = descPropThread.join();
        Map cateNameMap = cateNameThread.join();
        Map itemPriceMap = itemPriceMapThread.join();
        for (ItmBusinessExportEntity item : itemData) {
            BigDecimal price5;
            BigDecimal bigDecimal;
            HashMap uomConvHashMap;
            PriItemPricePagingVO priItemPricePagingVO;
            if (StringUtils.isNotBlank((CharSequence)item.getItemCode()) && null != (priItemPricePagingVO = (PriItemPricePagingVO)itemPriceMap.get(item.getItemCode()))) {
                item.setPrice1(priItemPricePagingVO.getPrice1());
                item.setPrice2(priItemPricePagingVO.getPrice2());
                item.setPrice3(priItemPricePagingVO.getPrice3());
                item.setPrice4(priItemPricePagingVO.getPrice4());
                item.setPrice5(priItemPricePagingVO.getPrice5());
                item.setPrice8(priItemPricePagingVO.getPrice8());
            }
            ItmApplyDCateExportVO itmApplyDCateExportVO = (ItmApplyDCateExportVO)cateNameMap.get(item.getItemCateCode());
            item.setBigCateName(itmApplyDCateExportVO.getBigCateName());
            item.setMidCateName(itmApplyDCateExportVO.getMidCateName());
            item.setSmallCateName(itmApplyDCateExportVO.getSmallCateName());
            if (StringUtils.isNotBlank((CharSequence)item.getItemSource()) && null != buMap.get(item.getItemSource())) {
                item.setItemSource(((OrgBuDTO)buMap.get(item.getItemSource())).getBuName());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getBuCode()) && null != buMap.get(item.getBuCode())) {
                item.setBuCode(((OrgBuDTO)buMap.get(item.getBuCode())).getBuName());
            }
            if (MapUtils.isNotEmpty((Map)(uomConvHashMap = (HashMap)itemUomConvMap.get(item.getId()))) && null != (bigDecimal = (BigDecimal)uomConvHashMap.get(item.getPurcUom() + "-" + item.getSaleUom()))) {
                item.setRatio(bigDecimal);
            }
            item.setItemType2((String)itemType2CodeMap.get(item.getItemType2()));
            item.setItemType((String)itemTypeCodeMap.get(item.getItemType()));
            item.setAllocType((String)allocTypeCodeMap.get(item.getAllocType()));
            item.setReturnExchangePolicy((String)returnExchangePolicyCodeMap.get(item.getReturnExchangePolicy()));
            item.setSaleUom((String)uomCodeMap.get(item.getSaleUom()));
            item.setPurcUom((String)uomCodeMap.get(item.getPurcUom()));
            if (null != taxRateMap.get(item.getTaxRateNo())) {
                item.setTaxRateNo(String.valueOf(taxRateMap.get(item.getTaxRateNo()) * 100.0));
            }
            if (null != taxRateMap.get(item.getTaxRateNo2())) {
                item.setTaxRateNo2(String.valueOf(taxRateMap.get(item.getTaxRateNo2()) * 100.0));
            }
            String weightUnit = (String)weightUnitCodeMap.get(item.getWeightUnit());
            BigDecimal grossWeight = item.getGrossWeight();
            if (null != grossWeight) {
                item.setWeightUnit(grossWeight.setScale(2, RoundingMode.HALF_UP) + weightUnit);
            }
            String volumeUnit = (String)volumeUnitCodeMap.get(item.getVolumeUnit());
            BigDecimal volume = item.getVolume();
            if (null != volume) {
                item.setVolumeUnit(volume.setScale(2, RoundingMode.HALF_UP) + volumeUnit);
            }
            String guaranteePeriodUnit = (String)timeUnitCodeMap.get(item.getGuaranteePeriodUnit());
            if (null != item.getGuaranteePeriod() && StringUtils.isNotBlank((CharSequence)guaranteePeriodUnit)) {
                item.setGuaranteePeriodUnit(item.getGuaranteePeriod() + guaranteePeriodUnit);
            }
            String warrantyPeriodUnit = (String)timeUnitCodeMap.get(item.getWarrantyPeriodUnit());
            if (null != item.getWarrantyPeriod() && StringUtils.isNotBlank((CharSequence)warrantyPeriodUnit)) {
                item.setWarrantyPeriodUnit(item.getWarrantyPeriod() + warrantyPeriodUnit);
            }
            item.setSalepurcFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSalepurcFlag()));
            item.setSnFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSnFlag()));
            item.setAftersalesServiceFlagxStr(this.itmExportUtil.trueOrFalseTransfrom(item.getAftersalesServiceFlagx()));
            item.setInstallFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getInstallFlag()));
            item.setReturnExchangeFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getReturnExchangeFlag()));
            item.setWarrantyFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getWarrantyFlag()));
            item.setMemberdiscFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getMemberdiscFlagX()));
            item.setDistributionFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getDistributionFlagX()));
            item.setLotFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getLotFlag()));
            List itemCateDescPropVOS = (List)descPropMap.get(item.getSpuId());
            ItmExportDescPropVO itmExportDescPropVO = new ItmExportDescPropVO();
            this.itmExportUtil.reflectionItemDescValue(itemCateDescPropVOS, itmExportDescPropVO);
            ItmItemExportConvert.INSTANCE.descVoToItem(item, itmExportDescPropVO);
            String itemAttr = item.getItemAttr();
            ItmExportSalePropVO itmExportSalePropVO = new ItmExportSalePropVO();
            List<ItemCateSalePropVO> itemCateSalePropVOS = this.itmExportUtil.jsonToItemAttrJsonEntity(itemAttr);
            this.itmExportUtil.reflectionItemSaleValue(itemCateSalePropVOS, itmExportSalePropVO);
            ItmItemExportConvert.INSTANCE.saleVoToItem(item, itmExportSalePropVO);
            BigDecimal price4 = item.getPrice4();
            if (null != price4) {
                item.setPrice4(price4.multiply(BigDecimal.valueOf(100L)));
            }
            if (null == (price5 = item.getPrice5())) continue;
            item.setPrice5(price5.multiply(BigDecimal.valueOf(100L)));
        }
        return PagingVO.builder().total(itemDataPageVo.getTotal()).records(ItmItemBusinessExcelConvert.INSTANCE.entityListToSysExport(itemData)).build();
    }

    public ItmItemBusinessExcelServiceImpl(ItmItemBusinessRepoProc itmItemBusinessRepoProc, ItmItemExportRepoProc itmItemExportRepoProc, ItmExportUtil itmExportUtil, OrgBuService orgBuService, ItmItemPropRepoProc itmItemPropRepoProc, ItmBrandRepoProc itmBrandRepoProc, SysUdcService sysUdcService, TaskExecutor taskExecutor) {
        this.itmItemBusinessRepoProc = itmItemBusinessRepoProc;
        this.itmItemExportRepoProc = itmItemExportRepoProc;
        this.itmExportUtil = itmExportUtil;
        this.orgBuService = orgBuService;
        this.itmItemPropRepoProc = itmItemPropRepoProc;
        this.itmBrandRepoProc = itmBrandRepoProc;
        this.sysUdcService = sysUdcService;
        this.taskExecutor = taskExecutor;
    }
}

