/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepo;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.dto.TableColumnExtDTO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmCateExcelConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateExportEntity;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateXinUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemCateListener;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemCateXinListener;
import com.elitesland.yst.supportdomain.item.excel.param.ItmItemCateExportParam;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemCateExcelService;
import com.elitesland.yst.supportdomain.item.excel.vo.ItmItemCateSystemExportVO;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCateContrParaService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmTagService;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ItmItemCateExcelServiceImpl
implements ItmItemCateExcelService {
    private final ItmItemCateService itmItemCateService;
    private final ItmTagService itmTagService;
    private final PriMainPriceService priMainPriceService;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmCateContrParaRepo itmCateContrParaRepo;
    private final TableColumnExtRepo tableColumnExtRepo;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmCateContrParaService itmCateContrParaService;
    private final UdcService sysUdcService;
    private static final Integer IS_BASIC = 1;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")
    public void uploadExcel(MultipartFile file) throws IOException {
        List<ItmTagDTO> tagDtos = this.itmTagService.findAllTagDto();
        List<ItmItemCateDTO> itemCates = this.itmItemCateService.findAllItemCateDto();
        Map<String, String> finTypeUdc = this.sysUdcService.getCodeMap("ITM", "FIN_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> qualifyTypeUdc = this.sysUdcService.getCodeMap("ITM", "QUALIFY_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ErrorInfo errorInfo = new ErrorInfo();
        ExcelReader reader = EasyExcel.read((InputStream)file.getInputStream()).build();
        ReadSheet sheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(ItmItemCateUploadExcel.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)new ItmItemCateListener(errorInfo, tagDtos, itemCates, finTypeUdc, qualifyTypeUdc, this.itmItemCateRepo, this.itmCateContrParaRepo, this.tableColumnExtRepo, this.priMainPriceService))).build();
        reader.read(new ReadSheet[]{sheet});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")
    public void uploadExcelxin(MultipartFile file) throws IOException {
        List<ItmItemCateDTO> itemCates = this.itmItemCateService.findAllItemCateDto();
        ErrorInfo errorInfo = new ErrorInfo();
        ExcelReader reader = EasyExcel.read((InputStream)file.getInputStream()).build();
        ReadSheet sheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(ItmItemCateXinUploadExcel.class)).headRowNumber(Integer.valueOf(3))).registerReadListener((ReadListener)new ItmItemCateXinListener(errorInfo, itemCates, this.itmItemCateRepo, this.itmCateContrParaRepo, this.tableColumnExtRepo, this.priMainPriceService))).build();
        reader.read(new ReadSheet[]{sheet});
    }

    @Override
    public void exportData(HttpServletResponse response) {
        ArrayList<ItmItemCateExportEntity> excelDataList = new ArrayList<ItmItemCateExportEntity>();
        List<ItmItemCateVO> treeVos = this.itmItemCateRepoProc.findAllTreeVos();
        Set<String> itemCateCodes = treeVos.stream().map(ItmItemCateVO::getItemCateCode).collect(Collectors.toSet());
        List<ItmCateContrParaVO> controlParamVos = this.itmCateContrParaService.findContrParamsByItemCateCodeSet(itemCateCodes);
        Map<String, List<ItmCateTagVO>> cateTagsMap = this.itmItemCateService.getCateTags(itemCateCodes);
        List<TableColumnExtDTO> cateQualifyTypes = this.itmItemCateService.getCateQualifyTypes(itemCateCodes);
        Map<String, String> finTypeUdc = this.sysUdcService.getCodeMap("ITM", "FIN_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> qualifyTypeUdc = this.sysUdcService.getCodeMap("ITM", "QUALIFY_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Long, ItmItemCateVO> treeVosLevel2Map = treeVos.stream().filter(leaf -> 2 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        Map<Long, ItmItemCateVO> treeVosLevel1Map = treeVos.stream().filter(leaf -> 1 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        for (ItmItemCateVO treeVo : treeVos) {
            if (treeVo.getGrade() != 3) continue;
            ItmItemCateExportEntity entity = new ItmItemCateExportEntity();
            BeanCopyUtil.beanCopy(treeVo, entity);
            if (IS_BASIC.equals(entity.getItemCateIsBasic())) {
                ArrayList<ItmCateContrParaVO> contrList = new ArrayList<ItmCateContrParaVO>();
                String itemCateCode = entity.getItemCateCode();
                for (ItmCateContrParaVO controlParamVo : controlParamVos) {
                    if (!itemCateCode.equals(controlParamVo.getItemCateCode())) continue;
                    contrList.add(controlParamVo);
                }
                entity.setContrParaVos(contrList);
                if (null != cateTagsMap && cateTagsMap.isEmpty()) {
                    entity.setCateTags(cateTagsMap.get(itemCateCode));
                }
                if (CollectionUtils.isNotEmpty(entity.getCateTags())) {
                    entity.setCateTagStr(entity.getCateTags().stream().map(ItmCateTagVO::getTagName).collect(Collectors.joining(",")));
                }
                ArrayList<String> cateQualifyTypeList = new ArrayList<String>();
                for (TableColumnExtDTO cateQualifyType : cateQualifyTypes) {
                    if (!itemCateCode.equals(cateQualifyType.getRowCode())) continue;
                    cateQualifyTypeList.add(cateQualifyType.getColumnValue());
                }
                this.convertQualifyType(qualifyTypeUdc, entity, cateQualifyTypeList);
            }
            this.convertItemCate(treeVosLevel2Map, treeVosLevel1Map, entity);
            this.convertControlVal(finTypeUdc, entity);
            excelDataList.add(entity);
        }
        this.convertToExcel(excelDataList, response);
    }

    @Override
    public void exportDataxin(HttpServletResponse response) {
        ArrayList<ItmItemCateExportEntity> excelDataList = new ArrayList<ItmItemCateExportEntity>();
        List<ItmItemCateVO> treeVos = this.itmItemCateRepoProc.findAllTreeVos();
        Set itemCateCodes = treeVos.stream().map(ItmItemCateVO::getItemCateCode).collect(Collectors.toSet());
        Map<Long, ItmItemCateVO> treeVosLevel2Map = treeVos.stream().filter(leaf -> 2 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        Map<Long, ItmItemCateVO> treeVosLevel1Map = treeVos.stream().filter(leaf -> 1 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        for (ItmItemCateVO treeVo : treeVos) {
            if (treeVo.getGrade() != 3) continue;
            ItmItemCateExportEntity entity = new ItmItemCateExportEntity();
            BeanCopyUtil.beanCopy(treeVo, entity);
            if (IS_BASIC.equals(entity.getItemCateIsBasic())) {
                ArrayList contrList = new ArrayList();
                String string = entity.getItemCateCode();
            }
            this.convertItemCate(treeVosLevel2Map, treeVosLevel1Map, entity);
            excelDataList.add(entity);
        }
        this.convertToExcelxin(excelDataList, response);
    }

    @Override
    public com.el.coordinator.core.common.jpa.vo.PagingVO<ItmItemCateSystemExportVO> getExportData(ItmItemCateExportParam queryParam) {
        ArrayList<ItmItemCateExportEntity> excelDataList = new ArrayList<ItmItemCateExportEntity>();
        PagingVO<String> allSmallCateByParam = this.itmItemCateRepoProc.findAllSmallCateByParam(queryParam);
        List<ItmItemCateVO> treeVos = this.itmItemCateRepoProc.findAllTreeVosByItemCateCode(allSmallCateByParam.getRecords());
        Set<String> itemCateCodes = treeVos.stream().map(ItmItemCateVO::getItemCateCode).collect(Collectors.toSet());
        List<ItmCateContrParaVO> controlParamVos = this.itmCateContrParaService.findContrParamsByItemCateCodeSet(itemCateCodes);
        Map<String, List<ItmCateTagVO>> cateTagsMap = this.itmItemCateService.getCateTags(itemCateCodes);
        List<TableColumnExtDTO> cateQualifyTypes = this.itmItemCateService.getCateQualifyTypes(itemCateCodes);
        Map<String, String> finTypeUdc = this.sysUdcService.getCodeMap("ITM", "FIN_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> qualifyTypeUdc = this.sysUdcService.getCodeMap("ITM", "QUALIFY_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Long, ItmItemCateVO> treeVosLevel2Map = treeVos.stream().filter(leaf -> 2 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        Map<Long, ItmItemCateVO> treeVosLevel1Map = treeVos.stream().filter(leaf -> 1 == leaf.getGrade()).collect(Collectors.toMap(ItmItemCateVO::getId, e -> e));
        for (ItmItemCateVO treeVo : treeVos) {
            if (treeVo.getGrade() != 3) continue;
            ItmItemCateExportEntity entity = new ItmItemCateExportEntity();
            BeanCopyUtil.beanCopy(treeVo, entity);
            if (IS_BASIC.equals(entity.getItemCateIsBasic())) {
                ArrayList<ItmCateContrParaVO> contrList = new ArrayList<ItmCateContrParaVO>();
                String itemCateCode = entity.getItemCateCode();
                for (ItmCateContrParaVO controlParamVo : controlParamVos) {
                    if (!itemCateCode.equals(controlParamVo.getItemCateCode())) continue;
                    contrList.add(controlParamVo);
                }
                entity.setContrParaVos(contrList);
                entity.setCateTags(cateTagsMap.get(itemCateCode));
                if (CollectionUtils.isNotEmpty(entity.getCateTags())) {
                    entity.setCateTagStr(entity.getCateTags().stream().map(ItmCateTagVO::getTagName).collect(Collectors.joining(",")));
                }
                ArrayList<String> cateQualifyTypeList = new ArrayList<String>();
                for (TableColumnExtDTO cateQualifyType : cateQualifyTypes) {
                    if (!itemCateCode.equals(cateQualifyType.getRowCode())) continue;
                    cateQualifyTypeList.add(cateQualifyType.getColumnValue());
                }
                this.convertQualifyType(qualifyTypeUdc, entity, cateQualifyTypeList);
            }
            this.convertItemCate(treeVosLevel2Map, treeVosLevel1Map, entity);
            this.convertControlVal(finTypeUdc, entity);
            excelDataList.add(entity);
        }
        return com.el.coordinator.core.common.jpa.vo.PagingVO.builder().records(ItmCateExcelConvert.INSTANCE.entityToExportVO(excelDataList)).total(allSmallCateByParam.getTotal()).build();
    }

    private void convertItemCate(Map<Long, ItmItemCateVO> treeVosLevel2Map, Map<Long, ItmItemCateVO> treeVosLevel1Map, ItmItemCateExportEntity entity) {
        if (entity.getGrade() == 3) {
            entity.setItemCateCode3(entity.getItemCateCode());
            entity.setItemCateName3(entity.getItemCateName());
            ItmItemCateVO itmItemCate2 = treeVosLevel2Map.get(entity.getPid());
            if (itmItemCate2 != null) {
                entity.setItemCateCode2(itmItemCate2.getItemCateCode());
                entity.setItemCateName2(itmItemCate2.getItemCateName());
                ItmItemCateVO itmItemCate1 = treeVosLevel1Map.get(itmItemCate2.getPid());
                if (itmItemCate1 != null) {
                    entity.setItemCateCode1(itmItemCate1.getItemCateCode());
                    entity.setItemCateName1(itmItemCate1.getItemCateName());
                }
            }
        }
        if (entity.getGrade() == 2) {
            entity.setItemCateCode2(entity.getItemCateCode());
            entity.setItemCateName2(entity.getItemCateName());
            ItmItemCateVO itmItemCate1 = treeVosLevel1Map.get(entity.getPid());
            if (itmItemCate1 != null) {
                entity.setItemCateCode1(itmItemCate1.getItemCateCode());
                entity.setItemCateName1(itmItemCate1.getItemCateName());
            }
        }
        if (entity.getGrade() == 1) {
            entity.setItemCateCode1(entity.getItemCateCode());
            entity.setItemCateName1(entity.getItemCateName());
        }
    }

    private void convertQualifyType(Map<String, String> qualifyTypeUdc, ItmItemCateExportEntity entity, List<String> cateQualifyTypes) {
        if (CollectionUtils.isNotEmpty(cateQualifyTypes)) {
            ArrayList<String> typeStrList = new ArrayList<String>();
            for (String type : cateQualifyTypes) {
                if (!qualifyTypeUdc.containsKey(type)) continue;
                typeStrList.add(qualifyTypeUdc.get(type));
            }
            entity.setQualifyTypes(StringUtils.join(typeStrList, (String)","));
        }
    }

    private void convertControlVal(Map<String, String> finTypeUdc, ItmItemCateExportEntity entity) {
        BigDecimal percent = new BigDecimal("100");
        if (CollectionUtils.isNotEmpty(entity.getContrParaVos())) {
            for (ItmCateContrParaVO contrParaVo : entity.getContrParaVos()) {
                BigDecimal value;
                String desc;
                if (ItmCateControlParamEnum.SN_FLAG.getCode().equals(contrParaVo.getControlParamCode())) {
                    if ("0".equals(contrParaVo.getControlParamValue())) {
                        entity.setSnFlag("\u5426");
                    }
                    if ("1".equals(contrParaVo.getControlParamValue())) {
                        entity.setSnFlag("\u662f");
                    }
                }
                if (ItmCateControlParamEnum.LOT_FLAG.getCode().equals(contrParaVo.getControlParamCode())) {
                    if ("0".equals(contrParaVo.getControlParamValue())) {
                        entity.setLotFlag("\u5426");
                    }
                    if ("1".equals(contrParaVo.getControlParamValue())) {
                        entity.setLotFlag("\u662f");
                    }
                }
                if (ItmCateControlParamEnum.FIN_TYPE.getCode().equals(contrParaVo.getControlParamCode()) && StringUtils.isNotBlank((CharSequence)(desc = finTypeUdc.get(contrParaVo.getControlParamValue())))) {
                    entity.setFinType(desc);
                }
                if (ItmCateControlParamEnum.GROSS_MARGIN_B.getCode().equals(contrParaVo.getControlParamCode()) && StringUtils.isNotBlank((CharSequence)contrParaVo.getControlParamValue())) {
                    value = new BigDecimal(contrParaVo.getControlParamValue());
                    entity.setPrice4(value.multiply(percent).toPlainString());
                }
                if (!ItmCateControlParamEnum.GROSS_MARGIN_C.getCode().equals(contrParaVo.getControlParamCode()) || !StringUtils.isNotBlank((CharSequence)contrParaVo.getControlParamValue())) continue;
                value = new BigDecimal(contrParaVo.getControlParamValue());
                entity.setPrice5(value.multiply(percent).toPlainString());
            }
        }
    }

    private void convertToExcel(List<ItmItemCateExportEntity> excelDataList, HttpServletResponse response) {
    }

    private void convertToExcelxin(List<ItmItemCateExportEntity> excelDataList, HttpServletResponse response) {
    }

    public ItmItemCateExcelServiceImpl(ItmItemCateService itmItemCateService, ItmTagService itmTagService, PriMainPriceService priMainPriceService, ItmItemCateRepo itmItemCateRepo, ItmCateContrParaRepo itmCateContrParaRepo, TableColumnExtRepo tableColumnExtRepo, ItmItemCateRepoProc itmItemCateRepoProc, ItmCateContrParaService itmCateContrParaService, UdcService sysUdcService) {
        this.itmItemCateService = itmItemCateService;
        this.itmTagService = itmTagService;
        this.priMainPriceService = priMainPriceService;
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmCateContrParaRepo = itmCateContrParaRepo;
        this.tableColumnExtRepo = tableColumnExtRepo;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCateContrParaService = itmCateContrParaService;
        this.sysUdcService = sysUdcService;
    }
}

