/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmCatePropExportEntity;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCatePropUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemCatePropListener;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemCatePropExportService;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropSearchParam;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmPropRepo;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropValueService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropValueVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ItmItemCatePropExportServiceImpl
implements ItmItemCatePropExportService {
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmPropService itmPropService;
    private final ItmCatePropService itmCatePropService;
    private final ItmCatePropRepo itmCatePropRepo;
    private final ItmCatePropValueRepo itmCatePropValueRepo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmPropRepo itmPropRepo;
    private final ItmCatePropValueService itmCatePropValueService;
    private final ItmItemCateService itmItemCateService;
    private final UdcService sysUdcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void uploadExcel(MultipartFile file) {
        ExcelReader reader;
        ErrorInfo errorInfo = new ErrorInfo();
        try {
            reader = EasyExcel.read((InputStream)file.getInputStream()).build();
        }
        catch (IOException e) {
            throw new BusinessException("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        ReadSheet sheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(ItmItemCatePropUploadExcel.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)new ItmItemCatePropListener(errorInfo, this.itmItemCateRepoProc, this.itmPropService, this.itmCatePropService, this.itmCatePropRepo, this.itmCatePropValueRepo, this.sysNumberGeneratorWrapper, this.itmPropRepo))).build();
        reader.read(new ReadSheet[]{sheet});
    }

    @Override
    public PagingVO<ItmCatePropExportEntity> getExportData(ItmCatePropSearchParam itmCatePropSearchParam) {
        PagingVO<ItmCatePropExportEntity> pagingVO = this.itmCatePropRepoProc.searchByParam(itmCatePropSearchParam);
        List result = pagingVO.getRecords();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            Set<Long> catePropIds = result.stream().map(ItmCatePropExportEntity::getId).collect(Collectors.toSet());
            Map<Long, List<ItmCatePropValueVO>> propValueMap = this.itmCatePropValueService.findPropValuesByCatePropIds(catePropIds).stream().collect(Collectors.groupingBy(ItmCatePropValueVO::getCatePropId));
            Map propTypeUdcMap = this.sysUdcService.getCodeMap("ITM", "CATE_PROP_TYPE");
            result.forEach(t -> {
                t.setItemCatePath(this.itmItemCateService.findItemCatePath(t.getItemCateCode()));
                if (propValueMap.containsKey(t.getId())) {
                    List propValues = (List)propValueMap.get(t.getId());
                    String propValueNames = propValues.stream().map(ItmCatePropValueVO::getPropValueName).collect(Collectors.joining("\u3001"));
                    t.setValueNames(propValueNames);
                }
                if (!CollectionUtils.isEmpty(t.getItemCatePath())) {
                    for (ItmItemCateSimpleTree simpleTree : t.getItemCatePath()) {
                        this.setItemCate((ItmCatePropExportEntity)t, simpleTree);
                        if (CollectionUtils.isEmpty(simpleTree.getTreeNodes())) continue;
                        for (ItmItemCateSimpleTree treeNode : simpleTree.getTreeNodes()) {
                            this.setItemCate((ItmCatePropExportEntity)t, treeNode);
                            if (CollectionUtils.isEmpty(treeNode.getTreeNodes())) continue;
                            for (ItmItemCateSimpleTree treeNode1 : treeNode.getTreeNodes()) {
                                this.setItemCate((ItmCatePropExportEntity)t, treeNode1);
                            }
                        }
                    }
                }
                t.setCatePropTypeName((String)propTypeUdcMap.get(t.getCatePropType()));
                this.setDicName((ItmCatePropExportEntity)t);
            });
        }
        pagingVO.setRecords(result);
        return pagingVO;
    }

    private void setItemCate(ItmCatePropExportEntity t, ItmItemCateSimpleTree simpleTree) {
        if (simpleTree.getGrade() == 1) {
            t.setItemCateName1(simpleTree.getItemCateName());
        }
        if (simpleTree.getGrade() == 2) {
            t.setItemCateName2(simpleTree.getItemCateName());
        }
        if (simpleTree.getGrade() == 3) {
            t.setItemCateName3(simpleTree.getItemCateName());
        }
    }

    private void setDicName(ItmCatePropExportEntity t) {
        if (t.getIsBox() != null) {
            if (0 == t.getIsBox()) {
                t.setIsBoxName("\u5355\u9009");
            }
            if (1 == t.getIsBox()) {
                t.setIsBoxName("\u590d\u9009");
            }
        }
        if (t.getIsHand() != null) {
            if (0 == t.getIsHand()) {
                t.setIsHandName("\u5217\u8868\u9009\u62e9");
            }
            if (1 == t.getIsHand()) {
                t.setIsHandName("\u624b\u52a8\u8f93\u5165");
            }
        }
        if (t.getIsMust() != null) {
            if (0 == t.getIsMust()) {
                t.setUsMustName("\u5426");
            }
            if (1 == t.getIsMust()) {
                t.setUsMustName("\u662f");
            }
        }
    }

    public ItmItemCatePropExportServiceImpl(ItmItemCateRepoProc itmItemCateRepoProc, ItmCatePropRepoProc itmCatePropRepoProc, ItmPropService itmPropService, ItmCatePropService itmCatePropService, ItmCatePropRepo itmCatePropRepo, ItmCatePropValueRepo itmCatePropValueRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmPropRepo itmPropRepo, ItmCatePropValueService itmCatePropValueService, ItmItemCateService itmItemCateService, UdcService sysUdcService) {
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.itmPropService = itmPropService;
        this.itmCatePropService = itmCatePropService;
        this.itmCatePropRepo = itmCatePropRepo;
        this.itmCatePropValueRepo = itmCatePropValueRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmPropRepo = itmPropRepo;
        this.itmCatePropValueService = itmCatePropValueService;
        this.itmItemCateService = itmItemCateService;
        this.sysUdcService = sysUdcService;
    }
}

