/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.service.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.provider.IdGeneratorProvider;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.provider.PurSuppProvider;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplyDCateExportVO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmItemExportConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmCateDescProp;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemAttr;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemPreUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemListener;
import com.elitesland.yst.supportdomain.item.excel.listener.ItmItemPreListener;
import com.elitesland.yst.supportdomain.item.excel.param.ItmItemExportParam;
import com.elitesland.yst.supportdomain.item.excel.repo.ItmItemExportRepoProc;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemExcelService;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescPropVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateSalePropVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItmItemExportVO;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemUomConvRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportDescPropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportSalePropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgOuService;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.ItmExportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ItmItemExcelServiceImpl
implements ItmItemExcelService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemExcelServiceImpl.class);
    private static final String TRUE = "\u662f";
    private static final String FALSE = "\u5426";
    private final PriMainPriceService priMainPriceService;
    private final OrgOuService orgOuService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmBrandRepoProc itmBrandRepoProc;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemPropRepo itmItemPropRepo;
    private final ItmItemUomConvRepo itmItemUomConvRepo;
    private final ItmCatePropValueRepoProc itmCatePropValueRepoProc;
    private final ItmItemService itmItemService;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemExportRepoProc itmItemExportRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final OrgBuService orgBuService;
    private final ItmExportUtil itmExportUtil;
    private final UdcService sysUdcService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    @DubboReference
    private PurSuppProvider purSuppProvider;
    private final IdGeneratorProvider snowflake;
    private final TaskExecutor taskExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void uploadExcel(MultipartFile file) {
        ExcelReader reader = null;
        try {
            reader = EasyExcelFactory.read((InputStream)file.getInputStream()).build();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "Excel \u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
        HashMap<String, Map<Integer, ItmCateDescProp>> cateDescPropMap = new HashMap<String, Map<Integer, ItmCateDescProp>>(16);
        HashMap<String, Map<Integer, ItmItemAttr>> cateAttrMap = new HashMap<String, Map<Integer, ItmItemAttr>>(16);
        HashMap<String, List<ItmCateDescProp>> notFillPropMap = new HashMap<String, List<ItmCateDescProp>>(16);
        ReadSheet sheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(ItmItemPreUploadExcel.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)new ItmItemPreListener(this.itmItemCateRepo, this.itmItemCateRepoProc, this.itmCatePropRepoProc, this.itmCatePropValueRepoProc, cateAttrMap, cateDescPropMap, notFillPropMap))).build();
        reader.read(new ReadSheet[]{sheet1});
        ReadSheet sheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)1).head(ItmItemUploadExcel.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)new ItmItemListener(this.sysUdcService, cateDescPropMap, cateAttrMap, notFillPropMap, this.itmItemCateRepoProc, this.itmBrandRepoProc, this.orgOuService, this.purSuppProvider, this.comTaxRateRpcService, this.itmItemRepo, this.itmItemPropRepo, this.priMainPriceService, this.sysNumberGeneratorWrapper, this.snowflake, this.itmItemUomConvRepo, this.itmItemService, this.orgBuRepo))).build();
        reader.read(new ReadSheet[]{sheet2});
    }

    @Override
    public PagingVO<ItmItemExportVO> getExportData(ItmItemExportParam param) {
        String brand = param.getBrand();
        List<String> brandCodes = this.itmBrandRepoProc.findBrandCodeByBuName(brand);
        PagingVO<ItmItemExportVO> itemExportDataPaging = this.itmItemExportRepoProc.findItemExportData(param, brandCodes);
        List itemExportDataList = itemExportDataPaging.getRecords();
        if (CollectionUtils.isEmpty((Collection)itemExportDataList)) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.emptyList()).build();
        }
        Map itemType2CodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE2");
        Map itemTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE");
        Map allocTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ALLOC_TYPE");
        Map returnExchangePolicyCodeMap = this.sysUdcService.getCodeMap("ITM", "RETURN_EXCHANGE_POLICY");
        Map uomCodeMap = this.sysUdcService.getCodeMap("COM", "UOM");
        Map weightUnitCodeMap = this.sysUdcService.getCodeMap("COM", "WEIGHT_UNIT");
        Map volumeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "VOLUME_UNIT");
        Map timeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "TIME_UNIT");
        Map itemStatus2CodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        CompletableFuture<Map> cateNameThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemCateCodeList = itemExportDataList.stream().map(ItmItemExportVO::getItemCateCode).collect(Collectors.toList());
            return this.itmExportUtil.allItemCateNameFill(itemCateCodeList);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> itemBrandMapThread = CompletableFuture.supplyAsync(() -> this.itmBrandRepoProc.getBrandNameByCode(itemExportDataList.stream().map(ItmItemExportVO::getBrand).collect(Collectors.toList())).stream().collect(Collectors.toMap(ItmBrandVO::getBrandCode, ItmBrandVO::getBrandName)), (Executor)this.taskExecutor);
        CompletableFuture<Map> itemUomConvMapThread = CompletableFuture.supplyAsync(() -> this.itmItemExportRepoProc.findItmItemUomByItemId(itemExportDataList.stream().map(ItmItemExportVO::getId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(ItmItemUomConvVO::getItemId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(HashMap::new, (m, v) -> m.put(v.getFromUom() + "-" + v.getToUom(), v.getRatio()), Map::putAll))), (Executor)this.taskExecutor);
        CompletableFuture<Map> itemPriceMapThread = CompletableFuture.supplyAsync(() -> {
            List<String> enableItemList = itemExportDataList.stream().map(ItmItemExportVO::getItemCode).collect(Collectors.toList());
            List<PriItemPricePagingVO> activeItemPrice = this.itmItemExportRepoProc.searchMainPrice(enableItemList, true);
            return activeItemPrice.stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> buMapThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemSources = itemExportDataList.stream().map(ItmItemExportVO::getItemSource).collect(Collectors.toList());
            OrgBuDtoParam buParam = OrgBuDtoParam.builder().buCodes(itemSources).build();
            return this.orgBuService.findBuDtoByParam(buParam).stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t, (t1, t2) -> t1));
        }, (Executor)this.taskExecutor);
        Map<Long, List<ItemCateDescPropVO>> descPropMap = this.itmItemExportRepoProc.getItemDescProp(itemExportDataList.stream().map(ItmItemExportVO::getSpuId).distinct().collect(Collectors.toList())).stream().collect(Collectors.groupingBy(ItemCateDescPropVO::getItemId));
        Set taxRateNoSet = itemExportDataList.stream().map(ItmItemExportVO::getTaxRateNo).collect(Collectors.toSet());
        Set taxRateNo2Set = itemExportDataList.stream().map(ItmItemExportVO::getTaxRateNo2).collect(Collectors.toSet());
        taxRateNoSet.addAll(taxRateNo2Set);
        ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
        taxParam.setTaxRateNos(new ArrayList(taxRateNoSet));
        Map<String, Double> taxRateMap = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam).stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, ComTaxRateRpcDTO::getTaxRateValue));
        Map cateNameMap = cateNameThread.join();
        Map itemBrandNameMap = itemBrandMapThread.join();
        Map itemUomConvMap = itemUomConvMapThread.join();
        Map buMap = buMapThread.join();
        Map itemPriceMap = itemPriceMapThread.join();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (ItmItemExportVO item : itemExportDataList) {
            BigDecimal price5;
            BigDecimal bigDecimal;
            HashMap uomConvHashMap;
            PriItemPricePagingVO priItemPricePagingVO;
            if (StringUtils.isNotBlank((CharSequence)item.getItemCode()) && null != (priItemPricePagingVO = (PriItemPricePagingVO)itemPriceMap.get(item.getItemCode()))) {
                item.setPrice1(priItemPricePagingVO.getPrice1());
                item.setPrice2(priItemPricePagingVO.getPrice2());
                item.setPrice3(priItemPricePagingVO.getPrice3());
                item.setPrice4(priItemPricePagingVO.getPrice4());
                item.setPrice5(priItemPricePagingVO.getPrice5());
                item.setPrice8(priItemPricePagingVO.getPrice8());
            }
            item.setBrand((String)itemBrandNameMap.get(item.getBrand()));
            ItmApplyDCateExportVO itmApplyDCateExportVO = (ItmApplyDCateExportVO)cateNameMap.get(item.getItemCateCode());
            item.setBigCateName(itmApplyDCateExportVO.getBigCateName());
            item.setMidCateName(itmApplyDCateExportVO.getMidCateName());
            item.setSmallCateName(itmApplyDCateExportVO.getSmallCateName());
            if (StringUtils.isNotBlank((CharSequence)item.getItemSource()) && null != buMap.get(item.getItemSource())) {
                item.setItemSource(((OrgBuDTO)buMap.get(item.getItemSource())).getBuName());
            }
            if (MapUtils.isNotEmpty((Map)(uomConvHashMap = (HashMap)itemUomConvMap.get(item.getId()))) && null != (bigDecimal = (BigDecimal)uomConvHashMap.get(item.getPurcUom() + "-" + item.getSaleUom()))) {
                item.setRatio(bigDecimal);
            }
            item.setItemType2((String)itemType2CodeMap.get(item.getItemType2()));
            item.setItemType((String)itemTypeCodeMap.get(item.getItemType()));
            item.setAllocType((String)allocTypeCodeMap.get(item.getAllocType()));
            item.setReturnExchangePolicy((String)returnExchangePolicyCodeMap.get(item.getReturnExchangePolicy()));
            item.setSaleUom((String)uomCodeMap.get(item.getSaleUom()));
            item.setPurcUom((String)uomCodeMap.get(item.getPurcUom()));
            if (null != taxRateMap.get(item.getTaxRateNo())) {
                item.setTaxRateNo(String.valueOf(taxRateMap.get(item.getTaxRateNo()) * 100.0));
            }
            if (null != taxRateMap.get(item.getTaxRateNo2())) {
                item.setTaxRateNo2(String.valueOf(taxRateMap.get(item.getTaxRateNo2()) * 100.0));
            }
            String weightUnit = (String)weightUnitCodeMap.get(item.getWeightUnit());
            BigDecimal grossWeight = item.getGrossWeight();
            if (null != grossWeight) {
                item.setWeightUnit(grossWeight.setScale(2, RoundingMode.HALF_UP) + weightUnit);
            }
            String volumeUnit = (String)volumeUnitCodeMap.get(item.getVolumeUnit());
            BigDecimal volume = item.getVolume();
            if (null != volume) {
                item.setVolumeUnit(volume.setScale(2, RoundingMode.HALF_UP) + volumeUnit);
            }
            String guaranteePeriodUnit = (String)timeUnitCodeMap.get(item.getGuaranteePeriodUnit());
            if (null != item.getGuaranteePeriod() && StringUtils.isNotBlank((CharSequence)guaranteePeriodUnit)) {
                item.setGuaranteePeriodUnit(item.getGuaranteePeriod() + guaranteePeriodUnit);
            }
            String warrantyPeriodUnit = (String)timeUnitCodeMap.get(item.getWarrantyPeriodUnit());
            if (null != item.getWarrantyPeriod() && StringUtils.isNotBlank((CharSequence)warrantyPeriodUnit)) {
                item.setWarrantyPeriodUnit(item.getWarrantyPeriod() + warrantyPeriodUnit);
            }
            item.setSalepurcFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSalepurcFlag()));
            item.setSnFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSnFlag()));
            item.setAftersalesServiceFlagxStr(this.itmExportUtil.trueOrFalseTransfrom(item.getAftersalesServiceFlagx()));
            item.setInstallFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getInstallFlag()));
            item.setReturnExchangeFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getReturnExchangeFlag()));
            item.setWarrantyFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getWarrantyFlag()));
            item.setMemberdiscFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getMemberdiscFlagX()));
            item.setDistributionFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getDistributionFlagX()));
            item.setLotFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getLotFlag()));
            List<ItemCateDescPropVO> itemCateDescPropVOS = descPropMap.get(item.getSpuId());
            ItmExportDescPropVO itmExportDescPropVO = new ItmExportDescPropVO();
            this.itmExportUtil.reflectionItemDescValue(itemCateDescPropVOS, itmExportDescPropVO);
            ItmItemExportConvert.INSTANCE.descVoToItem(item, itmExportDescPropVO);
            String itemAttr = item.getItemAttr();
            ItmExportSalePropVO itmExportSalePropVO = new ItmExportSalePropVO();
            List<ItemCateSalePropVO> itemCateSalePropVOS = this.itmExportUtil.jsonToItemAttrJsonEntity(itemAttr);
            this.itmExportUtil.reflectionItemSaleValue(itemCateSalePropVOS, itmExportSalePropVO);
            ItmItemExportConvert.INSTANCE.saleVoToItem(item, itmExportSalePropVO);
            BigDecimal price4 = item.getPrice4();
            if (null != price4) {
                item.setPrice4(price4.multiply(BigDecimal.valueOf(100L)));
            }
            if (null != (price5 = item.getPrice5())) {
                item.setPrice5(price5.multiply(BigDecimal.valueOf(100L)));
            }
            item.setItemStatus2(Arrays.stream(item.getItemStatus2().split(";")).map(itemStatus2CodeMap::get).collect(Collectors.joining(";")));
            item.setCreateTimeStr(df.format(item.getCreateTime()));
        }
        itemExportDataPaging.setRecords(itemExportDataList);
        return itemExportDataPaging;
    }

    public ItmItemExcelServiceImpl(PriMainPriceService priMainPriceService, OrgOuService orgOuService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmItemCateRepo itmItemCateRepo, ItmItemCateRepoProc itmItemCateRepoProc, ItmCatePropRepoProc itmCatePropRepoProc, ItmBrandRepoProc itmBrandRepoProc, ItmItemRepo itmItemRepo, ItmItemPropRepo itmItemPropRepo, ItmItemUomConvRepo itmItemUomConvRepo, ItmCatePropValueRepoProc itmCatePropValueRepoProc, ItmItemService itmItemService, OrgBuRepo orgBuRepo, ItmItemExportRepoProc itmItemExportRepoProc, ItmItemCateService itmItemCateService, OrgBuService orgBuService, ItmExportUtil itmExportUtil, UdcService sysUdcService, IdGeneratorProvider snowflake, TaskExecutor taskExecutor) {
        this.priMainPriceService = priMainPriceService;
        this.orgOuService = orgOuService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.itmBrandRepoProc = itmBrandRepoProc;
        this.itmItemRepo = itmItemRepo;
        this.itmItemPropRepo = itmItemPropRepo;
        this.itmItemUomConvRepo = itmItemUomConvRepo;
        this.itmCatePropValueRepoProc = itmCatePropValueRepoProc;
        this.itmItemService = itmItemService;
        this.orgBuRepo = orgBuRepo;
        this.itmItemExportRepoProc = itmItemExportRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.orgBuService = orgBuService;
        this.itmExportUtil = itmExportUtil;
        this.sysUdcService = sysUdcService;
        this.snowflake = snowflake;
        this.taskExecutor = taskExecutor;
    }
}

