/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.system.imp;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;
import com.el.coordinator.boot.fsm.service.importdata.DataImport;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmBrandDTO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmBrandExcelConvert;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBrandUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.system.ExcelUtil;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ItmBrandImportServiceImpl
implements DataImport<ItmBrandUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmBrandImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final String ENABLE = "ENABLE";
    private static final String BRAND_INITIAL = "\u54c1\u724c\u9996\u5b57\u6bcd";
    private final ItmBrandRepo itmBrandRepo;
    private final ItmBrandRepoProc itmBrandRepoProc;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final TransactionTemplate transactionTemplate;

    public String getTmplCode() {
        return "yst_support_brand_import";
    }

    public ImportResultRespVO.SyncResult execute(List<ItmBrandUploadExcel> dataList, int rowId) {
        if (CollUtil.isEmpty(dataList)) {
            return ImportResultRespVO.SyncResult.builder().total(Integer.valueOf(0)).numSuccess(Integer.valueOf(0)).failRecords(Collections.emptyList()).build();
        }
        return this.saveData(dataList, rowId);
    }

    private ImportResultRespVO.SyncResult saveData(List<ItmBrandUploadExcel> dataList, int rowId) {
        List<ItmBrandDTO> allBrandDto = this.itmBrandRepoProc.findAllBrandDto();
        List brandNameList = allBrandDto.stream().map(ItmBrandDTO::getBrandName).collect(Collectors.toList());
        List<String> brandCodeList = allBrandDto.stream().map(ItmBrandDTO::getBrandCode).collect(Collectors.toList());
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<ItmBrandUploadExcel> saveList = new ArrayList<ItmBrandUploadExcel>();
        for (ItmBrandUploadExcel data : dataList) {
            List<String> urlList;
            ArrayList<String> errorList = new ArrayList<String>();
            String brandName = data.getBrandName();
            if (StringUtils.isBlank((CharSequence)brandName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u724c\u540d\u79f0", "\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (brandNameList.contains(brandName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u724c\u540d\u79f0", "\u54c1\u724c\u540d\u79f0\u91cd\u590d"));
            } else {
                brandNameList.add(brandName);
            }
            String brandInitial = data.getBrandInitial();
            if (StringUtils.isBlank((CharSequence)brandInitial)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, BRAND_INITIAL, "\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (!brandInitial.matches("[a-zA-Z0-9]$")) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, BRAND_INITIAL, "\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u636e\uff1a\u4e00\u4f4d\u6570\u5b57\u6216\u5b57\u6bcd"));
            }
            String url = data.getUrl();
            if (StringUtils.isNotBlank((CharSequence)url) && !(urlList = Arrays.asList(url.split("="))).get(urlList.size() - 1).matches("[0-9]+$")) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1logo", "url\u683c\u5f0f\u9519\u8bef"));
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.addAll(errorList);
            } else {
                saveList.add(data);
            }
            ++rowId;
        }
        ImportResultRespVO.SyncResult syncResult = this.saveData(brandCodeList, saveList);
        return ExcelUtil.getSyncResult(errorResult, syncResult, dataList.size());
    }

    private ImportResultRespVO.SyncResult saveData(List<String> brandCodeList, List<ItmBrandUploadExcel> saveList) {
        ImportResultRespVO.SyncResult build = ImportResultRespVO.SyncResult.builder().build();
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                if (CollectionUtils.isNotEmpty((Collection)saveList)) {
                    saveList.forEach(brand -> {
                        String brandCode = this.sysNumberGeneratorWrapper.generate("BRAND_NO");
                        if (brandCodeList.contains(brandCode)) {
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u53d1\u53f7\u5668\u5f02\u5e38\uff0c\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
                        }
                        brandCodeList.add(brandCode);
                        brand.setBrandCode(brandCode);
                        brand.setStatus(ENABLE);
                        if (StringUtils.isNotBlank((CharSequence)brand.getUrl())) {
                            List<String> urlAndFileCode = Arrays.asList(brand.getUrl().split("="));
                            brand.setFileCode(urlAndFileCode.get(urlAndFileCode.size() - 1));
                        }
                    });
                    this.itmBrandRepo.saveAll(ItmBrandExcelConvert.INSTANCE.excelToDO(saveList));
                    build.setNumSuccess(Integer.valueOf(saveList.size()));
                }
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                log.error("\u4fdd\u5b58\u54c1\u7c7b\u5c5e\u6027\u9519\u8bef\uff1a{}", (Throwable)e);
                build.setFailRecords(List.of(e.getMessage()));
                build.setNumSuccess(Integer.valueOf(0));
                return build;
            }
            return build;
        });
        return build;
    }

    public ItmBrandImportServiceImpl(ItmBrandRepo itmBrandRepo, ItmBrandRepoProc itmBrandRepoProc, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, TransactionTemplate transactionTemplate) {
        this.itmBrandRepo = itmBrandRepo;
        this.itmBrandRepoProc = itmBrandRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.transactionTemplate = transactionTemplate;
    }
}

