/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.system.imp;

import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;
import com.el.coordinator.boot.fsm.service.importdata.DataImport;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropDO;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropValueDO;
import com.elitesland.yst.supportdomain.item.entity.ItmPropDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCatePropUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.system.ExcelUtil;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmPropRepo;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropValueService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmPropVO;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ItmCatePropImportServiceImpl
implements DataImport<ItmItemCatePropUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmCatePropImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmPropService itmPropService;
    private final ItmCatePropService itmCatePropService;
    private final ItmCatePropRepo itmCatePropRepo;
    private final ItmCatePropValueRepo itmCatePropValueRepo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmPropRepo itmPropRepo;
    private final ItmCatePropValueService itmCatePropValueService;
    private final ItmItemCateService itmItemCateService;
    private final UdcService sysUdcService;
    private final TransactionTemplate transactionTemplate;

    public String getTmplCode() {
        return "yst_support_cateProp_import";
    }

    public ImportResultRespVO.SyncResult execute(List<ItmItemCatePropUploadExcel> dataList, int startRowIndex) {
        return null;
    }

    private ImportResultRespVO.SyncResult checkAndSaveData(List<ItmItemCatePropUploadExcel> dataList, int rowId) {
        Map<Long, Map> itemCatePidMap = this.itmItemCateRepoProc.findAllDto().stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateName, t -> t, (t1, t2) -> t1))));
        List<ItmPropVO> itmPropList = this.itmPropService.findPropList(null);
        List itmPropNameList = this.itmPropService.findPropList(null).stream().map(ItmPropVO::getCatePropName).collect(Collectors.toList());
        List<String> itmPropCodeList = this.itmPropService.findPropList(null).stream().map(ItmPropVO::getCatePropCode).collect(Collectors.toList());
        HashMap smallCateNameMap = new HashMap();
        ArrayList<ItmPropDO> itmPropDos = new ArrayList<ItmPropDO>();
        HashMap<Integer, List<ItmCatePropValueDO>> itmCatePropValueMap = new HashMap<Integer, List<ItmCatePropValueDO>>();
        HashMap<Integer, ItmCatePropDO> itmCatePropDOMap = new HashMap<Integer, ItmCatePropDO>();
        ArrayList<String> errorResult = new ArrayList<String>();
        HashMap<Integer, ItmCatePropDO> saveMap = new HashMap<Integer, ItmCatePropDO>();
        for (ItmItemCatePropUploadExcel data : dataList) {
            Map cateNameMap;
            ArrayList<String> errorList = new ArrayList<String>();
            ItmCatePropDO itmCatePropDO = new ItmCatePropDO();
            String bigCateName = data.getBigCateName();
            Long bigCateId = null;
            if (StringUtils.isBlank((CharSequence)bigCateName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else {
                Map bigCateNameMap = itemCatePidMap.get(0L);
                if (bigCateNameMap.containsKey(bigCateName)) {
                    bigCateId = ((ItmItemCateDTO)bigCateNameMap.get(bigCateName)).getId();
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + bigCateName + "\u4e0d\u5b58\u5728"));
                }
            }
            String midCateName = data.getMidCateName();
            Long midCateId = null;
            if (StringUtils.isBlank((CharSequence)midCateName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else if (null != bigCateId) {
                Map midCateNameMap = itemCatePidMap.get(bigCateId);
                if (midCateNameMap.containsKey(midCateName)) {
                    midCateId = ((ItmItemCateDTO)midCateNameMap.get(midCateName)).getId();
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u54c1\u7c7b\u540d\u79f0\uff1a" + midCateName + "\u4e0d\u5b58\u5728"));
                }
            }
            String smallCateName = data.getSmallCateName();
            String smallCateCode = null;
            if (StringUtils.isBlank((CharSequence)smallCateName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u540d\u79f0", "\u6570\u636e\u5fc5\u586b"));
            } else if (null != midCateId && (cateNameMap = itemCatePidMap.get(midCateId)).containsKey(smallCateName)) {
                smallCateCode = ((ItmItemCateDTO)cateNameMap.get(smallCateName)).getItemCateCode();
                itmCatePropDO.setItemCateCode(smallCateCode);
            }
            String catePropName = data.getCatePropName();
            List smallCatePropName = null;
            smallCatePropName = CollectionUtils.isNotEmpty((Collection)((Collection)smallCateNameMap.get(smallCateCode))) ? (List)smallCateNameMap.get(smallCateCode) : this.itmCatePropService.getPropsByItemCateCode(smallCateCode).stream().map(ItmCatePropVO::getCatePropName).collect(Collectors.toList());
            if (smallCatePropName.contains(catePropName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u54c1\u7c7b\u540d\u79f0", "\u5c0f\u7c7b\uff1a" + smallCateName + " \u7684\u54c1\u7c7b\u5c5e\u6027\uff1a" + catePropName + " \u91cd\u590d"));
            } else {
                smallCatePropName.add(catePropName);
                smallCateNameMap.put(smallCateCode, smallCatePropName);
                itmCatePropDO.setCatePropName(catePropName);
                if (!itmPropNameList.contains(catePropName)) {
                    ItmPropDO itmPropDO = new ItmPropDO();
                    itmPropDO.setCatePropName(catePropName);
                    itmPropDos.add(itmPropDO);
                    itmPropNameList.add(catePropName);
                }
            }
            Boolean isSaleProp = null;
            String catePropType = data.getCatePropType();
            if (StringUtils.isBlank((CharSequence)catePropType)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u7c7b\u578b", "\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (ItmUdcEnum.ITM_CATE_PROP_TYPE_DESC_PROP.getValDesc().equals(catePropType)) {
                isSaleProp = false;
                itmCatePropDO.setCatePropType(ItmUdcEnum.ITM_CATE_PROP_TYPE_DESC_PROP.getUdcVal());
            } else if (ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getValDesc().equals(catePropType)) {
                isSaleProp = true;
                itmCatePropDO.setCatePropType(ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getUdcVal());
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u7c7b\u578b", "\u4e0d\u5b58\u5728\u7684\u5c5e\u6027\u7c7b\u578b\uff1a" + catePropType + ";\u8bf7\u586b\u5199\u9500\u552e\u5c5e\u6027\u6216\u8005\u63cf\u8ff0\u5c5e\u6027"));
            }
            String isMust = data.getIsMust();
            String isHand = data.getIsHand();
            boolean isHandFlag = false;
            if (null != isSaleProp && !isSaleProp.booleanValue()) {
                if (StringUtils.isBlank((CharSequence)isMust)) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u5fc5\u586b", "\u63cf\u8ff0\u5c5e\u6027-\u662f\u5426\u5fc5\u586b\u9879\uff0c\u5fc5\u586b"));
                } else if (isMust.matches("[01]$")) {
                    itmCatePropDO.setIsMust(Integer.valueOf(isMust));
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u5fc5\u586b", "\u8bf7\u586b\u51990\u62161"));
                }
                if (StringUtils.isBlank((CharSequence)isHand)) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f55\u5165\u65b9\u5f0f", "\u63cf\u8ff0\u5c5e\u6027-\u5f55\u5165\u65b9\u5f0f\u9879\uff0c\u5fc5\u586b"));
                } else if (isMust.matches("[01]$")) {
                    Integer isHandInteger = Integer.valueOf(isHand);
                    itmCatePropDO.setIsHand(isHandInteger);
                    if (isHandInteger.equals(ZERO)) {
                        isHandFlag = true;
                    }
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f55\u5165\u65b9\u5f0f", "\u8bf7\u586b\u51990\u62161"));
                }
                if (isHandFlag) {
                    String isBox = data.getIsBox();
                    if (StringUtils.isBlank((CharSequence)isBox)) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5355\u9009/\u590d\u9009", "\u63cf\u8ff0\u5c5e\u6027-\u5355\u9009\u590d\u9009 \u5728\u5f55\u5165\u65b9\u5f0f\u4e3a\u5217\u8868\u9009\u62e9\u65f6\uff0c\u5fc5\u586b"));
                    } else if (isBox.matches("[01]$")) {
                        itmCatePropDO.setIsBox(Integer.valueOf(isBox));
                    } else {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5355\u9009/\u590d\u9009", "\u8bf7\u586b\u51990\u62161"));
                    }
                    String propValueName = data.getPropValueName();
                    if (StringUtils.isNotBlank((CharSequence)propValueName)) {
                        List<String> propValueNameList = Arrays.asList(propValueName.split("(;)|(\uff1b)"));
                        if (CollectionUtils.isNotEmpty(propValueNameList) && CollectionUtils.isEmpty(errorList)) {
                            ArrayList itmCatePropValueSaveParams = new ArrayList();
                            propValueNameList.forEach(value -> {
                                ItmCatePropValueDO itmCatePropValueSaveParam = new ItmCatePropValueDO();
                                itmCatePropValueSaveParam.setPropValueName((String)value);
                                itmCatePropValueSaveParams.add(itmCatePropValueSaveParam);
                            });
                            itmCatePropValueMap.put(rowId, itmCatePropValueSaveParams);
                        }
                    } else {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5c5e\u6027\u503c", "\u63cf\u8ff0\u5c5e\u6027-\u5f55\u5165\u65b9\u5f0f\u4e3a\u5217\u8868\u9009\u62e9\u65f6\uff0c\u5c5e\u6027\u503c\u5fc5\u586b"));
                    }
                } else {
                    itmCatePropDO.setIsBox(ZERO);
                }
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.addAll(errorList);
            } else {
                saveMap.put(rowId, itmCatePropDO);
            }
            ++rowId;
        }
        ImportResultRespVO.SyncResult syncResult = this.saveData(itmPropList, itmPropCodeList, itmPropDos, itmCatePropValueMap, itmCatePropDOMap, saveMap);
        return ExcelUtil.getSyncResult(errorResult, syncResult, dataList.size());
    }

    private ImportResultRespVO.SyncResult saveData(List<ItmPropVO> itmPropList, List<String> itmPropCodeList, List<ItmPropDO> itmPropDos, Map<Integer, List<ItmCatePropValueDO>> itmCatePropValueMap, Map<Integer, ItmCatePropDO> itmCatePropDOMap, Map<Integer, ItmCatePropDO> saveMap) {
        ImportResultRespVO.SyncResult build = ImportResultRespVO.SyncResult.builder().build();
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                int size = itmCatePropDOMap.values().size();
                if (CollectionUtils.isNotEmpty((Collection)itmPropDos)) {
                    itmPropDos.forEach(itmProp -> {
                        String prop_no = this.sysNumberGeneratorWrapper.generate("PROP_NO");
                        if (itmPropCodeList.contains(prop_no)) {
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u5f02\u5e38\uff0c\u51fa\u73b0\u91cd\u590d\u7f16\u7801");
                        }
                        itmPropCodeList.add(prop_no);
                        itmProp.setCatePropCode(prop_no);
                        itmProp.setDeleteFlag(0);
                    });
                    this.itmPropRepo.saveAll(itmPropDos);
                }
                saveMap.values().forEach(cateProp -> {
                    cateProp.setCreateTime(LocalDateTime.now());
                    if (ItmUdcEnum.ITM_CATE_PROP_TYPE_SALE_PROP.getUdcVal().equals(cateProp.getCatePropType())) {
                        cateProp.setIsMust(ZERO);
                        cateProp.setIsHand(ONE);
                        cateProp.setIsBox(ZERO);
                    }
                    itmPropDos.forEach(prop -> {
                        if (prop.getCatePropName().equals(cateProp.getCatePropName())) {
                            cateProp.setCatePropCode(prop.getCatePropCode());
                        }
                    });
                    if (StringUtils.isBlank((CharSequence)cateProp.getCatePropCode())) {
                        itmPropList.forEach(prop -> {
                            if (prop.getCatePropName().equals(cateProp.getCatePropName())) {
                                cateProp.setCatePropCode(prop.getCatePropCode());
                            }
                        });
                    }
                });
                this.itmCatePropRepo.saveAll(itmCatePropDOMap.values());
                itmCatePropValueMap.forEach((rowId, itmCatePropValue) -> {
                    Long id = ((ItmCatePropDO)itmCatePropDOMap.get(rowId)).getId();
                    itmCatePropValue.forEach(value -> {
                        value.setCatePropId(id);
                        value.setCreateTime(LocalDateTime.now());
                    });
                });
                if (MapUtils.isNotEmpty((Map)itmCatePropValueMap)) {
                    List catePropValueResults = itmCatePropValueMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                    this.itmCatePropValueRepo.saveAll(catePropValueResults);
                }
                build.setNumSuccess(Integer.valueOf(size));
                return build;
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                log.error("\u4fdd\u5b58\u54c1\u7c7b\u5c5e\u6027\u9519\u8bef\uff1a{}", (Throwable)e);
                build.setFailRecords(List.of(e.getMessage()));
                build.setNumSuccess(Integer.valueOf(0));
                return build;
            }
        });
        return build;
    }

    public ItmCatePropImportServiceImpl(ItmItemCateRepoProc itmItemCateRepoProc, ItmCatePropRepoProc itmCatePropRepoProc, ItmPropService itmPropService, ItmCatePropService itmCatePropService, ItmCatePropRepo itmCatePropRepo, ItmCatePropValueRepo itmCatePropValueRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmPropRepo itmPropRepo, ItmCatePropValueService itmCatePropValueService, ItmItemCateService itmItemCateService, UdcService sysUdcService, TransactionTemplate transactionTemplate) {
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.itmPropService = itmPropService;
        this.itmCatePropService = itmCatePropService;
        this.itmCatePropRepo = itmCatePropRepo;
        this.itmCatePropValueRepo = itmCatePropValueRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmPropRepo = itmPropRepo;
        this.itmCatePropValueService = itmCatePropValueService;
        this.itmItemCateService = itmItemCateService;
        this.sysUdcService = sysUdcService;
        this.transactionTemplate = transactionTemplate;
    }
}

