/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.excel.system.imp;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;
import com.el.coordinator.boot.fsm.service.importdata.DataImport;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.TableColumnExtEnum;
import com.elitesland.yst.supportdomain.common.entity.TableColumnExtDO;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepo;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemCateDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemCateUploadExcel;
import com.elitesland.yst.supportdomain.item.excel.system.ExcelUtil;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmTagService;
import com.elitesland.yst.supportdomain.pri.param.PriCatePriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ItmItemCateImportServiceImpl
implements DataImport<ItmItemCateUploadExcel> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemCateImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Long ROOT_PID = 0L;
    private static final String REGEX = "\\d{2}$";
    private static final String ROOT_CODE = "0";
    private static final String TRUE_FLAG = "1";
    private static final String FALSE_FLAG = "0";
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);
    private final ItmItemCateService itmItemCateService;
    private final ItmTagService itmTagService;
    private final PriMainPriceService priMainPriceService;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmCateContrParaRepo itmCateContrParaRepo;
    private final TableColumnExtRepo tableColumnExtRepo;
    private final UdcService sysUdcService;
    private final TransactionTemplate transactionTemplate;

    public String getTmplCode() {
        return "yst_support_cate_import";
    }

    public ImportResultRespVO.SyncResult execute(List<ItmItemCateUploadExcel> dataList, int rowId) {
        if (CollUtil.isEmpty(dataList)) {
            return ImportResultRespVO.SyncResult.builder().total(Integer.valueOf(0)).numSuccess(Integer.valueOf(0)).failRecords(Collections.emptyList()).build();
        }
        ImportResultRespVO.SyncResult syncResult = this.checkAndSaveData(dataList, rowId);
        return syncResult;
    }

    private ImportResultRespVO.SyncResult checkAndSaveData(List<ItmItemCateUploadExcel> dataList, int rowId) {
        List<ItmTagDTO> tagDtos = this.itmTagService.findAllTagDto();
        List<ItmItemCateDTO> itemCates = this.itmItemCateService.findAllItemCateDto();
        Map<String, String> finTypeUdc = this.sysUdcService.getCodeMap("ITM", "FIN_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> qualifyTypeUdc = this.sysUdcService.getCodeMap("ITM", "QUALIFY_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> tagNameCodeMap = tagDtos.stream().collect(Collectors.toMap(ItmTagDTO::getTagName, ItmTagDTO::getTagCode));
        Map<String, ItmItemCateDTO> cateCodeDtoMap = itemCates.stream().collect(Collectors.toMap(ItmItemCateDTO::getItemCateCode, t -> t));
        Map<Long, List<ItmItemCateDTO>> catePidMap = itemCates.stream().collect(Collectors.groupingBy(ItmItemCateDTO::getPid));
        Map<Long, Set> catePidNameMap = catePidMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ItmItemCateDTO::getItemCateName).collect(Collectors.toSet())));
        HashMap<String, String> newCateCodeNameMap = new HashMap<String, String>();
        ArrayList<ItmItemCateUploadExcel> saveList = new ArrayList<ItmItemCateUploadExcel>();
        ArrayList<String> errorResult = new ArrayList<String>();
        for (ItmItemCateUploadExcel data : dataList) {
            String qualifyType;
            String snFlag;
            ArrayList<String> errorList = new ArrayList<String>();
            String cateBigCode = data.getItemCateBigCode();
            boolean hasBigCode = true;
            boolean isNewBigCode = false;
            if (StringUtils.isBlank((CharSequence)cateBigCode)) {
                hasBigCode = false;
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (cateCodeDtoMap.containsKey(cateBigCode)) {
                ItmItemCateDTO cateDto = cateCodeDtoMap.get(cateBigCode);
                if (cateDto.getPid() == null || ROOT_PID.equals(cateDto.getPid())) {
                    data.setCateBigId(cateDto.getId());
                    data.setCateBigName(cateDto.getItemCateName());
                } else {
                    hasBigCode = false;
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6240\u586b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4f46\u4e0d\u662f\u4e00\u7ea7\u54c1\u7c7b\uff0c\u5df2\u5b58\u5728\u54c1\u7c7b\u7684\u540d\u79f0\uff1a" + cateDto.getItemCateName()));
                }
            } else if (cateBigCode.matches(REGEX)) {
                isNewBigCode = true;
                data.setFullCateBigCode(cateBigCode);
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
            }
            String cateBigName = data.getItemCateBigName();
            if (StringUtils.isBlank((CharSequence)cateBigName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (hasBigCode) {
                if (isNewBigCode) {
                    if (!newCateCodeNameMap.containsKey(cateBigCode)) {
                        if (catePidNameMap.getOrDefault(0L, Collections.emptySet()).contains(cateBigName)) {
                            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                        }
                        newCateCodeNameMap.put(cateBigCode, cateBigName);
                    }
                } else if (!cateBigName.equals(data.getCateBigName())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e00\u7ea7\u54c1\u7c7b", "\u5339\u914d\u5230\u76f8\u540c\u7f16\u53f7\u7684\u54c1\u7c7b\uff0c\u4f46\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
                }
            }
            boolean hasMidCode = true;
            boolean isNewMidCode = false;
            String shortCateMidCode = data.getItemCateMidCode();
            String cateMidCode = cateBigCode + "-" + shortCateMidCode;
            if (StringUtils.isBlank((CharSequence)shortCateMidCode)) {
                hasMidCode = false;
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (hasBigCode && hasMidCode) {
                if (cateCodeDtoMap.containsKey(cateMidCode)) {
                    ItmItemCateDTO cateDto = cateCodeDtoMap.get(cateMidCode);
                    if (isNewBigCode) {
                        hasMidCode = false;
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u5982\u679c\u4e00\u7ea7\u54c1\u7c7b\u4e3a\u65b0\u5efa\uff0c\u5219\u4e8c\u7ea7\u54c1\u7c7b\u5fc5\u987b\u4e3a\u65b0\u5efa\u54c1\u7c7b"));
                    } else if (cateDto.getPid().equals(data.getCateBigId())) {
                        data.setCateMidId(cateDto.getId());
                        data.setCateMidName(cateDto.getItemCateName());
                    } else {
                        hasMidCode = false;
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6307\u5b9a\u7684\u4e8c\u7ea7\u54c1\u7c7b\u5df2\u7ecf\u5c5e\u4e8e\u5176\u5b83\u4e00\u7ea7\u54c1\u7c7b\uff0c\u4e00\u7ea7\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateBigName()));
                    }
                } else if (shortCateMidCode.matches(REGEX)) {
                    isNewMidCode = true;
                    data.setFullCateMidCode(cateMidCode);
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
                }
                String cateMidName = data.getItemCateMidName();
                if (StringUtils.isBlank((CharSequence)cateMidName)) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
                } else if (hasMidCode) {
                    if (isNewMidCode) {
                        if (!newCateCodeNameMap.containsKey(cateMidCode)) {
                            if (data.getCateBigId() != null && catePidNameMap.getOrDefault(data.getCateBigId(), Collections.emptySet()).contains(cateMidName)) {
                                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728"));
                            }
                            newCateCodeNameMap.put(cateMidCode, cateMidName);
                        }
                    } else if (!cateMidName.equals(data.getCateMidName())) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e8c\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u540d\u79f0\u4e0d\u6b63\u786e\uff0c\u7f16\u53f7\u76f8\u540c\u7684\u54c1\u7c7b\u540d\u79f0\uff1a" + data.getCateMidName()));
                    }
                }
            }
            boolean hasSmallCode = true;
            String shortCateSmallCode = data.getItemCateSmallCode();
            String cateSmallCode = cateMidCode + "-" + shortCateSmallCode;
            if (StringUtils.isBlank((CharSequence)shortCateSmallCode)) {
                hasSmallCode = false;
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (shortCateSmallCode.matches(REGEX)) {
                data.setFullCateSmallCode(cateSmallCode);
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u8bf7\u8f93\u5165\u4e24\u4f4d\u6570\u5b57"));
            }
            if (hasBigCode && hasMidCode && hasSmallCode) {
                boolean isNewSmallCode = true;
                if (cateCodeDtoMap.containsKey(cateSmallCode)) {
                    isNewSmallCode = false;
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b\u7f16\u7801", "\u54c1\u7c7b\u5df2\u5b58\u5728"));
                }
                if (isNewSmallCode) {
                    String cateSmallName = data.getItemCateSmallName();
                    if (StringUtils.isBlank((CharSequence)cateSmallName)) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
                    } else if (newCateCodeNameMap.containsKey(cateSmallCode)) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u54c1\u7c7b\u91cd\u590d\uff0c\u91cd\u590d\u54c1\u7c7b\u7f16\u7801\uff1a" + shortCateSmallCode));
                    } else {
                        if (data.getCateMidId() != null && catePidNameMap.getOrDefault(data.getCateMidId(), Collections.emptySet()).contains(cateSmallCode)) {
                            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4e09\u7ea7\u54c1\u7c7b", "\u76f8\u540c\u7236\u7c7b\u4e0b\uff0c\u54c1\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728"));
                        }
                        newCateCodeNameMap.put(cateSmallCode, cateSmallName);
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)(snFlag = data.getSnFlag()))) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u6570\u636e\u5fc5\u586b"));
            } else if (!TRUE_FLAG.equals(snFlag) && !"0".equals(snFlag)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u5e8f\u5217\u53f7", "\u53ea\u80fd\u586b 0 \u6216\u8005 1"));
            }
            String lotFlag = data.getLotFlag();
            if (StringUtils.isBlank((CharSequence)lotFlag)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u6570\u636e\u5fc5\u586b"));
            } else if (!TRUE_FLAG.equals(lotFlag) && !"0".equals(lotFlag)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u662f\u5426\u542f\u7528\u6279\u6b21\u53f7", "\u53ea\u80fd\u586b 0 \u6216\u8005 1"));
            }
            String finTypeName = data.getFinType();
            if (StringUtils.isBlank((CharSequence)finTypeName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d22\u52a1\u5206\u7c7b", "\u6570\u636e\u5fc5\u586b"));
            } else if (!finTypeUdc.containsKey(finTypeName)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d22\u52a1\u5206\u7c7b", "\u4e0d\u6b63\u786e\u7684\u8d22\u52a1\u5206\u7c7b\uff1a" + finTypeName));
            } else {
                data.setFinTypeCode(finTypeUdc.get(finTypeName));
            }
            String grossMarginBStr = data.getGrossMarginB();
            if (StringUtils.isBlank((CharSequence)grossMarginBStr)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5fc5\u586b"));
            } else {
                try {
                    BigDecimal grossMarginB = new BigDecimal(grossMarginBStr);
                    if (grossMarginB.compareTo(BigDecimal.ZERO) >= 0 && grossMarginB.compareTo(DIVISOR) < 1) {
                        data.setGrossMarginBDecimal(grossMarginB.divide(DIVISOR, 2, RoundingMode.HALF_UP));
                    } else {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u5927\u5c0f\u533a\u95f4\u5e94\u4e3a0-100"));
                    }
                }
                catch (NumberFormatException e) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57"));
                }
            }
            String grossMarginCStr = data.getGrossMarginC();
            if (StringUtils.isBlank((CharSequence)grossMarginCStr)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5fc5\u586b"));
            } else {
                try {
                    BigDecimal grossMarginC = new BigDecimal(grossMarginCStr);
                    if (grossMarginC.compareTo(BigDecimal.ZERO) >= 0 && grossMarginC.compareTo(DIVISOR) < 1) {
                        data.setGrossMarginCDecimal(grossMarginC.divide(DIVISOR, 2, RoundingMode.HALF_UP));
                    } else {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u5927\u5c0f\u533a\u95f4\u5e94\u4e3a0-100"));
                    }
                }
                catch (NumberFormatException e) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57"));
                }
            }
            String tagName = data.getTagSaveParams();
            if (StringUtils.isNotBlank((CharSequence)tagName)) {
                List tagNames = Arrays.stream(tagName.split("(;)|(\uff1b)")).distinct().collect(Collectors.toList());
                StringBuilder errorType = new StringBuilder();
                ArrayList<String> tagCodes = new ArrayList<String>();
                for (String tag : tagNames) {
                    if (tagNameCodeMap.containsKey(tag)) {
                        tagCodes.add(tagNameCodeMap.get(tag));
                        continue;
                    }
                    errorType.append(tag).append(" ");
                }
                if (errorType.length() > 0) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6807\u7b7e\u7ef4\u62a4", "\u4e0d\u6b63\u786e\u7684\u6807\u7b7e\u540d\u79f0\uff1a" + errorType));
                } else {
                    data.setTagCodes(tagCodes);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(qualifyType = data.getQualifyTypes()))) {
                List qualifyTypes = Arrays.stream(qualifyType.split("(;)|(\uff1b)")).distinct().collect(Collectors.toList());
                StringBuilder errorType = new StringBuilder();
                ArrayList<String> qualifyTypeCodes = new ArrayList<String>();
                for (String type : qualifyTypes) {
                    if (qualifyTypeUdc.containsKey(type)) {
                        qualifyTypeCodes.add(qualifyTypeUdc.get(type));
                        continue;
                    }
                    errorType.append(type).append(" ");
                }
                if (errorType.length() > 0) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8bc1\u7167\u7ef4\u62a4", "\u4e0d\u6b63\u786e\u7684\u8bc1\u7167\u7c7b\u578b\uff1a" + errorType));
                } else {
                    data.setQualifyTypeCodes(qualifyTypeCodes);
                }
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.addAll(errorList);
            } else {
                saveList.add(data);
            }
            ++rowId;
        }
        ImportResultRespVO.SyncResult syncResult = this.saveData(saveList, newCateCodeNameMap);
        return ExcelUtil.getSyncResult(errorResult, syncResult, dataList.size());
    }

    private ImportResultRespVO.SyncResult saveData(List<ItmItemCateUploadExcel> saveList, Map<String, String> newCateCodeNameMap) {
        this.transactionTemplate.setPropagationBehavior(3);
        ImportResultRespVO.SyncResult build = ImportResultRespVO.SyncResult.builder().build();
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                if (CollectionUtils.isNotEmpty((Collection)saveList)) {
                    HashMap pCodeDoGroupMap = new HashMap();
                    HashMap<String, ItmItemCateDO> codeDoMap = new HashMap<String, ItmItemCateDO>();
                    ArrayList<ItmItemCateDO> bigCateDos = new ArrayList<ItmItemCateDO>();
                    ArrayList<ItmItemCateDO> midCateDos = new ArrayList<ItmItemCateDO>();
                    ArrayList<ItmItemCateDO> smallCateDos = new ArrayList<ItmItemCateDO>();
                    ArrayList<ItmCateContrParaDO> itmCateContrParaDos = new ArrayList<ItmCateContrParaDO>();
                    ArrayList<PriCatePriceSaveRowParam> priCatePriceSaveParams = new ArrayList<PriCatePriceSaveRowParam>();
                    ArrayList<TableColumnExtDO> tagExtDos = new ArrayList<TableColumnExtDO>();
                    ArrayList<TableColumnExtDO> qualifyTypeExtDos = new ArrayList<TableColumnExtDO>();
                    LocalDate now = LocalDate.now();
                    for (ItmItemCateUploadExcel excelDatum : saveList) {
                        TableColumnExtDO tableColumnExtDO;
                        int sortNo;
                        String fullCateMidCode;
                        String fullCateBigCode = excelDatum.getFullCateBigCode();
                        if (StringUtils.isNotBlank((CharSequence)fullCateBigCode) && !codeDoMap.containsKey(fullCateBigCode)) {
                            ItmItemCateDO bigCateDo = new ItmItemCateDO();
                            bigCateDo.setItemCateCode(fullCateBigCode);
                            bigCateDo.setItemCateName((String)newCateCodeNameMap.get(fullCateBigCode));
                            bigCateDo.setGrade(1);
                            bigCateDo.setItemCateIsBasic(0);
                            bigCateDo.setStatus("ENABLE");
                            bigCateDo.setPid(0L);
                            if (pCodeDoGroupMap.containsKey("0")) {
                                ((List)pCodeDoGroupMap.get("0")).add(bigCateDo);
                            } else {
                                ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                                dos.add(bigCateDo);
                                pCodeDoGroupMap.put("0", dos);
                            }
                            codeDoMap.put(fullCateBigCode, bigCateDo);
                            bigCateDos.add(bigCateDo);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(fullCateMidCode = excelDatum.getFullCateMidCode())) && !codeDoMap.containsKey(fullCateMidCode)) {
                            ItmItemCateDO midCateDo = new ItmItemCateDO();
                            midCateDo.setItemCateCode(fullCateMidCode);
                            midCateDo.setItemCateName((String)newCateCodeNameMap.get(fullCateMidCode));
                            midCateDo.setGrade(2);
                            midCateDo.setItemCateIsBasic(0);
                            midCateDo.setStatus("ENABLE");
                            if (excelDatum.getCateBigId() != null) {
                                midCateDo.setPid(excelDatum.getCateBigId());
                            } else {
                                String pCode = excelDatum.getFullCateBigCode();
                                if (pCodeDoGroupMap.containsKey(pCode)) {
                                    ((List)pCodeDoGroupMap.get(pCode)).add(midCateDo);
                                } else {
                                    ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                                    dos.add(midCateDo);
                                    pCodeDoGroupMap.put(pCode, dos);
                                }
                            }
                            codeDoMap.put(fullCateMidCode, midCateDo);
                            midCateDos.add(midCateDo);
                        }
                        String fullCateSmallCode = excelDatum.getFullCateSmallCode();
                        ItmItemCateDO smallCateDo = new ItmItemCateDO();
                        smallCateDo.setItemCateCode(fullCateSmallCode);
                        smallCateDo.setItemCateName((String)newCateCodeNameMap.get(fullCateSmallCode));
                        smallCateDo.setGrade(3);
                        smallCateDo.setItemCateIsBasic(1);
                        smallCateDo.setStatus("ENABLE");
                        if (excelDatum.getCateMidId() != null) {
                            smallCateDo.setPid(excelDatum.getCateMidId());
                        } else {
                            String pCode = excelDatum.getFullCateMidCode();
                            if (pCodeDoGroupMap.containsKey(pCode)) {
                                ((List)pCodeDoGroupMap.get(pCode)).add(smallCateDo);
                            } else {
                                ArrayList<ItmItemCateDO> dos = new ArrayList<ItmItemCateDO>();
                                dos.add(smallCateDo);
                                pCodeDoGroupMap.put(pCode, dos);
                            }
                        }
                        codeDoMap.put(fullCateSmallCode, smallCateDo);
                        smallCateDos.add(smallCateDo);
                        ItmCateContrParaDO snFlagDo = new ItmCateContrParaDO();
                        snFlagDo.setItemCateCode(fullCateSmallCode);
                        snFlagDo.setControlParamCode(ItmCateControlParamEnum.SN_FLAG.getCode());
                        snFlagDo.setControlParamValue(excelDatum.getSnFlag());
                        itmCateContrParaDos.add(snFlagDo);
                        ItmCateContrParaDO lotFlagDo = new ItmCateContrParaDO();
                        lotFlagDo.setItemCateCode(fullCateSmallCode);
                        lotFlagDo.setControlParamCode(ItmCateControlParamEnum.LOT_FLAG.getCode());
                        lotFlagDo.setControlParamValue(excelDatum.getLotFlag());
                        itmCateContrParaDos.add(lotFlagDo);
                        ItmCateContrParaDO finTypeDo = new ItmCateContrParaDO();
                        finTypeDo.setItemCateCode(fullCateSmallCode);
                        finTypeDo.setControlParamCode(ItmCateControlParamEnum.FIN_TYPE.getCode());
                        finTypeDo.setControlParamValue(excelDatum.getFinTypeCode());
                        itmCateContrParaDos.add(finTypeDo);
                        PriCatePriceSaveRowParam priCatePriceSaveParam = new PriCatePriceSaveRowParam();
                        priCatePriceSaveParam.setItemCateCode(fullCateSmallCode);
                        priCatePriceSaveParam.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
                        priCatePriceSaveParam.setValidFrom(LocalDateTime.of(now, LocalTime.MIN));
                        priCatePriceSaveParam.setValidTo(LocalDateTime.of(now.plusYears(30L), LocalTime.MIN));
                        priCatePriceSaveParam.setPrice4(excelDatum.getGrossMarginBDecimal());
                        priCatePriceSaveParam.setPrice5(excelDatum.getGrossMarginCDecimal());
                        priCatePriceSaveParams.add(priCatePriceSaveParam);
                        if (CollectionUtils.isNotEmpty(excelDatum.getTagCodes())) {
                            sortNo = 1;
                            for (String tagCode : excelDatum.getTagCodes()) {
                                tableColumnExtDO = new TableColumnExtDO();
                                tableColumnExtDO.setTableName(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName());
                                tableColumnExtDO.setColumnName(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName());
                                tableColumnExtDO.setRowCode(fullCateSmallCode);
                                tableColumnExtDO.setColumnValue(tagCode);
                                tableColumnExtDO.setSortNo(sortNo++);
                                tagExtDos.add(tableColumnExtDO);
                            }
                        }
                        if (!CollectionUtils.isNotEmpty(excelDatum.getQualifyTypeCodes())) continue;
                        sortNo = 1;
                        for (String qualifyType : excelDatum.getQualifyTypeCodes()) {
                            tableColumnExtDO = new TableColumnExtDO();
                            tableColumnExtDO.setTableName(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName());
                            tableColumnExtDO.setColumnName(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName());
                            tableColumnExtDO.setRowCode(fullCateSmallCode);
                            tableColumnExtDO.setColumnValue(qualifyType);
                            tableColumnExtDO.setSortNo(sortNo++);
                            qualifyTypeExtDos.add(tableColumnExtDO);
                        }
                    }
                    this.itmItemCateRepo.saveAll(bigCateDos);
                    bigCateDos.forEach(big -> ((List)pCodeDoGroupMap.get(big.getItemCateCode())).forEach(mid -> mid.setPid(big.getId())));
                    this.itmItemCateRepo.saveAll(midCateDos);
                    midCateDos.forEach(mid -> ((List)pCodeDoGroupMap.get(mid.getItemCateCode())).forEach(small -> small.setPid(mid.getId())));
                    this.itmItemCateRepo.saveAll(smallCateDos);
                    this.itmCateContrParaRepo.saveAll(itmCateContrParaDos);
                    this.priMainPriceService.priCatePriceSave(priCatePriceSaveParams);
                    if (CollectionUtils.isNotEmpty(tagExtDos)) {
                        this.tableColumnExtRepo.saveAll(tagExtDos);
                    }
                    if (CollectionUtils.isNotEmpty(qualifyTypeExtDos)) {
                        this.tableColumnExtRepo.saveAll(qualifyTypeExtDos);
                    }
                    build.setNumSuccess(Integer.valueOf(smallCateDos.size()));
                }
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                log.error("\u4fdd\u5b58\u54c1\u7c7b\u5c5e\u6027\u9519\u8bef\uff1a{}", (Throwable)e);
                build.setFailRecords(List.of(e.getMessage()));
                build.setNumSuccess(Integer.valueOf(0));
                return build;
            }
            return build;
        });
        return build;
    }

    public ItmItemCateImportServiceImpl(ItmItemCateService itmItemCateService, ItmTagService itmTagService, PriMainPriceService priMainPriceService, ItmItemCateRepo itmItemCateRepo, ItmCateContrParaRepo itmCateContrParaRepo, TableColumnExtRepo tableColumnExtRepo, UdcService sysUdcService, TransactionTemplate transactionTemplate) {
        this.itmItemCateService = itmItemCateService;
        this.itmTagService = itmTagService;
        this.priMainPriceService = priMainPriceService;
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmCateContrParaRepo = itmCateContrParaRepo;
        this.tableColumnExtRepo = tableColumnExtRepo;
        this.sysUdcService = sysUdcService;
        this.transactionTemplate = transactionTemplate;
    }
}

