/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.provider;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.base.param.OrderItem;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.industry.general.item.proportion.provider.GeneralYstServicesetProvider;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.proportion.convert.YstServicesetConvert;
import com.elitesland.yst.srmdomain.proportion.repo.YstServicesetRepoProc;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstServicesetParamVO;
import com.elitesland.yst.srmdomain.proportion.vo.resp.YstServicesetRespVO;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemWhetherFreezeParam;
import com.elitesland.yst.supportdomain.item.convert.ItmItemAttachmentConvert;
import com.elitesland.yst.supportdomain.item.convert.ItmItemConvert;
import com.elitesland.yst.supportdomain.item.convert.ItmItemRelevanceConvert;
import com.elitesland.yst.supportdomain.item.convert.ItmItemSpuConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.entity.ItmItemAttachmentDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemRelevanceDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemSpuDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.provider.convert.ItmCheckLifeStatusConvert;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemBusinessRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemCateContrRpcPropRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemCateRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemStatusConfigRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemUomConvRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.vo.ItmItemCateContrPropVO;
import com.elitesland.yst.supportdomain.item.provider.vo.ItmItemLifeStatusFilterVO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemAttachmentRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemLifeStatusRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRelevanceRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemSpuRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemSpuRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCheckLifeStatusService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemStatusConfigVO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItemCateContrPropRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateContrPropDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateContrPropRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemPicDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemRelevanceDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemRpcPagingDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemStatusConfigRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemUomConvCalcRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.SpuImageDTO;
import com.elitesland.yst.supportdomain.provider.item.param.CommonItmItemParamVO;
import com.elitesland.yst.supportdomain.provider.item.param.ConvertUomRatioParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItemCateContrPropParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmCheckLifeStatusRpcParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateNameParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCheckSaveParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemQueryParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemRpcPagingParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSaveParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuQueryParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemStatusConfigRpcParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemUomConvCalcParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemUomConvRpcOtherParam;
import com.elitesland.yst.supportdomain.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.supportdomain.provider.item.vo.CommonItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ConvertUomRatioDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemQueryDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemSpuQueryDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemUomRpcVO;
import com.elitesland.yst.supportdomain.provider.item.vo.TmItmItemNRespVO;
import com.elitesland.yst.supportdomain.provider.item.vo.YstServicesetDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@UnicomTag(value="GENERAL")
public class ItmItemRpcServiceImpl
implements ItmItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemRpcServiceImpl.class);
    private static final String FIN_TYPE = "finType";
    private static final String PRICE_GROUP = "priceGroup";
    private static final String PRICE_GROUP2 = "priceGroup2";
    private static final String PRICE_GROUP3 = "priceGroup3";
    private final YstServicesetRepoProc ystServicesetRepoProc;
    private final ItmItemRpcRepoProc itmItemRpcRepoProc;
    private final GeneralYstServicesetProvider generalYstServicesetProvider;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemRepoProc itmItemRepoProc;
    private final ItmItemSpuRepo itmItemSpuRepo;
    private final ItmItemSpuRepoProc itmItemSpuRepoProc;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmItemAttachmentRepo itmItemAttachmentRepo;
    private final ItmItemRelevanceRepo itemRelevanceRepo;
    private final SrmItmItemRepoProc srmItmItemRepoProc;
    private final ItmItemUomConvRpcRepoProc itmItemUomConvRpcRepoProc;
    private final ItmItemCateContrRpcPropRepoProc itmItemCateContrRpcPropRepoProc;
    private final ItmItemCateRpcRepoProc itmItemCateRpcRepoProc;
    private final ItmItemBusinessRpcRepoProc itmItemBusinessRpcRepoProc;
    private final ItmItemStatusConfigRpcRepoProc itmItemStatusConfigRpcRepoProc;
    private final ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc;
    private final ItmItemLifeStatusRepoProc itmItemLifeStatusRepoProc;
    private final ItmCheckLifeStatusService itmCheckLifeStatusService;
    private final ItmItemCateService itmItemCateService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;

    public List<ItmItemRpcDTO> findItemRpcDtoByParam(ItmItemRpcDtoParam param) {
        List<ItmItemRpcDTO> dtos = this.itmItemRpcRepoProc.findRpcDtoByParam(param);
        HashMap spuImageList = new HashMap(16);
        if (CollectionUtils.isNotEmpty(dtos)) {
            ArrayList taxRateNos = new ArrayList();
            dtos.forEach(dto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)spuImageList.get(dto.getSpuId())))) {
                    dto.setSpuImageList((List)spuImageList.get(dto.getSpuId()));
                } else {
                    List<SpuImageDTO> itemImagesByItemId = this.itmItemRpcRepoProc.findItemImagesByItemId(dto.getSpuId());
                    dto.setSpuImageList(itemImagesByItemId);
                    spuImageList.put(dto.getSpuId(), itemImagesByItemId);
                }
                if (!StringUtils.isBlank((CharSequence)dto.getItemCateCode())) {
                    List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath(dto.getItemCateCode());
                    ArrayList<String> pathName = new ArrayList<String>();
                    this.buildPathName(path, pathName);
                    dto.setItemCatePathName(pathName);
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getTaxCode()) && !taxRateNos.contains(dto.getTaxCode())) {
                    taxRateNos.add(dto.getTaxCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getTaxCode2()) && !taxRateNos.contains(dto.getTaxCode2())) {
                    taxRateNos.add(dto.getTaxCode2());
                }
            });
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                    dtos.forEach(dto -> {
                        ComTaxRateRpcDTO tax;
                        if (StringUtils.isNotBlank((CharSequence)dto.getTaxCode()) && (tax = (ComTaxRateRpcDTO)taxMap.get(dto.getTaxCode())) != null) {
                            dto.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)dto.getTaxCode2()) && (tax = (ComTaxRateRpcDTO)taxMap.get(dto.getTaxCode2())) != null) {
                            dto.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                        }
                    });
                }
            }
        }
        return dtos;
    }

    public List<TmItmItemNRespVO> findItemRpcParam(List<Long> itemids) {
        QItmItemDO itmItem = QItmItemDO.itmItemDO;
        return ((JPAQuery)this.itmItemRpcRepoProc.selectSrmTms().where((Predicate)itmItem.id.in(itemids))).fetch();
    }

    @SysCodeProc
    public PagingVO<ItmItemRpcPagingDTO> findItemRpcPagingByParam(ItmItemRpcPagingParam param) {
        PagingVO<ItmItemRpcPagingDTO> result = this.itmItemRpcRepoProc.itemRpcPagingSearch(param);
        List<String> itemCodes = result.getRecords().stream().map(ItmItemRpcPagingDTO::getItemCode).collect(Collectors.toList());
        ArrayList notNowLifeStatus = new ArrayList();
        if (null != param.getStatusTime()) {
            this.itmItemLifeStatusRepoProc.findLifeStatusByItemIdsAndTime(itemCodes, param.getStatusTime());
        }
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ArrayList taxCodes = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (!StringUtils.isBlank((CharSequence)vo.getItemCateCode())) {
                    List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath(vo.getItemCateCode());
                    ArrayList<String> pathName = new ArrayList<String>();
                    this.buildPathName(path, pathName);
                    vo.setItemCatePathName(pathName);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && !taxCodes.contains(vo.getTaxCode())) {
                    taxCodes.add(vo.getTaxCode());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && !taxCodes.contains(vo.getTaxCode2())) {
                    taxCodes.add(vo.getTaxCode2());
                }
            });
            if (CollectionUtils.isNotEmpty(taxCodes)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxCodes);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                    result.getRecords().forEach(vo -> {
                        ComTaxRateRpcDTO tax;
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode())) != null) {
                            vo.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRateDesc(tax.getTaxRateDesc());
                        }
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode2())) != null) {
                            vo.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRate2Desc(tax.getTaxRateDesc());
                        }
                    });
                }
            }
        }
        return result;
    }

    public List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(ItmItemUomConvRpcDtoParam param) {
        List otherParam = param.getOtherParam();
        if (CollectionUtils.isNotEmpty((Collection)param.getOtherParam())) {
            List itemIds = otherParam.stream().map(ItmItemUomConvRpcOtherParam::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemIds)) {
                return Collections.emptyList();
            }
            List<ItmItemUomConvRpcDTO> rpcDtoByParam = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(ItmItemUomConvRpcDtoParam.builder().itemIds(itemIds).build());
            if (CollectionUtils.isEmpty(rpcDtoByParam)) {
                return Collections.emptyList();
            }
            Map<Long, List<ItmItemUomConvRpcDTO>> rpcDtoByParamMap = rpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemUomConvRpcDTO::getItemId));
            ArrayList<ItmItemUomConvRpcDTO> result = new ArrayList<ItmItemUomConvRpcDTO>();
            for (ItmItemUomConvRpcOtherParam convParam : otherParam) {
                Long itemId = convParam.getItemId();
                String fromUom = convParam.getFromUom();
                String toUom = convParam.getToUom();
                List<ItmItemUomConvRpcDTO> itmItemUomConvRpcDTOS = rpcDtoByParamMap.get(itemId);
                if (!CollectionUtils.isNotEmpty(itmItemUomConvRpcDTOS)) continue;
                for (ItmItemUomConvRpcDTO itmItemUomConvRpcDTO : itmItemUomConvRpcDTOS) {
                    String fromUom1 = itmItemUomConvRpcDTO.getFromUom();
                    String toUom1 = itmItemUomConvRpcDTO.getToUom();
                    if (fromUom.equals(fromUom1) && toUom.equals(toUom1)) {
                        result.add(itmItemUomConvRpcDTO);
                        continue;
                    }
                    if (!fromUom.equals(toUom1) || !toUom.equals(fromUom1)) continue;
                    BigDecimal ratio = itmItemUomConvRpcDTO.getRatio();
                    itmItemUomConvRpcDTO.setRatio(itmItemUomConvRpcDTO.getRevertRatio());
                    itmItemUomConvRpcDTO.setRevertRatio(ratio);
                    result.add(itmItemUomConvRpcDTO);
                }
            }
            return result;
        }
        List<ItmItemUomConvRpcDTO> result = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(param);
        if (CollectionUtils.isEmpty(result) && StringUtils.isNotBlank((CharSequence)param.getFromUom()) && StringUtils.isNotBlank((CharSequence)param.getToUom())) {
            String tempUom = param.getFromUom();
            param.setFromUom(param.getToUom());
            param.setToUom(tempUom);
            result = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(param);
            if (CollectionUtils.isNotEmpty(result)) {
                result.forEach(dto -> {
                    BigDecimal tempRatio = dto.getRatio();
                    dto.setRatio(dto.getRevertRatio());
                    dto.setRevertRatio(tempRatio);
                    String tmpUom = dto.getFromUom();
                    dto.setFromUom(dto.getToUom());
                    dto.setToUom(tmpUom);
                });
            }
        }
        return result;
    }

    public ItmItemCateContrPropRpcDTO findItemCateContPropDtoByItemId(List<Long> itemIds) {
        ItmItemCateContrPropRpcDTO itmItemCateContrPropRpcDTO = new ItmItemCateContrPropRpcDTO();
        Map<Long, List<ItmItemCateContrPropVO>> itmItemCateContrPropMap = this.itmItemCateContrRpcPropRepoProc.findRpcDtoByParam(itemIds).stream().collect(Collectors.groupingBy(ItmItemCateContrPropVO::getId));
        List<ItmItemCateContrPropDTO> itmItemCateContrPropDTOS = itmItemCateContrPropMap.keySet().stream().map(itemId -> {
            List itmItemCateContrPropVOS = (List)itmItemCateContrPropMap.get(itemId);
            ItmItemCateContrPropDTO itmItemCateContrPropDTO = new ItmItemCateContrPropDTO();
            itmItemCateContrPropDTO.setId(itemId);
            itmItemCateContrPropVOS.forEach(cateContr -> {
                String controlParamCode = cateContr.getControlParamCode();
                String controlParamValue = cateContr.getControlParamValue();
                if (StringUtils.isBlank((CharSequence)itmItemCateContrPropDTO.getSmallCateCode())) {
                    itmItemCateContrPropDTO.setSmallCateCode(cateContr.getSmallCateCode());
                    itmItemCateContrPropDTO.setItemCateName(cateContr.getItemCateName());
                }
                if (FIN_TYPE.equals(controlParamCode)) {
                    itmItemCateContrPropDTO.setControlParamValue(controlParamValue);
                } else if (PRICE_GROUP.equals(controlParamCode)) {
                    itmItemCateContrPropDTO.setPriceGroup(controlParamValue);
                } else if (PRICE_GROUP2.equals(controlParamCode)) {
                    itmItemCateContrPropDTO.setPriceGroup2(controlParamValue);
                } else if (PRICE_GROUP3.equals(controlParamCode)) {
                    itmItemCateContrPropDTO.setPriceGroup3(controlParamValue);
                }
            });
            return itmItemCateContrPropDTO;
        }).collect(Collectors.toList());
        itmItemCateContrPropDTOS.forEach(cate -> {
            if (StringUtils.isBlank((CharSequence)cate.getSmallCateCode())) {
                throw new BusinessException("\u65e0\u5bf9\u5e94\u7684\u5546\u54c1\u6216\u8005\u54c1\u7c7b\u5bf9\u5e94\u7684\u7ba1\u63a7\u53c2\u6570:" + cate.getId());
            }
            String midCateCode = this.itmItemCateRpcRepoProc.getPCateCodeByCateCode(cate.getSmallCateCode());
            if (StringUtils.isBlank((CharSequence)midCateCode)) {
                throw new BusinessException("\u5c0f\u7c7b\u65e0\u5bf9\u5e94\u7684\u4e2d\u7c7b");
            }
            cate.setMidCateCode(midCateCode);
            String bigCateCode = this.itmItemCateRpcRepoProc.getPCateCodeByCateCode(midCateCode);
            if (StringUtils.isBlank((CharSequence)bigCateCode)) {
                throw new BusinessException("\u4e2d\u7c7b\u65e0\u5bf9\u5e94\u7684\u5927\u7c7b");
            }
            cate.setBigCateCode(bigCateCode);
        });
        itmItemCateContrPropRpcDTO.setItmItemCateContrPropDTOS(itmItemCateContrPropDTOS);
        return itmItemCateContrPropRpcDTO;
    }

    public List<ItemCateContrPropRpcDTO> findItemCateContrPropByParam(ItemCateContrPropParam param) {
        List<ItmItemCateContrPropVO> rpcDtoByContrParam = this.itmItemCateContrRpcPropRepoProc.findRpcDtoByContrParam(param);
        Map<String, List<ItmItemCateContrPropVO>> itmItemCateContrPropMap = rpcDtoByContrParam.stream().collect(Collectors.groupingBy(ItmItemCateContrPropVO::getSmallCateCode));
        return itmItemCateContrPropMap.keySet().stream().map(cateContr -> {
            List itmItemCateContrPropVOS = (List)itmItemCateContrPropMap.get(cateContr);
            ItemCateContrPropRpcDTO itemCateContrPropRpcDTO = new ItemCateContrPropRpcDTO();
            itemCateContrPropRpcDTO.setItemCateCode(cateContr);
            itmItemCateContrPropVOS.forEach(contr -> {
                String controlParamCode = contr.getControlParamCode();
                String controlParamValue = contr.getControlParamValue();
                if (PRICE_GROUP.equals(controlParamCode)) {
                    itemCateContrPropRpcDTO.setPriceGroup(controlParamValue);
                } else if (PRICE_GROUP2.equals(controlParamCode)) {
                    itemCateContrPropRpcDTO.setPriceGroup2(controlParamValue);
                } else if (PRICE_GROUP3.equals(controlParamCode)) {
                    itemCateContrPropRpcDTO.setPriceGroup3(controlParamValue);
                } else if (FIN_TYPE.equals(controlParamCode)) {
                    itemCateContrPropRpcDTO.setFinType(controlParamValue);
                }
            });
            return itemCateContrPropRpcDTO;
        }).collect(Collectors.toList());
    }

    public List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param) {
        ArrayList taxCodes = new ArrayList();
        List<ItmItemBusinessRpcDTO> rpcDtoByParam = this.itmItemBusinessRpcRepoProc.findRpcDtoByParam(param);
        if (CollectionUtils.isEmpty(rpcDtoByParam)) {
            return Collections.emptyList();
        }
        rpcDtoByParam.forEach(rpc -> {
            String itemLifeStatus = rpc.getItemLifeStatus();
            if (StringUtils.isBlank((CharSequence)itemLifeStatus)) {
                rpc.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
            }
            if (StringUtils.isNotBlank((CharSequence)rpc.getTaxCode()) && !taxCodes.contains(rpc.getTaxCode())) {
                taxCodes.add(rpc.getTaxCode());
            }
            if (StringUtils.isNotBlank((CharSequence)rpc.getTaxCode2()) && !taxCodes.contains(rpc.getTaxCode2())) {
                taxCodes.add(rpc.getTaxCode2());
            }
        });
        if (CollectionUtils.isNotEmpty(taxCodes)) {
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxCodes);
            List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
            if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                rpcDtoByParam.forEach(vo -> {
                    ComTaxRateRpcDTO tax;
                    if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode())) != null) {
                        vo.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                        vo.setTaxRateDesc(tax.getTaxRateDesc());
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode2())) != null) {
                        vo.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                        vo.setTaxRate2Desc(tax.getTaxRateDesc());
                    }
                });
            }
        }
        return rpcDtoByParam;
    }

    private void buildPathName(List<ItmItemCateSimpleTree> tree, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathName.add(t.getItemCateName());
            this.buildPathName(t.getTreeNodes(), pathName);
        });
    }

    private void buildPathCodeAndName(List<ItmItemCateSimpleTree> tree, List<String> pathCode, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathCode.add(t.getItemCateCode());
            pathName.add(t.getItemCateName());
            this.buildPathCodeAndName(t.getTreeNodes(), pathCode, pathName);
        });
    }

    @SysCodeProc
    public PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(ItmItemBusinessRpcPagingParam param) {
        PagingVO<ItmItemBusinessRpcPagingDTO> result = this.itmItemRpcRepoProc.itemBusinessRpcPagingSearch(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ArrayList taxCodes = new ArrayList();
            result.getRecords().forEach(vo -> {
                String itemLifeStatus = vo.getItemLifeStatus();
                if (StringUtils.isBlank((CharSequence)itemLifeStatus)) {
                    vo.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getValDesc());
                }
                if (!StringUtils.isBlank((CharSequence)vo.getItemCateCode())) {
                    List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath(vo.getItemCateCode());
                    ArrayList<String> pathName = new ArrayList<String>();
                    this.buildPathName(path, pathName);
                    vo.setItemCatePathName(pathName);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && !taxCodes.contains(vo.getTaxCode())) {
                    taxCodes.add(vo.getTaxCode());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && !taxCodes.contains(vo.getTaxCode2())) {
                    taxCodes.add(vo.getTaxCode2());
                }
            });
            if (CollectionUtils.isNotEmpty(taxCodes)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxCodes);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                    result.getRecords().forEach(vo -> {
                        ComTaxRateRpcDTO tax;
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode())) != null) {
                            vo.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRateDesc(tax.getTaxRateDesc());
                        }
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode2())) != null) {
                            vo.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRate2Desc(tax.getTaxRateDesc());
                        }
                    });
                }
            }
        }
        return result;
    }

    public ItmItemCateCodeRpcDTO findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        List itemCateCodes = param.getItemCateCodes();
        HashMap resultMap = new HashMap();
        itemCateCodes.forEach(itemCateCode -> {
            List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            ArrayList<String> pathCode = new ArrayList<String>();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathCodeAndName(path, pathCode, pathName);
            resultMap.put(itemCateCode, ItmCateCodeAndNameRpcDTO.builder().cateNameList(pathName).cateCodeList(pathCode).build());
        });
        return ItmItemCateCodeRpcDTO.builder().cateMap(resultMap).build();
    }

    public List<ItmItemStatusConfigRpcDTO> findItmItemStatusConfigByParam(ItmItemStatusConfigRpcParam param) {
        return this.itmItemStatusConfigRpcRepoProc.findItmItemStatusConfigByParam(param);
    }

    public void checkItemLifeStatusConfigByParam(ItmCheckLifeStatusRpcParam param) {
        ItmItemWhetherFreezeParam freezeParam = ItmCheckLifeStatusConvert.INSTANCE.rpcParamToFreezeParam(param);
        this.itmCheckLifeStatusService.checkLifeStatusConfig(freezeParam);
    }

    public Map<String, Map<String, Map<String, String>>> getItemCateInfoByBigCateName(ItmItemCateNameParam param) {
        List<ItmItemCateVO> itmItemCateVOS = this.itmItemCateService.itmItemCateSearchTree();
        List bigItemCateNames = param.getBigItemCateNames();
        Map<String, Map<String, Map<String, String>>> result = itmItemCateVOS.stream().filter(cateVo -> bigItemCateNames.contains(cateVo.getItemCateName())).collect(Collectors.toMap(ItmItemCateVO::getItemCateName, ItmItemCateVO::getTreeNodes)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(ItmItemCateVO::getItemCateName, ItmItemCateVO::getTreeNodes)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entrySmall -> ((List)entrySmall.getValue()).stream().collect(Collectors.toMap(ItmItemCateVO::getItemCateName, ItmItemCateVO::getItemCateCode))))));
        return result;
    }

    public List<ItmItemUomConvCalcRpcDTO> getItemUomConvNumberByList(List<ItmItemUomConvCalcParam> params) {
        ArrayList<ItmItemUomConvCalcRpcDTO> result = new ArrayList<ItmItemUomConvCalcRpcDTO>();
        log.debug("\u6839\u636e\u5546\u54c1id\u3001\u4e1a\u52a1\u5355\u4f4d\u3001\u6570\u91cf\uff0c\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u6570\u636e---\u4e1a\u52a1\u5f00\u59cb");
        log.debug("\u6839\u636e\u5546\u54c1id\u3001\u4e1a\u52a1\u5355\u4f4d\u3001\u6570\u91cf\uff0c\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u6570\u636e---\u5165\u53c2\uff1a{}", params);
        if (CollectionUtils.isEmpty(params)) {
            log.debug("\u6839\u636e\u5546\u54c1id\u3001\u4e1a\u52a1\u5355\u4f4d\u3001\u6570\u91cf\uff0c\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u6570\u636e---\u5165\u53c2\u4e3a\u7a7a\uff1a{}", params);
            return Collections.emptyList();
        }
        List<Long> itemIds = params.stream().map(ItmItemUomConvCalcParam::getItemId).distinct().collect(Collectors.toList());
        List<ItmItemUomRpcVO> uomByItemId = this.itmItemRpcRepoProc.getUomFromItemByItemId(itemIds);
        List deleteItemList = uomByItemId.stream().filter(uom -> null != uom.getDeleteFlag() && !Integer.valueOf(0).equals(uom.getDeleteFlag())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteItemList)) {
            String deleteItemNameStr = deleteItemList.stream().map(ItmItemUomRpcVO::getItemName).collect(Collectors.joining("\u3001"));
            throw new BusinessException("\u5546\u54c1\uff1a" + deleteItemNameStr + ",\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        ArrayList<Long> notMatchUomItemIdList = new ArrayList<Long>();
        Map<Long, ItmItemUomRpcVO> uomMap = uomByItemId.stream().collect(Collectors.toMap(ItmItemUomRpcVO::getId, t -> t));
        for (ItmItemUomConvCalcParam param2 : params) {
            Long itemId = param2.getItemId();
            ItmItemUomRpcVO itmItemUomRpcVO = uomMap.get(itemId);
            if (null == itmItemUomRpcVO) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u5546\u54c1id\u4e3a\uff1a" + itemId + "\uff0c\u7684\u5546\u54c1");
            }
            String mainUom = itmItemUomRpcVO.getUom();
            if (mainUom.equals(param2.getBusinessUom())) {
                ItmItemUomConvCalcRpcDTO itmItemUomCalc = new ItmItemUomConvCalcRpcDTO();
                itmItemUomCalc.setItemId(itemId);
                itmItemUomCalc.setMainUom(mainUom);
                itmItemUomCalc.setConvertedNum(param2.getConvertNum());
                itmItemUomCalc.setBusinessUom(param2.getBusinessUom());
                result.add(itmItemUomCalc);
                continue;
            }
            notMatchUomItemIdList.add(itemId);
        }
        if (CollectionUtils.isNotEmpty(notMatchUomItemIdList)) {
            List notMatchUomList = params.stream().filter(param -> notMatchUomItemIdList.contains(param.getItemId())).collect(Collectors.toList());
            log.debug("\u6839\u636e\u5546\u54c1id\u3001\u4e1a\u52a1\u5355\u4f4d\u3001\u6570\u91cf\uff0c\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u6570\u636e---\u4e1a\u52a1\u5355\u4f4d\u4e0e\u4e3b\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\u7684\u5546\u54c1id\u5217\u8868\uff1a{}", notMatchUomItemIdList);
            Map<Long, ItmItemUomConvRpcDTO> uomFromUomMap = this.itmItemRpcRepoProc.getUomFromUomByItemId(notMatchUomItemIdList).stream().collect(Collectors.toMap(ItmItemUomConvRpcDTO::getItemId, t -> t));
            log.debug("\u6839\u636e\u5546\u54c1id\u3001\u4e1a\u52a1\u5355\u4f4d\u3001\u6570\u91cf\uff0c\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u6570\u636e---\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u8868\u4e2d\u7684\u6570\u636e\uff1a{}", uomFromUomMap);
            for (ItmItemUomConvCalcParam itmItemUomConvCalcParam : notMatchUomList) {
                BigDecimal ratio;
                ItmItemUomConvCalcRpcDTO itmItemUomCalc;
                String businessUom = itmItemUomConvCalcParam.getBusinessUom();
                Long itemId = itmItemUomConvCalcParam.getItemId();
                ItmItemUomRpcVO itmItemUomRpcVO = uomMap.get(itemId);
                String uom2 = itmItemUomRpcVO.getUom();
                ItmItemUomConvRpcDTO itmItemUomConvRpcDTO = uomFromUomMap.get(itemId);
                if (businessUom.equals(itmItemUomConvRpcDTO.getFromUom()) && uom2.equals(itmItemUomConvRpcDTO.getToUom())) {
                    itmItemUomCalc = new ItmItemUomConvCalcRpcDTO();
                    itmItemUomCalc.setItemId(itemId);
                    itmItemUomCalc.setMainUom(uom2);
                    itmItemUomCalc.setBusinessUom(businessUom);
                    ratio = itmItemUomConvRpcDTO.getRatio();
                    if (null != ratio) {
                        itmItemUomCalc.setConvertedNum(ratio.multiply(itmItemUomConvCalcParam.getConvertNum()));
                    } else {
                        itmItemUomCalc.setConvertedNum(itmItemUomConvCalcParam.getConvertNum());
                    }
                    result.add(itmItemUomCalc);
                    continue;
                }
                if (businessUom.equals(itmItemUomConvRpcDTO.getToUom()) && uom2.equals(itmItemUomConvRpcDTO.getFromUom())) {
                    itmItemUomCalc = new ItmItemUomConvCalcRpcDTO();
                    itmItemUomCalc.setItemId(itemId);
                    itmItemUomCalc.setMainUom(uom2);
                    itmItemUomCalc.setBusinessUom(businessUom);
                    ratio = itmItemUomConvRpcDTO.getRatio();
                    if (null != ratio && !BigDecimal.ZERO.equals(ratio)) {
                        itmItemUomCalc.setConvertedNum(ratio.divide(itmItemUomConvCalcParam.getConvertNum(), 4, RoundingMode.HALF_UP));
                    } else {
                        itmItemUomCalc.setConvertedNum(itmItemUomConvCalcParam.getConvertNum());
                    }
                    result.add(itmItemUomCalc);
                    continue;
                }
                throw new BusinessException("\u5546\u54c1:" + itmItemUomRpcVO.getItemName() + ",\u672a\u627e\u5230\u5c06\u8be5\u5355\u4f4d\u8f6c\u5316\u4e3a\u4e3b\u8ba1\u91cf\u5355\u4f4d\u7684\u7cfb\u6570");
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItmItemLifeStatusFilterVO getFilterCondition(String businessCode, String businExcuSignStatus) {
        ItmItemLifeStatusFilterVO result = new ItmItemLifeStatusFilterVO();
        if (StringUtils.isNotBlank((CharSequence)businessCode) && StringUtils.isNotBlank((CharSequence)businExcuSignStatus)) {
            List<ItmItemStatusConfigVO> statusVos = this.itmItemStatusConfigRepoProc.findStatusVOByBusinessCode(businessCode);
            if (CollectionUtils.isEmpty(statusVos)) {
                throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\u65e0\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e1a\u52a1\u7f16\u7801\uff1a" + businessCode);
            }
            ItmItemStatusConfigVO itmItemStatusConfigVO = statusVos.get(0);
            if (!itmItemStatusConfigVO.getConfigStatus().booleanValue()) return result;
            if (businExcuSignStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal())) {
                Boolean purcFlag = itmItemStatusConfigVO.getBusinExcuSignStatus3();
                if (null == purcFlag) {
                    throw new BusinessException("\u8be5\u4e1a\u52a1\u7f16\u7801\u5e76\u6ca1\u6709\u914d\u7f6e\u91c7\u8d2d\u51bb\u7ed3" + businessCode);
                }
                if (purcFlag.booleanValue()) return result;
                result.setPurcFreeze(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal());
                return result;
            } else {
                if (!businExcuSignStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal())) throw new BusinessException("\u9519\u8bef\u7684\u5546\u54c1\u51bb\u7ed3\u7c7b\u578b\uff1a" + businExcuSignStatus);
                Boolean saleFlag = itmItemStatusConfigVO.getBusinExcuSignStatus2();
                if (null == saleFlag) {
                    throw new BusinessException("\u8be5\u4e1a\u52a1\u7f16\u7801\u5e76\u6ca1\u6709\u914d\u7f6e\u9500\u552e\u51bb\u7ed3" + businessCode);
                }
                if (saleFlag.booleanValue()) return result;
                result.setSaleFreeze(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal());
            }
            return result;
        } else {
            if (!StringUtils.isBlank((CharSequence)businessCode) || !StringUtils.isBlank((CharSequence)businExcuSignStatus)) throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\u4e0e\u4e1a\u52a1\u6267\u884c\u6807\u8bc6\u72b6\u6001\u5fc5\u987b\u90fd\u4e3a\u7a7a\u6216\u90fd\u4e0d\u4e3a\u7a7a");
            return result;
        }
    }

    @Transactional
    public void saveItmItemBatch(List<ItmItemSaveParam> saveParam) {
        if (CollectionUtils.isNotEmpty(saveParam)) {
            saveParam.stream().forEach(t -> {
                if (t.getSpuId() == null) {
                    throw new BusinessException("\u5546\u54c1\uff1a" + t.getItemCode() + "\u7684SPU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                t.setSource(StringUtils.isNotEmpty((CharSequence)t.getSource()) ? t.getSource() : "GC");
            });
            for (ItmItemSaveParam param : saveParam) {
                ItmItemDO save = (ItmItemDO)this.itmItemRepo.save(ItmItemConvert.INSTANCE.copySaveParamToDo(param));
                if (!CollectionUtils.isNotEmpty((Collection)param.getItemPicList())) continue;
                List itemPicList = param.getItemPicList();
                itemPicList.stream().forEach(t -> t.setItemId(save.getId()));
                List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(itemPicList);
                this.itmItemAttachmentRepo.saveAll(doList);
            }
        }
    }

    @Transactional
    public void saveItmItemSpuBatch(List<ItmItemSpuSaveParam> saveParamList) {
        boolean checkFlag = this.checkSpuInfoRepeated(saveParamList);
        if (checkFlag) {
            throw new BusinessException("\u5546\u54c1\u5c5e\u6027\u4fe1\u606f\u91cd\u590d\u6216\u8005\u9879\u76ee\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        if (CollectionUtils.isNotEmpty(saveParamList)) {
            for (ItmItemSpuSaveParam spuSaveParam : saveParamList) {
                List itemList;
                String spuCode = this.sysNumberGeneratorWrapper.generate("ITEM_SPU_NO");
                spuSaveParam.setSpuCode(spuCode);
                ItmItemSpuDO itmItemSpuDO = ItmItemSpuConvert.INSTANCE.saveParamToDo(spuSaveParam);
                Long spuId = ((ItmItemSpuDO)this.itmItemSpuRepo.save(itmItemSpuDO)).getId();
                List itemPicList = spuSaveParam.getSpuPicList();
                if (CollectionUtils.isNotEmpty((Collection)itemPicList)) {
                    itemPicList.forEach(t -> t.setItemId(spuId));
                    List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(itemPicList);
                    this.itmItemAttachmentRepo.saveAll(doList);
                }
                List relevanceCatIdList = spuSaveParam.getRelevanceCatIdList();
                ArrayList<ItmItemRelevanceDTO> relevanceList = new ArrayList<ItmItemRelevanceDTO>();
                if (CollectionUtils.isNotEmpty((Collection)relevanceCatIdList)) {
                    relevanceCatIdList.forEach(t -> {
                        ItmItemRelevanceDTO dto = new ItmItemRelevanceDTO();
                        dto.setCatId(t);
                        dto.setItemId(spuId);
                        dto.setRelevanceType("TAIL");
                        relevanceList.add(dto);
                    });
                    List<ItmItemRelevanceDO> itmItemRelevanceDOS = ItmItemRelevanceConvert.INSTANCE.dtoToDoAll(relevanceList);
                    this.itemRelevanceRepo.saveAll(itmItemRelevanceDOS);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(itemList = spuSaveParam.getItemSaveParamList()))) continue;
                itemList.stream().forEach(t -> {
                    t.setSpuId(spuId);
                    t.setSpuCode(spuSaveParam.getSpuCode());
                    if (t.getMoq() == null || t.getMoq() == 0.0) {
                        t.setMoq(this.getSkuMoqBySpec((ItmItemSaveParam)t));
                    }
                    t.setItemAttr2((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr2()) ? t.getItemAttr2() + "/\u888b" : ""));
                    t.setItemAttr3((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr3()) ? t.getItemAttr3() + "/\u76d2" : ""));
                    t.setItemAttr4((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr4()) ? t.getItemAttr4() + "/\u7bb1" : ""));
                    t.setItemAttr(this.getItemAttrInfo((ItmItemSaveParam)t));
                    t.setSource(StringUtils.isNotEmpty((CharSequence)t.getSource()) ? t.getSource() : "GC");
                });
                for (ItmItemSaveParam saveParam : itemList) {
                    Long itemId = ((ItmItemDO)this.itmItemRepo.save(ItmItemConvert.INSTANCE.copySaveParamToDo(saveParam))).getId();
                    if (!CollectionUtils.isNotEmpty((Collection)saveParam.getItemPicList())) continue;
                    saveParam.getItemPicList().forEach(t -> t.setItemId(itemId));
                    List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(saveParam.getItemPicList());
                    this.itmItemAttachmentRepo.saveAll(doList);
                }
            }
        }
    }

    @Transactional
    public void saveItmItemSync(List<ItmItemSpuSaveParam> spuSaveParamList, List<ItmItemSaveParam> skuSaveParamList) {
        if (CollectionUtils.isNotEmpty(spuSaveParamList)) {
            ArrayList itmItemSpuDOList = new ArrayList();
            spuSaveParamList.forEach(param -> {
                ItmItemSpuDO itmItemSpuDO = ItmItemSpuConvert.INSTANCE.saveParamToDo((ItmItemSpuSaveParam)param);
                itmItemSpuDO.setSource("B2B");
                itmItemSpuDO.setBrand("A");
                itmItemSpuDOList.add(itmItemSpuDO);
            });
            this.itmItemSpuRepo.saveAll(itmItemSpuDOList);
        }
        if (CollectionUtils.isNotEmpty(skuSaveParamList)) {
            ArrayList itmItemDOList = new ArrayList();
            skuSaveParamList.forEach(param -> {
                ItmItemDO itemDO = ItmItemConvert.INSTANCE.copySaveParamToDo((ItmItemSaveParam)param);
                itemDO.setSource("B2B");
                itemDO.setSpuId(0L);
                itmItemDOList.add(itemDO);
            });
            this.itmItemRepo.saveAll(itmItemDOList);
        }
        this.itmItemRepo.updateSpuIdInfo("B2B");
    }

    @Transactional
    public void importItmItemSpuBatch(List<ItmItemSpuSaveParam> saveParamList) {
        if (CollectionUtils.isNotEmpty(saveParamList)) {
            for (ItmItemSpuSaveParam spuSaveParam : saveParamList) {
                String spuCode = this.sysNumberGeneratorWrapper.generate("ITEM_SPU_NO");
                spuSaveParam.setSpuCode(spuCode);
                ItmItemSpuDO itmItemSpuDO = ItmItemSpuConvert.INSTANCE.saveParamToDo(spuSaveParam);
                Long spuId = ((ItmItemSpuDO)this.itmItemSpuRepo.save(itmItemSpuDO)).getId();
                List itemList = spuSaveParam.getItemSaveParamList();
                if (!CollectionUtils.isNotEmpty((Collection)itemList)) continue;
                itemList.forEach(t -> {
                    t.setSpuId(spuId);
                    t.setSpuCode(spuSaveParam.getSpuCode());
                    if (t.getMoq() == null || t.getMoq() == 0.0) {
                        t.setMoq(this.getSkuMoqBySpec((ItmItemSaveParam)t));
                    }
                    t.setItemAttr2((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr2()) ? t.getItemAttr2() + "/\u888b" : ""));
                    t.setItemAttr3((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr3()) ? t.getItemAttr3() + "/\u76d2" : ""));
                    t.setItemAttr4((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr4()) ? t.getItemAttr4() + "/\u7bb1" : ""));
                    t.setItemAttr(this.getItemAttrInfo((ItmItemSaveParam)t));
                    t.setSource(StringUtils.isNotEmpty((CharSequence)t.getSource()) ? t.getSource() : "GC");
                });
                List<ItmItemDO> itemDOS = ItmItemConvert.INSTANCE.copySaveParamToDo(itemList);
                this.itmItemRepo.saveAll(itemDOS);
            }
        }
    }

    @Transactional
    public void updateItmItemSpuBatch(List<ItmItemSpuSaveParam> saveParamList) {
        boolean checkFlag = this.updateCheckSpuInfoRepeated(saveParamList);
        if (checkFlag) {
            throw new BusinessException("\u5546\u54c1\u5c5e\u6027\u4fe1\u606f\u91cd\u590d\u6216\u8005\u9879\u76ee\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        if (CollectionUtils.isNotEmpty(saveParamList)) {
            for (ItmItemSpuSaveParam spuSaveParam : saveParamList) {
                List itemList;
                Optional spuDo = this.itmItemSpuRepo.findById(spuSaveParam.getId());
                if (spuDo.isEmpty()) {
                    throw new BusinessException("\u4ea7\u54c1ID\uff1a" + spuSaveParam.getId() + "\u4e0d\u5b58\u5728");
                }
                ItmItemSpuConvert.INSTANCE.copySaveParamToDo(spuSaveParam, (ItmItemSpuDO)spuDo.get());
                Long spuId = ((ItmItemSpuDO)this.itmItemSpuRepo.save((ItmItemSpuDO)spuDo.get())).getId();
                List itemPicList = spuSaveParam.getSpuPicList();
                this.itmItemAttachmentRepo.deleteByItemId(spuId);
                if (CollectionUtils.isNotEmpty((Collection)itemPicList)) {
                    itemPicList.forEach(t -> t.setItemId(spuId));
                    List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(itemPicList);
                    this.itmItemAttachmentRepo.saveAll(doList);
                }
                List relevanceCatIdList = spuSaveParam.getRelevanceCatIdList();
                ArrayList<ItmItemRelevanceDTO> relevanceList = new ArrayList<ItmItemRelevanceDTO>();
                this.itemRelevanceRepo.deleteByItemIdIn(Collections.singletonList(spuId));
                if (CollectionUtils.isNotEmpty((Collection)relevanceCatIdList)) {
                    relevanceCatIdList.forEach(t -> {
                        ItmItemRelevanceDTO dto = new ItmItemRelevanceDTO();
                        dto.setCatId(t);
                        dto.setItemId(spuId);
                        dto.setRelevanceType("TAIL");
                        relevanceList.add(dto);
                    });
                    List<ItmItemRelevanceDO> itmItemRelevanceDOS = ItmItemRelevanceConvert.INSTANCE.dtoToDoAll(relevanceList);
                    this.itemRelevanceRepo.saveAll(itmItemRelevanceDOS);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(itemList = spuSaveParam.getItemSaveParamList()))) continue;
                itemList.forEach(t -> {
                    if (t.getMoq() == null || t.getMoq() == 0.0) {
                        t.setMoq(this.getSkuMoqBySpec((ItmItemSaveParam)t));
                    }
                    t.setItemAttr2((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr2()) ? t.getItemAttr2() + "/\u888b" : ""));
                    t.setItemAttr3((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr3()) ? t.getItemAttr3() + "/\u76d2" : ""));
                    t.setItemAttr4((String)(StringUtils.isNotEmpty((CharSequence)t.getItemAttr4()) ? t.getItemAttr4() + "/\u7bb1" : ""));
                    t.setItemAttr(this.getItemAttrInfo((ItmItemSaveParam)t));
                });
                List<Long> itemIdList = itemList.stream().map(ItmItemSaveParam::getId).collect(Collectors.toList());
                List<ItmItemDO> itemDoList = this.itmItemRepo.findByIdIn(itemIdList);
                ArrayList itemDoSaveList = new ArrayList();
                ArrayList attachmentDoList = new ArrayList();
                itemList.forEach(item -> {
                    ItmItemDO itemDO = (ItmItemDO)itemDoList.stream().filter(t -> t.getId().compareTo(item.getId()) == 0).collect(Collectors.toList()).get(0);
                    ItmItemConvert.INSTANCE.copySaveParamToDo((ItmItemSaveParam)item, itemDO);
                    itemDoSaveList.add(itemDO);
                    if (CollectionUtils.isNotEmpty((Collection)item.getItemPicList())) {
                        item.getItemPicList().forEach(t -> t.setItemId(item.getId()));
                        List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(item.getItemPicList());
                        attachmentDoList.addAll(doList);
                    }
                });
                this.itmItemRepo.saveAll(itemDoList);
                this.itmItemAttachmentRepo.deleteByItemIdIn(itemIdList);
                this.itmItemAttachmentRepo.saveAll(attachmentDoList);
            }
        }
    }

    private String getItemAttrInfo(ItmItemSaveParam item) {
        Object itemAttr = "";
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr2())) {
            itemAttr = (String)itemAttr + item.getItemAttr2() + " ";
        }
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr3())) {
            itemAttr = (String)itemAttr + item.getItemAttr3() + " ";
        }
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr4())) {
            itemAttr = (String)itemAttr + item.getItemAttr4();
        }
        return itemAttr;
    }

    private Double getSkuMoqBySpec(ItmItemSaveParam item) {
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr2())) {
            return Double.parseDouble(item.getItemAttr2());
        }
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr3())) {
            return Double.parseDouble(item.getItemAttr3());
        }
        if (StringUtils.isNotEmpty((CharSequence)item.getItemAttr4())) {
            return Double.parseDouble(item.getItemAttr4());
        }
        return 0.0;
    }

    private boolean checkSpuInfoRepeated(List<ItmItemSpuSaveParam> saveParamList) {
        for (ItmItemSpuSaveParam saveParam : saveParamList) {
            int disTotal;
            if (!CollectionUtils.isNotEmpty((Collection)saveParam.getItemSaveParamList())) continue;
            List<ItmItemCheckSaveParam> itmItemCheckSaveParams = ItmItemConvert.INSTANCE.saveParamToCheckParam(saveParam.getItemSaveParamList());
            int originalTotal = itmItemCheckSaveParams.size();
            if (originalTotal != (disTotal = itmItemCheckSaveParams.stream().distinct().collect(Collectors.toList()).size())) {
                return true;
            }
            List<String> codeList = saveParam.getItemSaveParamList().stream().map(ItmItemSaveParam::getItemCode).distinct().collect(Collectors.toList());
            if (originalTotal != codeList.size()) {
                return true;
            }
            List<ItmItemDO> itemCodeList = this.itmItemRepo.findByItemCodeIn(codeList);
            if (!CollectionUtils.isNotEmpty(itemCodeList)) continue;
            return true;
        }
        return false;
    }

    private boolean updateCheckSpuInfoRepeated(List<ItmItemSpuSaveParam> saveParamList) {
        for (ItmItemSpuSaveParam saveParam : saveParamList) {
            int disTotal;
            if (!CollectionUtils.isNotEmpty((Collection)saveParam.getItemSaveParamList())) continue;
            List<ItmItemCheckSaveParam> itmItemCheckSaveParams = ItmItemConvert.INSTANCE.saveParamToCheckParam(saveParam.getItemSaveParamList());
            int originalTotal = itmItemCheckSaveParams.size();
            if (originalTotal != (disTotal = itmItemCheckSaveParams.stream().distinct().collect(Collectors.toList()).size())) {
                return true;
            }
            List<String> codeList = saveParam.getItemSaveParamList().stream().map(ItmItemSaveParam::getItemCode).distinct().collect(Collectors.toList());
            if (originalTotal != codeList.size()) {
                return true;
            }
            List<Long> idList = saveParam.getItemSaveParamList().stream().map(ItmItemSaveParam::getId).distinct().collect(Collectors.toList());
            List<ItmItemDO> itemCodeList = this.itmItemRepo.findByIdInOrItemCodeIn(idList, codeList);
            if (originalTotal == itemCodeList.size()) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public Long deleteItmItemById(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
        }
        return this.itmItemRepoProc.deleteItmItemById(idList);
    }

    @Transactional
    public Long deleteItmItemSpuById(Long spuId) {
        if (spuId == null) {
            throw new BusinessException("\u5546\u54c1SPU_ID\u4e3a\u7a7a");
        }
        Long count = this.itmItemSpuRepoProc.deleteItmItemSpuById(spuId);
        if (count > 1L) {
            count = count + this.itmItemRepoProc.deleteItmItemBySpuId(spuId);
        }
        return count;
    }

    @Transactional
    public Long updateItmItemById(ItmItemSaveParam param) {
        if (param.getId() == null) {
            throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
        }
        Optional optional = this.itmItemRepo.findById(param.getId());
        if (optional.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230ID\uff1a" + param.getId() + "\u7684\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ItmItemConvert.INSTANCE.copySaveParamToDo(param, (ItmItemDO)optional.get());
        return ((ItmItemDO)this.itmItemRepo.save((ItmItemDO)optional.get())).getId();
    }

    @Transactional
    public Long updateItmItemSpuById(ItmItemSpuSaveParam param) {
        if (param.getId() == null) {
            throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
        }
        Optional optional = this.itmItemSpuRepo.findById(param.getId());
        if (optional.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230ID\uff1a" + param.getId() + "\u7684\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ItmItemSpuConvert.INSTANCE.copySaveParamToDo(param, (ItmItemSpuDO)optional.get());
        return ((ItmItemSpuDO)this.itmItemSpuRepo.save((ItmItemSpuDO)optional.get())).getId();
    }

    private List<OrderItem> initOrderColumn() {
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem itemTime = new OrderItem("createTime", false);
        orders.add(itemTime);
        return orders;
    }

    @SysCodeProc
    public PagingVO<ItmItemQueryDTO> queryItmItem(ItmItemQueryParam param) {
        long count;
        if (CollectionUtils.isEmpty((Collection)param.getOrders())) {
            param.setOrders(this.initOrderColumn());
        }
        if ((count = this.itmItemRepoProc.countItmItem(param)) > 0L) {
            List<ItmItemQueryDTO> list = this.itmItemRepoProc.queryItmItem(param);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @SysCodeProc
    public PagingVO<ItmItemSpuQueryDTO> queryItmItemSpu(ItmItemSpuQueryParam param) {
        long count;
        if (CollectionUtils.isEmpty((Collection)param.getOrders())) {
            param.setOrders(this.initOrderColumn());
        }
        if ((count = this.itmItemSpuRepoProc.countItmItemSpu(param)) > 0L) {
            List<ItmItemSpuQueryDTO> list = this.itmItemSpuRepoProc.queryItmItemSpu(param);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Transactional
    public void saveItmItemPic(List<ItmItemPicDTO> param) {
        if (CollectionUtils.isNotEmpty(param)) {
            ArrayList<Long> idList = new ArrayList<Long>();
            param.stream().forEach(t -> {
                if (t.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
                }
                idList.add(t.getItemId());
            });
            this.itmItemAttachmentRepo.deleteByItemIdIn(idList);
            List<ItmItemAttachmentDO> doList = ItmItemAttachmentConvert.INSTANCE.itemPicToItemAtt(param);
            this.itmItemAttachmentRepo.saveAll(doList);
        }
    }

    @SysCodeProc
    public ItmItemSpuQueryDTO queryItmItemSpuById(Long id) {
        if (id == null) {
            throw new BusinessException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional optional = this.itmItemSpuRepo.findById(id);
        if (optional.isEmpty()) {
            return null;
        }
        return ItmItemSpuConvert.INSTANCE.doToQueryDto((ItmItemSpuDO)optional.get());
    }

    public List<ItmItemPicDTO> queryItmItemPic(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
        }
        List<ItmItemAttachmentDO> doList = this.itmItemAttachmentRepo.findItmItemAttachmentDOSByItemIdIn(idList);
        return ItmItemAttachmentConvert.INSTANCE.itemPicDoToItemPicDto(doList);
    }

    public List<ItmItemRelevanceDTO> queryItemRelevance(Long itemId) {
        if (itemId == null) {
            throw new BusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
        }
        List<ItmItemRelevanceDO> relevanceList = this.itemRelevanceRepo.findByItemId(itemId);
        return ItmItemRelevanceConvert.INSTANCE.doToDtoAll(relevanceList);
    }

    public List<YstServicesetDTO> findbyservice() {
        YstServicesetParamVO ystServicesetParamVO = new YstServicesetParamVO();
        List<YstServicesetRespVO> ystServicesetRespVOS = this.ystServicesetRepoProc.search(ystServicesetParamVO);
        List<YstServicesetDTO> ystServicesetDTOList = YstServicesetConvert.INSTANCE.respVOToDTO(ystServicesetRespVOS);
        return ystServicesetDTOList;
    }

    @Transactional
    public void saveItemRelevance(List<ItmItemRelevanceDTO> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List<Long> itemIdList = dtoList.stream().map(ItmItemRelevanceDTO::getItemId).distinct().collect(Collectors.toList());
            long deleteCount = this.itemRelevanceRepo.deleteByItemIdIn(itemIdList);
            List<ItmItemRelevanceDO> relevanceList = ItmItemRelevanceConvert.INSTANCE.dtoToDoAll(dtoList);
            this.itemRelevanceRepo.saveAll(relevanceList);
            log.info("\u5220\u9664\u5173\u8054\u4ea7\u54c1\u6570\u91cf\uff1a{}\u4e2a\uff0c\u65b0\u589e\u5173\u8054\u4ea7\u54c1\uff1a{}\u4e2a", (Object)deleteCount, (Object)dtoList.size());
        }
    }

    public ConvertUomRatioDTO convertUomRatio(ConvertUomRatioParam payload) {
        List<ItmItemUomConvRpcDTO> convs4;
        List<ItmItemUomConvRpcDTO> convs3;
        List<ItmItemUomConvRpcDTO> convs2;
        ConvertUomRatioDTO result = new ConvertUomRatioDTO();
        List<ItmItemUomConvRpcDTO> convs1 = this.extracted(payload.getFromUom(), payload.getToUom(), payload.getItemId());
        if (CollectionUtils.isNotEmpty(convs1)) {
            result.setFromTo(convs1.get(0).getRatio());
        }
        if (CollectionUtils.isNotEmpty(convs2 = this.extracted(payload.getToUom(), payload.getFromUom(), payload.getItemId()))) {
            result.setToFrom(convs2.get(0).getRevertRatio());
        }
        String midUom = payload.getMidUom();
        if (StringUtils.isEmpty((CharSequence)payload.getMidUom())) {
            CommonItmItemParamVO itemParamVO = new CommonItmItemParamVO();
            itemParamVO.setItemId(payload.getItemId());
            List<CommonItmItemDTO> itemDTOS = this.srmItmItemRepoProc.commonItemSelect(itemParamVO);
            if (CollUtil.isEmpty(itemDTOS)) {
                throw new BusinessException("\u7269\u6599\u4e0d\u5b58\u5728");
            }
            midUom = itemDTOS.get(0).getUom();
        }
        if (CollectionUtils.isNotEmpty(convs3 = this.extracted(payload.getFromUom(), midUom, payload.getItemId()))) {
            result.setFromMid(convs3.get(0).getRatio());
        }
        if (CollectionUtils.isNotEmpty(convs4 = this.extracted(payload.getToUom(), midUom, payload.getItemId()))) {
            result.setToMid(convs4.get(0).getRatio());
        }
        return result;
    }

    private List<ItmItemUomConvRpcDTO> extracted(String fromUom, String toUom, Long itemId) {
        ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
        param.setFromUom(fromUom);
        param.setToUom(toUom);
        param.setItemIds(Arrays.asList(itemId));
        param.setFromUomType("A");
        param.setToUomType("A");
        return this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(param);
    }

    public List<String> existItemCode(List<String> itemCodes) {
        List<String> itemCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            itemCodeList = this.itmItemRepoProc.existItemCode(itemCodes);
        }
        return itemCodeList;
    }

    public ItmItemRpcServiceImpl(YstServicesetRepoProc ystServicesetRepoProc, ItmItemRpcRepoProc itmItemRpcRepoProc, GeneralYstServicesetProvider generalYstServicesetProvider, ItmItemRepo itmItemRepo, ItmItemRepoProc itmItemRepoProc, ItmItemSpuRepo itmItemSpuRepo, ItmItemSpuRepoProc itmItemSpuRepoProc, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmItemAttachmentRepo itmItemAttachmentRepo, ItmItemRelevanceRepo itemRelevanceRepo, SrmItmItemRepoProc srmItmItemRepoProc, ItmItemUomConvRpcRepoProc itmItemUomConvRpcRepoProc, ItmItemCateContrRpcPropRepoProc itmItemCateContrRpcPropRepoProc, ItmItemCateRpcRepoProc itmItemCateRpcRepoProc, ItmItemBusinessRpcRepoProc itmItemBusinessRpcRepoProc, ItmItemStatusConfigRpcRepoProc itmItemStatusConfigRpcRepoProc, ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc, ItmItemLifeStatusRepoProc itmItemLifeStatusRepoProc, ItmCheckLifeStatusService itmCheckLifeStatusService, ItmItemCateService itmItemCateService) {
        this.ystServicesetRepoProc = ystServicesetRepoProc;
        this.itmItemRpcRepoProc = itmItemRpcRepoProc;
        this.generalYstServicesetProvider = generalYstServicesetProvider;
        this.itmItemRepo = itmItemRepo;
        this.itmItemRepoProc = itmItemRepoProc;
        this.itmItemSpuRepo = itmItemSpuRepo;
        this.itmItemSpuRepoProc = itmItemSpuRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmItemAttachmentRepo = itmItemAttachmentRepo;
        this.itemRelevanceRepo = itemRelevanceRepo;
        this.srmItmItemRepoProc = srmItmItemRepoProc;
        this.itmItemUomConvRpcRepoProc = itmItemUomConvRpcRepoProc;
        this.itmItemCateContrRpcPropRepoProc = itmItemCateContrRpcPropRepoProc;
        this.itmItemCateRpcRepoProc = itmItemCateRpcRepoProc;
        this.itmItemBusinessRpcRepoProc = itmItemBusinessRpcRepoProc;
        this.itmItemStatusConfigRpcRepoProc = itmItemStatusConfigRpcRepoProc;
        this.itmItemStatusConfigRepoProc = itmItemStatusConfigRepoProc;
        this.itmItemLifeStatusRepoProc = itmItemLifeStatusRepoProc;
        this.itmCheckLifeStatusService = itmCheckLifeStatusService;
        this.itmItemCateService = itmItemCateService;
    }
}

