/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.provider;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemRespVO;
import com.elitesland.yst.srmdomain.proportion.entity.YstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepo;
import com.elitesland.yst.srmdomain.suppitem.entity.YstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepo;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.YstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13Repo;
import com.elitesland.yst.supportdomain.provider.item.service.YstSuppItemRpcService;
import com.elitesland.yst.supportdomain.provider.item.vo.YstSuppItemSaveVO;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@UnicomTag(value="GENERAL")
public class YstSuppItemServiceImpl
implements YstSuppItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(YstSuppItemServiceImpl.class);
    private final YstSuppItemRepo ystSuppItemRepo;
    private final YstSuppC13Repo ystSuppC13Repo;
    private final YstItemProportionRepo ystItemProportionRepo;
    private final SrmItmItemRepoProc itmItemRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public void autoSaveSuppItem(YstSuppItemSaveVO payload) {
        List itemIds = payload.getItemIds();
        for (Long itemId : itemIds) {
            boolean exists;
            SrmItmItemRespVO itemDO = this.itmItemRepoProc.findItemById(itemId);
            if (null == itemDO || (exists = this.ystSuppItemRepo.existsBySuppIdAndItemId(payload.getSuppId(), itemId))) continue;
            YstSuppItemDO suppItem = new YstSuppItemDO().setOuId(payload.getOuId()).setSuppId(payload.getSuppId()).setSuppCode(payload.getSuppCode()).setItemCode(itemDO.getItemCode()).setItemCateCode(itemDO.getItemCateCode()).setItemId(itemId);
            this.ystSuppItemRepo.save(suppItem);
            boolean prop = this.ystItemProportionRepo.existsBySuppIdAndItemId(payload.getSuppId(), itemId);
            if (!prop) {
                YstItemProportionDO proportionDO = new YstItemProportionDO().setOuId(payload.getOuId()).setSuppId(payload.getSuppId()).setSuppCode(payload.getSuppCode()).setItemCode(itemDO.getItemCode()).setItemCateCode(itemDO.getItemCateCode()).setItemId(itemId);
                this.ystItemProportionRepo.save(proportionDO);
            }
            if (!StrUtil.isNotBlank((CharSequence)itemDO.getC3Code()) || this.ystSuppC13Repo.existsBySuppIdAndC3Code(payload.getSuppId(), itemDO.getC3Code())) continue;
            YstSuppC13DO suppC13 = new YstSuppC13DO().setOuId(payload.getOuId()).setSuppId(payload.getSuppId()).setSuppCode(payload.getSuppCode()).setItemCateCode(itemDO.getItemCateCode()).setC1Code(itemDO.getC1Code()).setC2Code(itemDO.getC2Code()).setC3Code(itemDO.getC3Code());
            this.ystSuppC13Repo.save(suppC13);
        }
    }

    public YstSuppItemServiceImpl(YstSuppItemRepo ystSuppItemRepo, YstSuppC13Repo ystSuppC13Repo, YstItemProportionRepo ystItemProportionRepo, SrmItmItemRepoProc itmItemRepoProc) {
        this.ystSuppItemRepo = ystSuppItemRepo;
        this.ystSuppC13Repo = ystSuppC13Repo;
        this.ystItemProportionRepo = ystItemProportionRepo;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

