/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.supportdomain.item.dto.ItmBrandDTO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBrandExportEntity;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBrandSystemExport;
import com.elitesland.yst.supportdomain.item.param.ItmBrandPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmBrandRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;

    public com.elitesland.yst.common.base.PagingVO<ItmBrandPagingVO> findBrandPagingResults(ItmBrandPagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandPagingVO.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.id, ItmBrandRepoProc.itmBrand.brandCode, ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandEnName, ItmBrandRepoProc.itmBrand.brandInitial, ItmBrandRepoProc.itmBrand.fileCode, ItmBrandRepoProc.itmBrand.originalName, ItmBrandRepoProc.itmBrand.status})).from((EntityPath)itmBrand);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)param.getBrandCodeName())) {
            String likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(ItmBrandRepoProc.itmBrand.brandCode.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandName.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandEnName.like(likeStr))));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getStatus())) {
            predicates.add(ItmBrandRepoProc.itmBrand.status.eq((Object)param.getStatus()));
        }
        predicates.add(ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0).or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, itmBrand);
        param.setPaging(query);
        return com.elitesland.yst.common.base.PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmBrandVO findDetailsById(Long id) {
        return (ItmBrandVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandVO.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.id, ItmBrandRepoProc.itmBrand.brandCode, ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandEnName, ItmBrandRepoProc.itmBrand.brandInitial, ItmBrandRepoProc.itmBrand.fileCode, ItmBrandRepoProc.itmBrand.originalName, ItmBrandRepoProc.itmBrand.status})).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.id.eq((Object)id))).fetchOne();
    }

    public void updateStatusByIds(List<Long> ids, String status) {
        this.jpaQueryFactory.update((EntityPath)itmBrand).set((Path)ItmBrandRepoProc.itmBrand.status, (Object)status).where(new Predicate[]{ItmBrandRepoProc.itmBrand.id.in(ids)}).execute();
    }

    public void softDeleteById(Long id) {
        this.jpaQueryFactory.update((EntityPath)itmBrand).set(ItmBrandRepoProc.itmBrand.deleteFlag, (Object)1).where(new Predicate[]{ItmBrandRepoProc.itmBrand.id.eq((Object)id)}).execute();
    }

    public List<ItmBrandDTO> findAllBrandDto() {
        return this.selectBrandDto().fetch();
    }

    private JPAQuery<ItmBrandDTO> selectBrandDto() {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandDTO.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandCode})).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull().or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0)));
    }

    public List<ItmBrandExportEntity> findAllBrandExcelEntity(ItmBrandPagingParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandExportEntity.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandEnName, ItmBrandRepoProc.itmBrand.brandInitial, ItmBrandRepoProc.itmBrand.fileCode})).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull().or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0)));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)param.getBrandCodeName())) {
            String likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(ItmBrandRepoProc.itmBrand.brandCode.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandName.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandEnName.like(likeStr))));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getStatus())) {
            predicates.add(ItmBrandRepoProc.itmBrand.status.eq((Object)param.getStatus()));
        }
        predicates.add(ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0).or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(jpaQuery, itmBrand);
        return jpaQuery.fetch();
    }

    public PagingVO<ItmBrandSystemExport> findBrandExcelEntity(ItmBrandPagingParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandSystemExport.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandEnName, ItmBrandRepoProc.itmBrand.brandInitial, ItmBrandRepoProc.itmBrand.fileCode})).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull().or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0)));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)param.getBrandCodeName())) {
            String likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(ItmBrandRepoProc.itmBrand.brandCode.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandName.like(likeStr).or((Predicate)ItmBrandRepoProc.itmBrand.brandEnName.like(likeStr))));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getStatus())) {
            predicates.add(ItmBrandRepoProc.itmBrand.status.eq((Object)param.getStatus()));
        }
        predicates.add(ItmBrandRepoProc.itmBrand.deleteFlag.eq((Object)0).or((Predicate)ItmBrandRepoProc.itmBrand.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(jpaQuery, itmBrand);
        param.setPaging(jpaQuery);
        return PagingVO.builder().total(Long.valueOf(jpaQuery.fetchCount())).records(jpaQuery.fetch()).build();
    }

    public List<ItmBrandVO> getBrandNameByCode(List<String> brandCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandVO.class, (Expression[])new Expression[]{ItmBrandRepoProc.itmBrand.brandName, ItmBrandRepoProc.itmBrand.brandCode})).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.brandCode.in(brandCodes))).fetch();
    }

    public List<String> findBrandCodeByBuName(String buName) {
        String likeStr = "%" + buName + "%";
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ItmBrandRepoProc.itmBrand.brandCode).from((EntityPath)itmBrand)).where((Predicate)ItmBrandRepoProc.itmBrand.brandName.like(likeStr))).fetch();
    }

    public ItmBrandRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

