/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.entity.QItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemCateDO;
import com.elitesland.yst.supportdomain.item.param.ItmCateContrParaSearchParam;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmCateContrParaRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmCateContrParaDO itmCateContrPara = QItmCateContrParaDO.itmCateContrParaDO;

    public PagingVO<ItmCateContrParaPagingVO> searchPagingByCode(ItmCateContrParaSearchParam param) {
        QItmItemCateDO itmItemCate = QItmItemCateDO.itmItemCateDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmCateContrParaPagingVO.class, (Expression[])new Expression[]{this.itmCateContrPara.id, this.itmCateContrPara.controlParamCode, this.itmCateContrPara.controlParamValue, this.itmCateContrPara.sortNo, this.itmCateContrPara.status, itmItemCate.itemCateCode, itmItemCate.itemCateName})).from((EntityPath)this.itmCateContrPara)).innerJoin((EntityPath)itmItemCate)).on((Predicate)itmItemCate.itemCateCode.eq((Expression)this.itmCateContrPara.itemCateCode).and((Predicate)itmItemCate.deleteFlag.isNull().or((Predicate)itmItemCate.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)param.getCateCodeName())) {
            String likeStr = "%" + param.getCateCodeName() + "%";
            predicates.add(itmItemCate.itemCateCode.like(likeStr).or((Predicate)itmItemCate.itemCateName.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getStatus())) {
            predicates.add(this.itmCateContrPara.status.eq((Object)param.getStatus()));
        }
        predicates.add(this.itmCateContrPara.deleteFlag.isNull().or((Predicate)this.itmCateContrPara.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmCateContrPara);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmCateContrParaDetailsVO searchDetailsById(Long id) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmCateContrParaDetailsVO.class, (Expression[])new Expression[]{this.itmCateContrPara.id, this.itmCateContrPara.itemCateCode, this.itmCateContrPara.controlParamCode, this.itmCateContrPara.controlParamValue, this.itmCateContrPara.sortNo, this.itmCateContrPara.status})).from((EntityPath)this.itmCateContrPara)).where((Predicate)this.itmCateContrPara.id.eq((Object)id));
        return (ItmCateContrParaDetailsVO)query.fetchOne();
    }

    public List<ItmCateContrParaVO> findParamsByItemCateCode(String itemCateCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmCateContrParaVO.class, (Expression[])new Expression[]{this.itmCateContrPara.id, this.itmCateContrPara.itemCateCode, this.itmCateContrPara.controlParamCode, this.itmCateContrPara.controlParamValue})).from((EntityPath)this.itmCateContrPara)).where((Predicate)this.itmCateContrPara.itemCateCode.eq((Object)itemCateCode).and((Predicate)this.itmCateContrPara.deleteFlag.isNull().or((Predicate)this.itmCateContrPara.deleteFlag.eq((Object)0))))).orderBy(this.itmCateContrPara.sortNo.asc())).fetch();
    }

    public void softDeleteById(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.itmCateContrPara).set(this.itmCateContrPara.deleteFlag, (Object)1).where(new Predicate[]{this.itmCateContrPara.id.eq((Object)id)}).execute();
    }

    public void softDeleteByItemCateCode(String itemCateCode) {
        this.jpaQueryFactory.update((EntityPath)this.itmCateContrPara).set(this.itmCateContrPara.deleteFlag, (Object)1).where(new Predicate[]{this.itmCateContrPara.itemCateCode.eq((Object)itemCateCode)}).execute();
    }

    public void updateValueByCodeAndItemCateCode(String itemCateCode, String code, String value) {
        this.jpaQueryFactory.update((EntityPath)this.itmCateContrPara).set((Path)this.itmCateContrPara.controlParamValue, (Object)value).where(new Predicate[]{this.itmCateContrPara.itemCateCode.eq((Object)itemCateCode).and((Predicate)this.itmCateContrPara.controlParamCode.eq((Object)code))}).execute();
    }

    public List<ItmCateContrParaVO> findParamsByItemCateCodeSet(Set<String> itemCateCodeSet) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmCateContrParaVO.class, (Expression[])new Expression[]{this.itmCateContrPara.id, this.itmCateContrPara.itemCateCode, this.itmCateContrPara.controlParamCode, this.itmCateContrPara.controlParamValue})).from((EntityPath)this.itmCateContrPara)).where((Predicate)this.itmCateContrPara.itemCateCode.in(itemCateCodeSet).and((Predicate)this.itmCateContrPara.deleteFlag.isNull().or((Predicate)this.itmCateContrPara.deleteFlag.eq((Object)0))))).orderBy(this.itmCateContrPara.sortNo.asc())).fetch();
    }

    public ItmCateContrParaRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

