/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemBomDTO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBomDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmItemBomExportEntity;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBomDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBomPagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemBomRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemBomDO itmItemBom = QItmItemBomDO.itmItemBomDO;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
    private final QBean<ItmItemBomDetailsVO> itemBomDetailsVO;

    public com.elitesland.yst.common.base.PagingVO<ItmItemBomPagingVO> itemBomPagingSearch(ItmItemBomPagingParam param) {
        String likeStr;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBomPagingVO.class, (Expression[])new Expression[]{this.itmItemBom.id, this.itmItem.brand, this.itmBrand.brandName, this.itmItemBom.itemId, this.itmItem.itemName, this.itmItem.itemCode, this.itmItem.itemAbbr, this.itmItem.spec, this.itmItemBom.generalAccessoriesSpec, this.itmItemBom.qty, this.itmItem.uom, this.itmItemBom.pid, this.itmItemBom.grade, this.itmItemBom.remark})).from((EntityPath)this.itmItemBom)).innerJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.id.eq(this.itmItemBom.itemId))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCodeName())) {
            likeStr = "%" + param.getItemCodeName() + "%";
            predicates.add(this.itmItem.itemCode.like(likeStr).or((Predicate)this.itmItem.itemName.like(likeStr).or((Predicate)this.itmItem.itemAbbr.like(likeStr))));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSpec())) {
            likeStr = "%" + param.getSpec() + "%";
            predicates.add(this.itmItem.spec.like(likeStr));
        }
        if (param.getPid() != null) {
            predicates.add(this.itmItemBom.pid.eq((Object)param.getPid()));
        }
        predicates.add(this.itmItemBom.deleteFlag.isNull().or((Predicate)this.itmItemBom.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItemBom);
        param.setPaging(query);
        return com.elitesland.yst.common.base.PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemBomDetailsVO findBomDetailsById(Long id) {
        JPAQuery query = this.jpaQueryFactory.select(this.itemBomDetailsVO);
        this.detailsVoFrom((JPAQuery<ItmItemBomDetailsVO>)query);
        query.where((Predicate)this.itmItemBom.id.eq((Object)id).and((Predicate)this.itmItemBom.deleteFlag.isNull().or((Predicate)this.itmItemBom.deleteFlag.eq((Object)0))));
        return (ItmItemBomDetailsVO)query.fetchOne();
    }

    public List<ItmItemBomDetailsVO> findBomDetailsByPid(Long pid) {
        JPAQuery query = this.jpaQueryFactory.select(this.itemBomDetailsVO);
        this.detailsVoFrom((JPAQuery<ItmItemBomDetailsVO>)query);
        query.where((Predicate)this.itmItemBom.pid.eq((Object)pid).and((Predicate)this.itmItemBom.deleteFlag.isNull().or((Predicate)this.itmItemBom.deleteFlag.eq((Object)0))));
        return query.fetch();
    }

    private void detailsVoFrom(JPAQuery<ItmItemBomDetailsVO> query) {
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.from((EntityPath)this.itmItemBom)).innerJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.id.eq(this.itmItemBom.itemId))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))));
    }

    public void softDeleteBomByIds(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.itmItemBom).set(this.itmItemBom.deleteFlag, (Object)1).where(new Predicate[]{this.itmItemBom.id.in(ids)}).execute();
    }

    public List<Long> findIdsByPid(Long pid) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItemBom.id).from((EntityPath)this.itmItemBom)).where((Predicate)this.itmItemBom.pid.eq((Object)pid))).fetch();
    }

    public List<ItmItemBomDTO> findAllBomDto() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBomDTO.class, (Expression[])new Expression[]{this.itmItemBom.id, this.itmItemBom.pid, this.itmItem.itemCode})).from((EntityPath)this.itmItemBom)).innerJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.id.eq(this.itmItemBom.itemId))).where((Predicate)this.itmItemBom.deleteFlag.isNull().or((Predicate)this.itmItemBom.deleteFlag.eq((Object)0)))).fetch();
    }

    public PagingVO<ItmItemBomExportEntity> itemBomExportSearch(ItmItemBomPagingParam param) {
        String likeStr;
        QItmItemBomDO itmItemBom1 = new QItmItemBomDO("itmItemBom1");
        QItmItemDO itmItem1 = new QItmItemDO("itmItemDO1");
        QItmBrandDO itmBrand1 = new QItmBrandDO("itmBrandDO1");
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBomExportEntity.class, (Expression[])new Expression[]{this.itmItem.itemName, this.itmItem.itemCode, this.itmBrand.brandName, this.itmItem.spec, this.itmItem.uom, this.itmItem.remark, itmItem1.itemName.as("itemName1"), itmItem1.itemCode.as("itemCode1"), itmBrand1.brandName.as("brandName1"), itmItem1.spec.as("spec1"), itmItem1.uom.as("uom1"), itmItemBom1.qty, itmItemBom1.generalAccessoriesSpec, itmItemBom1.remark.as("remark1")})).from((EntityPath)this.itmItemBom)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.id.eq(this.itmItemBom.itemId))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))))).leftJoin((EntityPath)itmItemBom1)).on((Predicate)this.itmItemBom.id.eq(itmItemBom1.pid))).leftJoin((EntityPath)itmItem1)).on((Predicate)itmItem1.id.eq(itmItemBom1.itemId))).leftJoin((EntityPath)itmBrand1)).on((Predicate)itmBrand1.brandCode.eq((Expression)itmItem1.brand).and((Predicate)itmBrand1.deleteFlag.isNull().or((Predicate)itmBrand1.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCodeName())) {
            likeStr = "%" + param.getItemCodeName() + "%";
            predicates.add(this.itmItem.itemCode.like(likeStr).or((Predicate)this.itmItem.itemName.like(likeStr).or((Predicate)this.itmItem.itemAbbr.like(likeStr))));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSpec())) {
            likeStr = "%" + param.getSpec() + "%";
            predicates.add(this.itmItem.spec.like(likeStr));
        }
        if (param.getPid() != null) {
            predicates.add(this.itmItemBom.pid.eq((Object)param.getPid()));
        }
        predicates.add(this.itmItemBom.deleteFlag.isNull().or((Predicate)this.itmItemBom.deleteFlag.eq((Object)0)));
        ((JPAQuery)query.where(ExpressionUtils.allOf(predicates))).orderBy(new OrderSpecifier[]{new OrderSpecifier(Order.DESC, itmItemBom1.createTime), new OrderSpecifier(Order.DESC, (Expression)this.itmItem.itemCode)});
        param.fillOrders(query, this.itmItemBom);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemBomRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemBomDetailsVO = Projections.bean(ItmItemBomDetailsVO.class, (Expression[])new Expression[]{this.itmItemBom.id, this.itmItem.brand, this.itmBrand.brandName, this.itmItemBom.itemId, this.itmItem.itemName, this.itmItem.itemCode, this.itmItem.itemAbbr, this.itmItem.spec, this.itmItemBom.generalAccessoriesSpec, this.itmItemBom.qty, this.itmItem.uom, this.itmItemBom.pid, this.itmItemBom.grade, this.itmItemBom.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

