/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBusinessExportBEntity;
import com.elitesland.yst.supportdomain.item.excel.entity.ItmBusinessExportEntity;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessDetailVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuAndSourceVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemBusinessRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmItemBusinessDO itmItemBusinessDO = QItmItemBusinessDO.itmItemBusinessDO;

    public com.elitesland.yst.common.base.PagingVO<ItmItemBusinessPagingVO> selectPagingResult(ItmItemBusinessPagingParam param, List<String> buCodes) {
        String likeStr;
        QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessPagingVO.class, (Expression[])new Expression[]{this.itmItemBusinessDO.id, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.itemCateCode, itmBrand.brandName, this.itmItem.suppName, this.itmItemBusinessDO.allocType, this.itmItemBusinessDO.taxRateNo, this.itmItemBusinessDO.taxRateNo2, this.itmItemBusinessDO.taxRateTariff, this.itmItemBusinessDO.installFlag, this.itmItemBusinessDO.returnExchangeFlag, this.itmItemBusinessDO.warrantyFlag, this.itmItemBusinessDO.createTime})).from((EntityPath)this.itmItemBusinessDO)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.spuId.eq(this.itmItemBusinessDO.spuId).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).leftJoin((EntityPath)itmBrand)).on((Predicate)itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)itmBrand.deleteFlag.isNull().or((Predicate)itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isEmpty(buCodes)) {
            return null;
        }
        predicates.add(this.itmItemBusinessDO.buCode.in(buCodes));
        if (!StringUtils.isBlank((CharSequence)param.getSpuCodeName())) {
            likeStr = "%" + param.getSpuCodeName() + "%";
            predicates.add(this.itmItem.spuCode.like(likeStr).or((Predicate)this.itmItem.spuName.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getBrand())) {
            likeStr = "%" + param.getBrand() + "%";
            predicates.add(itmBrand.brandCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getBrandName())) {
            likeStr = "%" + param.getBrandName() + "%";
            predicates.add(itmBrand.brandName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            likeStr = "%" + param.getItemCateCode() + "%";
            predicates.add(this.itmItem.itemCateCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppName())) {
            likeStr = "%" + param.getSuppName() + "%";
            predicates.add(this.itmItem.suppName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppCode())) {
            predicates.add(this.itmItem.suppCode.eq((Object)param.getSuppCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemStatus())) {
            predicates.add(this.itmItem.itemStatus.eq((Object)param.getItemStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getBuTreeDIds())) {
            predicates.add(this.itmItemBusinessDO.buTreeDId.in(param.getBuTreeDIds()));
        }
        predicates.add(this.itmItemBusinessDO.deleteFlag.isNull().or((Predicate)this.itmItemBusinessDO.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        query.groupBy(this.itmItem.spuId);
        param.fillOrders(query, this.itmItemBusinessDO);
        param.setPaging(query);
        return com.elitesland.yst.common.base.PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemBusinessDetailVO searchItmItemBusinessDetail(Long id) {
        QItmBrandDO brand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessDetailVO.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.spuAbbr, this.itmItem.itemType, this.itmItem.itemStatus, this.itmItem.itemCateCode, this.itmItem.barCode, brand.id.as("brandId"), this.itmItem.brand, brand.brandName, this.itmItem.suppId, this.itmItem.suppCode, this.itmItem.suppAbbr, this.itmItem.suppName, this.itmItem.spec, this.itmItemBusinessDO.allocType, this.itmItemBusinessDO.taxRateNo, this.itmItemBusinessDO.taxRateNo2, this.itmItemBusinessDO.taxRateTariff, this.itmItemBusinessDO.installFlag, this.itmItemBusinessDO.returnExchangeFlag, this.itmItemBusinessDO.returnExchangePolicy, this.itmItemBusinessDO.warrantyFlag, this.itmItemBusinessDO.warrantyPeriod, this.itmItemBusinessDO.warrantyPeriodUnit, this.itmItemBusinessDO.buCode})).from((EntityPath)this.itmItemBusinessDO)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItemBusinessDO.spuId.eq(this.itmItem.spuId).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).leftJoin((EntityPath)brand)).on((Predicate)brand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)brand.deleteFlag.isNull().or((Predicate)brand.deleteFlag.eq((Object)0))))).where((Predicate)this.itmItemBusinessDO.id.eq((Object)id).and((Predicate)this.itmItemBusinessDO.deleteFlag.isNull().or((Predicate)this.itmItemBusinessDO.deleteFlag.eq((Object)0))))).groupBy(this.itmItem.spuId);
        return (ItmItemBusinessDetailVO)query.fetchOne();
    }

    public List<ItmItemBusinessDO> getBusinessDoBySpuCodeAndItemSource(List<ItmItemSpuAndSourceVO> vos) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        for (ItmItemSpuAndSourceVO vo : vos) {
            predicates.add(this.itmItemBusinessDO.itemSource.eq((Object)vo.getItemSource()).and((Predicate)this.itmItemBusinessDO.spuCode.eq((Object)vo.getSpuCode())));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItemBusinessDO).from((EntityPath)this.itmItemBusinessDO)).where(ExpressionUtils.anyOf(predicates))).fetch();
    }

    public List<ItmBusinessExportBEntity> getExportBusinessData(ItmItemBusinessPagingParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itmItemBusinessDO.buCode.eq((Object)param.getBuCode()));
        }
        predicates.add(this.itmItemBusinessDO.deleteFlag.isNull().or((Predicate)this.itmItemBusinessDO.deleteFlag.eq((Object)0)));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBusinessExportBEntity.class, (Expression[])new Expression[]{this.itmItemBusinessDO.spuCode, this.itmItemBusinessDO.allocType, this.itmItemBusinessDO.taxRateNo, this.itmItemBusinessDO.taxRateNo2, this.itmItemBusinessDO.taxRateTariff, this.itmItemBusinessDO.installFlag, this.itmItemBusinessDO.returnExchangeFlag, this.itmItemBusinessDO.returnExchangePolicy, this.itmItemBusinessDO.warrantyFlag, this.itmItemBusinessDO.warrantyPeriod, this.itmItemBusinessDO.warrantyPeriodUnit, this.itmItemBusinessDO.buCode})).from((EntityPath)this.itmItemBusinessDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public PagingVO<ItmBusinessExportEntity> getExportItemSkuData(ItmItemBusinessPagingParam param, List<String> brandCodes) {
        String likeStr;
        QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)param.getBrand())) {
            likeStr = "%" + param.getBrand() + "%";
            predicates.add(itmBrand.brandCode.like(likeStr).or((Predicate)itmBrand.brandName.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSpuCodeName())) {
            likeStr = "%" + param.getSpuCodeName() + "%";
            predicates.add(this.itmItem.spuCode.like(likeStr).or((Predicate)this.itmItem.spuName.like(likeStr)));
        }
        if (CollectionUtils.isNotEmpty(brandCodes)) {
            predicates.add(this.itmItem.brand.in(brandCodes));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppName())) {
            likeStr = "%" + param.getSuppName() + "%";
            predicates.add(this.itmItem.suppName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppCode())) {
            predicates.add(this.itmItem.suppCode.eq((Object)param.getSuppCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itmItemBusinessDO.buCode.eq((Object)param.getBuCode()));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBusinessExportEntity.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.spuCode, this.itmItem.itemAttr, this.itmItem.spuId, this.itmItem.itemSource, this.itmItem.spuName, this.itmItem.itemType2, this.itmItem.itemType, this.itmItem.outerCode, this.itmItem.itemCateCode, itmBrand.brandName.as("brand"), this.itmItem.suppName, this.itmItem.spec, this.itmItem.salepurcFlag, this.itmItem.aftersalesServiceFlagx, this.itmItem.snFlag, this.itmItem.lotFlag, this.itmItem.guaranteePeriod, this.itmItem.guaranteePeriodUnit, this.itmItem.storeCondition, this.itmItem.taxType, this.itmItem.itemName, this.itmItem.barCode, this.itmItem.ouCode, this.itmItem.suppItemCode, this.itmItem.saleUom, this.itmItem.purcUom, this.itmItem.memberdiscFlagX, this.itmItem.distributionFlagX, this.itmItem.packageSpec, this.itmItem.grossWeight, this.itmItem.weightUnit, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItemBusinessDO.allocType, this.itmItemBusinessDO.taxRateNo, this.itmItemBusinessDO.taxRateNo2, this.itmItemBusinessDO.taxRateTariff, this.itmItemBusinessDO.installFlag, this.itmItemBusinessDO.returnExchangeFlag, this.itmItemBusinessDO.returnExchangePolicy, this.itmItemBusinessDO.warrantyFlag, this.itmItemBusinessDO.warrantyPeriod, this.itmItemBusinessDO.warrantyPeriodUnit, this.itmItemBusinessDO.buCode})).from((EntityPath)this.itmItem)).innerJoin((EntityPath)this.itmItemBusinessDO)).on((Predicate)this.itmItem.spuCode.eq((Expression)this.itmItemBusinessDO.spuCode))).innerJoin((EntityPath)itmBrand)).on((Predicate)itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)itmBrand.deleteFlag.isNull().or((Predicate)itmBrand.deleteFlag.eq((Object)0))))).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemBusinessRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

