/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessStatusVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ItmItemBusinessStatusRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemBusinessStatusDO itmItemBusinessStatus = QItmItemBusinessStatusDO.itmItemBusinessStatusDO;

    public List<ItmItemBusinessStatusVO> getBusinessStatusToBByStatus(String lifeStatus) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        String likeStr = "%" + lifeStatus + "%";
        predicates.add(this.itmItemBusinessStatus.itemLifeStatus.like(likeStr));
        predicates.add(this.itmItemBusinessStatus.modifyTime.goe((Comparable)LocalDateTime.now().minusDays(7L)));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessStatusVO.class, (Expression[])new Expression[]{this.itmItemBusinessStatus.itemCode, this.itmItemBusinessStatus.buCode, this.itmItemBusinessStatus.itemLifeStatus})).from((EntityPath)this.itmItemBusinessStatus)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemBusinessStatusVO> getBusinessStatusToBNormal(String lifeStatus) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        String likeStr = "%" + lifeStatus + "%";
        predicates.add(this.itmItemBusinessStatus.modifyTime.goe((Comparable)LocalDateTime.now().minusDays(7L)));
        predicates.add(this.itmItemBusinessStatus.itemLifeStatus.notLike(likeStr));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessStatusVO.class, (Expression[])new Expression[]{this.itmItemBusinessStatus.itemCode, this.itmItemBusinessStatus.buCode, this.itmItemBusinessStatus.itemLifeStatus})).from((EntityPath)this.itmItemBusinessStatus)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public ItmItemBusinessStatusRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

