/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.entity.QItmItemCateDO;
import com.elitesland.yst.supportdomain.item.excel.param.ItmItemCateExportParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateAddParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemCatePageParamVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateSearchParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
public class ItmItemCateRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemCateDO itmItemCateDO = QItmItemCateDO.itmItemCateDO;
    private final QBean<ItmItemCateVO> itemCateTreeVOQBean;
    private final QBean<ItmItemCateSimpleTree> simpleTreeQBean;

    public JPAQuery<ItmItemCateVO> searchGetById() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemCateVO.class, (Expression[])new Expression[]{this.itmItemCateDO.id, this.itmItemCateDO.sortNo, this.itmItemCateDO.grade, this.itmItemCateDO.itemCateName, this.itmItemCateDO.itemCateCode, this.itmItemCateDO.safeQtyDays, this.itmItemCateDO.defDueDate, this.itmItemCateDO.pid})).from((EntityPath)this.itmItemCateDO);
    }

    public List<ItmItemCateVO> searchTms(ItmItemCatePageParamVO param) {
        JPAQuery<ItmItemCateVO> jpaQuery = this.searchGetById();
        param.fillOrders(jpaQuery, this.itmItemCateDO);
        param.setPaging(jpaQuery);
        return ((JPAQuery)jpaQuery.where(this.wherePid(param))).fetch();
    }

    public List<ItmItemCateVO> searchTmss(ItmItemCatePageParamVO param) {
        JPAQuery<ItmItemCateVO> jpaQuery = this.searchGetById();
        return ((JPAQuery)jpaQuery.where(this.wherePid(param))).fetch();
    }

    public Predicate wherePid(ItmItemCatePageParamVO param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (!StringUtils.isEmpty((Object)param.getPid())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.pid.eq((Object)param.getPid()));
        }
        if (!StringUtils.isEmpty((Object)param.getId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.id.eq((Object)param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.id.in(param.getIds()));
        }
        if (!CollectionUtils.isEmpty(param.getPids())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.pid.in(param.getPids()));
        }
        return predicate;
    }

    public Long countContractTmplTm(ItmItemCatePageParamVO param) {
        return ((JPAQuery)this.searchGetById().where(this.wherePid(param))).fetchCount();
    }

    public PagingVO<ItmItemCateVO> itmItemCateSearchByParam(ItmItemCateSearchParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select(this.itemCateTreeVOQBean).from((EntityPath)this.itmItemCateDO);
        BooleanExpression predicate = this.itmItemCateDO.isNotNull().or((Predicate)this.itmItemCateDO.isNull());
        predicate = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getItemCateCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.itemCateCode.eq((Object)param.getItemCateCode()));
        predicate = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getItemCateName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.itemCateName.like("%" + param.getItemCateName() + "%"));
        predicate = param.getPid() == null ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.pid.eq((Object)param.getPid()));
        predicate = param.getGrade() == null ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.grade.eq((Object)param.getGrade()));
        predicate = param.getItemCateIsBasic() == null ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.itemCateIsBasic.eq((Object)param.getItemCateIsBasic()));
        predicate = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getStatus()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItemCateDO.status.eq((Object)param.getStatus()));
        query.where((Predicate)predicate);
        param.fillOrders(query, this.itmItemCateDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemCateDetailsVO searchDetailsById(Long id) {
        return (ItmItemCateDetailsVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemCateDetailsVO.class, (Expression[])new Expression[]{this.itmItemCateDO.id, this.itmItemCateDO.pid, this.itmItemCateDO.sortNo, this.itmItemCateDO.grade, this.itmItemCateDO.itemCateCode, this.itmItemCateDO.itemCateName, this.itmItemCateDO.itemCateIsBasic, this.itmItemCateDO.status})).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.id.eq((Object)id))).fetchOne();
    }

    public List<ItmItemCateVO> findAllTreeVos() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemCateTreeVOQBean).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.deleteFlag.isNull().or((Predicate)this.itmItemCateDO.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<ItmItemCateVO> findAllTreeVosByItemCateCode(List<String> itemCateCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemCateTreeVOQBean).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.deleteFlag.isNull().or((Predicate)this.itmItemCateDO.deleteFlag.eq((Object)0)))).where((Predicate)this.itmItemCateDO.itemCateCode.in(itemCateCodes))).fetch();
    }

    public PagingVO<String> findAllSmallCateByParam(ItmItemCateExportParam param) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItemCateDO.itemCateCode).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.deleteFlag.isNull().or((Predicate)this.itmItemCateDO.deleteFlag.eq((Object)0)))).where((Predicate)this.itmItemCateDO.grade.eq((Object)3));
        param.fillOrders(query, this.itmItemCateDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmItemCateVO> findTreeExcelVos(ItmItemCateExportParam param) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemCateTreeVOQBean).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.deleteFlag.isNull().or((Predicate)this.itmItemCateDO.deleteFlag.eq((Object)0)));
        param.fillOrders(query, this.itmItemCateDO);
        param.setPaging(query);
        return query.fetch();
    }

    public ItmItemCateSimpleTree findSimpleTreeById(Long id) {
        return (ItmItemCateSimpleTree)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.simpleTreeQBean).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.id.eq((Object)id))).fetchOne();
    }

    public Long findIdByCode(String itemCateCode) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItemCateDO.id).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.itemCateCode.eq((Object)itemCateCode))).fetchOne();
    }

    public String findCodeById(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItemCateDO.itemCateCode).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.id.eq((Object)id))).fetchOne();
    }

    public void updateStatusByIds(Set<Long> ids, String status) {
        this.jpaQueryFactory.update((EntityPath)this.itmItemCateDO).set((Path)this.itmItemCateDO.status, (Object)status).where(new Predicate[]{this.itmItemCateDO.id.in(ids)}).execute();
    }

    public void softDeleteById(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.itmItemCateDO).set(this.itmItemCateDO.deleteFlag, (Object)1).where(new Predicate[]{this.itmItemCateDO.id.eq((Object)id)}).execute();
    }

    public List<ItmItemCateDTO> findAllDto() {
        return this.selectDto().fetch();
    }

    public ItmItemCateDTO findByPidAndCateName(Long pid, String itemCateName) {
        return (ItmItemCateDTO)((JPAQuery)((JPAQuery)this.selectDto().where((Predicate)this.itmItemCateDO.pid.eq((Object)pid))).where((Predicate)this.itmItemCateDO.itemCateName.eq((Object)itemCateName))).fetchOne();
    }

    private JPAQuery<ItmItemCateDTO> selectDto() {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemCateDTO.class, (Expression[])new Expression[]{this.itmItemCateDO.id, this.itmItemCateDO.itemCateCode, this.itmItemCateDO.itemCateName, this.itmItemCateDO.pid})).from((EntityPath)this.itmItemCateDO)).where((Predicate)this.itmItemCateDO.deleteFlag.isNull().or((Predicate)this.itmItemCateDO.deleteFlag.eq((Object)0)));
    }

    @Transactional(rollbackFor={Exception.class})
    @Modifying
    public Long updateSafeQtyAndDefDue(ItmItemCateAddParam param) {
        long count = this.jpaQueryFactory.update((EntityPath)this.itmItemCateDO).set((Path)this.itmItemCateDO.safeQtyDays, (Object)param.getSafeQtyDays()).set((Path)this.itmItemCateDO.defDueDate, (Object)param.getDefDueDate()).where(new Predicate[]{this.itmItemCateDO.id.in(param.getIdList())}).execute();
        return count;
    }

    public ItmItemCateRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemCateTreeVOQBean = Projections.bean(ItmItemCateVO.class, (Expression[])new Expression[]{this.itmItemCateDO.id, this.itmItemCateDO.pid, this.itmItemCateDO.sortNo, this.itmItemCateDO.grade, this.itmItemCateDO.itemCateCode, this.itmItemCateDO.itemCateName, this.itmItemCateDO.itemCateIsBasic, this.itmItemCateDO.status});
        this.simpleTreeQBean = Projections.bean(ItmItemCateSimpleTree.class, (Expression[])new Expression[]{this.itmItemCateDO.id, this.itmItemCateDO.pid, this.itmItemCateDO.sortNo, this.itmItemCateDO.grade, this.itmItemCateDO.itemCateCode, this.itmItemCateDO.itemCateName});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

