/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemLifeStatusDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusSearchParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeUpdateParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeOuVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusDeleteParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusVO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemLifeStatusRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItemDO = QItmItemDO.itmItemDO;
    private final QItmItemLifeStatusDO itmItemLifeStatusDO = QItmItemLifeStatusDO.itmItemLifeStatusDO;
    private final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
    private final QOrgBuDO orgBu = QOrgBuDO.orgBuDO;
    private final QOrgOuDO orgOu = QOrgOuDO.orgOuDO;

    public PagingVO<ItmItemLifeStatusPagingVO> searchItemLifeList(ItmItemLifeStatusPagingParam param) {
        String likeStr;
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            likeStr = "%" + param.getItemCode() + "%";
            predicates.add(this.itmItemDO.itemCode.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemName())) {
            likeStr = "%" + param.getItemName() + "%";
            predicates.add(this.itmItemDO.itemName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itmItemDO.itemSource.eq((Object)param.getItemSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItemDO.itemType2.eq((Object)param.getItemType2()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItemDO.itemType2.eq((Object)param.getItemType2()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItemDO.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppName())) {
            predicates.add(this.itmItemDO.suppName.eq((Object)param.getSuppName()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBrand())) {
            predicates.add(this.itmBrand.brandName.eq((Object)param.getBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemLifeStatus())) {
            predicates.add(this.itmItemLifeStatusDO.itemLifeStatus.eq((Object)param.getItemLifeStatus()));
        }
        if (null != param.getDateFrom()) {
            predicates.add(this.itmItemLifeStatusDO.validFrom.goe((Comparable)param.getDateFrom()));
        }
        if (null != param.getDateTo()) {
            predicates.add(this.itmItemLifeStatusDO.validTo.loe((Comparable)param.getDateTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getLifeStatusCode())) {
            predicates.add(this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)param.getLifeStatusCode()));
        }
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.itmItemLifeStatusDO.getMetadata()));
        predicates.add(this.itmItemLifeStatusDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusPagingVO.class, (Expression[])new Expression[]{this.itmItemDO.itemCode, this.itmItemDO.itemName, this.itmItemDO.itemType2, this.itmItemDO.itemCateCode, this.itmBrand.brandName, this.itmItemDO.suppName, this.itmItemLifeStatusDO.lifeStatusCode, this.itmItemLifeStatusDO.itemLifeStatus, this.itmItemLifeStatusDO.globalOrNot, this.itmItemLifeStatusDO.creator, this.itmItemLifeStatusDO.ouName, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo, this.itmItemLifeStatusDO.createTime})).from((EntityPath)this.itmItemDO)).innerJoin((EntityPath)this.itmItemLifeStatusDO)).on((Predicate)this.itmItemDO.itemCode.eq((Expression)this.itmItemLifeStatusDO.itemCode))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItemDO.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))))).where(ExpressionUtils.allOf(predicates));
        query.groupBy((Expression)this.itmItemLifeStatusDO.lifeStatusCode);
        param.fillOrders(query, this.itmItemLifeStatusDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmItemLifeOuVO> findBranchPlantList(String lifeStatusCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeOuVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.branchPlant, this.orgBu.buName})).from((EntityPath)this.itmItemLifeStatusDO)).where((Predicate)this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)lifeStatusCode))).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.itmItemLifeStatusDO.branchPlant.eq((Expression)this.orgBu.buCode))).fetch();
    }

    public List<ItmItemLifeStatusVO> findItemLifeStatusVOByItemCodes(List<String> itemCodes, Boolean globalOrNot) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.itemCode, this.itmItemLifeStatusDO.itemLifeStatus, this.itmItemLifeStatusDO.branchPlant, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo})).from((EntityPath)this.itmItemLifeStatusDO)).where((Predicate)this.itmItemLifeStatusDO.itemCode.in(itemCodes).and((Predicate)this.itmItemLifeStatusDO.globalOrNot.eq(globalOrNot)))).fetch();
    }

    private Long getItemTotalCount(List<Predicate> predicates) {
        List fetch = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItemDO.id).from((EntityPath)this.itmItemDO)).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItemDO.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))))).where(ExpressionUtils.allOf(predicates))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.itmItemDO.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))))).innerJoin((EntityPath)this.itmItemLifeStatusDO)).on((Predicate)this.itmItemDO.id.eq(this.itmItemLifeStatusDO.itemId))).groupBy(new Expression[]{this.itmItemLifeStatusDO.globalOrNot, this.itmItemLifeStatusDO.itemLifeStatus})).fetch();
        return fetch.size();
    }

    public List<ItmItemLifeStatusDetailsVO> searchLifeStatusDetails(String lifeStatusCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusDetailsVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.itemCode, this.itmItemLifeStatusDO.buCode, this.itmItemLifeStatusDO.itemSource, this.itmItemDO.itemName, this.itmItemLifeStatusDO.globalOrNot, this.itmItemLifeStatusDO.itemLifeStatus, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo, this.itmItemLifeStatusDO.lifeStatusCode, this.itmItemLifeStatusDO.ouId, this.itmItemLifeStatusDO.ouCode, this.itmItemLifeStatusDO.ouName, this.itmItemLifeStatusDO.createTime, this.itmItemLifeStatusDO.creator, this.itmItemLifeStatusDO.createUserId})).from((EntityPath)this.itmItemLifeStatusDO)).leftJoin((EntityPath)this.itmItemDO)).on((Predicate)this.itmItemDO.itemCode.eq((Expression)this.itmItemLifeStatusDO.itemCode))).where((Predicate)this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)lifeStatusCode))).groupBy((Expression)this.itmItemLifeStatusDO.lifeStatusCode)).fetch();
    }

    public List<ItmItemLifeStatusVO> findGlobalInfoByItemCode(ItmItemLifeStatusSearchParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            predicates.add(this.itmItemLifeStatusDO.itemCode.eq((Object)param.getItemCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemLifeStatus())) {
            predicates.add(this.itmItemLifeStatusDO.itemLifeStatus.eq((Object)param.getItemLifeStatus()));
        }
        if (null != param.getGlobalOrNot()) {
            predicates.add(this.itmItemLifeStatusDO.globalOrNot.eq(param.getGlobalOrNot()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itmItemLifeStatusDO.buCode.eq((Object)param.getBuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getLifeStatusCode())) {
            predicates.add(this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)param.getLifeStatusCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getNonLifeStatusCode())) {
            predicates.add(this.itmItemLifeStatusDO.lifeStatusCode.ne((Object)param.getNonLifeStatusCode()));
        }
        predicates.add(this.itmItemLifeStatusDO.validTo.goe((Comparable)LocalDateTime.now()));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.itemCode, this.itmItemLifeStatusDO.itemLifeStatus, this.itmItemLifeStatusDO.globalOrNot, this.itmItemLifeStatusDO.branchPlant, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo, this.itmItemLifeStatusDO.createTime})).from((EntityPath)this.itmItemLifeStatusDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public void deleteByLifeStatusCode(ItmItemLifeStatusDeleteParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getLifeStatusCode())) {
            predicates.add(this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)param.getLifeStatusCode()));
        }
        if (null != param.getGlobalOrNot()) {
            predicates.add(this.itmItemLifeStatusDO.globalOrNot.eq(param.getGlobalOrNot()));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return;
        }
        this.jpaQueryFactory.delete((EntityPath)this.itmItemLifeStatusDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)}).execute();
    }

    public void updateLifeStatus(ItmItemLifeUpdateParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itmItemLifeStatusDO.buCode.eq((Object)param.getBuCode()));
        } else {
            predicates.add(this.itmItemLifeStatusDO.buCode.isNull());
        }
        this.jpaQueryFactory.update((EntityPath)this.itmItemLifeStatusDO).set(this.itmItemLifeStatusDO.validFrom, (Object)param.getValidFrom()).set(this.itmItemLifeStatusDO.validTo, (Object)param.getValidTo()).set(this.itmItemLifeStatusDO.createTime, (Object)param.getCreateTime()).set((Path)this.itmItemLifeStatusDO.creator, (Object)param.getCreator()).set(this.itmItemLifeStatusDO.createUserId, (Object)param.getCreateUserId()).where(new Predicate[]{this.itmItemLifeStatusDO.itemCode.eq((Object)param.getItemCode()).and((Predicate)this.itmItemLifeStatusDO.lifeStatusCode.eq((Object)param.getLifeStatusCode())).and((Predicate)this.itmItemLifeStatusDO.globalOrNot.eq(param.getGlobalOrNot()))}).where(new Predicate[]{ExpressionUtils.allOf(predicates)}).execute();
    }

    public void deleteByLifeStatusCode(List<String> codes) {
        this.jpaQueryFactory.update((EntityPath)this.itmItemLifeStatusDO).set(this.itmItemLifeStatusDO.deleteFlag, (Object)1).where(new Predicate[]{this.itmItemLifeStatusDO.lifeStatusCode.in(codes)}).execute();
    }

    public List<ItmItemLifeStatusDetailsVO> findItemDetailsByLifeStatusCodes(List<String> lifeStatusCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusDetailsVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.lifeStatusCode, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo})).from((EntityPath)this.itmItemLifeStatusDO)).where((Predicate)this.itmItemLifeStatusDO.lifeStatusCode.in(lifeStatusCodes))).fetch();
    }

    public List<ItmItemLifeStatusVO> findLifeStatusByItemCode(List<String> itemCodes) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.itmItemLifeStatusDO.itemCode.in(itemCodes));
        LocalDateTime now = LocalDateTime.now();
        predicates.add(this.itmItemLifeStatusDO.validTo.goe((Comparable)now).and((Predicate)this.itmItemLifeStatusDO.validFrom.loe((Comparable)now)));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.globalOrNot, this.itmItemLifeStatusDO.branchPlant, this.itmItemLifeStatusDO.itemLifeStatus, this.itmItemLifeStatusDO.itemCode, this.itmItemLifeStatusDO.validFrom, this.itmItemLifeStatusDO.validTo})).from((EntityPath)this.itmItemLifeStatusDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemLifeStatusVO> findLifeStatusByItemIdsAndTime(List<String> itemCodes, LocalDateTime time) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatusDO.itemCode, this.itmItemLifeStatusDO.buCode, this.itmItemLifeStatusDO.lifeStatusCode})).from((EntityPath)this.itmItemLifeStatusDO)).where((Predicate)this.itmItemLifeStatusDO.itemCode.in(itemCodes))).where((Predicate)this.itmItemLifeStatusDO.validFrom.loe((Comparable)time).and((Predicate)this.itmItemLifeStatusDO.validTo.goe((Comparable)time)))).fetch();
    }

    public ItmItemLifeStatusRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

