/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemPropDO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescPropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemPropVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ItmItemPropRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemPropDO itemProp = QItmItemPropDO.itmItemPropDO;

    public List<ItmItemPropVO> findVosByItemId(Long itemId) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemPropVO.class, (Expression[])new Expression[]{this.itemProp.id, this.itemProp.itemId, this.itemProp.catePropCode, this.itemProp.catePropName, this.itemProp.catePropType, this.itemProp.propValue})).from((EntityPath)this.itemProp)).where((Predicate)this.itemProp.itemId.eq((Object)itemId).and((Predicate)this.itemProp.deleteFlag.isNull().or((Predicate)this.itemProp.deleteFlag.eq((Object)0))));
        return query.fetch();
    }

    public boolean existsByCatePropCodeAndItemNotDelete(String catePropCode) {
        QItmItemDO itmItem = QItmItemDO.itmItemDO;
        long count = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.itemProp).innerJoin((EntityPath)itmItem)).on((Predicate)itmItem.id.eq(this.itemProp.itemId).and((Predicate)itmItem.deleteFlag.isNull().or((Predicate)itmItem.deleteFlag.eq((Object)0))))).where((Predicate)this.itemProp.catePropCode.eq((Object)catePropCode))).fetchCount();
        return count > 0L;
    }

    public void deleteBySpuCodes(List<String> spuCodeList) {
        QItmItemDO qItmItemDO = QItmItemDO.itmItemDO;
        this.jpaQueryFactory.delete((EntityPath)this.itemProp).where(new Predicate[]{this.itemProp.itemId.in((SubQueryExpression)((JPAQuery)this.jpaQueryFactory.select(qItmItemDO.id).from((EntityPath)qItmItemDO)).where((Predicate)qItmItemDO.spuCode.in(spuCodeList)))}).execute();
    }

    public List<ItmItemPropVO> findByItemIdsForTw(List<Long> spuIds, String catePropName) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemPropVO.class, (Expression[])new Expression[]{this.itemProp.id, this.itemProp.itemId, this.itemProp.catePropCode, this.itemProp.catePropName, this.itemProp.catePropType, this.itemProp.propValue})).from((EntityPath)this.itemProp)).where((Predicate)this.itemProp.itemId.in(spuIds).and((Predicate)this.itemProp.deleteFlag.isNull().or((Predicate)this.itemProp.deleteFlag.eq((Object)0))).and((Predicate)this.itemProp.catePropName.eq((Object)catePropName)));
        return query.fetch();
    }

    public List<ItemCateDescPropVO> getItemDescProp(List<Long> spuIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItemCateDescPropVO.class, (Expression[])new Expression[]{this.itemProp.itemId, this.itemProp.catePropCode, this.itemProp.catePropName, this.itemProp.propValue})).from((EntityPath)this.itemProp)).where((Predicate)this.itemProp.itemId.in(spuIds))).orderBy(new OrderSpecifier[]{this.itemProp.itemId.desc(), this.itemProp.catePropCode.desc()})).fetch();
    }

    public ItmItemPropRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

