/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemSpuDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemChangUpdateVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemPubBusiParamVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSkuVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuInfoVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuPagingVO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemQueryParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemQueryDTO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ItmItemRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmItemSpuDO itmItemSpu = QItmItemSpuDO.itmItemSpuDO;
    private final QItmItemBusinessStatusDO itemBusinessStatus = QItmItemBusinessStatusDO.itmItemBusinessStatusDO;
    private final QBean<ItmItemQueryDTO> itemList;

    public PagingVO<ItmItemSpuPagingVO> selectSpuPagingResult(ItmItemSpuPagingParam param) {
        String likeStr;
        QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSpuPagingVO.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.itemStatus, this.itmItem.itemCateCode, this.itmItem.itemSource, this.itmItem.brand, itmBrand.brandName, this.itmItem.suppId, this.itmItem.suppCode, this.itmItem.suppAbbr, this.itmItem.suppName, this.itmItem.salepurcFlag, this.itmItem.snFlag, this.itmItem.lotFlag, this.itmItem.allocType, this.itmItem.guaranteePeriod, this.itmItem.guaranteePeriodUnit, this.itmItem.storeCondition, this.itmItem.finType, this.itmItem.costType, this.itmItem.taxRateNo, this.itmItem.taxRateNo2, this.itmItem.taxRateTariff, this.itmItem.aftersalesServiceFlagx, this.itmItem.installFlag, this.itmItem.returnExchangeFlag, this.itmItem.warrantyFlag, this.itmItem.spec, this.itmItem.createTime, this.itmItem.releaseFlag, this.itmItem.cat})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)itmBrand)).on((Predicate)itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)itmBrand.deleteFlag.isNull().or((Predicate)itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)param.getSpuCode())) {
            likeStr = "%" + param.getSpuCode() + "%";
            predicates.add(this.itmItem.spuCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSpuName())) {
            likeStr = "%" + param.getSpuName() + "%";
            predicates.add(this.itmItem.spuName.like(likeStr).or((Predicate)this.itmItem.spuAbbr.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getBrand())) {
            likeStr = "%" + param.getBrand() + "%";
            predicates.add(itmBrand.brandName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getOuterCode())) {
            predicates.add(this.itmItem.outerCode.eq((Object)param.getOuterCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemStatus())) {
            predicates.add(this.itmItem.itemStatus.eq((Object)param.getItemStatus()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (param.getSnFlag() != null) {
            predicates.add(this.itmItem.snFlag.eq(param.getSnFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCat())) {
            predicates.add(this.itmItem.cat.eq((Object)param.getCat()));
        }
        if (param.getLotFlag() != null) {
            predicates.add(this.itmItem.lotFlag.eq(param.getLotFlag()));
        }
        if (param.getInstallFlag() != null) {
            predicates.add(this.itmItem.installFlag.eq(param.getInstallFlag()));
        }
        if (param.getGuaranteeFlag() != null) {
            predicates.add(this.itmItem.guaranteeFlag.eq(param.getGuaranteeFlag()));
        }
        if (param.getWarrantyFlag() != null) {
            predicates.add(this.itmItem.warrantyFlag.eq(param.getWarrantyFlag()));
        }
        if (param.getAftersalesServiceFlagx() != null) {
            predicates.add(this.itmItem.aftersalesServiceFlagx.eq(param.getAftersalesServiceFlagx()));
        }
        if (param.getReleaseFlag() != null) {
            predicates.add(this.itmItem.releaseFlag.eq(param.getReleaseFlag()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itmItem.itemSource.eq((Object)param.getItemSource()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppCode())) {
            predicates.add(this.itmItem.suppCode.eq((Object)param.getSuppCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getAllocType())) {
            predicates.add(this.itmItem.allocType.eq((Object)param.getAllocType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        predicates.add(this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)));
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.itmItem.getMetadata()));
        query.where(ExpressionUtils.allOf(predicates));
        query.groupBy(this.itmItem.spuId);
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemSpuDetailsVO searchSpuDetailVoById(Long id) {
        QItmBrandDO brand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSpuDetailsVO.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.spuAbbr, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.itemStatus, this.itmItem.itemCateCode, this.itmItem.itemSource, this.itmItem.barCode, brand.id.as("brandId"), this.itmItem.brand, brand.brandName, this.itmItem.suppId, this.itmItem.suppCode, this.itmItem.suppAbbr, this.itmItem.suppName, this.itmItem.spec, this.itmItem.salepurcFlag, this.itmItem.snFlag, this.itmItem.lotFlag, this.itmItem.guaranteeFlag, this.itmItem.allocType, this.itmItem.guaranteePeriod, this.itmItem.guaranteePeriodUnit, this.itmItem.transCondition, this.itmItem.storeCondition, this.itmItem.finType, this.itmItem.costType, this.itmItem.taxType, this.itmItem.taxRateNo, this.itmItem.taxRateNo2, this.itmItem.taxRateTariff, this.itmItem.aftersalesServiceFlagx, this.itmItem.installFlag, this.itmItem.returnExchangeFlag, this.itmItem.returnExchangePolicy, this.itmItem.warrantyFlag, this.itmItem.warrantyPeriod, this.itmItem.warrantyPeriodUnit, this.itmItem.secOuId})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)brand)).on((Predicate)brand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)brand.deleteFlag.isNull().or((Predicate)brand.deleteFlag.eq((Object)0))))).where((Predicate)this.itmItem.spuId.eq((Object)id))).groupBy(this.itmItem.spuId);
        return (ItmItemSpuDetailsVO)query.fetchOne();
    }

    public List<ItmItemSkuVO> findSkuVosBySpuId(Long spuId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemStatus2, this.itmItem.itemAttr, this.itmItem.itemCode, this.itmItem.itemName, this.itmItem.itemAbbr, this.itmItem.barCode, this.itmItem.outerCode, this.itmItem.suppItemCode, this.itmItem.uom, this.itmItem.pricingUom, this.itmItem.saleUom, this.itmItem.purcUom, this.itmItem.packageSpec, this.itmItem.grossWeight, this.itmItem.netWeight, this.itmItem.weightUnit, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItem.length, this.itmItem.width, this.itmItem.height, this.itmItem.lengthUnit, this.itmItem.memberdiscFlagX, this.itmItem.distributionFlagX})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.eq((Object)spuId))).fetch();
    }

    public List<ItmItemSkuVO> findSkuBusinessVosBySpuId(Long spuId, String buCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itemBusinessStatus.itemLifeStatus, this.itmItem.itemAttr, this.itmItem.itemCode, this.itmItem.itemName, this.itmItem.itemAbbr, this.itmItem.barCode, this.itmItem.outerCode, this.itmItem.suppItemCode, this.itmItem.uom, this.itmItem.pricingUom, this.itmItem.saleUom, this.itmItem.purcUom, this.itmItem.packageSpec, this.itmItem.grossWeight, this.itmItem.netWeight, this.itmItem.weightUnit, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItem.length, this.itmItem.width, this.itmItem.height, this.itmItem.lengthUnit, this.itmItem.memberdiscFlagX, this.itmItem.distributionFlagX})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itemBusinessStatus)).on((Predicate)this.itmItem.itemCode.eq((Expression)this.itemBusinessStatus.itemCode).and((Predicate)this.itemBusinessStatus.buCode.eq((Object)buCode)))).where((Predicate)this.itmItem.spuId.eq((Object)spuId))).fetch();
    }

    public void approveItemBySpuIds(List<Long> ids, String itemStatus, LocalDateTime time) {
        JPAUpdateClause sql = this.jpaQueryFactory.update((EntityPath)this.itmItem).set((Path)this.itmItem.itemStatus, (Object)itemStatus);
        if (time != null) {
            sql.set(this.itmItem.createTime, (Object)time);
        }
        sql.where(new Predicate[]{this.itmItem.spuId.in(ids)}).execute();
    }

    public boolean existsByBrandCodeAndItemNotDelete(String brandCode) {
        long count = ((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.itmItem).where((Predicate)this.itmItem.brand.eq((Object)brandCode).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).fetchCount();
        return count > 0L;
    }

    public boolean existsByCateCodeAndItemNotDelete(String itemCateCode) {
        long count = ((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.itmItem).where((Predicate)this.itmItem.itemCateCode.eq((Object)itemCateCode).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).fetchCount();
        return count > 0L;
    }

    public List<String> findItemCodesBySpuIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItem.itemCode).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.in(ids))).fetch();
    }

    public List<ItmItemBusinessSaveParam> findItemBusinessSaveParamBySpuIds(List<Long> spuId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessSaveParam.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.itemSource, this.itmItem.allocType, this.itmItem.taxRateNo, this.itmItem.taxRateNo2, this.itmItem.taxRateTariff, this.itmItem.installFlag, this.itmItem.returnExchangeFlag, this.itmItem.returnExchangePolicy, this.itmItem.warrantyFlag, this.itmItem.warrantyPeriod, this.itmItem.warrantyPeriodUnit})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.in(spuId))).groupBy(this.itmItem.spuId)).fetch();
    }

    public List<ItmItemDTO> findAllItemDto(String itemType) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemDTO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.spuCode, this.itmItem.barCode, this.itmItem.spec})).from((EntityPath)this.itmItem);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)itemType)) {
            predicates.add(this.itmItem.itemType2.eq((Object)itemType));
        }
        predicates.add(this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<ItmItemDTO> findItemDtoBySpuIds(List<Long> spuIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemDTO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.spec, this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.itemStatus, this.itmItem.itemType2})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.in(spuIds))).fetch();
    }

    public void softDeleteBySpuId(List<Long> spuIds) {
        this.jpaQueryFactory.update((EntityPath)this.itmItem).set(this.itmItem.deleteFlag, (Object)1).where(new Predicate[]{this.itmItem.spuId.in(spuIds)}).execute();
    }

    public List<Tuple> searchItemCateCodeByItemCode(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.itmItem.itemCateCode, this.itmItem.itemCode}).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).fetch();
    }

    public List<String> searchItemCodes() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItem.itemCode).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<Long> findNeedSync(List<Long> supIds, Pageable pageable, List<String> itemType2s) {
        BooleanExpression predicate = this.itmItem.isNotNull().or((Predicate)this.itmItem.isNull());
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItem.suppId.isNotNull());
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItem.itemStatus.eq((Object)"ENABLE"));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItem.itemType2.in(itemType2s));
        if (CollectionUtils.isNotEmpty(supIds)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.itmItem.suppId.notIn(supIds));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItem.spuId).from((EntityPath)this.itmItem)).where((Predicate)predicate)).offset(pageable.getOffset())).limit((long)pageable.getPageSize())).fetch();
    }

    public List<ItmItemChangUpdateVO> findItmItemChangInfo(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemChangUpdateVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).fetch();
    }

    public void deleteBySpuCodes(List<String> spuCodeList) {
        this.jpaQueryFactory.delete((EntityPath)this.itmItem).where(new Predicate[]{this.itmItem.spuCode.in(spuCodeList)}).execute();
    }

    public List<Long> findAllSpuIds() {
        return ((JPAQuery)this.jpaQueryFactory.select(this.itmItem.spuId).from((EntityPath)this.itmItem)).fetch();
    }

    public void updateReleaseFlag(List<Long> spuIds) {
        this.jpaQueryFactory.update((EntityPath)this.itmItem).set((Path)this.itmItem.releaseFlag, (Object)true).where(new Predicate[]{this.itmItem.spuId.in(spuIds)}).execute();
    }

    public List<Long> findNeedSyncForTw(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItem.spuId).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.aftersalesServiceFlagx.eq(Boolean.valueOf(true)).and((Predicate)this.itmItem.itemType2.eq((Object)ItmUdcEnum.ITM_ITM_TYPE2_10.getUdcVal()).and((Predicate)this.itmItem.spuId.in(ids))))).fetch();
    }

    public List<ItmItemDTO> findItemDtoByItemCode(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemDTO.class, (Expression[])new Expression[]{this.itmItem.itemCode, this.itmItem.secOuId, this.itmItem.creator, this.itmItem.createUserId})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes))).fetch();
    }

    public List<ItmItemSpuInfoVO> findSpuInfoBySpuIds(List<Long> spuIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSpuInfoVO.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.spuCode, this.itmItem.id.as("itemId"), this.itmItem.itemCode})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.in(spuIds))).fetch();
    }

    public List<ItmItemSpuInfoVO> findSpuInfoByItemCode(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSpuInfoVO.class, (Expression[])new Expression[]{this.itmItem.itemCode, this.itmItem.itemStatus2})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes))).fetch();
    }

    public List<Long> checkIsThreeItem(List<Long> spuIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItem.spuId).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuId.in(spuIds).and((Predicate)this.itmItem.cat.eq((Object)"1")))).fetch();
    }

    public List<ItmItemPubBusiParamVO> getPubItemAttributesBySpuCodes(List<String> spuCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemPubBusiParamVO.class, (Expression[])new Expression[]{this.itmItem.spuCode, this.itmItem.itemSource, this.itmItem.allocType, this.itmItem.taxRateNo, this.itmItem.taxRateNo2, this.itmItem.installFlag, this.itmItem.releaseFlag, this.itmItem.returnExchangeFlag, this.itmItem.returnExchangePolicy, this.itmItem.warrantyFlag, this.itmItem.warrantyPeriod, this.itmItem.warrantyPeriodUnit})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.spuCode.in(spuCode))).fetch();
    }

    public Long deleteItmItemById(List<Long> idList) {
        Long count = this.jpaQueryFactory.update((EntityPath)this.itmItem).set(this.itmItem.deleteFlag, (Object)1).where(new Predicate[]{this.itmItem.id.in(idList)}).execute();
        return count;
    }

    public Long deleteItmItemBySpuId(Long spuId) {
        Long count = this.jpaQueryFactory.update((EntityPath)this.itmItem).set(this.itmItem.deleteFlag, (Object)1).where(new Predicate[]{this.itmItem.spuId.eq((Object)spuId)}).execute();
        return count;
    }

    public long countItmItem(ItmItemQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItem.count()).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itmItemSpu)).on((Predicate)this.itmItem.spuId.eq(this.itmItemSpu.id));
        jpaQuery.where(this.itemWhere(param));
        return jpaQuery.fetchCount();
    }

    public List<ItmItemQueryDTO> queryItmItem(ItmItemQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemList).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itmItemSpu)).on((Predicate)this.itmItem.spuId.eq(this.itmItemSpu.id));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, (EntityPathBase)this.itmItem);
        jpaQuery.where(this.itemWhere(param));
        return jpaQuery.fetch();
    }

    private Predicate itemWhere(ItmItemQueryParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.itmItem.source.in((Object[])new String[]{"GC", "B2B"}));
        if (param.getId() != null) {
            predicates.add(this.itmItem.id.eq((Object)param.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemCode())) {
            predicates.add(this.itmItem.itemCode.eq((Object)param.getItemCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemCode2())) {
            predicates.add(this.itmItem.itemCode2.eq((Object)param.getItemCode2()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemCode3())) {
            predicates.add(this.itmItem.itemCode3.eq((Object)param.getItemCode3()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemName())) {
            predicates.add(this.itmItem.itemName.eq((Object)param.getItemName()));
        }
        if (param.getSpuId() != null) {
            predicates.add(this.itmItem.spuId.eq((Object)param.getSpuId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpuCode())) {
            predicates.add(this.itmItem.spuCode.eq((Object)param.getSpuCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpuName())) {
            predicates.add(this.itmItemSpu.spuName.like("%" + param.getSpuName() + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStandard())) {
            predicates.add(this.itmItem.standard.eq((Object)param.getStandard()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStandardDesc())) {
            predicates.add(this.itmItem.standardDesc.eq((Object)param.getStandardDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getMaterial())) {
            predicates.add(this.itmItem.material.eq((Object)param.getMaterial()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getMaterialDesc())) {
            predicates.add(this.itmItem.materialDesc.eq((Object)param.getMaterialDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getDiameter())) {
            predicates.add(this.itmItem.diameter.eq((Object)param.getDiameter()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getDiameterDesc())) {
            predicates.add(this.itmItem.diameterDesc.eq((Object)param.getDiameterDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getLengths())) {
            predicates.add(this.itmItem.lengths.eq((Object)param.getLengths()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getLengthsDesc())) {
            predicates.add(this.itmItem.lengthsDesc.eq((Object)param.getLengthsDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getTooth())) {
            predicates.add(this.itmItem.tooth.eq((Object)param.getTooth()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getToothDesc())) {
            predicates.add(this.itmItem.toothDesc.eq((Object)param.getToothDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSurface())) {
            predicates.add(this.itmItem.surface.eq((Object)param.getSurface()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSurfaceDesc())) {
            predicates.add(this.itmItem.surfaceDesc.eq((Object)param.getSurfaceDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSource())) {
            predicates.add(this.itmItem.source.eq((Object)param.getSource()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStrength())) {
            predicates.add(this.itmItem.strength.eq((Object)param.getStrength()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStrengthDesc())) {
            predicates.add(this.itmItem.strengthDesc.eq((Object)param.getStrengthDesc()));
        }
        if (param.getCatId() != null) {
            predicates.add(this.itmItemSpu.catId.eq((Object)param.getCatId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpec())) {
            predicates.add(this.itmItem.spec.eq((Object)param.getSpec()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemStatus2())) {
            predicates.add(this.itmItem.itemStatus2.eq((Object)param.getItemStatus2()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemLevel())) {
            predicates.add(this.itmItem.itemLevel.eq((Object)param.getItemLevel()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getItemLevelDesc())) {
            predicates.add(this.itmItem.itemLevelDesc.eq((Object)param.getItemLevelDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getWasherType())) {
            predicates.add(this.itmItem.washerType.eq((Object)param.getWasherType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getWasherTypeDesc())) {
            predicates.add(this.itmItem.washerTypeDesc.eq((Object)param.getWasherTypeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getKind())) {
            predicates.add(this.itmItem.kind.eq((Object)param.getKind()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getKindDesc())) {
            predicates.add(this.itmItem.kindDesc.eq((Object)param.getKindDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getPurpose())) {
            predicates.add(this.itmItem.purpose.eq((Object)param.getPurpose()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getPurposeDesc())) {
            predicates.add(this.itmItem.purposeDesc.eq((Object)param.getPurposeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getToothLength())) {
            predicates.add(this.itmItem.toothLength.eq((Object)param.getToothLength()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getToothLengthDesc())) {
            predicates.add(this.itmItem.toothLengthDesc.eq((Object)param.getToothLengthDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getToothShape())) {
            predicates.add(this.itmItem.toothShape.eq((Object)param.getToothShape()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getToothShapeDesc())) {
            predicates.add(this.itmItem.toothShapeDesc.eq((Object)param.getToothShapeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getShape())) {
            predicates.add(this.itmItem.shape.eq((Object)param.getShape()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getShapeDesc())) {
            predicates.add(this.itmItem.shapeDesc.eq((Object)param.getShapeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCaudate())) {
            predicates.add(this.itmItem.caudate.eq((Object)param.getCaudate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCaudateDesc())) {
            predicates.add(this.itmItem.caudateDesc.eq((Object)param.getCaudateDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOuterDiameter())) {
            predicates.add(this.itmItem.outerDiameter.eq((Object)param.getOuterDiameter()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOuterDiameterDesc())) {
            predicates.add(this.itmItem.outerDiameterDesc.eq((Object)param.getOuterDiameterDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getHeadShape())) {
            predicates.add(this.itmItem.headShape.eq((Object)param.getHeadShape()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getHeadShapeDesc())) {
            predicates.add(this.itmItem.headShapeDesc.eq((Object)param.getHeadShapeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getWhorl())) {
            predicates.add(this.itmItem.whorl.eq((Object)param.getWhorl()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getWhorlDesc())) {
            predicates.add(this.itmItem.whorlDesc.eq((Object)param.getWhorlDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getThickness())) {
            predicates.add(this.itmItem.thickness.eq((Object)param.getThickness()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getThicknessDesc())) {
            predicates.add(this.itmItem.thicknessDesc.eq((Object)param.getThicknessDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getRhabditiform())) {
            predicates.add(this.itmItem.rhabditiform.eq((Object)param.getRhabditiform()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getRhabditiformDesc())) {
            predicates.add(this.itmItem.rhabditiformDesc.eq((Object)param.getRhabditiformDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAntiLoose())) {
            predicates.add(this.itmItem.antiLoose.eq((Object)param.getAntiLoose()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAntiLooseDesc())) {
            predicates.add(this.itmItem.antiLooseDesc.eq((Object)param.getAntiLooseDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSizeLevel())) {
            predicates.add(this.itmItem.sizeLevel.eq((Object)param.getSizeLevel()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSizeLevelDesc())) {
            predicates.add(this.itmItem.sizeLevelDesc.eq((Object)param.getSizeLevelDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getGrooveShape())) {
            predicates.add(this.itmItem.grooveShape.eq((Object)param.getGrooveShape()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getGrooveShapeDesc())) {
            predicates.add(this.itmItem.grooveShapeDesc.eq((Object)param.getGrooveShapeDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getInnerDiameter())) {
            predicates.add(this.itmItem.innerDiameter.eq((Object)param.getInnerDiameter()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getInnerDiameterDesc())) {
            predicates.add(this.itmItem.innerDiameterDesc.eq((Object)param.getInnerDiameterDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getProcessingMethod())) {
            predicates.add(this.itmItem.processingMethod.eq((Object)param.getProcessingMethod()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getProcessingMethodDesc())) {
            predicates.add(this.itmItem.processingMethodDesc.eq((Object)param.getProcessingMethodDesc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSuitIndustry())) {
            predicates.add(this.itmItem.suitIndustry.eq((Object)param.getSuitIndustry()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSuitIndustryDesc())) {
            predicates.add(this.itmItem.suitIndustryDesc.eq((Object)param.getSuitIndustryDesc()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<String> existItemCode(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItem.itemCode).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes))).fetch();
    }

    public List<ItmItemQueryDTO> findItemByItemCodes(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemQueryDTO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.itemCode2, this.itmItem.itemCode3, this.itmItem.itemName, this.itmItem.itemName2, this.itmItem.spec})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes))).fetch();
    }

    public ItmItemQueryDTO findItemByItemCode2(String itemCode2) {
        return (ItmItemQueryDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemQueryDTO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.itemCode2})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode2.eq((Object)itemCode2))).fetchOne();
    }

    public ItmItemRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemList = Projections.bean(ItmItemQueryDTO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.itemCode2, this.itmItem.itemCode3, this.itmItem.itemName, this.itmItem.itemName2, this.itmItem.spec, this.itmItem.itemAttr, this.itmItem.itemAttr2, this.itmItem.itemAttr3, this.itmItem.itemAttr4, this.itmItem.pricingUom, this.itmItem.storeUom, this.itmItem.netWeight, this.itmItem.moq, this.itmItem.standard, this.itmItem.standardDesc, this.itmItem.standardSort, this.itmItem.material, this.itmItem.materialDesc, this.itmItem.materialSort, this.itmItem.diameter, this.itmItem.diameterDesc, this.itmItem.diameterSort, this.itmItem.lengths, this.itmItem.lengthsDesc, this.itmItem.lengthsSort, this.itmItem.tooth, this.itmItem.toothDesc, this.itmItem.toothSort, this.itmItem.surface, this.itmItem.surfaceDesc, this.itmItem.surfaceSort, this.itmItem.strength, this.itmItem.strengthDesc, this.itmItem.strengthSort, this.itmItem.source, this.itmItem.itemStatus2, this.itmItem.spuId, this.itmItemSpu.spuCode, this.itmItemSpu.spuName, this.itmItemSpu.brand, this.itmItemSpu.catId, this.itmItem.itemLevel, this.itmItem.itemLevelDesc, this.itmItem.itemLevelSort, this.itmItem.washerType, this.itmItem.washerTypeDesc, this.itmItem.washerTypeSort, this.itmItem.kind, this.itmItem.kindDesc, this.itmItem.kindSort, this.itmItem.purpose, this.itmItem.purposeDesc, this.itmItem.purposeSort, this.itmItem.toothLength, this.itmItem.toothLengthDesc, this.itmItem.toothLengthSort, this.itmItem.toothShape, this.itmItem.toothShapeDesc, this.itmItem.toothShapeSort, this.itmItem.shape, this.itmItem.shapeDesc, this.itmItem.shapeSort, this.itmItem.caudate, this.itmItem.caudateDesc, this.itmItem.caudateSort, this.itmItem.outerDiameter, this.itmItem.outerDiameterDesc, this.itmItem.outerDiameterSort, this.itmItem.headShape, this.itmItem.headShapeDesc, this.itmItem.headShapeSort, this.itmItem.whorl, this.itmItem.whorlDesc, this.itmItem.whorlSort, this.itmItem.thickness, this.itmItem.thicknessDesc, this.itmItem.thicknessSort, this.itmItem.rhabditiform, this.itmItem.rhabditiformDesc, this.itmItem.rhabditiformSort, this.itmItem.antiLoose, this.itmItem.antiLooseDesc, this.itmItem.antiLooseSort, this.itmItem.sizeLevel, this.itmItem.sizeLevelDesc, this.itmItem.sizeLevelSort, this.itmItem.grooveShape, this.itmItem.grooveShapeDesc, this.itmItem.grooveShapeSort, this.itmItem.innerDiameter, this.itmItem.innerDiameterDesc, this.itmItem.innerDiameterSort, this.itmItem.processingMethod, this.itmItem.processingMethodDesc, this.itmItem.processingMethodSort, this.itmItem.suitIndustry, this.itmItem.suitIndustryDesc, this.itmItem.suitIndustrySort});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

