/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.entity.QItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemCateDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemSegmentPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateParaSegmentVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSegmentInfoPagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemSegmentInfoRepoProc {
    private static final List<String> PRICE_GROUP_LIST = List.of("priceGroup", "priceGroup2", "priceGroup3");
    private final JPAQueryFactory jpaQueryFactory;
    private QItmItemCateDO itmItemCateDO = QItmItemCateDO.itmItemCateDO;
    private QItmCateContrParaDO itmCateContrParaDO = QItmCateContrParaDO.itmCateContrParaDO;

    public PagingVO<ItmItemSegmentInfoPagingVO> searchPagingList(ItmItemSegmentPagingParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItemCateDO.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        predicates.add(this.itmItemCateDO.grade.eq((Object)3));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSegmentInfoPagingVO.class, (Expression[])new Expression[]{this.itmItemCateDO.itemCateCode})).from((EntityPath)this.itmItemCateDO)).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItemCateDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmItemCateParaSegmentVO> findDetailByItemCateCode(String itemCateCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemCateParaSegmentVO.class, (Expression[])new Expression[]{this.itmCateContrParaDO.id, this.itmCateContrParaDO.itemCateCode, this.itmCateContrParaDO.controlParamCode, this.itmCateContrParaDO.controlParamName, this.itmCateContrParaDO.controlParamValue, this.itmCateContrParaDO.remark})).from((EntityPath)this.itmCateContrParaDO)).where((Predicate)this.itmCateContrParaDO.controlParamCode.in(PRICE_GROUP_LIST).and((Predicate)this.itmCateContrParaDO.itemCateCode.eq((Object)itemCateCode)).and((Predicate)this.itmCateContrParaDO.deleteFlag.isNull().or((Predicate)this.itmCateContrParaDO.deleteFlag.eq((Object)0))))).fetch();
    }

    public void hardDeleteSegment(String itemCateCode) {
        this.jpaQueryFactory.delete((EntityPath)this.itmCateContrParaDO).where(new Predicate[]{this.itmCateContrParaDO.itemCateCode.eq((Object)itemCateCode).and((Predicate)this.itmCateContrParaDO.controlParamCode.in(PRICE_GROUP_LIST))}).execute();
    }

    public ItmItemSegmentInfoRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

