/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.supportdomain.item.entity.QItmItemSpuDO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuQueryParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemSpuQueryDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemSpuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemSpuDO itmItemSpu = QItmItemSpuDO.itmItemSpuDO;
    private final QBean<ItmItemSpuQueryDTO> itemSpuList;

    public Long deleteItmItemSpuById(Long spuId) {
        Long count = this.jpaQueryFactory.update((EntityPath)this.itmItemSpu).set(this.itmItemSpu.deleteFlag, (Object)1).where(new Predicate[]{this.itmItemSpu.id.eq((Object)spuId)}).execute();
        return count;
    }

    public long countItmItemSpu(ItmItemSpuQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItemSpu.count()).from((EntityPath)this.itmItemSpu);
        jpaQuery.where(this.itemSpuWhere(param));
        return jpaQuery.fetchCount();
    }

    public List<ItmItemSpuQueryDTO> queryItmItemSpu(ItmItemSpuQueryParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.itemSpuList).from((EntityPath)this.itmItemSpu);
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, (EntityPathBase)this.itmItemSpu);
        jpaQuery.where(this.itemSpuWhere(param));
        return jpaQuery.fetch();
    }

    private Predicate itemSpuWhere(ItmItemSpuQueryParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.itmItemSpu.deleteFlag.eq((Object)0));
        if (param.getId() != null) {
            predicates.add(this.itmItemSpu.id.eq((Object)param.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpuCode())) {
            predicates.add(this.itmItemSpu.spuCode.eq((Object)param.getSpuCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpuName())) {
            predicates.add(this.itmItemSpu.spuName.eq((Object)param.getSpuName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getBrand())) {
            predicates.add(this.itmItemSpu.brand.eq((Object)param.getBrand()));
        }
        if (param.getCatId() != null) {
            predicates.add(this.itmItemSpu.catId.eq((Object)param.getCatId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpuStatus())) {
            predicates.add(this.itmItemSpu.spuStatus.eq((Object)param.getSpuStatus()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public ItmItemSpuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemSpuList = Projections.bean(ItmItemSpuQueryDTO.class, (Expression[])new Expression[]{this.itmItemSpu.id, this.itmItemSpu.spuCode, this.itmItemSpu.spuName, this.itmItemSpu.brand, this.itmItemSpu.unit, this.itmItemSpu.saleUnit, this.itmItemSpu.catId, this.itmItemSpu.spuFileCode, this.itmItemSpu.spuFileName, this.itmItemSpu.spuStatus, this.itmItemSpu.spuDetailInfo});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

