/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.entity.QItmTagDO;
import com.elitesland.yst.supportdomain.item.param.ItmTagPagingParam;
import com.elitesland.yst.supportdomain.item.vo.ItmTagPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagTreeVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmTagRepoProc {
    private static final String ENABLE = "ENABLE";
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmTagDO itmTag = QItmTagDO.itmTagDO;
    private final QBean<ItmTagTreeVO> itmTagTreeVOQBean;

    public PagingVO<ItmTagPagingVO> searchPagingByParam(ItmTagPagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmTagPagingVO.class, (Expression[])new Expression[]{this.itmTag.id, this.itmTag.tagCode, this.itmTag.tagName, this.itmTag.tagDesc, this.itmTag.status})).from((EntityPath)this.itmTag);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)param.getTagCodeName())) {
            String likeStr = "%" + param.getTagCodeName() + "%";
            predicates.add(this.itmTag.tagCode.like(likeStr).or((Predicate)this.itmTag.tagName.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getStatus())) {
            predicates.add(this.itmTag.status.eq((Object)param.getStatus()));
        }
        predicates.add(this.itmTag.deleteFlag.isNull().or((Predicate)this.itmTag.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmTag);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmTagTreeVO> findAllTagTreeVO() {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmTagTreeVOQBean).from((EntityPath)this.itmTag)).where((Predicate)this.itmTag.deleteFlag.isNull().or((Predicate)this.itmTag.deleteFlag.eq((Object)0)));
        return query.fetch();
    }

    public List<ItmTagTreeVO> querySubTagByPid(Long pid) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmTagTreeVOQBean).from((EntityPath)this.itmTag)).where((Predicate)this.itmTag.pid.eq((Object)(pid == null ? 0L : pid)).and((Predicate)this.itmTag.deleteFlag.isNull().or((Predicate)this.itmTag.deleteFlag.eq((Object)0))))).orderBy(new OrderSpecifier[]{this.itmTag.sortNo.asc(), this.itmTag.id.asc()});
        return query.fetch();
    }

    public ItmTagVO queryTagDetailsById(Long id) {
        QItmTagDO pItmTag = new QItmTagDO("pItmTag");
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmTagVO.class, (Expression[])new Expression[]{this.itmTag.id, this.itmTag.sortNo, this.itmTag.grade, this.itmTag.tagCode, this.itmTag.tagName, this.itmTag.tagType, this.itmTag.tagDesc, this.itmTag.status, this.itmTag.pid, pItmTag.tagCode.as("upperTagCode"), pItmTag.tagName.as("upperTagName"), pItmTag.tagType.as("upperTagType")})).from((EntityPath)this.itmTag)).leftJoin((EntityPath)pItmTag)).on((Predicate)pItmTag.id.eq(this.itmTag.pid))).where((Predicate)this.itmTag.id.eq((Object)id));
        return (ItmTagVO)query.fetchOne();
    }

    public void updateTagStatusByIds(List<Long> ids, String status) {
        this.jpaQueryFactory.update((EntityPath)this.itmTag).set((Path)this.itmTag.status, (Object)status).where(new Predicate[]{this.itmTag.id.in(ids)}).execute();
    }

    public void softDeleteTagById(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.itmTag).set(this.itmTag.deleteFlag, (Object)1).where(new Predicate[]{this.itmTag.id.eq((Object)id)}).execute();
    }

    public List<Long> findIdsByPids(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.itmTag.id).from((EntityPath)this.itmTag)).where((Predicate)this.itmTag.pid.in(ids))).fetch();
    }

    public List<ItmTagDTO> findDtoByTagCodes(List<String> tagCodes) {
        return ((JPAQuery)this.selectTagDto().where((Predicate)this.itmTag.tagCode.in(tagCodes))).fetch();
    }

    public List<ItmTagDTO> findAllDto() {
        return this.selectTagDto().fetch();
    }

    private JPAQuery<ItmTagDTO> selectTagDto() {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmTagDTO.class, (Expression[])new Expression[]{this.itmTag.id, this.itmTag.tagCode, this.itmTag.tagName})).from((EntityPath)this.itmTag)).where((Predicate)this.itmTag.deleteFlag.isNull().or((Predicate)this.itmTag.deleteFlag.eq((Object)0)));
    }

    public ItmTagRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itmTagTreeVOQBean = Projections.bean(ItmTagTreeVO.class, (Expression[])new Expression[]{this.itmTag.id, this.itmTag.pid, this.itmTag.sortNo, this.itmTag.grade, this.itmTag.tagCode, this.itmTag.tagName, this.itmTag.tagType, this.itmTag.status});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

