/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.convert.ItmBrandConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmBrandDO;
import com.elitesland.yst.supportdomain.item.param.ItmBrandPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmBrandSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmBrandService;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandVO;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmBrandServiceImpl
implements ItmBrandService {
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmBrandRepo itmBrandRepo;
    private final ItmBrandRepoProc itmBrandRepoProc;
    private final ItmItemRepoProc itmItemRepoProc;

    @Override
    public PagingVO<ItmBrandPagingVO> itmBrandPagingSearch(ItmBrandPagingParam param) {
        return this.itmBrandRepoProc.findBrandPagingResults(param);
    }

    @Override
    public ItmBrandVO findItmBrandDetailsById(Long id) {
        return this.itmBrandRepoProc.findDetailsById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateItmBrand(ItmBrandSaveParam param) {
        ItmBrandDO itmBrandDO;
        if (param.getId() == null) {
            if (StringUtils.isBlank((CharSequence)param.getBrandName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.itmBrandRepo.existsByBrandName(param.getBrandName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728");
            }
            itmBrandDO = ItmBrandConvert.INSTANCE.paramToDo(param);
            String brandCode = this.sysNumberGeneratorWrapper.generate("BRAND_NO");
            if (this.itmBrandRepo.existsByBrandCode(brandCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u54c1\u724c\u7f16\u53f7\uff1a" + brandCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            itmBrandDO.setBrandCode(brandCode);
        } else {
            if (!StringUtils.isBlank((CharSequence)param.getBrandName()) && this.itmBrandRepo.existsByBrandNameAndIdNot(param.getBrandName(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728");
            }
            Optional optional = this.itmBrandRepo.findById(param.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u54c1\u724c");
            }
            itmBrandDO = (ItmBrandDO)optional.get();
            ItmBrandConvert.INSTANCE.updateDoFromSaveParam(param, itmBrandDO);
        }
        ItmBrandDO result = (ItmBrandDO)this.itmBrandRepo.save(itmBrandDO);
        return result.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void switchStatusByIds(List<Long> ids, String status) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u9009\u62e9\u54c1\u724c");
        }
        this.itmBrandRepoProc.updateStatusByIds(ids, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteById(Long id) {
        Optional brandDoOptional = this.itmBrandRepo.findById(id);
        if (brandDoOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        ItmBrandDO brand = (ItmBrandDO)brandDoOptional.get();
        if (this.itmItemRepoProc.existsByBrandCodeAndItemNotDelete(brand.getBrandCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u724c\u5df2\u88ab\u5546\u54c1\u5360\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.itmBrandRepoProc.softDeleteById(id);
    }

    public ItmBrandServiceImpl(SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmBrandRepo itmBrandRepo, ItmBrandRepoProc itmBrandRepoProc, ItmItemRepoProc itmItemRepoProc) {
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmBrandRepo = itmBrandRepo;
        this.itmBrandRepoProc = itmBrandRepoProc;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

