/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.item.convert.ItmCateContrParaConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.param.ItmCateContrParaSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmCateGrossMarginUpdateParam;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCateContrParaRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCateContrParaService;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaVO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmCateContrParaServiceImpl
implements ItmCateContrParaService {
    private final ItmCateContrParaRepo itmCateContrParaRepo;
    private final ItmCateContrParaRepoProc itmCateContrParaRepoProc;
    private PriMainPriceService priMainPriceService;

    @Lazy
    @Autowired
    public void setPriMainPriceService(PriMainPriceService priMainPriceService) {
        this.priMainPriceService = priMainPriceService;
    }

    @Override
    @SysCodeProc
    public List<ItmCateContrParaVO> findContrParamsByItemCateCode(String itemCateCode) {
        List<ItmCateContrParaVO> vos = this.itmCateContrParaRepoProc.findParamsByItemCateCode(itemCateCode);
        List<PriCatePricePagingVO> priCatePricePagingVos = this.priMainPriceService.priCatePriceQuery(Collections.singletonList(itemCateCode));
        if (CollectionUtils.isNotEmpty(priCatePricePagingVos) && priCatePricePagingVos.size() == 1) {
            PriCatePricePagingVO priCatePricePagingVO = priCatePricePagingVos.get(0);
            ItmCateContrParaVO price4ParaVo = new ItmCateContrParaVO();
            price4ParaVo.setItemCateCode(itemCateCode);
            price4ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_B.getCode());
            price4ParaVo.setControlParamValue(priCatePricePagingVO.getPrice4().toPlainString());
            vos.add(price4ParaVo);
            ItmCateContrParaVO price5ParaVo = new ItmCateContrParaVO();
            price5ParaVo.setItemCateCode(itemCateCode);
            price5ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_C.getCode());
            price5ParaVo.setControlParamValue(priCatePricePagingVO.getPrice5().toPlainString());
            vos.add(price5ParaVo);
        }
        return vos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmCateContrParaHardSave(String itemCateCode, List<ItmCateContrParaSaveParam> params) {
        if (StringUtils.isBlank((CharSequence)itemCateCode)) {
            return;
        }
        this.itmCateContrParaRepo.deleteByItemCateCode(itemCateCode);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmCateContrParaDO> itmCateContrParaDos = ItmCateContrParaConvert.INSTANCE.saveParamToDO(params);
        itmCateContrParaDos.forEach(t -> t.setItemCateCode(itemCateCode));
        this.itmCateContrParaRepo.saveAll(itmCateContrParaDos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteByItemCateCode(String itemCateCode) {
        this.itmCateContrParaRepoProc.softDeleteByItemCateCode(itemCateCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCateGrossMargin(List<ItmCateGrossMarginUpdateParam> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        for (ItmCateGrossMarginUpdateParam param : params) {
            if (!PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal().equals(param.getPriceType())) continue;
            if (PriMainPriceUdcEnum.PRI_PRICE_TYPE3_ITEM_GROSS_MARGIN_B.getUdcVal().equals(param.getPriceType3())) {
                this.itmCateContrParaRepoProc.updateValueByCodeAndItemCateCode(param.getItemCateCode(), ItmCateControlParamEnum.GROSS_MARGIN_B.getCode(), param.getPrice().toString());
                continue;
            }
            if (!PriMainPriceUdcEnum.PRI_PRICE_TYPE3_ITEM_GROSS_MARGIN_C.getUdcVal().equals(param.getPriceType3())) continue;
            this.itmCateContrParaRepoProc.updateValueByCodeAndItemCateCode(param.getItemCateCode(), ItmCateControlParamEnum.GROSS_MARGIN_C.getCode(), param.getPrice().toString());
        }
    }

    @Override
    public List<ItmCateContrParaVO> findContrParamsByItemCateCodeSet(Set<String> itemCateCodeSet) {
        List<ItmCateContrParaVO> vos = this.itmCateContrParaRepoProc.findParamsByItemCateCodeSet(itemCateCodeSet);
        List<PriCatePricePagingVO> priCatePricePagingVos = this.priMainPriceService.priCatePriceQuery(new ArrayList<String>(itemCateCodeSet));
        if (CollectionUtils.isNotEmpty(priCatePricePagingVos)) {
            for (PriCatePricePagingVO priCatePricePagingVO : priCatePricePagingVos) {
                ItmCateContrParaVO price4ParaVo = new ItmCateContrParaVO();
                price4ParaVo.setItemCateCode(priCatePricePagingVO.getItemCateCode());
                price4ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_B.getCode());
                price4ParaVo.setControlParamValue(priCatePricePagingVO.getPrice4().toPlainString());
                vos.add(price4ParaVo);
                ItmCateContrParaVO price5ParaVo = new ItmCateContrParaVO();
                price5ParaVo.setItemCateCode(priCatePricePagingVO.getItemCateCode());
                price5ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_C.getCode());
                price5ParaVo.setControlParamValue(priCatePricePagingVO.getPrice5().toPlainString());
                vos.add(price5ParaVo);
            }
        }
        return vos;
    }

    public ItmCateContrParaServiceImpl(ItmCateContrParaRepo itmCateContrParaRepo, ItmCateContrParaRepoProc itmCateContrParaRepoProc) {
        this.itmCateContrParaRepo = itmCateContrParaRepo;
        this.itmCateContrParaRepoProc = itmCateContrParaRepoProc;
    }
}

