/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.convert.ItmCatePropConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropDO;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropSearchParam;
import com.elitesland.yst.supportdomain.item.param.ItmPropSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropValueService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropDetailVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropValueVO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItmCatePropServiceImpl
implements ItmCatePropService {
    private ItmItemCateService itmItemCateService;
    private final ItmCatePropValueService itmCatePropValueService;
    private final ItmPropService itmPropService;
    private final ItmCatePropRepo itmCatePropRepo;
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmItemPropRepoProc itmItemPropRepoProc;

    @Lazy
    @Autowired
    public void setItmItemCateService(ItmItemCateService itmItemCateService) {
        this.itmItemCateService = itmItemCateService;
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmCatePropPagingVO> searchPagingByParam(ItmCatePropSearchParam param) {
        PagingVO<ItmCatePropPagingVO> result = this.itmCatePropRepoProc.searchPagingByParam(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            Set<Long> catePropIds = result.getRecords().stream().map(ItmCatePropPagingVO::getId).collect(Collectors.toSet());
            Map<Long, List<ItmCatePropValueVO>> propValueMap = this.itmCatePropValueService.findPropValuesByCatePropIds(catePropIds).stream().collect(Collectors.groupingBy(ItmCatePropValueVO::getCatePropId));
            result.getRecords().forEach(t -> {
                t.setItemCatePath(this.itmItemCateService.findItemCatePath(t.getItemCateCode()));
                if (propValueMap.containsKey(t.getId())) {
                    List propValues = (List)propValueMap.get(t.getId());
                    String propValueNames = propValues.stream().map(ItmCatePropValueVO::getPropValueName).collect(Collectors.joining("\u3001"));
                    t.setValueNames(propValueNames);
                }
            });
        }
        return result;
    }

    @Override
    public ItmCatePropDetailVO getDetailById(Long id) {
        ItmCatePropDetailVO result = this.itmCatePropRepoProc.findDetailById(id);
        List<ItmCatePropValueVO> propValues = this.itmCatePropValueService.findPropValuesByCatePropIds(Collections.singleton(result.getId()));
        result.setValues(propValues);
        if (!StringUtils.isBlank((CharSequence)result.getItemCateCode())) {
            result.setItemCatePath(this.itmItemCateService.findItemCatePath(result.getItemCateCode()));
        }
        return result;
    }

    @Override
    public List<ItmCatePropVO> getPropsByItemCateCode(String itemCateCode) {
        List<ItmCatePropVO> result = this.itmCatePropRepoProc.findPropsByItemCateCode(itemCateCode);
        Set<Long> catePropIds = result.stream().map(ItmCatePropVO::getId).collect(Collectors.toSet());
        Map<Long, List<ItmCatePropValueVO>> propValueMap = this.itmCatePropValueService.findPropValuesByCatePropIds(catePropIds).stream().collect(Collectors.groupingBy(ItmCatePropValueVO::getCatePropId));
        result.forEach(t -> {
            if (propValueMap.containsKey(t.getId())) {
                t.setValues((List)propValueMap.get(t.getId()));
            }
        });
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long itmCatePropSaveOrUpdate(ItmCatePropSaveParam param) {
        ItmCatePropDO itmCatePropDO = null;
        if (param.getId() == null) {
            if (!StringUtils.isBlank((CharSequence)param.getCatePropCode()) && this.itmCatePropRepo.existsByItemCateCodeAndCatePropCode(param.getItemCateCode(), param.getCatePropCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u54c1\u7c7b\u5df2\u5b58\u5728\u76f8\u540c\u5c5e\u6027");
            }
            itmCatePropDO = ItmCatePropConvert.INSTANCE.saveParamToDO(param);
        } else {
            if (StringUtils.isNotBlank((CharSequence)param.getCatePropCode()) && this.itmCatePropRepo.existsByItemCateCodeAndCatePropCodeAndIdNot(param.getItemCateCode(), param.getCatePropCode(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u54c1\u7c7b\u5df2\u5b58\u5728\u76f8\u540c\u5c5e\u6027");
            }
            Optional itmCatePropDoOptional = this.itmCatePropRepo.findById(param.getId());
            if (itmCatePropDoOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u7c7b\u5c5e\u6027" + param.getCatePropCode() + "\u4e0d\u5b58\u5728");
            }
            itmCatePropDO = (ItmCatePropDO)itmCatePropDoOptional.get();
            ItmCatePropConvert.INSTANCE.updateDoFromSaveParam(param, itmCatePropDO);
        }
        if (StringUtils.isBlank((CharSequence)param.getCatePropCode())) {
            if (StringUtils.isBlank((CharSequence)param.getCatePropName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ItmPropSaveParam propSaveParam = ItmPropSaveParam.builder().catePropName(param.getCatePropName()).build();
            String catePropCode = this.itmPropService.saveProp(propSaveParam);
            itmCatePropDO.setCatePropCode(catePropCode);
        }
        ItmCatePropDO result = (ItmCatePropDO)this.itmCatePropRepo.save(itmCatePropDO);
        Long catePropId = result.getId();
        this.itmCatePropValueService.itmCatePropValuesHardSave(catePropId, param.getValues());
        return catePropId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteById(Long id) {
        Optional optional = this.itmCatePropRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        ItmCatePropDO itmCateProp = (ItmCatePropDO)optional.get();
        if (this.itmItemPropRepoProc.existsByCatePropCodeAndItemNotDelete(itmCateProp.getCatePropCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5c5e\u6027\u5df2\u88ab\u5546\u54c1\u5360\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.itmCatePropRepoProc.softDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteByItemCateCode(String itemCateCode) {
        this.itmCatePropRepoProc.softDeleteByItemCateCode(itemCateCode);
    }

    public ItmCatePropServiceImpl(ItmCatePropValueService itmCatePropValueService, ItmPropService itmPropService, ItmCatePropRepo itmCatePropRepo, ItmCatePropRepoProc itmCatePropRepoProc, ItmItemPropRepoProc itmItemPropRepoProc) {
        this.itmCatePropValueService = itmCatePropValueService;
        this.itmPropService = itmPropService;
        this.itmCatePropRepo = itmCatePropRepo;
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.itmItemPropRepoProc = itmItemPropRepoProc;
    }
}

