/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.convert.ItmCatePropValueConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmCatePropValueDO;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropValueSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropValueRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropValueService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropValueVO;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmCatePropValueServiceImpl
implements ItmCatePropValueService {
    private final ItmCatePropValueRepo itmCatePropValueRepo;
    private final ItmCatePropValueRepoProc itmCatePropValueRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmCatePropValuesHardSave(Long catePropId, List<ItmCatePropValueSaveParam> params) {
        if (catePropId == null) {
            return;
        }
        this.itmCatePropValueRepo.deleteByCatePropId(catePropId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmCatePropValueDO> itmCatePropValueDos = ItmCatePropValueConvert.INSTANCE.saveParamToDO(params);
        for (ItmCatePropValueDO value : itmCatePropValueDos) {
            value.setCatePropId(catePropId);
        }
        this.itmCatePropValueRepo.saveAll(itmCatePropValueDos);
    }

    @Override
    public List<ItmCatePropValueVO> findPropValuesByCatePropIds(Set<Long> catePropIds) {
        return this.itmCatePropValueRepoProc.findValuesByCateIds(catePropIds);
    }

    @Override
    public void itmCatePropValueDelete(Long catePropId) {
        this.itmCatePropValueRepo.deleteByCatePropId(catePropId);
    }

    public ItmCatePropValueServiceImpl(ItmCatePropValueRepo itmCatePropValueRepo, ItmCatePropValueRepoProc itmCatePropValueRepoProc) {
        this.itmCatePropValueRepo = itmCatePropValueRepo;
        this.itmCatePropValueRepoProc = itmCatePropValueRepoProc;
    }
}

