/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemWhetherFreezeParam;
import com.elitesland.yst.supportdomain.item.component.repo.ItmItemLifeRepoProc;
import com.elitesland.yst.supportdomain.item.entity.ItmItemStatusConfigDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepo;
import com.elitesland.yst.supportdomain.item.service.ItmCheckLifeStatusService;
import com.elitesland.yst.supportdomain.item.task.repo.ItmItemLifeStatusJobRepoProc;
import com.elitesland.yst.supportdomain.item.vo.ItmCheckBusinessStatusVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusVO;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItmCheckLifeStatusServiceImpl
implements ItmCheckLifeStatusService {
    private static final Logger log = LoggerFactory.getLogger(ItmCheckLifeStatusServiceImpl.class);
    private final ItmItemLifeStatusJobRepoProc itmItemLifeStatusJobRepoProc;
    private final ItmItemLifeRepoProc itmItemLifeRepoProc;
    private final ItmItemStatusConfigRepo itmItemStatusConfigRepo;
    private final UdcService sysUdcService;

    @Override
    public void checkLifeStatusConfig(ItmItemWhetherFreezeParam param) {
        List<ItmCheckBusinessStatusVO> businessList = param.getBusinessList();
        List<String> itemCodes = param.getItemCodes();
        if (CollectionUtils.isEmpty(businessList) && CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(businessList) && CollectionUtils.isNotEmpty(itemCodes)) {
            throw new BusinessException("\u5546\u54c1\u7f16\u7801\u5217\u8868\u3001\u7ecf\u8425\u76ee\u5f55\u6570\u636e\u5217\u8868\uff0c\u4e0d\u80fd\u540c\u65f6\u4e0d\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty(businessList)) {
            this.checkBusinessLifeStatusConfig(param);
        } else if (CollectionUtils.isNotEmpty(itemCodes)) {
            this.checkItemLifeStatusConfig(param);
        }
    }

    private void checkBusinessLifeStatusConfig(ItmItemWhetherFreezeParam param) {
        Map lifeStatusMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        String checkItemLifeStatus = this.getStatusConfigByBusinessCode(param);
        if (StringUtils.isBlank((CharSequence)checkItemLifeStatus)) {
            return;
        }
        LocalDateTime statusTime = param.getStatusTime();
        if (null == statusTime) {
            statusTime = LocalDateTime.now();
        }
        List<ItmCheckBusinessStatusVO> checkBusinessList = param.getBusinessList();
        List<String> itemCodes = checkBusinessList.stream().map(ItmCheckBusinessStatusVO::getItemCode).distinct().collect(Collectors.toList());
        List<ItmItemLifeStatusVO> globalStatusList = this.itmItemLifeRepoProc.findGlobalLifeStatusOnTime(itemCodes, statusTime);
        Map<String, List> globalStatusMap = globalStatusList.stream().collect(Collectors.groupingBy(ItmItemLifeStatusVO::getItemCode)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ItmItemLifeStatusVO::getItemLifeStatus).distinct().collect(Collectors.toList())));
        List<ItmItemLifeStatusVO> nonGlobalStatusList = this.itmItemLifeRepoProc.findBusinessLifeStatusOnTime(param.getBusinessList(), statusTime);
        Map<String, List> nonGlobalStatusMap = nonGlobalStatusList.stream().collect(Collectors.groupingBy(life -> life.getItemCode() + "-" + life.getBranchPlant())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ItmItemLifeStatusVO::getItemLifeStatus).distinct().collect(Collectors.toList())));
        ArrayList errorItemCodeList = new ArrayList();
        globalStatusMap.forEach((key, value) -> {
            if (value.contains(checkItemLifeStatus)) {
                errorItemCodeList.add(key);
            }
        });
        nonGlobalStatusMap.forEach((key, value) -> {
            if (value.contains(checkItemLifeStatus)) {
                errorItemCodeList.add(List.of(key.split("-")).get(0));
            }
        });
        String errorItemCodeString = String.join((CharSequence)"\u3001", errorItemCodeList);
        if (StringUtils.isNotBlank((CharSequence)errorItemCodeString)) {
            throw new BusinessException(MessageFormat.format("\u5546\u54c1:{0},\u5df2{1}", errorItemCodeString, lifeStatusMap.get(checkItemLifeStatus)));
        }
    }

    private void checkItemLifeStatusConfig(ItmItemWhetherFreezeParam param) {
        Map lifeStatusMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        String checkItemLifeStatus = this.getStatusConfigByBusinessCode(param);
        if (StringUtils.isBlank((CharSequence)checkItemLifeStatus)) {
            return;
        }
        List<String> itemCodes = param.getItemCodes();
        LocalDateTime statusTime = param.getStatusTime();
        if (null == statusTime) {
            statusTime = LocalDateTime.now();
        }
        List<ItmItemLifeStatusVO> lifeStatusList = this.itmItemLifeRepoProc.findItemLifeStatusOnTime(itemCodes, statusTime);
        Map<String, String> itemLifeStatusMap = this.splitBusinessAndItemLifeStatus(lifeStatusList);
        ArrayList errorItemCodes = new ArrayList();
        itemLifeStatusMap.forEach((key, value) -> {
            if (value.contains(checkItemLifeStatus)) {
                errorItemCodes.add(key);
            }
        });
        String errorItemCodeString = Strings.join(errorItemCodes, (char)'\u3001');
        if (StringUtils.isNotBlank((CharSequence)errorItemCodeString)) {
            throw new BusinessException(MessageFormat.format("\u5546\u54c1:{0},\u5df2{1}", errorItemCodeString, lifeStatusMap.get(checkItemLifeStatus)));
        }
    }

    private String getStatusConfigByBusinessCode(ItmItemWhetherFreezeParam param) {
        ItmItemStatusConfigDO itmItemStatusConfigDO;
        String businessCode = param.getBusinessCode();
        Optional<ItmItemStatusConfigDO> byBusinessCode = this.itmItemStatusConfigRepo.findByBusinessCode(businessCode);
        String itemLifeStatus = param.getItemLifeStatus();
        String checkItemLifeStatus = null;
        if (byBusinessCode.isPresent()) {
            itmItemStatusConfigDO = byBusinessCode.get();
            checkItemLifeStatus = this.getCheckItemLifeStatus(itemLifeStatus, itmItemStatusConfigDO);
            if (StringUtils.isBlank((CharSequence)checkItemLifeStatus)) {
                return null;
            }
        } else {
            return null;
        }
        log.info("\u6821\u9a8c\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\uff0c\u72b6\u6001\u914d\u7f6e\u4fe1\u606f" + itmItemStatusConfigDO);
        return checkItemLifeStatus;
    }

    private Map<String, String> splitBusinessAndItemLifeStatus(List<ItmItemLifeStatusVO> lifeStatusVOS) {
        List<String> allGroupOuCode = this.itmItemLifeStatusJobRepoProc.findAllGroupOuCode();
        List saleFreezeList = lifeStatusVOS.stream().filter(lifeStatus -> ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal().equals(lifeStatus.getItemLifeStatus())).collect(Collectors.toList());
        List purcFreezeList = lifeStatusVOS.stream().filter(lifeStatus -> ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal().equals(lifeStatus.getItemLifeStatus())).collect(Collectors.toList());
        Map<String, List<ItmItemLifeStatusVO>> itemSaleFreezeMap = saleFreezeList.stream().filter(saleFreeze -> {
            Boolean globalOrNot = saleFreeze.getGlobalOrNot();
            boolean b = !allGroupOuCode.contains(saleFreeze.getItemSource()) && saleFreeze.getBranchPlant().equals(saleFreeze.getItemSource());
            return globalOrNot != false || b;
        }).collect(Collectors.groupingBy(ItmItemLifeStatusVO::getItemCode));
        Map<String, List<ItmItemLifeStatusVO>> itemPurcFreezeMap = purcFreezeList.stream().filter(purcFreeze -> purcFreeze.getGlobalOrNot() != false || purcFreeze.getGlobalOrNot() == false && purcFreeze.getBranchPlant().equals(purcFreeze.getItemSource())).collect(Collectors.groupingBy(ItmItemLifeStatusVO::getItemCode));
        HashMap itemLifeStatusSaleMap = new HashMap();
        if (MapUtils.isNotEmpty(itemSaleFreezeMap)) {
            itemSaleFreezeMap.keySet().forEach(sale -> itemLifeStatusSaleMap.put(sale, ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal()));
        }
        HashMap itemLifeStatusPurcMap = new HashMap();
        if (MapUtils.isNotEmpty(itemPurcFreezeMap)) {
            itemPurcFreezeMap.keySet().forEach(sale -> itemLifeStatusPurcMap.put(sale, ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal()));
        }
        Map<String, String> itemLifeStatusMap = Stream.of(itemLifeStatusSaleMap, itemLifeStatusPurcMap).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1 + ";" + v2));
        return itemLifeStatusMap;
    }

    private String getCheckItemLifeStatus(String itemLifeStatus, ItmItemStatusConfigDO statusConfig) {
        if (statusConfig.getConfigStatus().booleanValue()) {
            if (ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal().equals(itemLifeStatus)) {
                if (!statusConfig.getBusinExcuSignStatus2().booleanValue()) {
                    return ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal();
                }
            } else if (ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal().equals(itemLifeStatus)) {
                if (!statusConfig.getBusinExcuSignStatus3().booleanValue()) {
                    return ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal();
                }
            } else {
                throw new BusinessException("\u751f\u547d\u72b6\u6001\uff1a" + itemLifeStatus + ",\u4e0d\u5b58\u5728");
            }
        }
        return null;
    }

    public ItmCheckLifeStatusServiceImpl(ItmItemLifeStatusJobRepoProc itmItemLifeStatusJobRepoProc, ItmItemLifeRepoProc itmItemLifeRepoProc, ItmItemStatusConfigRepo itmItemStatusConfigRepo, UdcService sysUdcService) {
        this.itmItemLifeStatusJobRepoProc = itmItemLifeStatusJobRepoProc;
        this.itmItemLifeRepoProc = itmItemLifeRepoProc;
        this.itmItemStatusConfigRepo = itmItemStatusConfigRepo;
        this.sysUdcService = sysUdcService;
    }
}

