/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSubmitParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemApproveService;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessService;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemApproveServiceImpl
implements ItmItemApproveService {
    private final PriMainPriceService priMainPriceService;
    private final ItmItemBusinessService itmItemBusinessService;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemRepoProc itmItemRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSubmitItem(ItmItemSubmitParam param) {
        if (CollectionUtils.isEmpty(param.getIds())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u9009\u62e9\u5546\u54c1");
        }
        if (this.itmItemRepo.existsBySpuIdInAndItemStatus(param.getIds(), ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u4e3a \u542f\u7528 \u7684\u5546\u54c1");
        }
        List<Long> spuIds = param.getIds();
        LocalDateTime now = LocalDateTime.now();
        this.itmItemRepoProc.approveItemBySpuIds(spuIds, ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal(), LocalDateTime.now());
        List<String> itemCodes = this.itmItemRepoProc.findItemCodesBySpuIds(spuIds);
        LocalDate nowDate = now.toLocalDate();
        this.priMainPriceService.updatePriceStatus(itemCodes, ComUdcEnum.COM_ACTIVE.getUdcVal(), LocalDateTime.of(nowDate, LocalTime.MIN), LocalDateTime.of(nowDate.plusYears(30L), LocalTime.MIN));
        List<ItmItemBusinessSaveParam> itmItemBusinessSaveParams = this.itmItemRepoProc.findItemBusinessSaveParamBySpuIds(spuIds);
        this.itmItemBusinessService.itmItemBusinessSave(itmItemBusinessSaveParams, true);
    }

    public ItmItemApproveServiceImpl(PriMainPriceService priMainPriceService, ItmItemBusinessService itmItemBusinessService, ItmItemRepo itmItemRepo, ItmItemRepoProc itmItemRepoProc) {
        this.priMainPriceService = priMainPriceService;
        this.itmItemBusinessService = itmItemBusinessService;
        this.itmItemRepo = itmItemRepo;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

