/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.convert.ItmItemAttachmentConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemAttachmentDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemAttachmentSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmSkuImageSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemAttachmentRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemAttachmentRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemAttachmentService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemAttachmentVO;
import com.elitesland.yst.supportdomain.item.vo.ItmSkuImageVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemAttachmentServiceImpl
implements ItmItemAttachmentService {
    private final ItmItemAttachmentRepo itmItemAttachmentRepo;
    private final ItmItemAttachmentRepoProc itmItemAttachmentRepoProc;

    @Override
    public List<ItmSkuImageVO> findSkuImgByItemIds(List<Long> itemIds) {
        return this.itmItemAttachmentRepoProc.findSkuImgByItemIds(itemIds);
    }

    @Override
    public List<ItmItemAttachmentVO> findAttachmentByItemIdAndFileType(Long itemId, String fileType) {
        return this.itmItemAttachmentRepoProc.findItemImagesByItemIdAndFileType(itemId, fileType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemAttachmentsHardSave(Long itemId, List<ItmItemAttachmentSaveParam> params) {
        if (itemId == null) {
            return;
        }
        this.itmItemAttachmentRepo.deleteByItemId(itemId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemAttachmentDO> attachments = ItmItemAttachmentConvert.INSTANCE.saveParamToDo(params);
        attachments.forEach(attachment -> attachment.setItemId(itemId));
        this.itmItemAttachmentRepo.saveAll(attachments);
    }

    @Override
    public void skuImgHardSave(List<Long> itemIds, List<ItmSkuImageSaveParam> params) {
        if (CollectionUtils.isNotEmpty(itemIds)) {
            this.itmItemAttachmentRepo.deleteByItemIdIn(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        this.itmItemAttachmentRepo.saveAll(ItmItemAttachmentConvert.INSTANCE.skuImageSaveParamToDo(params));
    }

    public ItmItemAttachmentServiceImpl(ItmItemAttachmentRepo itmItemAttachmentRepo, ItmItemAttachmentRepoProc itmItemAttachmentRepoProc) {
        this.itmItemAttachmentRepo = itmItemAttachmentRepo;
        this.itmItemAttachmentRepoProc = itmItemAttachmentRepoProc;
    }
}

