/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.convert.ItmItemBomConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBomDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBomRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBomRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemBomService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBomDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBomPagingVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@UnicomTag(value="GENERAL")
public class ItmItemBomServiceImpl
implements ItmItemBomService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemBomServiceImpl.class);
    private final ItmItemBomRepo itmItemBomRepo;
    private final ItmItemBomRepoProc itmItemBomRepoProc;

    @SysCodeProc
    public PagingVO<ItmItemBomPagingVO> itemBomPagingSearch(ItmItemBomPagingParam param) {
        return this.itmItemBomRepoProc.itemBomPagingSearch(param);
    }

    @SysCodeProc
    public ItmItemBomDetailsVO findBomDetailsById(Long id) {
        ItmItemBomDetailsVO result = this.itmItemBomRepoProc.findBomDetailsById(id);
        if (result == null) {
            return null;
        }
        result.setBomDetailsVos(this.itmItemBomRepoProc.findBomDetailsByPid(result.getId()));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long itemBomSaveOrUpdate(ItmItemBomSaveParam param) {
        Long id = param.getId();
        List<ItmItemBomSaveParam> bomSubSaveParams = param.getBomDetailsVos();
        if (CollectionUtils.isEmpty(bomSubSaveParams)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b50\u4ef6\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (id == null) {
            ItmItemBomDO bomDo = ItmItemBomConvert.INSTANCE.saveParamToDo(param);
            this.itmItemBomRepo.save((Object)bomDo);
            id = bomDo.getId();
            ArrayList<ItmItemBomDO> bomSubDos = new ArrayList<ItmItemBomDO>();
            for (ItmItemBomSaveParam saveParam : bomSubSaveParams) {
                ItmItemBomDO subDo = ItmItemBomConvert.INSTANCE.saveParamToDo(saveParam);
                subDo.setPid(id);
                bomSubDos.add(subDo);
            }
            this.itmItemBomRepo.saveAll(bomSubDos);
        } else {
            Optional optional = this.itmItemBomRepo.findById(id);
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u7ed3\u6784\uff1a" + id + " \u4e0d\u5b58\u5728");
            }
            ItmItemBomDO bomDo = (ItmItemBomDO)((Object)optional.get());
            ItmItemBomConvert.INSTANCE.updateDoFromSaveParam(param, bomDo);
            this.itmItemBomRepo.save((Object)bomDo);
            List<ItmItemBomDO> bomSubDos = this.itmItemBomRepo.findByPid(bomDo.getId());
            List existsIds = bomSubDos.stream().map(BaseModel::getId).collect(Collectors.toList());
            List insertSubParams = bomSubSaveParams.stream().filter(t -> t.getId() == null || !existsIds.contains(t.getId())).collect(Collectors.toList());
            List updateSubParams = bomSubSaveParams.stream().filter(t -> existsIds.contains(t.getId())).collect(Collectors.toList());
            List updateIds = updateSubParams.stream().map(ItmItemBomSaveParam::getId).collect(Collectors.toList());
            List deleteSubDos = bomSubDos.stream().filter(t -> !updateIds.contains(t.getId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(insertSubParams)) {
                List insertSubDos = insertSubParams.stream().map(insertParam -> {
                    ItmItemBomDO subDo = ItmItemBomConvert.INSTANCE.saveParamToDo((ItmItemBomSaveParam)insertParam);
                    subDo.setPid(bomDo.getId());
                    return subDo;
                }).collect(Collectors.toList());
                this.itmItemBomRepo.saveAll(insertSubDos);
            }
            if (CollectionUtils.isNotEmpty(updateSubParams)) {
                Map<Long, ItmItemBomDO> existsDoMap = bomSubDos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t));
                List updateSubDos = updateSubParams.stream().map(updateParam -> {
                    ItmItemBomDO subDo = (ItmItemBomDO)((Object)((Object)existsDoMap.get(updateParam.getId())));
                    ItmItemBomConvert.INSTANCE.updateDoFromSaveParam((ItmItemBomSaveParam)updateParam, subDo);
                    return subDo;
                }).collect(Collectors.toList());
                this.itmItemBomRepo.saveAll(updateSubDos);
            }
            if (CollectionUtils.isNotEmpty(deleteSubDos)) {
                this.itmItemBomRepo.deleteInBatch(deleteSubDos);
            }
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemBomSoftDelete(Long id) {
        ArrayList<Long> softDeleteIds = new ArrayList<Long>();
        softDeleteIds.add(id);
        List<Long> subIds = this.itmItemBomRepoProc.findIdsByPid(id);
        if (CollectionUtils.isNotEmpty(subIds)) {
            this.findAllSubIds(softDeleteIds, subIds);
        }
        this.itmItemBomRepoProc.softDeleteBomByIds(softDeleteIds);
    }

    @Override
    public void getData() {
        log.warn("not tongming user\uff0chave no data");
    }

    private void findAllSubIds(List<Long> ids, List<Long> subIds) {
        subIds.forEach(id -> {
            List<Long> subIdList = this.itmItemBomRepoProc.findIdsByPid((Long)id);
            if (CollectionUtils.isNotEmpty((Collection)subIds)) {
                this.findAllSubIds(ids, subIdList);
            }
            ids.add((Long)id);
        });
    }

    public ItmItemBomServiceImpl(ItmItemBomRepo itmItemBomRepo, ItmItemBomRepoProc itmItemBomRepoProc) {
        this.itmItemBomRepo = itmItemBomRepo;
        this.itmItemBomRepoProc = itmItemBomRepoProc;
    }
}

