/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.component.PermissionWithRoleCacheService;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.SysUdcProxyService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.convert.ItmItemBusinessConvert;
import com.elitesland.yst.supportdomain.item.convert.ItmItemConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessConfigParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessService;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessStatusService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemPropService;
import com.elitesland.yst.supportdomain.item.service.ItmItemTagService;
import com.elitesland.yst.supportdomain.item.service.ItmItemUomConvService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessDetailVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSkuVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.service.OrgEmpBuService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDVO;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuVO;
import com.elitesland.yst.supportdomain.org.vo.SystemBuTreeVO;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.SystemSettingNoEnum;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import com.elitesland.yst.system.service.SysUdcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemBusinessServiceImpl
implements ItmItemBusinessService {
    private static final String NORMAL = "\u6b63\u5e38";
    private final ItmItemBusinessRepo itmItemBusinessRepo;
    private final ItmItemBusinessRepoProc itmItemBusinessRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgBuTreeDService orgBuTreeDService;
    private final ItmItemRepoProc itmItemRepoProc;
    private final SysUdcProxyService sysUdcProxyService;
    private final PriMainPriceService priMainPriceService;
    private final ItmItemUomConvService itmItemUomConvService;
    private final ItmItemTagService itmItemTagService;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuRepoProc orgBuRepoProc;
    private final OrgBuTreeDRepoProc orgBuTreeDRepoProc;
    private final OrgBuRepo orgBuRepo;
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemPropService itmItemPropService;
    private final OrgBuTreeVersionService orgBuTreeVersionService;
    private final ItmItemBusinessStatusService itmItemBusinessStatusService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    private final OrgEmpBuService orgEmpBuService;
    private final SysUdcService sysUdcService;
    private final PermissionWithRoleCacheService permissionWithRoleCacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemBusinessSave(List<ItmItemBusinessSaveParam> itmItemBusinessSaveParams, boolean isPush) {
        ArrayList<ItmItemBusinessDO> itmItemBusinessDOs = new ArrayList<ItmItemBusinessDO>();
        SystemBuTreeVO activeVersionByBuTreeCode = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.ITEM_BUSI_TREE.name());
        if (null == activeVersionByBuTreeCode) {
            throw new BusinessException("\u83b7\u53d6\u7ecf\u8425\u76ee\u5f55\u7ec4\u7ec7\u6811\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e");
        }
        String orgBuTreeCode = activeVersionByBuTreeCode.getBuTreeCode();
        List buCodeList = this.orgBuRepoProc.findBuDtoByTreeCode(orgBuTreeCode).stream().map(OrgBuDTO::getBuCode).collect(Collectors.toList());
        for (ItmItemBusinessSaveParam itmItemBusinessSaveParam : itmItemBusinessSaveParams) {
            ItmItemBusinessDO itmItemBusinessDO = ItmItemBusinessConvert.INSTANCE.paramToDo(itmItemBusinessSaveParam);
            itmItemBusinessDO.setBuCode(itmItemBusinessSaveParam.getItemSource());
            if (isPush) {
                Optional<OrgBuDO> optional = this.orgBuRepo.findByBuCode(itmItemBusinessSaveParam.getItemSource());
                if (optional.isEmpty()) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7ec4\u7ec7");
                }
                if (this.itmItemBusinessRepo.existsBySpuIdAndBuCode(itmItemBusinessSaveParam.getSpuId(), itmItemBusinessSaveParam.getItemSource())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\uff1a" + itmItemBusinessSaveParam.getSpuCode() + "\uff0c\u7ec4\u7ec7\uff1a" + optional.get().getBuName() + "\uff0c\u5df2\u53d1\u5e03\u5230\u7ecf\u8425\u76ee\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u5e03");
                }
                if (CollectionUtils.isNotEmpty(buCodeList) && !buCodeList.contains(itmItemBusinessSaveParam.getItemSource())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\uff1a" + optional.get().getBuName() + "\uff0c\u4e0d\u5728\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6811\u4e0a");
                }
            }
            if (!CollectionUtils.isNotEmpty(buCodeList) || !buCodeList.contains(itmItemBusinessSaveParam.getItemSource())) continue;
            itmItemBusinessDO.setBuTreeDId(this.orgBuTreeDRepoProc.searchBuTreeDIdByTreeCodeAndBuCode(orgBuTreeCode, itmItemBusinessSaveParam.getItemSource()));
            itmItemBusinessDOs.add(itmItemBusinessDO);
        }
        this.itmItemBusinessRepo.saveAll(itmItemBusinessDOs);
        this.itmItemRepoProc.updateReleaseFlag(itmItemBusinessDOs.stream().map(ItmItemBusinessDO::getSpuId).collect(Collectors.toList()));
        this.itmItemBusinessStatusService.saveDataToBusinessStatus(itmItemBusinessDOs, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemBusinessUpdate(ItmItemBusinessSaveParam itmItemBusinessSaveParam) {
        Optional optional = this.itmItemBusinessRepo.findById(itmItemBusinessSaveParam.getId());
        if (optional.isPresent()) {
            ItmItemBusinessDO itmItemBusinessDO = (ItmItemBusinessDO)optional.get();
            ItmItemBusinessConvert.INSTANCE.updateDoFromSaveParam(itmItemBusinessSaveParam, itmItemBusinessDO);
            itmItemBusinessDO.setReturnExchangePolicy(itmItemBusinessSaveParam.getReturnExchangePolicy());
            itmItemBusinessDO.setWarrantyPeriod(itmItemBusinessSaveParam.getWarrantyPeriod());
            itmItemBusinessDO.setWarrantyPeriodUnit(itmItemBusinessSaveParam.getWarrantyPeriodUnit());
            this.itmItemBusinessRepo.save(itmItemBusinessDO);
            if (itmItemBusinessDO.getItemSource().equals(itmItemBusinessDO.getBuCode())) {
                List<ItmItemDO> itemItemDOList = this.itmItemRepo.findBySpuCode(itmItemBusinessDO.getSpuCode());
                List itemItemDOs = itemItemDOList.stream().map(s -> {
                    ItmItemBusinessConvert.INSTANCE.updateDoFromItemSaveParam(itmItemBusinessSaveParam, (ItmItemDO)s);
                    s.setReturnExchangePolicy(itmItemBusinessSaveParam.getReturnExchangePolicy());
                    s.setWarrantyPeriod(itmItemBusinessSaveParam.getWarrantyPeriod());
                    s.setWarrantyPeriodUnit(itmItemBusinessSaveParam.getWarrantyPeriodUnit());
                    return s;
                }).collect(Collectors.toList());
                this.itmItemRepo.saveAll(itemItemDOs);
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4e0d\u5b58\u5728\uff0cid:" + itmItemBusinessSaveParam.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemBusinessCreate(ItmItemBusinessConfigParam ItmItemBusinessConfigParam2) {
        ArrayList<ItmItemBusinessDO> itmItemBusinessDOResult = new ArrayList<ItmItemBusinessDO>();
        List itmItemBusinessDOList = this.itmItemBusinessRepo.findAllById(ItmItemBusinessConfigParam2.getIds());
        ItmItemBusinessConfigParam2.getBuTreeDIds().forEach(s -> itmItemBusinessDOList.forEach(t -> {
            ItmItemBusinessDO itmItemBusinessDO = (ItmItemBusinessDO)SerializationUtils.clone((Serializable)t);
            String buCode = this.orgBuTreeDRepoProc.searchBuCodeByBuTreeDId((Long)s);
            itmItemBusinessDO.setBuTreeDId((Long)s);
            itmItemBusinessDO.setBuCode(buCode);
            itmItemBusinessDOResult.add(itmItemBusinessDO);
        }));
        StringBuilder str = new StringBuilder();
        itmItemBusinessDOResult.forEach(s -> {
            if (this.itmItemBusinessRepo.existsBySpuIdAndBuCode(s.getSpuId(), s.getBuCode())) {
                Optional<OrgBuDO> optional = this.orgBuRepo.findByBuCode(s.getBuCode());
                str.append("\u7ec4\u7ec7:" + optional.get().getBuName() + ",\u5df2\u5206\u914d\u5546\u54c1\uff1a" + s.getSpuCode() + ",\u8bf7\u52ff\u91cd\u590d\u5206\u914d;");
            }
        });
        if (StringUtils.isNotBlank((CharSequence)str)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, str.toString());
        }
        this.itmItemBusinessRepo.saveAll(itmItemBusinessDOResult);
        this.itmItemBusinessStatusService.saveDataToBusinessStatus(itmItemBusinessDOResult, false);
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemBusinessPagingVO> itemPagingSearch(ItmItemBusinessPagingParam param) {
        List<Long> buTreeDIds = param.getBuTreeDId() == null ? this.getEmpBuDetail().stream().map(s -> s.getEmpBuTreeDId()).collect(Collectors.toList()) : Collections.singletonList(param.getBuTreeDId());
        List<String> buCodes = this.orgBuTreeDRepoProc.searchBuCodeByBuTreeDIds(buTreeDIds);
        PagingVO<ItmItemBusinessPagingVO> result = this.itmItemBusinessRepoProc.selectPagingResult(param, buCodes);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ArrayList taxRateNos = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemBusinessPagingVO record : result.getRecords()) {
                ComTaxRateRpcDTO tax;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        return result;
    }

    @Override
    @SysCodeProc
    public ItmItemBusinessDetailVO searchItmItemBusinessDetail(Long id) {
        Map lifeStatusMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        ItmItemBusinessDetailVO result = this.itmItemBusinessRepoProc.searchItmItemBusinessDetail(id);
        if (result == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
        }
        if (!StringUtils.isBlank((CharSequence)result.getItemCateCode())) {
            result.setItemCatePath(this.itmItemCateService.findItemCatePath(result.getItemCateCode()));
        }
        ArrayList<String> taxRateNos = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo())) {
            taxRateNos.add(result.getTaxRateNo());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2())) {
            taxRateNos.add(result.getTaxRateNo2());
        }
        if (CollectionUtils.isNotEmpty(taxRateNos)) {
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxRateNos);
            List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
            if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                ComTaxRateRpcDTO tax;
                Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo()) && (tax = taxMap.get(result.getTaxRateNo())) != null) {
                    result.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRateDesc(tax.getTaxRateDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2()) && (tax = taxMap.get(result.getTaxRateNo2())) != null) {
                    result.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRate2Desc(tax.getTaxRateDesc());
                }
            }
        }
        List<ItmItemSkuVO> skuVos = this.itmItemRepoProc.findSkuBusinessVosBySpuId(result.getSpuId(), result.getBuCode());
        this.sysUdcProxyService.translate(skuVos);
        if (!CollectionUtils.isEmpty(skuVos)) {
            List<Long> itemIds = skuVos.stream().map(ItmItemSkuVO::getId).collect(Collectors.toList());
            List<String> itemCodes = skuVos.stream().map(ItmItemSkuVO::getItemCode).collect(Collectors.toList());
            Map<String, PriItemPricePagingVO> skuPriceMap = this.priMainPriceService.priMainPriceQuery(itemCodes, true).stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
            Map<Long, List<ItmItemTagVO>> skuTagMap = this.itmItemTagService.findVoByItemIds(itemIds).stream().collect(Collectors.groupingBy(ItmItemTagVO::getItemId));
            Map<Long, List<ItmItemUomConvVO>> uomConvMap = this.itmItemUomConvService.getItmItemUomConvByItemIds(itemIds).stream().collect(Collectors.groupingBy(ItmItemUomConvVO::getItemId));
            skuVos.forEach(sku -> {
                if (StringUtils.isBlank((CharSequence)sku.getItemLifeStatus())) {
                    sku.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getValDesc());
                } else {
                    String itemLifeStatusName = Arrays.stream(sku.getItemLifeStatus().split(";")).map(lifeStatusMap::get).collect(Collectors.joining(";"));
                    sku.setItemLifeStatus(itemLifeStatusName);
                }
                Long itemId = sku.getId();
                String itemCode = sku.getItemCode();
                if (skuPriceMap.containsKey(itemCode)) {
                    ItmItemConvert.INSTANCE.updateSkuVoFromPricePagingVo((PriItemPricePagingVO)skuPriceMap.get(itemCode), (ItmItemSkuVO)sku);
                }
                if (skuTagMap.containsKey(itemId)) {
                    sku.setItemTags((List)skuTagMap.get(itemId));
                }
                if (uomConvMap.containsKey(itemId)) {
                    sku.setItemUomConvVos((List)uomConvMap.get(itemId));
                }
            });
            result.setItemSkuVos(skuVos);
        }
        result.setItemPropVos(this.itmItemPropService.findVosByItemId(result.getSpuId()));
        return result;
    }

    @Override
    public List<OrgBuTreeDVO> searchItmItemBusinessBuTree() {
        SystemBuTreeVO systemBuTreeVO = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.ITEM_BUSI_TREE.name());
        Optional<OrgBuTreeDO> optional = this.orgBuTreeRepo.findByBuTreeCodeAndNowVersion(systemBuTreeVO.getBuTreeCode(), systemBuTreeVO.getVersion());
        List<OrgBuTreeDVO> result = new ArrayList<OrgBuTreeDVO>();
        if (optional.isPresent()) {
            Long buTreeId = optional.get().getId();
            Long buTreeDId = (Long)this.getEmpBuDetail().stream().map(s -> s.getEmpBuTreeDId()).collect(Collectors.toList()).get(0);
            result = this.orgBuTreeDService.orgBuTreeDSearchTree(buTreeId, OrgUdcEnum.BU_STATUS_CLOSED.getUdcVal(), buTreeDId);
        }
        return result;
    }

    private List<OrgEmpBuVO> getEmpBuDetail() {
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            Long userId = generalUserDetails.getUser().getId();
            Optional<OrgEmpDO> orgEmpOptional = this.orgEmpRepo.findByUserId(userId);
            if (orgEmpOptional.isPresent()) {
                SystemBuTreeVO systemBuTreeVO = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.ITEM_BUSI_TREE.name());
                List<OrgEmpBuVO> orgEmpBuVos = this.orgEmpBuService.findEmpBuVoByEmpIdsAndVersion(Collections.singletonList(orgEmpOptional.get().getId()), systemBuTreeVO.getVersion());
                List<OrgEmpBuVO> orgEmpBuVoList = orgEmpBuVos.stream().filter(s -> UtilEnum.BU_ORG_TREE.getValue().equals(s.getEmpBuTreeCode()) && null != s.getEmpBuTreeDId()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(orgEmpBuVoList)) {
                    return orgEmpBuVoList;
                }
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u767b\u5f55\u4eba\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5728\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6811\u4e0a");
            }
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u767b\u5f55\u4eba\u5458\u5de5\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f");
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemBusinessPagingVO> itmItemBusinessSearchUp(ItmItemBusinessPagingParam param) {
        Long buTreeDId = (Long)this.getEmpBuDetail().stream().map(s -> s.getEmpBuTreeDId()).collect(Collectors.toList()).get(0);
        Optional optional = this.orgBuTreeDRepo.findById(buTreeDId);
        if (optional.isPresent()) {
            if (((OrgBuTreeDDO)optional.get()).getPid() != null && ((OrgBuTreeDDO)optional.get()).getPid() != 0L) {
                param.setBuTreeDId(((OrgBuTreeDDO)optional.get()).getPid());
                return this.itemPagingSearch(param);
            }
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u65e0\u4e0a\u7ea7\u7ec4\u7ec7");
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u8282\u70b9\uff1a" + buTreeDId + ",\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemBusinessSet(List<Long> ids) {
        List<Long> buTreeDIds = this.getEmpBuDetail().stream().map(s -> s.getEmpBuTreeDId()).collect(Collectors.toList());
        ItmItemBusinessConfigParam itmItemBusinessConfigParam = new ItmItemBusinessConfigParam();
        itmItemBusinessConfigParam.setBuTreeDIds(buTreeDIds);
        itmItemBusinessConfigParam.setIds(ids);
        this.itmItemBusinessCreate(itmItemBusinessConfigParam);
    }

    public ItmItemBusinessServiceImpl(ItmItemBusinessRepo itmItemBusinessRepo, ItmItemBusinessRepoProc itmItemBusinessRepoProc, ItmItemCateService itmItemCateService, OrgEmpRepo orgEmpRepo, OrgBuTreeDService orgBuTreeDService, ItmItemRepoProc itmItemRepoProc, SysUdcProxyService sysUdcProxyService, PriMainPriceService priMainPriceService, ItmItemUomConvService itmItemUomConvService, ItmItemTagService itmItemTagService, OrgBuTreeRepo orgBuTreeRepo, OrgBuRepoProc orgBuRepoProc, OrgBuTreeDRepoProc orgBuTreeDRepoProc, OrgBuRepo orgBuRepo, OrgBuTreeDRepo orgBuTreeDRepo, ItmItemRepo itmItemRepo, ItmItemPropService itmItemPropService, OrgBuTreeVersionService orgBuTreeVersionService, ItmItemBusinessStatusService itmItemBusinessStatusService, OrgEmpBuService orgEmpBuService, SysUdcService sysUdcService, PermissionWithRoleCacheService permissionWithRoleCacheService) {
        this.itmItemBusinessRepo = itmItemBusinessRepo;
        this.itmItemBusinessRepoProc = itmItemBusinessRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.orgEmpRepo = orgEmpRepo;
        this.orgBuTreeDService = orgBuTreeDService;
        this.itmItemRepoProc = itmItemRepoProc;
        this.sysUdcProxyService = sysUdcProxyService;
        this.priMainPriceService = priMainPriceService;
        this.itmItemUomConvService = itmItemUomConvService;
        this.itmItemTagService = itmItemTagService;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuRepoProc = orgBuRepoProc;
        this.orgBuTreeDRepoProc = orgBuTreeDRepoProc;
        this.orgBuRepo = orgBuRepo;
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.itmItemRepo = itmItemRepo;
        this.itmItemPropService = itmItemPropService;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
        this.itmItemBusinessStatusService = itmItemBusinessStatusService;
        this.orgEmpBuService = orgEmpBuService;
        this.sysUdcService = sysUdcService;
        this.permissionWithRoleCacheService = permissionWithRoleCacheService;
    }
}

