/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.convert.ItmItemBusinessStatusConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessStatusRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessStatusService;
import com.elitesland.yst.supportdomain.item.task.service.ItmItemLifeStatusAsyncService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuInfoVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ItmItemBusinessStatusServiceImpl
implements ItmItemBusinessStatusService {
    private final ItmItemBusinessStatusRepo itmItemBusinessStatusRepo;
    private final ItmItemRepoProc itmItemRepoProc;
    private final ItmItemLifeStatusAsyncService itmItemLifeStatusAsyncService;

    @Override
    public void saveDataToBusinessStatus(List<ItmItemBusinessDO> dos, Boolean isRelease) {
        List<Long> spuIds = dos.stream().map(ItmItemBusinessDO::getSpuId).collect(Collectors.toList());
        List<ItmItemSpuInfoVO> spuInfoBySpuIds = this.itmItemRepoProc.findSpuInfoBySpuIds(spuIds);
        Map<Long, List<ItmItemSpuInfoVO>> spuIdMap = spuInfoBySpuIds.stream().collect(Collectors.groupingBy(ItmItemSpuInfoVO::getSpuId));
        ArrayList resultDos = new ArrayList();
        if (isRelease.booleanValue()) {
            List<String> itemCodeList = spuInfoBySpuIds.stream().map(ItmItemSpuInfoVO::getItemCode).collect(Collectors.toList());
            Map itemCodeMap = this.itmItemRepoProc.findSpuInfoByItemCode(itemCodeList).stream().collect(HashMap::new, (m, v) -> m.put(v.getItemCode(), v.getItemStatus2()), HashMap::putAll);
            dos.forEach(business -> {
                List itmItemSpuInfoVOS = (List)spuIdMap.get(business.getSpuId());
                List<ItmItemBusinessStatusDO> itmItemBusinessStatusDOS = ItmItemBusinessStatusConvert.INSTANCE.businessDoToSpuDo(itmItemSpuInfoVOS);
                if (CollectionUtils.isNotEmpty(itmItemBusinessStatusDOS)) {
                    itmItemBusinessStatusDOS.forEach(statusDo -> {
                        statusDo.setItemSource(business.getItemSource());
                        statusDo.setBuCode(business.getBuCode());
                        String itemLifeStatus = (String)itemCodeMap.get(statusDo.getItemCode());
                        if (StringUtils.isBlank((CharSequence)itemLifeStatus)) {
                            statusDo.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
                        } else {
                            statusDo.setItemLifeStatus(itemLifeStatus);
                        }
                    });
                    resultDos.addAll(itmItemBusinessStatusDOS);
                }
            });
        } else {
            dos.forEach(business -> {
                List itmItemSpuInfoVOS = (List)spuIdMap.get(business.getSpuId());
                List<ItmItemBusinessStatusDO> itmItemBusinessStatusDOS = ItmItemBusinessStatusConvert.INSTANCE.businessDoToSpuDo(itmItemSpuInfoVOS);
                if (CollectionUtils.isNotEmpty(itmItemBusinessStatusDOS)) {
                    itmItemBusinessStatusDOS.forEach(statusDo -> {
                        statusDo.setItemSource(business.getItemSource());
                        statusDo.setBuCode(business.getBuCode());
                        statusDo.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
                    });
                    resultDos.addAll(itmItemBusinessStatusDOS);
                }
            });
        }
        this.itmItemBusinessStatusRepo.saveAll(resultDos);
        this.itmItemLifeStatusAsyncService.timeTaskAsyncLifeStatus();
    }

    public ItmItemBusinessStatusServiceImpl(ItmItemBusinessStatusRepo itmItemBusinessStatusRepo, ItmItemRepoProc itmItemRepoProc, ItmItemLifeStatusAsyncService itmItemLifeStatusAsyncService) {
        this.itmItemBusinessStatusRepo = itmItemBusinessStatusRepo;
        this.itmItemRepoProc = itmItemRepoProc;
        this.itmItemLifeStatusAsyncService = itmItemLifeStatusAsyncService;
    }
}

