/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ItmItemCateCacheManager {
    private static final Logger log = LoggerFactory.getLogger(ItmItemCateCacheManager.class);
    private final Map<String, List<ItmItemCateSimpleTree>> cateSimpleTreeCacheMap = new ConcurrentHashMap<String, List<ItmItemCateSimpleTree>>();
    private final ItmItemCateRepoProc itmItemCateRepoProc;

    @Async
    public void refreshItemCatePathCache(String itemCateCode) {
        if (StringUtils.isBlank((CharSequence)itemCateCode)) {
            return;
        }
        Long id = this.itmItemCateRepoProc.findIdByCode(itemCateCode);
        this.refreshItemCatePathCache(id);
    }

    @Async
    public void refreshItemCatePathCache(Long id) {
        if (id == null) {
            return;
        }
        ItmItemCateSimpleTree treeNode = this.itmItemCateRepoProc.findSimpleTreeById(id);
        ItmItemCateSimpleTree result = this.buildPath(treeNode);
        List<ItmItemCateSimpleTree> cacheValue = Collections.singletonList(result);
        this.cateSimpleTreeCacheMap.put(treeNode.getItemCateCode(), cacheValue);
    }

    @Async
    public void deleteItemCatePathCache(String itemCateCode) {
        if (StringUtils.isBlank((CharSequence)itemCateCode)) {
            return;
        }
        this.cateSimpleTreeCacheMap.remove(itemCateCode);
    }

    public List<ItmItemCateSimpleTree> findItemCatePath(String itemCateCode) {
        if (this.cateSimpleTreeCacheMap.containsKey(itemCateCode)) {
            return this.cateSimpleTreeCacheMap.get(itemCateCode);
        }
        this.refreshItemCatePathCache(itemCateCode);
        return this.cateSimpleTreeCacheMap.getOrDefault(itemCateCode, Collections.emptyList());
    }

    private ItmItemCateSimpleTree buildPath(ItmItemCateSimpleTree treeNode) {
        if (treeNode.getPid() == null || treeNode.getPid() == 0L) {
            return treeNode;
        }
        ItmItemCateSimpleTree pSimpleTree = this.itmItemCateRepoProc.findSimpleTreeById(treeNode.getPid());
        if (pSimpleTree != null) {
            pSimpleTree.setTreeNodes(Collections.singletonList(treeNode));
            return this.buildPath(pSimpleTree);
        }
        return treeNode;
    }

    public ItmItemCateCacheManager(ItmItemCateRepoProc itmItemCateRepoProc) {
        this.itmItemCateRepoProc = itmItemCateRepoProc;
    }
}

