/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.TableColumnExtEnum;
import com.elitesland.yst.supportdomain.common.service.TableColumnExtService;
import com.elitesland.yst.supportdomain.item.convert.ItmItemCateConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateDTO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.dto.TableColumnExtDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemCateDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemCateDO;
import com.elitesland.yst.supportdomain.item.param.ItmCateContrParaSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmCateTagSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateAddParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemCatePageParamVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateSearchParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmCateContrParaService;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmTagService;
import com.elitesland.yst.supportdomain.item.service.impl.ItmItemCateCacheManager;
import com.elitesland.yst.supportdomain.item.vo.ItmCateContrParaVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateQualifyVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.elitesland.yst.supportdomain.item.vo.YstItemClassView;
import com.elitesland.yst.supportdomain.pri.param.PriCatePriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.ItmCateControlParamEnum;
import com.elitesland.yst.supportdomain.util.TreeUtils;
import com.elitesland.yst.system.service.SysUdcService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ItmItemCateServiceImpl
implements ItmItemCateService {
    private final ItmCatePropService itmCatePropService;
    private final ItmCateContrParaService itmCateContrParaService;
    private final TableColumnExtService tableColumnExtService;
    private final ItmTagService itmTagService;
    private final PriMainPriceService priMainPriceService;
    private final ItmItemCateCacheManager itmItemCateCacheManager;
    private final ItmItemCateRepo itmItemCateRepo;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final ItmItemRepoProc itmItemRepoProc;
    @DubboReference
    private SysUdcService udcService;
    private static final Integer IS_BASIC = 1;

    @Override
    @CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")
    @Transactional(rollbackFor={Exception.class})
    public Long itmItemCateCreate(ItmItemCateAddParam itmItemCateParam) {
        if (this.itmItemCateRepo.existsByItemCateCode(itmItemCateParam.getItemCateCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u7c7b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (this.itmItemCateRepo.existsByItemCateNameAndPid(itmItemCateParam.getItemCateName(), itmItemCateParam.getPid())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        ItmItemCateDO itmItemCateDO = ItmItemCateConvert.INSTANCE.saveToDo(itmItemCateParam);
        boolean isRoot = false;
        if (itmItemCateParam.getPid() == null || itmItemCateParam.getPid() == 0L) {
            itmItemCateDO.setPid(0L);
            itmItemCateDO.setGrade(1);
            isRoot = true;
        }
        ItmItemCateDO result = (ItmItemCateDO)this.itmItemCateRepo.save(itmItemCateDO);
        if (isRoot) {
            result.setCodePath(result.getItemCateCode());
        } else {
            Optional pCodeOptional = this.itmItemCateRepo.findById(itmItemCateParam.getPid());
            if (pCodeOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u4e0a\u7ea7\u54c1\u7c7b");
            }
            ItmItemCateDO pCode = (ItmItemCateDO)pCodeOptional.get();
            result.setCodePath(pCode.getCodePath() + "/" + result.getItemCateCode());
            result.setGrade(pCode.getGrade() + 1);
        }
        this.itmItemCateRepo.save(result);
        if (IS_BASIC.equals(itmItemCateParam.getItemCateIsBasic())) {
            if (CollectionUtils.isNotEmpty(itmItemCateParam.getContrParaSaveParams())) {
                PriCatePriceSaveRowParam priCatePriceSaveParam = new PriCatePriceSaveRowParam();
                List<ItmCateContrParaSaveParam> cateContrParams = itmItemCateParam.getContrParaSaveParams();
                Iterator<ItmCateContrParaSaveParam> iterator = cateContrParams.iterator();
                while (iterator.hasNext()) {
                    ItmCateContrParaSaveParam cateContrParam = iterator.next();
                    if (ItmCateControlParamEnum.GROSS_MARGIN_B.getCode().equals(cateContrParam.getControlParamCode())) {
                        priCatePriceSaveParam.setPrice4(new BigDecimal(cateContrParam.getControlParamValue()));
                        iterator.remove();
                        continue;
                    }
                    if (!ItmCateControlParamEnum.GROSS_MARGIN_C.getCode().equals(cateContrParam.getControlParamCode())) continue;
                    priCatePriceSaveParam.setPrice5(new BigDecimal(cateContrParam.getControlParamValue()));
                    iterator.remove();
                }
                priCatePriceSaveParam.setItemCateCode(result.getItemCateCode());
                priCatePriceSaveParam.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
                LocalDate now = LocalDate.now();
                priCatePriceSaveParam.setValidFrom(LocalDateTime.of(now, LocalTime.MIN));
                priCatePriceSaveParam.setValidTo(LocalDateTime.of(now.plusYears(30L), LocalTime.MIN));
                this.priMainPriceService.priCatePriceSave(Collections.singletonList(priCatePriceSaveParam));
            }
            this.itmCateContrParaService.itmCateContrParaHardSave(result.getItemCateCode(), itmItemCateParam.getContrParaSaveParams());
            this.cateTagHardSave(result.getId(), result.getItemCateCode(), itmItemCateParam.getTagSaveParams());
            this.cateQualifyTypesHardSave(result.getId(), result.getItemCateCode(), itmItemCateParam.getQualifyTypes());
        }
        return result.getId();
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")})
    public Long itmItemCateUpdate(ItmItemCateAddParam itmItemCateParam) {
        Optional optional = this.itmItemCateRepo.findById(itmItemCateParam.getId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u54c1\u7c7b\uff1a" + itmItemCateParam.getItemCateCode());
        }
        if (this.itmItemCateRepo.existsByItemCateNameAndPidAndIdNot(itmItemCateParam.getItemCateName(), itmItemCateParam.getPid(), itmItemCateParam.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        ItmItemCateDO itmItemCateDO = (ItmItemCateDO)optional.get();
        ItmItemCateConvert.INSTANCE.updateDoFromAddParam(itmItemCateParam, itmItemCateDO);
        ItmItemCateDO result = (ItmItemCateDO)this.itmItemCateRepo.save(itmItemCateDO);
        if (IS_BASIC.equals(result.getItemCateIsBasic())) {
            List<ItmCateContrParaSaveParam> cateContrParams = itmItemCateParam.getContrParaSaveParams();
            if (CollectionUtils.isNotEmpty(cateContrParams)) {
                Iterator<ItmCateContrParaSaveParam> iterator = cateContrParams.iterator();
                while (iterator.hasNext()) {
                    ItmCateContrParaSaveParam cateContrParam = iterator.next();
                    if (ItmCateControlParamEnum.GROSS_MARGIN_B.getCode().equals(cateContrParam.getControlParamCode())) {
                        iterator.remove();
                        continue;
                    }
                    if (!ItmCateControlParamEnum.GROSS_MARGIN_C.getCode().equals(cateContrParam.getControlParamCode())) continue;
                    iterator.remove();
                }
            }
            this.itmCateContrParaService.itmCateContrParaHardSave(itmItemCateDO.getItemCateCode(), cateContrParams);
            this.cateTagHardSave(result.getId(), result.getItemCateCode(), itmItemCateParam.getTagSaveParams());
            this.cateQualifyTypesHardSave(result.getId(), result.getItemCateCode(), itmItemCateParam.getQualifyTypes());
        }
        this.itmItemCateCacheManager.deleteItemCatePathCache(itmItemCateDO.getItemCateCode());
        return result.getId();
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")})
    @Transactional(rollbackFor={Exception.class})
    public void itmItemCateSoftDelete(Long id) {
        Optional optional = this.itmItemCateRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u54c1\u7c7b\u4e0d\u5b58\u5728");
        }
        ItmItemCateDO itmItemCate = (ItmItemCateDO)optional.get();
        if (this.itmItemCateRepo.existsByPid(itmItemCate.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u54c1\u7c7b\u5b58\u5728\u5b50\u54c1\u7c7b\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        String itemCateCode = itmItemCate.getItemCateCode();
        if (this.itmItemRepoProc.existsByCateCodeAndItemNotDelete(itemCateCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u54c1\u7c7b\u5df2\u88ab\u5546\u54c1\u5360\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.itmCatePropService.softDeleteByItemCateCode(itemCateCode);
        this.itmCateContrParaService.softDeleteByItemCateCode(itemCateCode);
        this.tableColumnExtService.softDeleteExtColumn(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), itemCateCode);
        this.tableColumnExtService.softDeleteExtColumn(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName(), TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName(), itemCateCode);
        this.priMainPriceService.priCatePriceDelete(Collections.singletonList(itemCateCode));
        this.itmItemCateRepoProc.softDeleteById(id);
        this.itmItemCateCacheManager.deleteItemCatePathCache(itemCateCode);
    }

    public List<ItmItemCateVO> build(List<ItmItemCateVO> itmItemCateVOList, Long id, List<ItmItemCateVO> result) {
        List treeList = itmItemCateVOList.stream().filter(s -> id.equals(s.getPid())).collect(Collectors.toList());
        for (ItmItemCateVO itmItemCateVO : treeList) {
            result.add(itmItemCateVO);
            this.build(itmItemCateVOList, itmItemCateVO.getId(), result);
        }
        return result;
    }

    @Override
    public PagingVO<ItmItemCateVO> itmItemCateSearchByParam(ItmItemCateSearchParam itmItemCateParam) {
        return this.itmItemCateRepoProc.itmItemCateSearchByParam(itmItemCateParam);
    }

    @Override
    public ItmItemCateDetailsVO itmItemCateSearchById(Long id) {
        ItmItemCateDetailsVO details = this.itmItemCateRepoProc.searchDetailsById(id);
        if (details != null && IS_BASIC.equals(details.getItemCateIsBasic())) {
            String itemCateCode = details.getItemCateCode();
            List<ItmCateContrParaVO> controlParamVos = this.itmCateContrParaService.findContrParamsByItemCateCode(itemCateCode);
            List<PriCatePricePagingVO> priCatePricePagingVos = this.priMainPriceService.priCatePriceQuery(Collections.singletonList(itemCateCode));
            if (CollectionUtils.isNotEmpty(priCatePricePagingVos) && priCatePricePagingVos.size() == 1) {
                PriCatePricePagingVO priCatePricePagingVO = priCatePricePagingVos.get(0);
                ItmCateContrParaVO price4ParaVo = new ItmCateContrParaVO();
                price4ParaVo.setItemCateCode(itemCateCode);
                price4ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_B.getCode());
                price4ParaVo.setControlParamValue(priCatePricePagingVO.getPrice4().toPlainString());
                controlParamVos.add(price4ParaVo);
                ItmCateContrParaVO price5ParaVo = new ItmCateContrParaVO();
                price5ParaVo.setItemCateCode(itemCateCode);
                price5ParaVo.setControlParamCode(ItmCateControlParamEnum.GROSS_MARGIN_C.getCode());
                price5ParaVo.setControlParamValue(priCatePricePagingVO.getPrice5().toPlainString());
                controlParamVos.add(price5ParaVo);
            }
            details.setContrParaVos(controlParamVos);
            details.setCateTags(this.getCateTags(itemCateCode));
            details.setQualifyTypes(this.getCateQualifyTypes(itemCateCode));
        }
        return details;
    }

    @Override
    public List<ItmItemCateVO> itmItemCateSearchByPid(Long pid) {
        QItmItemCateDO itmItemCateDO = QItmItemCateDO.itmItemCateDO;
        BooleanExpression predicate = itmItemCateDO.pid.eq((Object)pid);
        Iterator result = this.itmItemCateRepo.findAll((Predicate)predicate).iterator();
        ArrayList<ItmItemCateVO> itmItemCateVOList = new ArrayList<ItmItemCateVO>();
        while (result.hasNext()) {
            ItmItemCateVO itmItemCateVO;
            itmItemCateVO.setIsLeaf(!this.itmItemCateRepo.existsByPid((itmItemCateVO = ItmItemCateConvert.INSTANCE.doToVo((ItmItemCateDO)result.next())).getId()));
            itmItemCateVOList.add(itmItemCateVO);
        }
        return itmItemCateVOList;
    }

    @Override
    @Cacheable(cacheNames={"ITEM_CATE"}, key="'TREE'", unless="#result == null")
    public List<ItmItemCateVO> itmItemCateSearchTree() {
        List<ItmItemCateVO> treeVos = this.itmItemCateRepoProc.findAllTreeVos();
        return TreeUtils.buildTree(null, true, treeVos);
    }

    @Override
    public List<ItmItemCateSimpleTree> findItemCatePath(String itemCateCode) {
        return this.itmItemCateCacheManager.findItemCatePath(itemCateCode);
    }

    @Override
    @CacheEvict(cacheNames={"ITEM_CATE"}, key="'TREE'")
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusByIds(Set<Long> ids, String status) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u9009\u62e9\u54c1\u7c7b");
        }
        this.itmItemCateRepoProc.updateStatusByIds(ids, status);
    }

    @Override
    public List<ItmCateTagVO> findCateTagByItemCateCode(String itemCateCode) {
        return this.getCateTags(itemCateCode);
    }

    @Override
    @SysCodeProc
    public List<ItmCateQualifyVO> findCateQualifyTypesByItemCateCode(String itemCateCode) {
        List<TableColumnExtDTO> tableColumnExtDTOS = this.tableColumnExtService.findExtColumnValues(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName(), TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName(), itemCateCode);
        if (CollectionUtils.isEmpty(tableColumnExtDTOS)) {
            return null;
        }
        return tableColumnExtDTOS.stream().map(t -> new ItmCateQualifyVO(t.getColumnValue())).collect(Collectors.toList());
    }

    @Override
    public List<ItmItemCateDTO> findAllItemCateDto() {
        return this.itmItemCateRepoProc.findAllDto();
    }

    private ItmItemCateSimpleTree buildPath(ItmItemCateSimpleTree treeNode) {
        if (treeNode.getPid() == null || treeNode.getPid() == 0L) {
            return treeNode;
        }
        ItmItemCateSimpleTree pSimpleTree = this.itmItemCateRepoProc.findSimpleTreeById(treeNode.getPid());
        if (pSimpleTree != null) {
            pSimpleTree.setTreeNodes(Collections.singletonList(treeNode));
            return this.buildPath(pSimpleTree);
        }
        return treeNode;
    }

    private void cateTagHardSave(Long rowId, String rowCode, List<ItmCateTagSaveParam> tagSaveParams) {
        if (CollectionUtils.isEmpty(tagSaveParams)) {
            this.tableColumnExtService.extColumnHardSave(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), rowId, rowCode, null);
        } else {
            List<String> values = tagSaveParams.stream().map(ItmCateTagSaveParam::getTagCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.tableColumnExtService.extColumnHardSave(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), rowId, rowCode, values);
        }
    }

    private void cateQualifyTypesHardSave(Long rowId, String rowCode, List<String> qualifyTypes) {
        this.tableColumnExtService.extColumnHardSave(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName(), TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName(), rowId, rowCode, qualifyTypes);
    }

    @Override
    public List<ItmCateTagVO> getCateTags(String rowCode) {
        List<TableColumnExtDTO> tableColumnExtDTOS = this.tableColumnExtService.findExtColumnValues(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), rowCode);
        if (CollectionUtils.isEmpty(tableColumnExtDTOS)) {
            return null;
        }
        List<String> tagCodes = tableColumnExtDTOS.stream().map(TableColumnExtDTO::getColumnValue).collect(Collectors.toList());
        List<ItmTagDTO> itmTagDTOS = this.itmTagService.findTagDtoByTagCodes(tagCodes);
        if (CollectionUtils.isEmpty(itmTagDTOS)) {
            return null;
        }
        Map<String, ItmTagDTO> tagDTOMap = itmTagDTOS.stream().collect(Collectors.toMap(ItmTagDTO::getTagCode, t -> t));
        ArrayList<ItmCateTagVO> cateTagVOS = new ArrayList<ItmCateTagVO>();
        for (TableColumnExtDTO columnExtDTO : tableColumnExtDTOS) {
            if (!tagDTOMap.containsKey(columnExtDTO.getColumnValue())) continue;
            ItmTagDTO tag = tagDTOMap.get(columnExtDTO.getColumnValue());
            ItmCateTagVO itmCateTagVO = new ItmCateTagVO();
            itmCateTagVO.setId(tag.getId());
            itmCateTagVO.setTagCode(tag.getTagCode());
            itmCateTagVO.setTagName(tag.getTagName());
            cateTagVOS.add(itmCateTagVO);
        }
        return cateTagVOS;
    }

    @Override
    public List<String> getCateQualifyTypes(String rowCode) {
        List<TableColumnExtDTO> tableColumnExtDTOS = this.tableColumnExtService.findExtColumnValues(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName(), TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName(), rowCode);
        if (CollectionUtils.isEmpty(tableColumnExtDTOS)) {
            return null;
        }
        return tableColumnExtDTOS.stream().map(TableColumnExtDTO::getColumnValue).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<ItmCateTagVO>> getCateTags(Set<String> itemCateCodes) {
        HashMap<String, List<ItmCateTagVO>> resultMap = new HashMap<String, List<ItmCateTagVO>>();
        List<TableColumnExtDTO> tableColumnExtDTOS = this.tableColumnExtService.findExtColumnValues(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), itemCateCodes);
        if (CollectionUtils.isEmpty(tableColumnExtDTOS)) {
            return null;
        }
        List<String> tagCodes = tableColumnExtDTOS.stream().map(TableColumnExtDTO::getColumnValue).collect(Collectors.toList());
        List<ItmTagDTO> itmTagDTOS = this.itmTagService.findTagDtoByTagCodes(tagCodes);
        if (CollectionUtils.isEmpty(itmTagDTOS)) {
            return null;
        }
        for (TableColumnExtDTO tableColumnExtDTO : tableColumnExtDTOS) {
            for (ItmTagDTO itmTagDTO : itmTagDTOS) {
                if (!tableColumnExtDTO.getColumnValue().equals(itmTagDTO.getTagCode())) continue;
                ItmCateTagVO itmCateTagVO = new ItmCateTagVO();
                itmCateTagVO.setId(itmTagDTO.getId());
                itmCateTagVO.setTagCode(itmTagDTO.getTagCode());
                itmCateTagVO.setTagName(itmTagDTO.getTagName());
                if (resultMap.get(tableColumnExtDTO.getRowCode()) == null) {
                    ArrayList catList = new ArrayList();
                    resultMap.put(tableColumnExtDTO.getRowCode(), catList);
                }
                ((List)resultMap.get(tableColumnExtDTO.getRowCode())).add(itmCateTagVO);
            }
        }
        return resultMap;
    }

    @Override
    public List<TableColumnExtDTO> getCateQualifyTypes(Set<String> itemCateCodes) {
        return this.tableColumnExtService.findExtColumnValues(TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getTableName(), TableColumnExtEnum.ITEM_CATE_QUALIFY_TYPE.getColumnName(), itemCateCodes);
    }

    @Override
    @SysCodeProc
    public PagingVO<YstItemClassView> searchGetById(ItmItemCatePageParamVO param) {
        QItmItemCateDO itmItemCateDO = QItmItemCateDO.itmItemCateDO;
        BooleanExpression predicate = itmItemCateDO.id.eq((Object)param.getId());
        ArrayList<YstItemClassView> list = new ArrayList<YstItemClassView>();
        ArrayList ids = new ArrayList();
        ArrayList idslist = new ArrayList();
        ItmItemCateVO itmItemCateVO = (ItmItemCateVO)((JPAQuery)this.itmItemCateRepoProc.searchGetById().where((Predicate)predicate)).fetchOne();
        if (null != itmItemCateVO && !ObjectUtils.isEmpty((Object)itmItemCateVO)) {
            if (!ObjectUtils.isEmpty((Object)itmItemCateVO.getPid()) && 0L != itmItemCateVO.getPid()) {
                BooleanExpression predicate2 = itmItemCateDO.id.eq((Object)itmItemCateVO.getPid());
                ItmItemCateVO itmItemCateVO2 = (ItmItemCateVO)((JPAQuery)this.itmItemCateRepoProc.searchGetById().where((Predicate)predicate2)).fetchOne();
                if (null != itmItemCateVO2 && !ObjectUtils.isEmpty((Object)itmItemCateVO2)) {
                    if (!ObjectUtils.isEmpty((Object)itmItemCateVO2.getPid()) && 0L != itmItemCateVO2.getPid()) {
                        BooleanExpression predicate3 = itmItemCateDO.id.eq((Object)itmItemCateVO2.getPid());
                        ItmItemCateVO itmItemCateVO3 = (ItmItemCateVO)((JPAQuery)this.itmItemCateRepoProc.searchGetById().where((Predicate)predicate3)).fetchOne();
                        if (null != itmItemCateVO3 && !ObjectUtils.isEmpty((Object)itmItemCateVO3)) {
                            YstItemClassView ystItemClassView = new YstItemClassView();
                            ystItemClassView.setC1Id(itmItemCateVO3.getId());
                            ystItemClassView.setC1Code(itmItemCateVO3.getItemCateCode());
                            ystItemClassView.setC1Name(itmItemCateVO3.getItemCateName());
                            ystItemClassView.setC2Id(itmItemCateVO2.getId());
                            ystItemClassView.setC2Code(itmItemCateVO2.getItemCateCode());
                            ystItemClassView.setC2Name(itmItemCateVO2.getItemCateName());
                            ystItemClassView.setC3Id(itmItemCateVO.getId());
                            ystItemClassView.setC3Code(itmItemCateVO.getItemCateCode());
                            ystItemClassView.setC3Name(itmItemCateVO.getItemCateName());
                            ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
                            ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
                            ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
                            ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
                            list.add(ystItemClassView);
                            this.fill(list);
                            return new PagingVO(1L, list);
                        }
                        YstItemClassView ystItemClassView = new YstItemClassView();
                        ystItemClassView.setC1Id(itmItemCateVO2.getId());
                        ystItemClassView.setC1Code(itmItemCateVO2.getItemCateCode());
                        ystItemClassView.setC1Name(itmItemCateVO2.getItemCateName());
                        ystItemClassView.setC2Id(itmItemCateVO.getId());
                        ystItemClassView.setC2Code(itmItemCateVO.getItemCateCode());
                        ystItemClassView.setC2Name(itmItemCateVO.getItemCateName());
                        ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
                        ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
                        ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
                        ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
                        list.add(ystItemClassView);
                        this.fill(list);
                        return new PagingVO(1L, list);
                    }
                    ItmItemCatePageParamVO itmItemCatePageParamVO = new ItmItemCatePageParamVO();
                    itmItemCatePageParamVO.setPid(itmItemCateVO.getId());
                    itmItemCatePageParamVO.setSize(param.getSize());
                    itmItemCatePageParamVO.setCurrent(param.getCurrent() + 1);
                    Long total = this.itmItemCateRepoProc.countContractTmplTm(itmItemCatePageParamVO);
                    List<ItmItemCateVO> itmItemCateVOS = this.itmItemCateRepoProc.searchTms(itmItemCatePageParamVO);
                    if (null != itmItemCateVOS && !CollectionUtils.isEmpty(itmItemCateVOS)) {
                        List<YstItemClassView> ystItemClassViewlist = itmItemCateVOS.stream().map(i -> {
                            YstItemClassView ystItemClassView = new YstItemClassView();
                            ystItemClassView.setC1Id(itmItemCateVO2.getId());
                            ystItemClassView.setC1Code(itmItemCateVO2.getItemCateCode());
                            ystItemClassView.setC1Name(itmItemCateVO2.getItemCateName());
                            ystItemClassView.setC2Id(itmItemCateVO.getId());
                            ystItemClassView.setC2Code(itmItemCateVO.getItemCateCode());
                            ystItemClassView.setC2Name(itmItemCateVO.getItemCateName());
                            ystItemClassView.setC3Id(i.getId());
                            ystItemClassView.setC3Code(i.getItemCateCode());
                            ystItemClassView.setC3Name(i.getItemCateName());
                            ystItemClassView.setDefDueDate(i.getDefDueDate());
                            ystItemClassView.setDefDueDateName(i.getDefDueDateName());
                            ystItemClassView.setSafeQtyDays(i.getSafeQtyDays());
                            ystItemClassView.setSafeQtyDaysName(i.getSafeQtyDaysName());
                            return ystItemClassView;
                        }).collect(Collectors.toList());
                        this.fill(ystItemClassViewlist);
                        return total > 0L ? PagingVO.builder().total(total).records(ystItemClassViewlist).build() : new PagingVO();
                    }
                    YstItemClassView ystItemClassView = new YstItemClassView();
                    ystItemClassView.setC1Id(itmItemCateVO2.getId());
                    ystItemClassView.setC1Code(itmItemCateVO2.getItemCateCode());
                    ystItemClassView.setC1Name(itmItemCateVO2.getItemCateName());
                    ystItemClassView.setC2Id(itmItemCateVO.getId());
                    ystItemClassView.setC2Code(itmItemCateVO.getItemCateCode());
                    ystItemClassView.setC2Name(itmItemCateVO.getItemCateName());
                    ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
                    ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
                    ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
                    ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
                    list.add(ystItemClassView);
                    this.fill(list);
                    return new PagingVO(1L, list);
                }
                YstItemClassView ystItemClassView = new YstItemClassView();
                ystItemClassView.setC1Id(itmItemCateVO.getId());
                ystItemClassView.setC1Code(itmItemCateVO.getItemCateCode());
                ystItemClassView.setC1Name(itmItemCateVO.getItemCateName());
                ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
                ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
                ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
                ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
                list.add(ystItemClassView);
                this.fill(list);
                return new PagingVO(1L, list);
            }
            ItmItemCatePageParamVO itmItemCatePageParamVO = new ItmItemCatePageParamVO();
            itmItemCatePageParamVO.setPid(itmItemCateVO.getId());
            Long total = this.itmItemCateRepoProc.countContractTmplTm(itmItemCatePageParamVO);
            if (total > 0L) {
                List<ItmItemCateVO> itmItemCateVOS = this.itmItemCateRepoProc.searchTmss(itmItemCatePageParamVO);
                List<Long> ids2 = itmItemCateVOS.stream().map(ItmItemCateVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(ids2)) {
                    ItmItemCatePageParamVO itmItemCatePageParamVO2 = new ItmItemCatePageParamVO();
                    itmItemCatePageParamVO2.setSize(param.getSize());
                    itmItemCatePageParamVO2.setCurrent(param.getCurrent() + 1);
                    itmItemCatePageParamVO2.setPids(ids2);
                    Long total2 = this.itmItemCateRepoProc.countContractTmplTm(itmItemCatePageParamVO2);
                    List<ItmItemCateVO> itmItemCateVOS2 = this.itmItemCateRepoProc.searchTms(itmItemCatePageParamVO2);
                    if (!CollectionUtils.isEmpty(itmItemCateVOS2)) {
                        List<YstItemClassView> ystItemClassViewlist = itmItemCateVOS2.stream().map(i -> {
                            YstItemClassView ystItemClassView = new YstItemClassView();
                            ystItemClassView.setC1Id(itmItemCateVO.getId());
                            ystItemClassView.setC1Code(itmItemCateVO.getItemCateCode());
                            ystItemClassView.setC1Name(itmItemCateVO.getItemCateName());
                            Optional<ItmItemCateVO> first = itmItemCateVOS.stream().filter(t -> t.getId().equals(i.getPid())).findFirst();
                            if (first.isPresent()) {
                                ystItemClassView.setC2Id(i.getPid());
                                ystItemClassView.setC2Code(first.get().getItemCateCode());
                                ystItemClassView.setC2Name(first.get().getItemCateName());
                            }
                            ystItemClassView.setC3Id(i.getId());
                            ystItemClassView.setC3Code(i.getItemCateCode());
                            ystItemClassView.setC3Name(i.getItemCateName());
                            ystItemClassView.setDefDueDate(i.getDefDueDate());
                            ystItemClassView.setDefDueDateName(i.getDefDueDateName());
                            ystItemClassView.setSafeQtyDays(i.getSafeQtyDays());
                            ystItemClassView.setSafeQtyDaysName(i.getSafeQtyDaysName());
                            return ystItemClassView;
                        }).collect(Collectors.toList());
                        this.fill(ystItemClassViewlist);
                        return total2 > 0L ? PagingVO.builder().total(total2).records(ystItemClassViewlist).build() : new PagingVO();
                    }
                    itmItemCatePageParamVO.setSize(param.getSize());
                    itmItemCatePageParamVO.setCurrent(param.getCurrent() + 1);
                    List<ItmItemCateVO> itmItemCateVOS3 = this.itmItemCateRepoProc.searchTms(itmItemCatePageParamVO);
                    List<YstItemClassView> ystItemClassViewlist = itmItemCateVOS3.stream().map(i -> {
                        YstItemClassView ystItemClassView = new YstItemClassView();
                        ystItemClassView.setC1Id(itmItemCateVO.getId());
                        ystItemClassView.setC1Code(itmItemCateVO.getItemCateCode());
                        ystItemClassView.setC1Name(itmItemCateVO.getItemCateName());
                        ystItemClassView.setC2Id(i.getId());
                        ystItemClassView.setC2Code(i.getItemCateCode());
                        ystItemClassView.setC2Name(i.getItemCateName());
                        ystItemClassView.setDefDueDate(i.getDefDueDate());
                        ystItemClassView.setDefDueDateName(i.getDefDueDateName());
                        ystItemClassView.setSafeQtyDays(i.getSafeQtyDays());
                        ystItemClassView.setSafeQtyDaysName(i.getSafeQtyDaysName());
                        return ystItemClassView;
                    }).collect(Collectors.toList());
                    this.fill(ystItemClassViewlist);
                    return new PagingVO(total.longValue(), ystItemClassViewlist);
                }
                YstItemClassView ystItemClassView = new YstItemClassView();
                ystItemClassView.setC1Id(itmItemCateVO.getId());
                ystItemClassView.setC1Code(itmItemCateVO.getItemCateCode());
                ystItemClassView.setC1Name(itmItemCateVO.getItemCateName());
                ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
                ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
                ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
                ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
                list.add(ystItemClassView);
                this.fill(list);
                return new PagingVO(1L, list);
            }
            YstItemClassView ystItemClassView = new YstItemClassView();
            ystItemClassView.setC1Id(itmItemCateVO.getId());
            ystItemClassView.setC1Code(itmItemCateVO.getItemCateCode());
            ystItemClassView.setC1Name(itmItemCateVO.getItemCateName());
            ystItemClassView.setDefDueDate(itmItemCateVO.getDefDueDate());
            ystItemClassView.setDefDueDateName(itmItemCateVO.getDefDueDateName());
            ystItemClassView.setSafeQtyDays(itmItemCateVO.getSafeQtyDays());
            ystItemClassView.setSafeQtyDaysName(itmItemCateVO.getSafeQtyDaysName());
            list.add(ystItemClassView);
            this.fill(list);
            return new PagingVO(1L, list);
        }
        return new PagingVO();
    }

    void fill(List<YstItemClassView> list) {
        Map safeQtyDaysMap = this.udcService.getCodeMap("SRM", "SAFEQTY_DAYS");
        Map defDueDateMap = this.udcService.getCodeMap("SRM", "DEF_DUEDATE");
        list.forEach(i -> {
            if (MapUtils.isNotEmpty((Map)safeQtyDaysMap)) {
                i.setSafeQtyDaysName((String)safeQtyDaysMap.get(i.getSafeQtyDays()));
            }
            if (MapUtils.isNotEmpty((Map)defDueDateMap)) {
                i.setDefDueDateName((String)defDueDateMap.get(i.getDefDueDate()));
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateItmItemCate(ItmItemCateAddParam param) {
        return this.itmItemCateRepoProc.updateSafeQtyAndDefDue(param);
    }

    public ItmItemCateServiceImpl(ItmCatePropService itmCatePropService, ItmCateContrParaService itmCateContrParaService, TableColumnExtService tableColumnExtService, ItmTagService itmTagService, PriMainPriceService priMainPriceService, ItmItemCateCacheManager itmItemCateCacheManager, ItmItemCateRepo itmItemCateRepo, ItmItemCateRepoProc itmItemCateRepoProc, ItmItemRepoProc itmItemRepoProc) {
        this.itmCatePropService = itmCatePropService;
        this.itmCateContrParaService = itmCateContrParaService;
        this.tableColumnExtService = tableColumnExtService;
        this.itmTagService = itmTagService;
        this.priMainPriceService = priMainPriceService;
        this.itmItemCateCacheManager = itmItemCateCacheManager;
        this.itmItemCateRepo = itmItemCateRepo;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

