/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.convert.ItmItemComboConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemComboDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemComboPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemComboSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemComboRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemComboRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmComboDService;
import com.elitesland.yst.supportdomain.item.service.ItmComboTagService;
import com.elitesland.yst.supportdomain.item.service.ItmItemComboService;
import com.elitesland.yst.supportdomain.item.vo.ItmComboDVO;
import com.elitesland.yst.supportdomain.item.vo.ItmComboTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemComboDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemComboVO;
import com.elitesland.yst.supportdomain.util.CodeGeneratorUtil;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemComboServiceImpl
implements ItmItemComboService {
    private final ItmItemComboRepo itmItemComboRepo;
    private final ItmItemComboRepoProc itmItemComboRepoProc;
    private final ItmComboDService itmComboDService;
    private final ItmComboTagService itmComboTagService;

    @Override
    public String createCode() {
        return CodeGeneratorUtil.createCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long itmItemComboSaveOrUpdate(ItmItemComboSaveParam param) {
        ItmItemComboDO itmItemComboDO = ItmItemComboConvert.INSTANCE.saveParamToDO(param);
        this.itmComboDService.itmComboDSaveOrUpdate(param.getItmComboDSaveParamList());
        this.itmComboTagService.itmComboTagSaveOrUpdate(param.getItmComboTagSaveParamList());
        ItmItemComboDO result = (ItmItemComboDO)this.itmItemComboRepo.save(itmItemComboDO);
        return result.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemComboUpdate(ItmItemComboSaveParam param) {
        this.itmComboDService.delete(param.getItemComboCode());
        this.itmComboTagService.delete(param.getItemComboCode());
        this.itmItemComboSaveOrUpdate(param);
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemComboVO> itmItemComboSearchByParams(ItmItemComboPagingParam param) {
        return this.itmItemComboRepoProc.search(param);
    }

    @Override
    public ItmItemComboDetailsVO searchItmItemComboDetailsById(Long id) {
        Optional optional = this.itmItemComboRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7ec4\u5408\u5546\u54c1\u4fe1\u606f");
        }
        ItmItemComboDO itmItemComboDO = (ItmItemComboDO)optional.get();
        List<ItmComboDVO> itemComboDList = this.itmComboDService.itmComboDQueryByCode(itmItemComboDO.getItemComboCode());
        List<ItmComboTagVO> itemComboTagList = this.itmComboTagService.itmComboTagQueryByCode(itmItemComboDO.getItemComboCode());
        ItmItemComboDetailsVO ItmItemComboDetailsVO2 = ItmItemComboConvert.INSTANCE.doToVo(itmItemComboDO);
        ItmItemComboDetailsVO2.setItmComboDVOList(itemComboDList);
        ItmItemComboDetailsVO2.setItmComboTagVOList(itemComboTagList);
        return ItmItemComboDetailsVO2;
    }

    public ItmItemComboServiceImpl(ItmItemComboRepo itmItemComboRepo, ItmItemComboRepoProc itmItemComboRepoProc, ItmComboDService itmComboDService, ItmComboTagService itmComboTagService) {
        this.itmItemComboRepo = itmItemComboRepo;
        this.itmItemComboRepoProc = itmItemComboRepoProc;
        this.itmComboDService = itmComboDService;
        this.itmComboTagService = itmComboTagService;
    }
}

