/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.convert.ItmItemLifeStatusConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.entity.ItmItemLifeStatusDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusSaveParamList;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusSchDeleteParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusSearchParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeStatusUpdateParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemLifeUpdateParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemLifeStatusRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemLifeStatusRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemLifeStatusService;
import com.elitesland.yst.supportdomain.item.task.service.ItmItemLifeStatusJobService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeOuVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusDeleteParam;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusVO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemLifeStatusServiceImpl
implements ItmItemLifeStatusService {
    private static final String LIFE_STATUS = "LIFE_STATUS";
    private final ItmItemLifeStatusRepoProc itmItemLifeStatusRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemLifeStatusRepo itmItemLifeStatusRepo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final UdcService sysUdcService;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemLifeStatusJobService itmItemLifeStatusJobService;

    @Override
    @SysCodeProc
    public PagingVO<ItmItemLifeStatusPagingVO> searchItemLifeList(ItmItemLifeStatusPagingParam param) {
        PagingVO<ItmItemLifeStatusPagingVO> itmItemLifeStatusPagingVOPagingVO = this.itmItemLifeStatusRepoProc.searchItemLifeList(param);
        itmItemLifeStatusPagingVOPagingVO.getRecords().forEach(life -> {
            String itemCateCode = life.getItemCateCode();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathName(this.itmItemCateService.findItemCatePath(itemCateCode), pathName);
            String collect = String.join((CharSequence)">", pathName);
            life.setItemCateNames(collect);
            List<ItmItemLifeOuVO> branchPlantList = this.itmItemLifeStatusRepoProc.findBranchPlantList(life.getLifeStatusCode());
            List ouNames = branchPlantList.stream().map(ItmItemLifeOuVO::getBuName).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ouNames)) {
                life.setBranchPlants(String.join((CharSequence)";", ouNames));
            }
            life.setValidSection(life.getValidFrom().toLocalDate() + " \u81f3 " + life.getValidTo().toLocalDate());
        });
        return itmItemLifeStatusPagingVOPagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveLifeStatus(ItmItemLifeStatusSaveParam param) {
        List<ItmItemLifeStatusSaveParamList> saveParamLists = param.getSaveParamLists();
        if (CollectionUtils.isEmpty(saveParamLists)) {
            throw new BusinessException("\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.insertLifeStatus(saveParamLists);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateLifeStatus(ItmItemLifeStatusUpdateParam param) {
        ItmItemLifeStatusDetailsVO itmItemLifeStatusDetailsVO = this.searchLifeStatusDetails(param.getLifeStatusCode());
        if (null == itmItemLifeStatusDetailsVO) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.compareTo(param.getValidTo()) >= 0) {
            throw new BusinessException("\u5386\u53f2\u6570\u636e\u4e0d\u80fd\u53d8\u66f4");
        }
        Boolean oldGlobalOrNot = itmItemLifeStatusDetailsVO.getGlobalOrNot();
        Boolean newGlobalOrNot = param.getGlobalOrNot();
        if (!oldGlobalOrNot.booleanValue() && newGlobalOrNot.booleanValue()) {
            ItmItemLifeStatusVO oldLifeStatus;
            Boolean intersectsOrNot;
            ItmItemLifeStatusSearchParam searchVO = ItmItemLifeStatusSearchParam.builder().globalOrNot(true).itemCode(param.getItemCode()).itemLifeStatus(param.getItemLifeStatus()).build();
            List<ItmItemLifeStatusVO> globalInfoByItemCode = this.itmItemLifeStatusRepoProc.findGlobalInfoByItemCode(searchVO);
            if (CollectionUtils.isNotEmpty(globalInfoByItemCode) && (intersectsOrNot = this.judgementLocalDateTime((oldLifeStatus = globalInfoByItemCode.get(0)).getValidFrom(), oldLifeStatus.getValidTo(), param.getValidFrom(), param.getValidTo())).booleanValue()) {
                throw new BusinessException("\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u7684\u5168\u5c40\u51bb\u7ed3\uff0c\u4e0e\u5f53\u524d\u53d8\u66f4\u7684\u65f6\u95f4\u6bb5\u91cd\u53e0");
            }
            this.itmItemLifeStatusRepoProc.deleteByLifeStatusCode(ItmItemLifeStatusDeleteParam.builder().lifeStatusCode(param.getLifeStatusCode()).globalOrNot(false).build());
            ItmItemLifeStatusDO itmItemLifeStatusDO = ItmItemLifeStatusConvert.INSTANCE.updateParamToDO(param);
            itmItemLifeStatusDO.setOuId(itmItemLifeStatusDetailsVO.getOuId());
            itmItemLifeStatusDO.setOuCode(itmItemLifeStatusDetailsVO.getOuCode());
            itmItemLifeStatusDO.setOuName(itmItemLifeStatusDetailsVO.getOuName());
            itmItemLifeStatusDO.setCreateTime(itmItemLifeStatusDetailsVO.getCreateTime());
            itmItemLifeStatusDO.setCreator(itmItemLifeStatusDetailsVO.getCreator());
            itmItemLifeStatusDO.setCreateUserId(itmItemLifeStatusDetailsVO.getCreateUserId());
            itmItemLifeStatusDO.setSecOuId(itmItemLifeStatusDetailsVO.getOuId());
            this.itmItemLifeStatusRepo.save(itmItemLifeStatusDO);
        } else if (oldGlobalOrNot.booleanValue() && !newGlobalOrNot.booleanValue()) {
            List<ItmItemLifeStatusDO> insertDos = this.insertBranchData(param, itmItemLifeStatusDetailsVO);
            if (CollectionUtils.isNotEmpty(insertDos)) {
                this.itmItemLifeStatusRepoProc.deleteByLifeStatusCode(ItmItemLifeStatusDeleteParam.builder().lifeStatusCode(param.getLifeStatusCode()).globalOrNot(true).build());
                insertDos.forEach(dos -> {
                    dos.setCreateTime(itmItemLifeStatusDetailsVO.getCreateTime());
                    dos.setCreator(itmItemLifeStatusDetailsVO.getCreator());
                    dos.setCreateUserId(itmItemLifeStatusDetailsVO.getCreateUserId());
                    dos.setSecOuId(itmItemLifeStatusDetailsVO.getOuId());
                });
                this.itmItemLifeStatusRepo.saveAll(insertDos);
            }
        } else if (oldGlobalOrNot.booleanValue() && newGlobalOrNot.booleanValue()) {
            ItmItemLifeStatusSearchParam searchVO = ItmItemLifeStatusSearchParam.builder().lifeStatusCode(param.getLifeStatusCode()).build();
            List<ItmItemLifeStatusVO> globalInfoByItemCode = this.itmItemLifeStatusRepoProc.findGlobalInfoByItemCode(searchVO);
            if (CollectionUtils.isNotEmpty(globalInfoByItemCode)) {
                ItmItemLifeStatusVO oldLifeStatus = globalInfoByItemCode.get(0);
                LocalDateTime validFrom = oldLifeStatus.getValidFrom();
                LocalDateTime validTo = oldLifeStatus.getValidTo();
                LocalDateTime nowLocalDateTime = LocalDateTime.now();
                if (nowLocalDateTime.compareTo(validFrom) > 0 && nowLocalDateTime.compareTo(validTo) < 0) {
                    if (validFrom.compareTo(param.getValidFrom()) != 0) {
                        throw new BusinessException("\u5728\u51bb\u7ed3\u72b6\u6001\u751f\u6548\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u751f\u6548\u65f6\u95f4");
                    }
                    ItmItemLifeUpdateParam build = ItmItemLifeUpdateParam.builder().buCode(param.getBuCode()).itemCode(param.getItemCode()).lifeStatusCode(param.getLifeStatusCode()).globalOrNot(param.getGlobalOrNot()).validFrom(param.getValidFrom()).validTo(param.getValidTo()).createTime(itmItemLifeStatusDetailsVO.getCreateTime()).creator(itmItemLifeStatusDetailsVO.getCreator()).createUserId(itmItemLifeStatusDetailsVO.getCreateUserId()).build();
                    this.itmItemLifeStatusRepoProc.updateLifeStatus(build);
                } else {
                    ItmItemLifeUpdateParam build = ItmItemLifeUpdateParam.builder().buCode(param.getBuCode()).itemCode(param.getItemCode()).lifeStatusCode(param.getLifeStatusCode()).globalOrNot(param.getGlobalOrNot()).validFrom(param.getValidFrom()).validTo(param.getValidTo()).createTime(itmItemLifeStatusDetailsVO.getCreateTime()).creator(itmItemLifeStatusDetailsVO.getCreator()).createUserId(itmItemLifeStatusDetailsVO.getCreateUserId()).build();
                    this.itmItemLifeStatusRepoProc.updateLifeStatus(build);
                }
            }
        } else if (!oldGlobalOrNot.booleanValue() && !newGlobalOrNot.booleanValue()) {
            List<String> newBranchPlantList = param.getBranchPlantList();
            if (CollectionUtils.isEmpty(newBranchPlantList)) {
                throw new BusinessException("\u975e\u5168\u5c40\u6570\u636e\uff0c\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<ItmItemLifeStatusDO> insertDos = this.insertBranchData(param, itmItemLifeStatusDetailsVO);
            insertDos.forEach(insert -> {
                insert.setLifeStatusCode(param.getLifeStatusCode());
                insert.setCreateTime(itmItemLifeStatusDetailsVO.getCreateTime());
                insert.setCreator(itmItemLifeStatusDetailsVO.getCreator());
                insert.setCreateUserId(itmItemLifeStatusDetailsVO.getCreateUserId());
                insert.setSecOuId(itmItemLifeStatusDetailsVO.getOuId());
            });
            this.itmItemLifeStatusRepoProc.deleteByLifeStatusCode(ItmItemLifeStatusDeleteParam.builder().lifeStatusCode(param.getLifeStatusCode()).globalOrNot(false).build());
            this.itmItemLifeStatusRepo.saveAll(insertDos);
        }
    }

    private List<ItmItemLifeStatusDO> insertBranchData(ItmItemLifeStatusUpdateParam param, ItmItemLifeStatusDetailsVO itmItemLifeStatusDetailsVO) {
        ItmItemLifeStatusSearchParam searchVO = ItmItemLifeStatusSearchParam.builder().itemCode(param.getItemCode()).buCode(param.getBuCode()).globalOrNot(false).itemLifeStatus(param.getItemLifeStatus()).nonLifeStatusCode(param.getLifeStatusCode()).build();
        List<ItmItemLifeStatusVO> noGlobalInfo = this.itmItemLifeStatusRepoProc.findGlobalInfoByItemCode(searchVO);
        Map<String, ItmItemLifeStatusVO> noGlobalInfoByItemCode = noGlobalInfo.stream().collect(Collectors.toMap(ItmItemLifeStatusVO::getBranchPlant, t -> t));
        if (CollectionUtils.isEmpty(param.getBranchPlantList())) {
            throw new BusinessException("\u975e\u5168\u5c40\u6570\u636e\uff0c\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> branchPlantList = param.getBranchPlantList();
        ArrayList<ItmItemLifeStatusDO> insertDos = new ArrayList<ItmItemLifeStatusDO>();
        String lifeStatusCode = param.getLifeStatusCode();
        branchPlantList.forEach(branch -> {
            ItmItemLifeStatusVO itmItemLifeStatusVO = (ItmItemLifeStatusVO)noGlobalInfoByItemCode.get(branch);
            if (null != itmItemLifeStatusVO) {
                LocalDateTime oldValidFrom = itmItemLifeStatusVO.getValidFrom();
                LocalDateTime oldValidTo = itmItemLifeStatusVO.getValidTo();
                LocalDateTime newValidFrom = param.getValidFrom();
                LocalDateTime newValidTo = param.getValidTo();
                Boolean intersectsOrNot = this.judgementLocalDateTime(oldValidFrom, oldValidTo, newValidFrom, newValidTo);
                Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode((String)branch);
                if (!byBuCode.isPresent()) {
                    throw new BusinessException(branch + "\u8be5\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
                }
                String buName = byBuCode.get().getBuName();
                if (intersectsOrNot.booleanValue()) {
                    throw new BusinessException("\u5546\u54c1\uff1a" + param.getItemCode() + ",\u5728\u8303\u56f4\uff1a" + buName + "\uff0c\u51bb\u7ed3\u65f6\u95f4\u91cd\u53e0");
                }
            }
            ItmItemLifeStatusDO itmItemLifeStatusDO = ItmItemLifeStatusConvert.INSTANCE.updateParamToDO(param);
            itmItemLifeStatusDO.setOuId(itmItemLifeStatusDetailsVO.getOuId());
            itmItemLifeStatusDO.setOuCode(itmItemLifeStatusDetailsVO.getOuCode());
            itmItemLifeStatusDO.setOuName(itmItemLifeStatusDetailsVO.getOuName());
            itmItemLifeStatusDO.setBranchPlant((String)branch);
            itmItemLifeStatusDO.setLifeStatusCode(lifeStatusCode);
            insertDos.add(itmItemLifeStatusDO);
        });
        return insertDos;
    }

    @Override
    @SysCodeProc
    public ItmItemLifeStatusDetailsVO searchLifeStatusDetails(String lifeStatusCode) {
        List<ItmItemLifeStatusDetailsVO> itmItemLifeStatusDetailsVOS = this.itmItemLifeStatusRepoProc.searchLifeStatusDetails(lifeStatusCode);
        if (1 == itmItemLifeStatusDetailsVOS.size()) {
            ItmItemLifeStatusDetailsVO itmItemLifeStatusDetailsVO = itmItemLifeStatusDetailsVOS.get(0);
            List<ItmItemLifeOuVO> branchPlantList = this.itmItemLifeStatusRepoProc.findBranchPlantList(itmItemLifeStatusDetailsVO.getLifeStatusCode());
            itmItemLifeStatusDetailsVO.setBranchPlants(branchPlantList);
            return itmItemLifeStatusDetailsVO;
        }
        throw new BusinessException("\u6570\u636e\u4e0d\u552f\u4e00\u3001\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLifeStatusByParam(ItmItemLifeStatusSchDeleteParam param) {
        List<String> lifeStatusCodes = param.getLifeStatusCodes();
        if (CollectionUtils.isEmpty(lifeStatusCodes)) {
            throw new BusinessException("\u5220\u9664\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ItmItemLifeStatusDetailsVO> lifeStatusDetails = this.itmItemLifeStatusRepoProc.findItemDetailsByLifeStatusCodes(lifeStatusCodes);
        LocalDateTime nowDateTime = LocalDateTime.now();
        lifeStatusDetails.forEach(lifeStatus -> {
            LocalDateTime validFrom = lifeStatus.getValidFrom();
            LocalDateTime validTo = lifeStatus.getValidTo();
            if (nowDateTime.compareTo(validTo) >= 0) {
                throw new BusinessException("\u5386\u53f2\u6570\u636e\u4e0d\u80fd\u5220\u9664");
            }
            if (nowDateTime.compareTo(validFrom) >= 0 && nowDateTime.compareTo(validTo) <= 0) {
                throw new BusinessException("\u51bb\u7ed3\u751f\u6548\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.itmItemLifeStatusRepoProc.deleteByLifeStatusCode(lifeStatusCodes);
    }

    private void insertLifeStatus(List<ItmItemLifeStatusSaveParamList> list) {
        this.checkSaveListIsRepeat(list);
        List<String> itemCodeList = list.stream().map(ItmItemLifeStatusSaveParamList::getItemCode).collect(Collectors.toList());
        List<ItmItemLifeStatusVO> nonGlobalOrNotList = this.itmItemLifeStatusRepoProc.findItemLifeStatusVOByItemCodes(itemCodeList, false);
        List<ItmItemLifeStatusVO> globalOrNotList = this.itmItemLifeStatusRepoProc.findItemLifeStatusVOByItemCodes(itemCodeList, true);
        ArrayList<ItmItemLifeStatusDO> insertDos = new ArrayList<ItmItemLifeStatusDO>();
        list.forEach(insert -> {
            String lifeStatusCode = this.sysNumberGeneratorWrapper.generate(LIFE_STATUS);
            String ouCode = insert.getOuCode();
            if (StringUtils.isBlank((CharSequence)ouCode)) {
                throw new BusinessException("\u521b\u5efa\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (insert.getGlobalOrNot().booleanValue()) {
                List isRepeatList = globalOrNotList.stream().filter(global -> {
                    boolean itemCodeFlag = insert.getItemCode().equals(global.getItemCode());
                    boolean itemLifeStatusFlag = insert.getItemLifeStatus().equals(global.getItemLifeStatus());
                    return itemCodeFlag && itemLifeStatusFlag && this.judgementLocalDateTime(global.getValidFrom(), global.getValidTo(), insert.getValidFrom(), insert.getValidTo()) != false;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(isRepeatList)) {
                    throw new BusinessException("\u5546\u54c1:" + insert.getItemCode() + "\u5168\u5c40\u6570\u636e\u4e0d\u5141\u8bb8\u51fa\u73b0\u65f6\u95f4\u6bb5\u91cd\u53e0");
                }
                ItmItemLifeStatusDO itmItemLifeStatusDO = ItmItemLifeStatusConvert.INSTANCE.paramToDo((ItmItemLifeStatusSaveParamList)insert);
                itmItemLifeStatusDO.setLifeStatusCode(lifeStatusCode);
                insertDos.add(itmItemLifeStatusDO);
            } else {
                List<String> branchPlantList = insert.getBranchPlantList();
                if (CollectionUtils.isEmpty(branchPlantList)) {
                    throw new BusinessException("\u4e0d\u662f\u5168\u5c40\u6570\u636e\uff0c\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                branchPlantList.forEach(branch -> {
                    List isRepeatList = nonGlobalOrNotList.stream().filter(nonGlobal -> {
                        boolean itemCodeFlag = insert.getItemCode().equals(nonGlobal.getItemCode());
                        boolean itemLifeStatusFlag = insert.getItemLifeStatus().equals(nonGlobal.getItemLifeStatus());
                        return itemCodeFlag && itemLifeStatusFlag && branch.equals(nonGlobal.getBranchPlant()) && this.judgementLocalDateTime(nonGlobal.getValidFrom(), nonGlobal.getValidTo(), insert.getValidFrom(), insert.getValidTo()) != false;
                    }).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(isRepeatList)) {
                        Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode((String)branch);
                        if (!byBuCode.isPresent()) {
                            throw new BusinessException(branch + "\u8be5\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
                        }
                        String buName = byBuCode.get().getBuName();
                        throw new BusinessException("\u5546\u54c1:" + insert.getItemCode() + ",\u5728\u8303\u56f4\u4e3a\uff1a" + buName + "\u4e2d,\u51bb\u7ed3\u65f6\u95f4\u91cd\u53e0");
                    }
                    ItmItemLifeStatusDO itmItemLifeStatusDO = ItmItemLifeStatusConvert.INSTANCE.paramToDo((ItmItemLifeStatusSaveParamList)insert);
                    itmItemLifeStatusDO.setBranchPlant((String)branch);
                    itmItemLifeStatusDO.setLifeStatusCode(lifeStatusCode);
                    insertDos.add(itmItemLifeStatusDO);
                });
            }
        });
        insertDos.forEach(dos -> dos.setSecOuId(dos.getOuId()));
        this.itmItemLifeStatusRepo.saveAll(insertDos);
    }

    private void buildPathName(List<ItmItemCateSimpleTree> tree, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathName.add(t.getItemCateName());
            this.buildPathName(t.getTreeNodes(), pathName);
        });
    }

    private Boolean judgementLocalDateTime(LocalDateTime oldValidFrom, LocalDateTime oldValidTo, LocalDateTime newValidFrom, LocalDateTime newValidTo) {
        LocalDateTime fromTime = newValidFrom.compareTo(oldValidFrom) > 0 ? newValidFrom : oldValidFrom;
        LocalDateTime toTime = newValidTo.compareTo(oldValidTo) > 0 ? oldValidTo : newValidTo;
        boolean ss = fromTime.compareTo(toTime) < 0;
        return ss;
    }

    private void checkSaveListIsRepeat(List<ItmItemLifeStatusSaveParamList> list) {
        Map udcMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        List globalList = list.stream().filter(ItmItemLifeStatusSaveParamList::getGlobalOrNot).collect(Collectors.toList());
        Map<String, List<ItmItemLifeStatusSaveParamList>> globalMap = globalList.stream().collect(Collectors.groupingBy(global -> global.getItemCode() + "-" + global.getItemLifeStatus() + "-" + global.getItemSource() + "-" + global.getBuCode()));
        globalMap.forEach((key, value) -> {
            if (value.size() > 1) {
                List<String> keys = Arrays.asList(key.split("-"));
                throw new BusinessException("\u5546\u54c1\uff1a" + keys.get(0) + ", \u5168\u91cf\u6570\u636e\u91cd\u590d\uff01\u5728\u4e00\u6b21\u65b0\u589e\u4e2d\u540c\u4e00\u5546\u54c1\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u6761\u5168\u91cf\u6570\u636e");
            }
        });
        List<ItmItemLifeStatusSaveParamList> nonGlobalList = list.stream().filter(saveList -> saveList.getGlobalOrNot() == false).collect(Collectors.toList());
        ArrayList checkDos = new ArrayList();
        nonGlobalList.forEach(nonGlobal -> {
            List<String> branchPlantList = nonGlobal.getBranchPlantList();
            branchPlantList.forEach(branchPlant -> {
                ItmItemLifeStatusDO itmItemLifeStatusDO = ItmItemLifeStatusConvert.INSTANCE.paramToDo((ItmItemLifeStatusSaveParamList)nonGlobal);
                itmItemLifeStatusDO.setBranchPlant((String)branchPlant);
                checkDos.add(itmItemLifeStatusDO);
            });
        });
        Map<String, List<ItmItemLifeStatusDO>> nonGlobalMap = checkDos.stream().collect(Collectors.groupingBy(global -> global.getItemCode() + "-" + global.getItemLifeStatus() + "-" + global.getItemSource() + "-" + global.getBranchPlant() + "-" + global.getBuCode()));
        nonGlobalMap.forEach((key, value) -> {
            if (value.size() > 1) {
                LocalDateTime[][] localDateTimes = new LocalDateTime[value.size()][2];
                for (int i = 0; i < value.size(); ++i) {
                    LocalDateTime validFrom = ((ItmItemLifeStatusDO)value.get(i)).getValidFrom();
                    LocalDateTime validTo = ((ItmItemLifeStatusDO)value.get(i)).getValidTo();
                    localDateTimes[i][0] = validFrom;
                    localDateTimes[i][1] = validTo;
                }
                if (this.multiTimePeriod(localDateTimes).booleanValue()) {
                    List<String> keys = Arrays.asList(key.split("-"));
                    Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(keys.get(3));
                    if (!byBuCode.isPresent()) {
                        throw new BusinessException(keys.get(3) + "\u8be5\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                    String buName = byBuCode.get().getBuName();
                    throw new BusinessException("\u5546\u54c1\uff1a" + keys.get(0) + ",\u8303\u56f4\uff1a" + buName + ", \u51bb\u7ed3\u7c7b\u578b\uff1a" + (String)udcMap.get(keys.get(1)) + "\uff0c\u51bb\u7ed3\u65f6\u95f4\u91cd\u53e0");
                }
            }
        });
    }

    private Boolean multiTimePeriod(LocalDateTime[][] localDateTimes) {
        Arrays.sort(localDateTimes, Comparator.comparing(localDateTime -> localDateTime[1]));
        int size = localDateTimes.length;
        LocalDateTime firstPeriod = localDateTimes[0][1];
        int periodNum = 1;
        for (int i = 1; i < size; ++i) {
            if (localDateTimes[i][0].compareTo(firstPeriod) < 0) continue;
            ++periodNum;
            firstPeriod = localDateTimes[i][1];
        }
        return size != periodNum;
    }

    public ItmItemLifeStatusServiceImpl(ItmItemLifeStatusRepoProc itmItemLifeStatusRepoProc, ItmItemCateService itmItemCateService, ItmItemLifeStatusRepo itmItemLifeStatusRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, UdcService sysUdcService, OrgBuRepo orgBuRepo, ItmItemLifeStatusJobService itmItemLifeStatusJobService) {
        this.itmItemLifeStatusRepoProc = itmItemLifeStatusRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.itmItemLifeStatusRepo = itmItemLifeStatusRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.sysUdcService = sysUdcService;
        this.orgBuRepo = orgBuRepo;
        this.itmItemLifeStatusJobService = itmItemLifeStatusJobService;
    }
}

