/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.entity.ItmItemAttachmentDO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemAttachmentRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemPictureService;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemQueryDTO;
import com.elitesland.yst.system.service.SysSettingService;
import com.elitesland.yst.system.vo.SysSettingVO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ItmItemPictureServiceImpl
implements ItmItemPictureService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemPictureServiceImpl.class);
    private final ItmItemAttachmentRepo itmItemAttachmentRepo;
    private final ItmItemRepoProc itmItemRepoProc;
    @DubboReference(version="${provider.service.version}", check=false)
    private SysSettingService sysSettingService;
    private static final String INIT_PICTURE_LOC = "INIT_PICTURE_LOC";
    private static final String[] PICTURE_TYPE = new String[]{"BMP", "JPG", "JPEG", "PNG", "GIF", "PDF"};

    @Override
    public void upload(MultipartFile uploadFile) throws Exception {
        SysSettingVO pictureLoc = this.sysSettingService.oneByNo(INIT_PICTURE_LOC);
        String picture = Optional.ofNullable(pictureLoc).map(SysSettingVO::getSettingVal).orElse("");
        if (StrUtil.isBlank((CharSequence)picture)) {
            throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u521d\u59cb\u5316\u5546\u54c1\u56fe\u7247\u6587\u4ef6\u76ee\u5f55");
        }
        File packFile = new File(picture);
        if (!packFile.exists()) {
            packFile.mkdirs();
        }
        if (uploadFile == null) {
            throw new RuntimeException("\u8bf7\u4e0a\u4f20\u6587\u4ef6");
        }
        String filename = uploadFile.getOriginalFilename();
        String packFilePath = picture + File.separator + filename;
        File file = new File(packFilePath);
        try {
            FileUtils.copyToFile((InputStream)uploadFile.getInputStream(), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u538b\u7f29\u6587\u4ef6\u5230:" + picture + " \u5931\u8d25!");
        }
        ZipUtil.unzip((String)packFilePath, (String)picture);
        FileUtil.del((String)packFilePath);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initItemPicture() {
        SysSettingVO pictureLoc = this.sysSettingService.oneByNo(INIT_PICTURE_LOC);
        String picture = Optional.ofNullable(pictureLoc).map(SysSettingVO::getSettingVal).orElse("");
        if (StrUtil.isBlank((CharSequence)picture)) {
            throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u521d\u59cb\u5316\u5546\u54c1\u56fe\u7247\u6587\u4ef6\u76ee\u5f55");
        }
        List files = FileUtil.loopFiles((String)picture);
        for (File file : files) {
            String exName;
            if (!FileNameUtil.isType((String)file.getName(), (String[])PICTURE_TYPE)) {
                log.error("\u4e0a\u4f20\u7684\u6587\u4ef6:{},\u4e0d\u662f\u56fe\u7247\u683c\u5f0f", (Object)file.getName());
                continue;
            }
            String fileStr = file.getAbsolutePath();
            if (fileStr.contains("__")) continue;
            String abstr = StrUtil.subAfter((CharSequence)fileStr, (CharSequence)picture, (boolean)true);
            String fullName = file.getName();
            String itemCode2 = exName.substring(0, (exName = fullName.substring(0, fullName.indexOf("."))).contains("-") ? exName.indexOf("-") : exName.length());
            this.itmItemAttachmentRepo.deleteByItemCode(exName);
            ItmItemQueryDTO itemVO = this.itmItemRepoProc.findItemByItemCode2(itemCode2);
            if (Objects.isNull(itemVO)) {
                log.error("\u5546\u54c1:{} \u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1", (Object)file.getName());
                continue;
            }
            ItmItemAttachmentDO itmItemAttachmentDO = new ItmItemAttachmentDO();
            itmItemAttachmentDO.setUrl(abstr);
            itmItemAttachmentDO.setFileType("ITEM");
            itmItemAttachmentDO.setItemCode(itemVO.getItemCode());
            itmItemAttachmentDO.setFileName(fullName);
            itmItemAttachmentDO.setFileCode(itemCode2);
            itmItemAttachmentDO.setItemId(itemVO.getId());
            this.itmItemAttachmentRepo.save(itmItemAttachmentDO);
            log.info("\u5546\u54c1\uff1a{},\u56fe\u7247\u4e0a\u4f20\u6210\u529f", (Object)itemCode2);
        }
        FileUtil.del((String)picture);
    }

    public ItmItemPictureServiceImpl(ItmItemAttachmentRepo itmItemAttachmentRepo, ItmItemRepoProc itmItemRepoProc) {
        this.itmItemAttachmentRepo = itmItemAttachmentRepo;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

