/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.convert.ItmItemPropConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemPropDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemPropSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemPropVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemPropServiceImpl
implements ItmItemPropService {
    private final ItmItemPropRepo itmItemPropRepo;
    private final ItmItemPropRepoProc itmItemPropRepoProc;

    @Override
    public List<ItmItemPropVO> findVosByItemId(Long itemId) {
        return this.itmItemPropRepoProc.findVosByItemId(itemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemPropsHardSave(Long itemId, List<ItmItemPropSaveParam> params) {
        if (itemId == null) {
            return;
        }
        this.itmItemPropRepo.deleteByItemId(itemId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemPropDO> itmItemPropDos = ItmItemPropConvert.INSTANCE.saveParamToDo(params);
        itmItemPropDos.forEach(t -> t.setItemId(itemId));
        this.itmItemPropRepo.saveAll(itmItemPropDos);
    }

    public ItmItemPropServiceImpl(ItmItemPropRepo itmItemPropRepo, ItmItemPropRepoProc itmItemPropRepoProc) {
        this.itmItemPropRepo = itmItemPropRepo;
        this.itmItemPropRepoProc = itmItemPropRepoProc;
    }
}

