/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.item.convert.ItmItemQualifyConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemQualifyDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemQualifySaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemQualifyRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemQualifyRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemQualifyService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemQualifyVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemQualifyServiceImpl
implements ItmItemQualifyService {
    private final ItmItemQualifyRepo itmItemQualifyRepo;
    private final ItmItemQualifyRepoProc itmItemQualifyRepoProc;

    @Override
    @SysCodeProc
    public List<ItmItemQualifyVO> findVosBySpuId(Long spuId) {
        return this.itmItemQualifyRepoProc.findVosBySpuId(spuId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemQualifyHardSave(Long spuId, List<ItmItemQualifySaveParam> params) {
        if (spuId == null) {
            return;
        }
        this.itmItemQualifyRepo.deleteBySpuId(spuId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemQualifyDO> qualifyDos = ItmItemQualifyConvert.INSTANCE.saveParamToDo(params);
        qualifyDos.forEach(qualify -> qualify.setSpuId(spuId));
        this.itmItemQualifyRepo.saveAll(qualifyDos);
    }

    public ItmItemQualifyServiceImpl(ItmItemQualifyRepo itmItemQualifyRepo, ItmItemQualifyRepoProc itmItemQualifyRepoProc) {
        this.itmItemQualifyRepo = itmItemQualifyRepo;
        this.itmItemQualifyRepoProc = itmItemQualifyRepoProc;
    }
}

